/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.objectserver;

import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.distribution.ServerConsole;

public abstract class AbstractObjectServer
implements Server {
    private ServerConsole console;
    private NakedObjectStore objectStore;

    public NakedObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void init(NakedObjectStore nakedObjectStore, ServerConsole serverConsole) {
        if (nakedObjectStore == null) {
            throw new NullPointerException();
        }
        this.objectStore = nakedObjectStore;
        this.setConsole(serverConsole);
    }

    public void log() {
        if (this.console != null) {
            this.console.log();
        }
    }

    public void log(String string) {
        if (this.console != null) {
            this.console.log(string);
        }
    }

    public void setConsole(ServerConsole serverConsole) {
        if (this.console != null) {
            this.console.close();
        }
        this.console = serverConsole;
        this.console.init(this);
    }

    public void shutdown() {
        if (this.objectStore != null) {
            this.objectStore.shutdown();
        }
        if (this.console != null) {
            this.console.close();
            this.console = null;
        }
    }
}

