/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.AbstractNakedValue;
import org.nakedobjects.object.value.Case;

public class TextString
extends AbstractNakedValue {
    private String text;

    public TextString() {
        this.text = null;
    }

    public TextString(String string) {
        this.text = string;
    }

    public TextString(TextString textString) {
        this.text = textString.toString();
    }

    public void clear() {
        this.text = null;
    }

    public boolean contains(String string) {
        return this.contains(string, Case.SENSITIVE);
    }

    public boolean contains(String string, Case case_) {
        this.checkCanOperate();
        if (this.text == null) {
            return false;
        }
        if (case_ == Case.SENSITIVE) {
            return this.text.indexOf(string) >= 0;
        }
        return this.text.toLowerCase().indexOf(string.toLowerCase()) >= 0;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof TextString)) {
            throw new IllegalArgumentException("Can only copy the value of  a TextString object");
        }
        this.text = ((TextString)naked).text;
    }

    public boolean endsWith(String string) {
        return this.endsWith(string, Case.SENSITIVE);
    }

    public boolean endsWith(String string, Case case_) {
        this.checkCanOperate();
        if (this.text == null) {
            return false;
        }
        if (case_ == Case.SENSITIVE) {
            return this.text.endsWith(string);
        }
        return this.text.toLowerCase().endsWith(string.toLowerCase());
    }

    public boolean equals(Object object) {
        if (object instanceof TextString) {
            TextString textString = (TextString)object;
            if (this.text == null) {
                return textString.text == null;
            }
            return this.text.equals(textString.text);
        }
        return super.equals(object);
    }

    public String getObjectHelpText() {
        return "A TextString object.";
    }

    public boolean isEmpty() {
        return this.text == null || this.text.equals("");
    }

    public boolean isSameAs(Naked naked) {
        if (naked instanceof TextString) {
            return this.isSameAs((TextString)naked);
        }
        return false;
    }

    public boolean isSameAs(String string) {
        return this.isSameAs(string, Case.SENSITIVE);
    }

    public boolean isSameAs(String string, Case case_) {
        if (this.text == null) {
            return false;
        }
        if (case_ == Case.SENSITIVE) {
            return this.text.equals(string);
        }
        return this.text.equalsIgnoreCase(string);
    }

    public boolean isSameAs(TextString textString) {
        return this.isSameAs(textString, Case.SENSITIVE);
    }

    public boolean isSameAs(TextString textString, Case case_) {
        if (this.text == null) {
            return this.text == textString.text;
        }
        if (case_ == Case.SENSITIVE) {
            return this.text.equals(textString.text);
        }
        return this.text.equalsIgnoreCase(textString.text);
    }

    public void parse(String string) throws ValueParseException {
        this.setValue(string);
    }

    public void reset() {
        this.text = null;
    }

    public void setText(String string) {
        this.setValue(string);
    }

    public void setText(TextString textString) {
        this.setValue(textString);
    }

    public void setValue(String string) {
        this.text = string == null || string.equals("") ? null : string;
    }

    public void setValue(TextString textString) {
        this.text = textString.text;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, Case.SENSITIVE);
    }

    public boolean startsWith(String string, Case case_) {
        if (this.text == null) {
            return false;
        }
        if (case_ == Case.SENSITIVE) {
            return this.text.startsWith(string);
        }
        return this.text.toLowerCase().startsWith(string.toLowerCase());
    }

    public String stringValue() {
        return this.text;
    }

    public Title title() {
        return new Title(this.isEmpty() ? "" : this.text);
    }

    public void restoreString(String string) {
        this.text = string;
    }

    public String saveString() {
        return this.text;
    }
}

