/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.Magnitude;

public class Date
extends Magnitude
implements Externalizable {
    private static final DateFormat SHORT_FORMAT = DateFormat.getDateInstance(3);
    private static final DateFormat MEDIUM_FORMAT = DateFormat.getDateInstance(2);
    private static final DateFormat LONG_FORMAT = DateFormat.getDateInstance(1);
    private static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(2, 2);
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(2);
    public static final int DATE = 0;
    public static final int TIME = 1;
    public static final int DATE_TIME = 2;
    private transient DateFormat format = MEDIUM_FORMAT;
    private int type;
    private boolean isNull = true;
    private java.util.Date date;

    public Date() {
        this.setType(0);
        this.set(this.createCalendar());
        this.isNull = false;
    }

    public Date(int n) {
        this.setType(n);
        this.set(this.createCalendar());
        this.isNull = false;
    }

    public Date(int n, int n2) {
        this.setType(1);
        this.setTime(n, n2, 0);
        this.isNull = false;
    }

    public Date(int n, int n2, int n3) {
        this.setType(0);
        this.setDate(n3, n2, n);
        this.isNull = false;
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        this.setType(2);
        this.setDateTime(n3, n2, n, n4, n5, 0);
        this.isNull = false;
    }

    public Date(String string, int n) {
        this.setType(n);
        if (string.equals("")) {
            throw new IllegalArgumentException("Date must be set up to a value.");
        }
        try {
            this.parse(string);
        }
        catch (ValueParseException valueParseException) {
            throw new IllegalArgumentException("Date string could not be parsed.");
        }
        this.isNull = false;
    }

    public Date(Date date) {
        this.setType(date.type);
        this.date = date.date;
        this.isNull = date.isNull;
    }

    public void add(int n, int n2, int n3) {
        this.checkCanOperate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        calendar.add(5, n);
        calendar.add(2, n2);
        calendar.add(1, n3);
        this.set(calendar);
    }

    public boolean after(Date date) {
        this.checkCanOperate();
        return this.date.after(date.date);
    }

    public boolean before(Date date) {
        this.checkCanOperate();
        return this.date.before(date.date);
    }

    private void checkDate(int n, int n2, int n3) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Month must be in the range 1 - 12 inclusive");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n3, n2 - 1, 0);
        int n4 = calendar.getMaximum(5);
        if (n < 1 || n > n4) {
            throw new IllegalArgumentException("Day must be in the range 1 - " + n4 + " inclusive");
        }
    }

    private void checkTime(int n, int n2, int n3) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Hour must be in the range 0 - 23 inclusive");
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Minute must be in the range 0 - 59 inclusive");
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("Second must be in the range 0 - 59 inclusive");
        }
    }

    public void clear() {
        this.isNull = true;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof Date)) {
            throw new IllegalArgumentException("Can only copy the value of  a Date object");
        }
        this.date = ((Date)naked).date;
        this.isNull = ((Date)naked).isNull;
    }

    private Calendar createCalendar() {
        Calendar calendar = Calendar.getInstance();
        switch (this.type) {
            case 1: {
                calendar.set(1, 0);
                calendar.set(2, 0);
                calendar.set(5, 0);
                break;
            }
            case 0: {
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(9, 0);
                break;
            }
        }
        calendar.set(14, 0);
        return calendar;
    }

    public java.util.Date dateValue() {
        return this.isNull ? null : this.date;
    }

    public Calendar calendarValue() {
        if (this.isNull) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        return calendar;
    }

    private DateFormat format() {
        switch (this.type) {
            case 0: {
                return MEDIUM_FORMAT;
            }
            case 1: {
                return TIME_FORMAT;
            }
            case 2: {
                return DATE_TIME_FORMAT;
            }
        }
        return MEDIUM_FORMAT;
    }

    public java.util.Date getDate() {
        return this.isNull ? null : this.date;
    }

    public String getObjectHelpText() {
        switch (this.type) {
            case 0: {
                return "A Date object, storing day, month and year.";
            }
            case 1: {
                return "A Time object, storing hours and minutes.";
            }
            case 2: {
                return "A Date object holding a date and time.";
            }
        }
        return "An invalid Data object";
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public boolean isEqualTo(Magnitude magnitude) {
        if (magnitude instanceof Date) {
            if (this.isNull) {
                return magnitude.isEmpty();
            }
            return this.date.equals(((Date)magnitude).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public boolean isLessThan(Magnitude magnitude) {
        this.checkCanOperate();
        if (magnitude instanceof Date) {
            return !this.isNull && !magnitude.isEmpty() && this.date.before(((Date)magnitude).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public long longValue() {
        this.checkCanOperate();
        return this.date.getTime();
    }

    public void parse(String string) throws ValueParseException {
        if ((string = string.trim()).equals("")) {
            this.clear();
        } else {
            String string2 = string.toLowerCase();
            Calendar calendar = this.createCalendar();
            if (!string2.equals("today") && !string2.equals("now")) {
                if (string2.startsWith("+")) {
                    int n = Integer.valueOf(string2.substring(1));
                    calendar.setTime(this.date);
                    calendar.add(5, n);
                } else if (string2.startsWith("-")) {
                    int n = Integer.valueOf(string2.substring(1));
                    calendar.setTime(this.date);
                    calendar.add(5, -n);
                } else if (this.type == 0) {
                    DateFormat[] dateFormatArray = new DateFormat[]{LONG_FORMAT, MEDIUM_FORMAT, SHORT_FORMAT};
                    int n = 0;
                    while (n < dateFormatArray.length) {
                        try {
                            calendar.setTime(dateFormatArray[n].parse(string));
                            break;
                        }
                        catch (ParseException parseException) {
                            if (n + 1 == dateFormatArray.length) {
                                throw new ValueParseException(parseException, "Invalid date " + string);
                            }
                            ++n;
                        }
                    }
                } else {
                    try {
                        calendar.setTime(this.format().parse(string));
                    }
                    catch (ParseException parseException) {
                        throw new ValueParseException(parseException, "Invalid date " + string);
                    }
                }
            }
            this.set(calendar);
            this.isNull = false;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.isNull = objectInput.readBoolean();
        this.date.setTime(objectInput.readLong());
    }

    public void reset() {
        this.date = new java.util.Date();
        this.isNull = false;
    }

    public boolean sameDayAs(Date date) {
        return this.sameAs(date, 6);
    }

    public boolean sameWeekAs(Date date) {
        return this.sameAs(date, 3);
    }

    public boolean sameMonthAs(Date date) {
        return this.sameAs(date, 2);
    }

    public boolean sameYearAs(Date date) {
        return this.sameAs(date, 1);
    }

    private boolean sameAs(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date.date);
        return calendar.get(n) == calendar2.get(n);
    }

    private void set(Calendar calendar) {
        this.date = calendar.getTime();
    }

    public void setDate(int n, int n2, int n3) {
        this.setValue(n, n2, n3);
    }

    public void setValue(int n, int n2, int n3) {
        this.checkDate(n3, n2, n);
        Calendar calendar = this.createCalendar();
        calendar.set(n, n2 - 1, n3);
        this.set(calendar);
    }

    public void setDate(java.util.Date date) {
        this.setValue(date);
    }

    public void setValue(java.util.Date date) {
        if (date == null) {
            this.isNull = true;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            this.date = calendar.getTime();
        }
    }

    public void setValue(Date date) {
        if (date == null) {
            this.isNull = true;
        } else {
            this.date = new java.util.Date(date.getDate().getTime());
        }
    }

    public void setDateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkDate(n3, n2 - 1, n);
        this.checkTime(n4, n5, n6);
        Calendar calendar = this.createCalendar();
        calendar.set(n3, n2 - 1, n, n4, n5, n6);
        this.set(calendar);
    }

    public void setTime(int n, int n2, int n3) {
        this.checkTime(n, n2, n3);
        Calendar calendar = this.createCalendar();
        calendar.set(10, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        this.set(calendar);
    }

    private void setType(int n) {
        if (n != 0 && n != 2 && n != 1) {
            throw new IllegalArgumentException("Type be must be equal to one of the valid types: DATE, DATE_TIME or TIME");
        }
        this.type = n;
    }

    public void toStartOfWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        calendar.set(8, calendar.getMinimum(8));
        this.date = calendar.getTime();
    }

    public void toStartOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        calendar.set(2, calendar.getMinimum(2));
        this.date = calendar.getTime();
    }

    public void toStartOfYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        calendar.set(6, calendar.getMinimum(6));
        this.date = calendar.getTime();
    }

    public Title title() {
        return new Title(this.isNull ? "" : this.format.format(this.date));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.isNull);
        objectOutput.writeLong(this.date.getTime());
    }

    public void restoreString(String string) {
        if (string.equals("NULL")) {
            this.clear();
        } else {
            int n = Integer.valueOf(string.substring(0, 4));
            int n2 = Integer.valueOf(string.substring(4, 6));
            int n3 = Integer.valueOf(string.substring(6));
            this.setValue(n, n2, n3);
        }
    }

    public String saveString() {
        if (this.isEmpty()) {
            return "NULL";
        }
        Calendar calendar = this.calendarValue();
        StringBuffer stringBuffer = new StringBuffer(8);
        String string = String.valueOf(calendar.get(1));
        stringBuffer.append("0000".substring(0, 4 - string.length()));
        stringBuffer.append(string);
        int n = calendar.get(2) + 1;
        stringBuffer.append(n <= 9 ? "0" : "");
        stringBuffer.append(n);
        int n2 = calendar.get(5);
        stringBuffer.append(n2 <= 9 ? "0" : "");
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }
}

