/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.Server;

class SerialNumberRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private String id;

    public SerialNumberRequest(String string) {
        this.id = string;
    }

    void generateResponse(Server server) {
        try {
            this.response = new Long(server.getObjectStore().serialNumber(this.id));
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public String getId() {
        return this.id;
    }

    public long getSerialNumber() throws ObjectStoreException {
        this.sendRequest();
        return (Long)this.response;
    }

    public String toString() {
        return "Serial Number [" + this.getId() + "]";
    }
}

