/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.Server;

class NumberOfElementsRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private Object collectionOid;

    public NumberOfElementsRequest(NakedCollection nakedCollection) {
        this.collectionOid = nakedCollection.getOid();
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            this.response = new Integer(nakedObjectStore.numberOfElements((NakedCollection)nakedObjectStore.getObject(this.collectionOid)));
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    int size() throws ObjectStoreException {
        this.sendRequest();
        return (Integer)this.response;
    }

    public String toString() {
        return "Number of elements [for=" + this.collectionOid + "]";
    }
}

