/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object;

import java.io.Serializable;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;

public class ExternalOid
implements Serializable {
    private final Object oid;
    private final String type;
    private static final long serialVersionUID = 670440236586243633L;

    public ExternalOid(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot create an ExternalOid for Naked object that has no OID");
        }
        this.oid = object;
        this.type = string;
    }

    public ExternalOid(NakedObject nakedObject) {
        this(nakedObject.getNakedClass().getName(), nakedObject.getOid());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ExternalOid) {
            ExternalOid externalOid = (ExternalOid)object;
            return this.oid.equals(externalOid.oid) && this.type.equals(externalOid.type);
        }
        return false;
    }

    public Object getOid() {
        return this.oid;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.type.hashCode();
        n = 37 * n + this.oid.hashCode();
        return n;
    }

    public NakedObject recreateObject(NakedObjectStore nakedObjectStore) {
        NakedObject nakedObject;
        if (nakedObjectStore.isObjectCached(this.oid)) {
            try {
                nakedObject = nakedObjectStore.getObject(this.oid);
            }
            catch (ObjectStoreException objectStoreException) {
                throw new RuntimeException("Cannot recreate object due to object store problem");
            }
        } else {
            NakedClass nakedClass = NakedClass.getNakedClass(this.type);
            nakedObject = nakedClass.acquireInstance();
            nakedObject.setOid(this.oid);
            nakedObjectStore.cache(nakedObject);
        }
        return nakedObject;
    }

    public String toString() {
        return this.type + "/" + this.oid;
    }
}

