/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view.border;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.ViewBorder;

public class CompoundBorder
extends ViewBorder {
    private ViewBorder inner;
    private ViewBorder outer;

    public CompoundBorder(ViewBorder viewBorder, ViewBorder viewBorder2) {
        if (viewBorder == null) {
            throw new NullPointerException("An outer borders must exists");
        }
        if (viewBorder2 == null) {
            throw new NullPointerException("An inner borders must exists");
        }
        this.inner = viewBorder2;
        this.outer = viewBorder;
    }

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        Insets insets = this.inner.getBorderInsets(objectViewer);
        Insets insets2 = this.outer.getBorderInsets(objectViewer);
        return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        this.outer.paint(graphics, rectangle, objectViewer);
        Insets insets = this.outer.getBorderInsets(objectViewer);
        int n = rectangle.x + insets.left;
        int n2 = rectangle.y + insets.top;
        int n3 = rectangle.width - insets.left - insets.right;
        int n4 = rectangle.height - insets.top - insets.bottom;
        this.inner.paint(graphics, new Rectangle(n, n2, n3, n4), objectViewer);
    }

    public String toString() {
        return "CompoundBorder [outer=" + this.outer + ",inner=" + this.inner + "]";
    }
}

