/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import org.apache.log4j.Category;
import org.nakedobjects.utility.ConfigurationParameters;

public class TextStyle {
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$basicgui$view$TextStyle == null ? (class$org$nakedobjects$basicgui$view$TextStyle = TextStyle.class$("org.nakedobjects.basicgui.view.TextStyle")) : class$org$nakedobjects$basicgui$view$TextStyle));
    private static final Font FALLBACK_FONT = new Font("SansSerif", 0, 12);
    public static final String DEFAULT_FONT = "nakedobjects.basic-gui.font.default";
    public static final String FONT_NORMAL = "nakedobjects.basic-gui.font.normal";
    public static final String FONT_TITLE = "nakedobjects.basic-gui.font.title";
    public static final String FONT_LABEL = "nakedobjects.basic-gui.font.label";
    public static final String FONT_CLASS = "nakedobjects.basic-gui.font.class";
    public static final String FONT_DEBUG = "nakedobjects.basic-gui.font.debug";
    public static final int UNKNOWN = 0;
    public static final int NORMAL = 1;
    public static final int TITLE = 2;
    public static final int LABEL = 3;
    public static final int CLASS = 4;
    public static final int FEEDBACK = 5;
    public static final int DEBUG = 6;
    private static final ConfigurationParameters cfg = ConfigurationParameters.getInstance();
    private static TextStyle[] styles;
    private Font font;
    private Frame fontMetricsComponent = new Frame();
    private FontMetrics metrics;
    static /* synthetic */ Class class$org$nakedobjects$basicgui$view$TextStyle;

    public TextStyle(Font font) {
        this.font = font;
        this.metrics = this.fontMetricsComponent.getFontMetrics(font);
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    public static TextStyle getStyle(int n) {
        if (n < 1 || n >= styles.length) {
            n = 0;
        }
        return styles[n];
    }

    private static TextStyle load(String string) {
        Font font = cfg.getFont(string);
        LOG.info((Object)("font " + string + " loaded as " + font));
        if (font == null) {
            font = cfg.getFont(DEFAULT_FONT, FALLBACK_FONT);
        }
        return new TextStyle(font);
    }

    public String toString() {
        return this.font.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TextStyle textStyle = TextStyle.load(DEFAULT_FONT);
        styles = new TextStyle[]{textStyle, TextStyle.load(FONT_NORMAL), TextStyle.load(FONT_TITLE), TextStyle.load(FONT_LABEL), TextStyle.load(FONT_CLASS), textStyle, TextStyle.load(FONT_DEBUG)};
    }
}

