/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.event.action;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.nakedobjects.basicgui.event.action.ObjectActionEvent;
import org.nakedobjects.basicgui.event.action.ObjectActionListener;

public class ObjectActionProcessor {
    private boolean selected = false;
    private ObjectActionListener listener;

    public ObjectActionProcessor(ObjectActionListener objectActionListener) {
        this.listener = objectActionListener;
    }

    private void click(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.listener.doubleClicked(this.createEvent(3, mouseEvent));
        } else if (mouseEvent.getClickCount() == 3) {
            this.listener.tripleClicked(this.createEvent(4, mouseEvent));
        } else {
            this.listener.clicked(this.createEvent(3, mouseEvent));
            if (this.selected) {
                this.listener.deselected(this.createEvent(6, mouseEvent));
                this.selected = false;
            } else {
                this.listener.selected(this.createEvent(2, mouseEvent));
                this.selected = true;
            }
        }
    }

    private ObjectActionEvent createEvent(int n, MouseEvent mouseEvent) {
        Component component = this.getComponent(mouseEvent);
        int n2 = mouseEvent.getModifiers();
        Point point = mouseEvent.getPoint();
        return new ObjectActionEvent(n, n2, component, point);
    }

    private Component getComponent(MouseEvent mouseEvent) {
        return mouseEvent.getComponent();
    }

    private void popup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if ((mouseEvent.getModifiers() & 1) == 1) {
                this.listener.shiftRightClicked(this.createEvent(7, mouseEvent));
            } else {
                this.listener.rightClicked(this.createEvent(5, mouseEvent));
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                this.click(mouseEvent);
                break;
            }
            case 501: {
                this.popup(mouseEvent);
                break;
            }
            case 502: {
                this.popup(mouseEvent);
                break;
            }
            case 504: {
                this.listener.identified(this.createEvent(0, mouseEvent));
                break;
            }
            case 505: {
                this.listener.deidentified(this.createEvent(1, mouseEvent));
            }
        }
    }
}

