REM  *******************************************************
REM  * Written by CorTech Training for WTT Course I        *
REM  * For Auditors: WTTRGR01.BAS                          *
REM  *******************************************************
'
CLS
PRINT "ENTER FILE NAME, EX. KAY";
INPUT FILE$
FILE$ = FILE$ + ".DAT"
OPEN FILE$ FOR INPUT AS #1
INPUT #1, N%
REM  * Measured Areas and Depths
DIM AREA(N%), DEPTH(N%)
REM  * Linear Regression Variables
DIM X(N%), Y(N%)
REM  * Normalized Areas and Depths
DIM NX(N%), NY(N%)
REM  * FUNCTIONS OF X() AND Y()
DIM FX(N%), FY(N%)
REM  * Calculated normalized values
DIM NORMA(400), NORMD(400), A(400), D(400)
PRINT "ENTER A PIT DEPTH FOR A LONG PIPELINE:";
INPUT PM
FOR I% = 1 TO N%
        INPUT #1, AREA(I%), DEPTH(I%)
       'PRINT I%; AREA(I%), DEPTH(I%)
NEXT
FOR I% = 1 TO N%
        NX(I%) = AREA(I%) / AREA(N%)
        NY(I%) = DEPTH(I%) / DEPTH(N%)
        X(I%) = AREA(I%)
        Y(I%) = DEPTH(I%) / PM
        FY(I%) = LOG(-LOG(1 - Y(I%)))
        FX(I%) = LOG(X(I%))
NEXT I%
FOR I% = 1 TO N%
        SUMX = SUMX + FX(I%)
        SUMY = SUMY + FY(I%)
        SUMXY = SUMXY + FX(I%) * FY(I%)
        SUMXSQ = SUMXSQ + FX(I%) * FX(I%)
        SUMYSQ = SUMYSQ + FY(I%) * FY(I%)
NEXT I%
A = (N% * SUMXY - SUMX * SUMY) / (N% * SUMXSQ - SUMX * SUMX)
B = (SUMY - A * SUMX) / N%
K = A
V = EXP(-B / A)
PRINT K, V
SCREEN 12
VIEW (100, 50)-(520, 375)
WINDOW (-.1, 0)-(1.1, 1.1)
'LINE (0, 0)-(1, 1)
FOR I% = 1 TO N%
        PSET (NX(I%), NY(I%))
        CIRCLE (NX(I%), NY(I%)), .01
NEXT I%
FOR I% = 1 TO 400
        NORMA(I%) = I% / 400
        A(I%) = AREA(N%) * NORMA(I%)
        NORMD(I%) = PM * (1 - EXP(-(A(I%) / V) ^ K)) / DEPTH(N%)
        PSET (NORMA(I%), NORMD(I%))
NEXT I%
FOR J% = 1 TO 110
        PSET (-.1, J% / 100)
        PSET (1.1, J% / 100)
        PSET (-.1 + (J% - 1) * 1.1 / 100, 0)
        PSET (-.1 + (J% - 1) * 1.1 / 100, 1.1)
NEXT J%
LINE (0, 0)-(0, .05)
LINE (0, 1.05)-(O, 1.1)
LINE (1!, 0)-(1!, .05)
LINE (1!, 1.05)-(1!, 1.1)
LINE (-.1, 1!)-(-.05, 1!)
LINE (1.05, 1)-(1.1, 1)
CLOSE #1
END





