/*======================================================================*/
/* Default.cpp: default syntax handling									*/
/*======================================================================*/
/* COPYRIGHT 1992-2002, Jean-Pierre Menicucci - All rights reserved		*/
/*======================================================================*/

#include <afxwin.h>						// mfc defines
#include "..\Ocx\Genfun.h"				// general functions
#include "..\Ocx\Syntax.h"				// syntax functions
#include "Resource.h"					// templates

#define MAX_TOKEN_LENGTH 4095			// 12 bits

enum Syntax { Selected, Space, Other };

/*======================================================================*/
/* InitSyntax: initialize library internal storage (used in "generic")	*/
/* return:																*/
/*		nHan							index of syntax in library		*/
/*======================================================================*/

int __declspec(dllexport) InitSyntax (
	int nSyn,							// syntax index
	LPCTSTR	lpszName					// syntax name
	)
{
	return 0;
}

/*======================================================================*/
/* GetSyntax: return library syntax info								*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void __declspec(dllexport) GetSyntax (
	int nSyn,							// syntax index
	LPCTSTR	lpszName,					// syntax name
	LPCTSTR lpszFile,					// file name
	HKEY hSyntKey						// registry key
	)
{
	LSyntax S;							// syntax object

	S.o_csName = lpszName;				// syntax library name
	S.o_csFile = lpszFile;				// syntax library file
	S.o_csTypes = _T("*.*");			// file types handled

	S.o_csFont = _T("Courier New");		// font name
	if (GetACP() == 1251)				// character set
		S.o_lfCharSet = RUSSIAN_CHARSET;
	else
		S.o_lfCharSet = DEFAULT_CHARSET;
	S.o_nSize = 10;						// size

	S.o_bMirror = TRUE;					// mirror screen font

	S.o_csPFont = _T("Courier New");	// printer font name
	if (GetACP() == 1251)				// character set
		S.o_lfPCharSet = RUSSIAN_CHARSET;
	else
		S.o_lfPCharSet = DEFAULT_CHARSET;
	S.o_nPSize = 10;					// size

	LSyntaxItem Selected (IDS_SELECTED,	0xFFFFFFFF, 0xFF800000, FW_NORMAL, 0x00);
	LSyntaxItem Space	 (IDS_SPACE,	0x00990000, 0xFFFFFFFF, FW_NORMAL, 0x00);
	LSyntaxItem Other	 (IDS_OTHER,	0xFF000000, 0xFFFFFFFF, FW_NORMAL, 0x00);

	S.o_SIA.Add (Selected);
	S.o_SIA.Add (Space);
	S.o_SIA.Add (Other);

	DWORD dwDisposition;				// REG_CREATED_NEW_KEY or REG_OPENED_EXISTING_KEY 
	HKEY hSyntax = 0;					// subtree key

	int rc = RegCreateKeyEx (hSyntKey, lpszName, NULL,
		TEXT(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL,
		&hSyntax, &dwDisposition);

	if (hSyntax) {
		S.Store (hSyntax);
		RegFlushKey (hSyntax);
		RegCloseKey (hSyntax);
		}
}

/*======================================================================*/
/* GLOBBUF		global buffer descriptor								*/
/*======================================================================*/

typedef struct TagGLOBBUF {
	int			nSiz;					// buffer size
	HANDLE		hHan;					// buffer handle
	LPTSTR		lpTex;					// buffer pointer
	int			nLen;					// bytes effective length
	} GLOBBUF, * P_GLOBBUF;

/*======================================================================*/
/* TOKINF		token info descriptor									*/
/*======================================================================*/

typedef struct TagTOKINF {			// token info item
    unsigned nSyn : 4;					// syntax index
    unsigned nVar : 4;					// variant index
    unsigned nInd : 4;					// current syntax
    unsigned nPrv : 4;					// previous syntax
    unsigned nLev : 4;					// nesting level
	unsigned nLen : 12;					// token length
	} TOKINF;

/*======================================================================*/
/* GetToken: minimal syntax processing: spaces and words for word wrap	*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void __declspec(dllexport) GetToken (
	int nSyn,							// syntax index
	GLOBBUF* pGB,						// global buffer
	int nOff,							// token offset
	TOKINF* pTI							// token info
	)
{
LPTSTR lpTex;							// character pointer
int nLen;								// line length
int n;									// index

nLen = pGB->nLen;
if (nLen == 0)							// empty line
	return;								// return

lpTex = pGB->lpTex + nOff;				// pointer to token beginning
pTI->nPrv = pTI->nInd;					// previous syntax
pTI->nLev = 0;							// nesting level

/********************/
/* token is a space */
/********************/

if (*lpTex == ' ' || *lpTex == '\t') {
	pTI->nInd = Space;
	for (n = 1; n < nLen - nOff && n < MAX_TOKEN_LENGTH; n++)
		if (*(lpTex + n) != ' ' && *(lpTex + n) != '\t')
			break;
	}

/*******************/
/* token is a word */
/*******************/

else {
	pTI->nInd = Other;
	for (n = 1; n < nLen - nOff && n < MAX_TOKEN_LENGTH; n++)
		if (*(lpTex + n) == ' ' || *(lpTex + n) == '\t')
			break;
	}

pTI->nLen = n;
}
