#ifndef _FILE_FUNCS
#define _FILE_FUNCS

#include "sticky.h"

enum ExportModes {TEXTMODE = 0, RECORDMODE = 1};

#define EXPORTVERSION15 "StickyExport V1.5\032"
#define EXPORTVERSION16 "StickyExport V1.6\032"

// ***************** Previous Sticky Structures *****************



struct StickyRecFMT15
{
    struct StringRec
    {
        int   strLen;
        char* pString;
    };

    struct Alarm
    {
        int   year, month, day;
        int   hour, minute, AMPM;                     // am = 0, pm = 1;
        int   alarmSndRpt;
        BOOL  LoopPlayback;
        BOOL  alarmEnabled;   

        // Alarm blinking of sticky notes...
        COLORREF alarmBlinkCol;                       // colour of the sticky that will blink.
        BOOL     alarmBlinking;                       // allow blinking of sticky?
        BOOL     alarmBlinker;                        // used to test when sticky is activated
                                                      // after an alarm.
    };

    RECT      winDim;

    // Colour definition for window
    COLORREF  textCol;
    COLORREF  backCol;
    HBRUSH    backGH;

    // Window State Variables.
    BOOL      rolledUp;
    BOOL      minimised;
    BOOL      restored;
    int       winShowState;
    BOOL      topMostWin;
    BOOL      vScrollBar;
    BOOL      hScrollBar;    
    BOOL      thinEdge;

    StringRec userMemo;
    BOOL      wordWrapped;
    HWND      stickyWnd;
    HWND      editControl;

    // Font info for a given sticky edit control
    LOGFONT   editFont;
    HFONT     hFont;

    // Font to describe sticky title
    LOGFONT   titleFont;

    // ***** Sticky Window Caption ******
    char  winCaption[CAPTIONSIZE+1];           // 51 is the default Sticky preferences
    Alarm stickyAlrm;                          // Alarm information.
};


// ************************** function prototypes ***************************

int  ImportStickyFile   (char* pFileName);
int  ImportStickyFile   (void);
int  ExportStickyFile   (int wndIdx);
void Convert15to16      (StickyRec* pNewRec, StickyRecFMT15* pOldRec);
int  ImportDragDropFile (char* pFileName, int mode, int wndIdx);
int  ImportStickyFileIntoEditControl (int mode, int wndIdx);

#endif // _FILE_FUNCS