#ifndef _BALL_CODE
#define _BALL_CODE

#include <stdlib.h>         // rand(), abs()
#include <time.h>
#include <windows.h>
#include "ball.h"

void Ball::Init (  int xSR, int ySR,
                   int miX, int maX,
                   int miY, int maY,
                   HWND hwd, int icnID)
{   
    RECT parentWnd;


     srand( (unsigned)time( NULL ) );

    // Assign  screen boundrys
    minX = miX; maxX = maX;
    minY = miY; maxY = maY;

    // Assign rotation values.
    xSpdRng = xSR;
    ySpdRng = ySR;

    // Initialise the x, y, z speed increment
    xSpd = (rand() % xSpdRng)+2;
    ySpd = (rand() % ySpdRng)+2;

    // These parameters will be used to move object over the screen
    hwnd   = hwd;
    iconID = icnID;

    GetWindowRect (GetDlgItem (hwnd, iconID), &iconRect);
    GetWindowRect (hwnd, &parentWnd);
    tx = iconRect.left - parentWnd.left;
    ty = iconRect.top  - parentWnd.top;
    GetClientRect (GetDlgItem (hwnd, iconID), &iconRect);
}

void Ball::Show ()
{
    // move the icon to a new location.
    MoveWindow     (GetDlgItem (hwnd, iconID), tx, ty, iconRect.right, iconRect.bottom, TRUE);
    InvalidateRect (GetDlgItem (hwnd, iconID), NULL, TRUE);
}

void Ball::Move (void)
{
    // Main working function.
    tx += xSpd;
    ty += ySpd;

    // Process x coordinate
    if ((tx <= minX) || (tx >= (maxX-iconRect.right)))
    {
       tx += -xSpd;
       if (xSpd > 0)
           xSpd = -((rand() % xSpdRng)+1);
       else
           xSpd = ((rand() % xSpdRng)+1);
    }

    // Process y coordinate
    if ((ty <= minY) || (ty >= (maxY-iconRect.bottom)))
    {
        ty += -ySpd;
        if (ySpd > 0)
           ySpd = -((rand() % ySpdRng)+1);
        else
            ySpd = ((rand() % ySpdRng)+1);

    }
}

#endif // _BALL_CODE