/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nt;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class NTEventLogAppender
extends AppenderSkeleton {
    private int _handle = 0;
    public static final String SOURCE_OPTION = "Source";
    private String source = null;
    private String server = null;
    private static final int FATAL = Priority.FATAL.toInt();
    private static final int ERROR = Priority.ERROR.toInt();
    private static final int WARN = Priority.WARN.toInt();
    private static final int INFO = Priority.INFO.toInt();
    private static final int DEBUG = Priority.DEBUG.toInt();

    public NTEventLogAppender() {
        this(null, null, null);
    }

    public NTEventLogAppender(String source) {
        this(null, source, null);
    }

    public NTEventLogAppender(String server, String source) {
        this(server, source, null);
    }

    public NTEventLogAppender(Layout layout) {
        this(null, null, layout);
    }

    public NTEventLogAppender(String source, Layout layout) {
        this(null, source, layout);
    }

    public NTEventLogAppender(String server, String source, Layout layout) {
        if (source == null) {
            source = "Log4j";
        }
        this.layout = layout == null ? new TTCCLayout() : layout;
        try {
            this._handle = this.registerEventSource(server, source);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._handle = 0;
        }
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{SOURCE_OPTION});
    }

    public void setOption(String key, String value) {
        if (value == null) {
            return;
        }
        super.setOption(key, value);
        if (key.equalsIgnoreCase(SOURCE_OPTION)) {
            this.source = value.trim();
        }
    }

    public void close() {
    }

    public void activateOptions() {
        if (this.source != null) {
            try {
                this._handle = this.registerEventSource(this.server, this.source);
            }
            catch (Exception e) {
                LogLog.error("Could not register event source.", e);
                this._handle = 0;
            }
        }
    }

    public void append(LoggingEvent event) {
        String[] s;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            int len = s.length;
            int i = 0;
            while (i < len) {
                sbuf.append(s[i]);
                ++i;
            }
        }
        int nt_category = event.priority.toInt();
        this.reportEvent(this._handle, sbuf.toString(), nt_category);
    }

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public void setSource(String source) {
        this.source = source.trim();
    }

    public String getSource() {
        return this.source;
    }

    public boolean requiresLayout() {
        return true;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    private native void deregisterEventSource(int var1);

    static {
        System.loadLibrary("NTEventLogAppender");
    }
}

