/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.ui;

import com.rexbot.game.ui.UICommand;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Category;

public class UIService {
    private static Category cat = Category.getInstance(class$com$rexbot$game$ui$UIService == null ? (class$com$rexbot$game$ui$UIService = UIService.class$("com.rexbot.game.ui.UIService")) : class$com$rexbot$game$ui$UIService);
    private static UIService instance = null;
    private static String REGFILE = "/registration.properties";
    private Hashtable commands = new Hashtable();
    static /* synthetic */ Class class$com$rexbot$game$ui$UIService;

    private UIService() {
        try {
            this.registerCommands();
        }
        catch (Exception e) {
            cat.error(e, e);
        }
    }

    public static UIService getInstance() {
        if (instance == null) {
            instance = new UIService();
        }
        return instance;
    }

    public void fire(String cmd, Object data) {
        cat.debug("Firing cmd=" + cmd + " data=" + data);
        UICommand uicmd = (UICommand)this.commands.get(cmd);
        if (uicmd == null) {
            cat.error("Command does not exist for cmd=" + cmd + " data=" + data);
            return;
        }
        uicmd.fire(data);
    }

    private void registerCommands() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Properties reg = new Properties();
        InputStream is = this.getClass().getResourceAsStream(REGFILE);
        if (is == null) {
            cat.fatal("Unable to find command registration file.  REGFILE=" + REGFILE);
        }
        reg.load(is);
        Iterator<Object> it = reg.keySet().iterator();
        while (it.hasNext()) {
            Object cmd = it.next();
            String cmdClass = (String)reg.get(cmd);
            cat.debug("Registering cmd=" + cmd + " with class=" + cmdClass);
            this.commands.put(cmd, Class.forName(cmdClass).newInstance());
            cat.debug("Registered cmd=" + cmd + " with class=" + cmdClass);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

