/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.HandCalculator;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.Palette;
import com.rexbot.game.card.Player;
import com.rexbot.game.card.commands.NewGameCommand;
import java.awt.Color;
import java.io.IOException;
import java.util.Hashtable;

public class PlayerManager {
    private Hashtable players = new Hashtable();
    private static PlayerManager instance = null;

    private PlayerManager() {
    }

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }

    public Player getPlayer(int num) {
        Player player = (Player)this.players.get(String.valueOf(num));
        if (player == null) {
            player = new Player(num);
            this.players.put(String.valueOf(num), player);
        }
        return player;
    }

    public void saveBrains() throws IOException {
        for (int i = 1; i <= 10; ++i) {
            Player player = this.getPlayer(i);
            player.getBrain().save("brain_" + i);
        }
    }

    public void retrieveBrains() throws IOException {
        for (int i = 1; i <= 10; ++i) {
            Player player = this.getPlayer(i);
            player.getBrain().retrieve("brain_" + i);
        }
    }

    public void scrambleBrains() throws IOException {
        for (int i = 1; i <= 10; ++i) {
            Player player = this.getPlayer(i);
            player.getBrain().scramble();
        }
        this.saveBrains();
    }

    public void setHumanPlayer(int number) {
        for (int i = 1; i <= 10; ++i) {
            Player player = (Player)this.players.get(String.valueOf(i));
            if (i == number) {
                player.setType(0);
            } else {
                player.setType(1);
            }
            player.setStake(0L);
        }
    }

    public void resetActivePlayers() {
        for (int i = 1; i <= 10; ++i) {
            Player player = (Player)this.players.get(String.valueOf(i));
            player.setAmountBetthisRound(0L);
            if (!player.isFolded()) {
                if (NewGameCommand.run) {
                    if (player.getNumber() == Opts.getInstance().getHumanPlayer()) {
                        player.getHand().setMessage(HandCalculator.getPokerValueAsString(player.getHand().getCards()), Palette.backgroundColor, Color.black);
                    } else {
                        player.getHand().setMessage("Waiting", Palette.backgroundColor, Color.black);
                    }
                } else {
                    player.getHand().setMessage(HandCalculator.getPokerValueAsString(player.getHand().getCards()), Palette.backgroundColor, Color.black);
                }
            }
            if (i <= Opts.getInstance().getNumOfPlayers()) continue;
            player.setFolded(true);
        }
    }

    public void unfoldPlayers() {
        for (int i = 1; i <= 10; ++i) {
            Player player = (Player)this.players.get(String.valueOf(i));
            if (i > Opts.getInstance().getNumOfPlayers()) {
                player.setFolded(true);
                continue;
            }
            player.setFolded(false);
        }
    }

    public Player getFirstActivePlayer() {
        for (int i = 1; i <= 10; ++i) {
            Player player = (Player)this.players.get(String.valueOf(i));
            if (player.isFolded()) continue;
            return player;
        }
        return null;
    }

    public boolean allBetsEqual() {
        long bet = this.getFirstActivePlayer().getAmountBetThisRound();
        for (int i = 1; i <= 10; ++i) {
            Player player = (Player)this.players.get(String.valueOf(i));
            if (player.isFolded() || player.getAmountBetThisRound() == bet) continue;
            return false;
        }
        return true;
    }

    public int getActivePlayerCount() {
        int count = 0;
        for (int i = 1; i <= 10; ++i) {
            Player player = (Player)this.players.get(String.valueOf(i));
            if (player.isFolded()) continue;
            ++count;
        }
        return count;
    }
}

