/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Main;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.Palette;
import com.rexbot.game.ui.UIService;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.log4j.Category;

public class HumanInput
extends JPanel
implements ActionListener {
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$HumanInput == null ? (class$com$rexbot$game$card$HumanInput = HumanInput.class$("com.rexbot.game.card.HumanInput")) : class$com$rexbot$game$card$HumanInput);
    long amount = 0L;
    private JLabel betTextLabel;
    private JButton callButton;
    private JButton foldButton;
    private JButton quitButton;
    private JButton raiseButton;
    private int decision;
    static /* synthetic */ Class class$com$rexbot$game$card$HumanInput;

    public HumanInput() {
        this.initComponents();
        this.setOpaque(false);
        this.setVisible(false);
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Palette.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g2d);
    }

    private void initComponents() {
        this.betTextLabel = new JLabel();
        this.foldButton = new JButton();
        this.callButton = new JButton();
        this.raiseButton = new JButton();
        this.quitButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.betTextLabel.setFont(new Font("SansSerif", 0, 24));
        this.betTextLabel.setText("Bet to you: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.betTextLabel, gridBagConstraints);
        this.foldButton.setMnemonic('f');
        this.foldButton.setText("Fold");
        this.foldButton.setOpaque(false);
        this.foldButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HumanInput.this.foldButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.foldButton, gridBagConstraints);
        this.callButton.setMnemonic('c');
        this.callButton.setText("Call");
        this.callButton.setOpaque(false);
        this.callButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HumanInput.this.callButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.callButton, gridBagConstraints);
        this.raiseButton.setMnemonic('r');
        this.raiseButton.setText("Raise");
        this.raiseButton.setOpaque(false);
        this.raiseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HumanInput.this.raiseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.raiseButton, gridBagConstraints);
        this.quitButton.setMnemonic('q');
        this.quitButton.setText("Quit");
        this.quitButton.setOpaque(false);
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HumanInput.this.quitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.quitButton, gridBagConstraints);
    }

    private void quitButtonActionPerformed(ActionEvent evt) {
        UIService.getInstance().fire("StopGame", null);
        this.setDecision(-1);
    }

    private void raiseButtonActionPerformed(ActionEvent evt) {
        this.setDecision(2);
    }

    private void callButtonActionPerformed(ActionEvent evt) {
        this.setDecision(1);
    }

    private void foldButtonActionPerformed(ActionEvent evt) {
        this.setDecision(0);
    }

    public synchronized int getDecision(long bet) {
        this.betTextLabel.setText("Bet To You: $" + bet * (long)Opts.getInstance().getBetMultiplier());
        if (bet == 0L) {
            this.foldButton.setEnabled(false);
        } else {
            this.foldButton.setEnabled(true);
        }
        this.setVisible(true);
        ((JComponent)Main.instance.getContentPane()).registerKeyboardAction(this, "f", KeyStroke.getKeyStroke('f'), 1);
        ((JComponent)Main.instance.getContentPane()).registerKeyboardAction(this, "c", KeyStroke.getKeyStroke('c'), 1);
        ((JComponent)Main.instance.getContentPane()).registerKeyboardAction(this, "r", KeyStroke.getKeyStroke('r'), 1);
        ((JComponent)Main.instance.getContentPane()).registerKeyboardAction(this, "q", KeyStroke.getKeyStroke('q'), 1);
        this.requestFocus();
        this.repaint();
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.decision;
    }

    public synchronized void setDecision(int decision) {
        this.decision = decision;
        cat.debug("trying to notify of decision=" + decision);
        this.setVisible(false);
        ((JComponent)Main.instance.getContentPane()).unregisterKeyboardAction(KeyStroke.getKeyStroke('f'));
        ((JComponent)Main.instance.getContentPane()).unregisterKeyboardAction(KeyStroke.getKeyStroke('c'));
        ((JComponent)Main.instance.getContentPane()).unregisterKeyboardAction(KeyStroke.getKeyStroke('r'));
        ((JComponent)Main.instance.getContentPane()).unregisterKeyboardAction(KeyStroke.getKeyStroke('q'));
        this.repaint();
        this.notifyAll();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("f")) {
            this.setDecision(0);
        } else if (actionEvent.getActionCommand().equals("c")) {
            this.setDecision(1);
        } else if (actionEvent.getActionCommand().equals("r")) {
            this.setDecision(2);
        } else if (actionEvent.getActionCommand().equals("q")) {
            UIService.getInstance().fire("StopGame", null);
            this.setDecision(-1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

