// This code (C) 1998-2000 Sean Dwyer <ewe2@cvis.com.au> under GPL.

#ifndef __mtools_h
#define __mtools_h

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// decided to change to the 285 correlation because astronomical data supports
// it much better


#define JD_CORRELATION 584285.0L

// the safer integer mod
#define AMOD(x,y) (1 + (((x) - 1) % (y)))

#define GREGORIAN_EPOCH 1

// defines for setting date format - not strictly necessary atm.
#define DATE_GREGOK (0x0001)
#define DATE_JDNOK  (0x0002)
#define DATE_LONGOK (0x0004)

// structures to turn all that pesky data into one variable

typedef struct longdate
{
	int bak,kat,tun,uin,kin;
} longdate;

typedef struct gregdate
{
	int day, month, year;
} gregdate;

// nice simple structure for everything

typedef struct mydate
{
	unsigned int set;
	gregdate gdate;
	longdate ldate;
	double jdn;
} mydate;

// exported functions - amounts to a public dll interface
// IMPORTANT - ONLY include functions necessary to other apps,
// this version currently only supports current display NOT
// arbitary dates!!
// all these are necessary for output

// can anyone explain why date_from_jul() was declared "int"
// but actually "void" in the source and gcc DIDNT KNOW?!
// cBuilder complained right away <ack>

extern "C" __declspec(dllexport) void date_from_jul(double, gregdate *thedate);
extern "C" __declspec(dllexport) double gregtojdn(int day, int month, int year);
extern "C" __declspec(dllexport) void jdntolong(double, longdate *thedate);
extern "C" __declspec(dllexport) double longtojdn(longdate *thedate);
extern "C" __declspec(dllexport) const char *get_haab_date(double,int *);
extern "C" __declspec(dllexport) const char *get_tzolkin_date(double, int *);
extern "C" __declspec(dllexport) void set_date(mydate *thedate);
// exported to provide the look of the old commandline version.
extern "C" __declspec(dllexport) const char *gmonth_str(int);
#endif // __mtools_h


