#include <stdio.h>
#include <string.h>

#define oldNameLen 24
#define oldDateLen 10
#define oldPhoneLen 13
#define oldAddressLen 34

#define newNameLen 40
#define newDateLen 10
#define newPhoneLen 21
#define newAddressLen 40
#define newDayLen 2


void main(void)
{
   FILE * in;
   FILE * out;
   char str1[oldNameLen+oldDateLen+oldPhoneLen+oldAddressLen],
        str2[newNameLen+newDateLen+newPhoneLen+newAddressLen+newDayLen];
   int  oldLen = oldNameLen+oldDateLen+oldPhoneLen+oldAddressLen,
        newLen = newNameLen+newDateLen+newPhoneLen+newAddressLen+newDayLen,
        i;

   printf("BIRTHDAY SCANNER v1.1  (Convertor Utility)\n");
   printf("Converts datafile BIRTHDAY.TXT from old 1.0 to new 1.1 version.\n");

   if (rename("birthday.txt","birthday.tx1") != 0)
   {
      printf("Can't rename old datafile BIRTHDAY.TXT to BIRTHDAY.TX1...");
      return;
   }

   if ( (in = fopen("birthday.tx1","rt")) == NULL )
   {
      printf("Can't open old datafile BIRTHDAY.TXT...");
      return;
   }

   if ( (out = fopen("birthday.txt","w+t")) == NULL)
   {
      printf("Can't open old datafile BIRTHDAY.TXT...");
      return;
   }


   while (!feof(in))
   {
      fgets(str1,oldLen,in);

      if (strlen(str1)>0)
      {
         memset(str2,' ',newLen);
         memcpy(str2,str1,oldNameLen);
         memcpy(str2+newNameLen,str1+oldNameLen,oldDateLen);
         memcpy(str2+newNameLen+newDateLen,str1+oldNameLen+oldDateLen,oldPhoneLen);

         i = strlen(str1)-oldNameLen-oldDateLen-oldPhoneLen;
         if (i>0)
         {
            memcpy(str2+newNameLen+newDateLen+newPhoneLen,str1+oldNameLen+oldDateLen+oldPhoneLen,i);
         }
         memcpy(str2+newNameLen+newDateLen+newPhoneLen+newAddressLen,"3 ",newDayLen);
         str2[newLen] = 0;
         str2[newLen+1] = 0;
         fputs(str2,out);
      }
   }

   fclose(out);
   fclose(in);

   printf("Datafile BIRTHDAY.TXT was successfully converted!\n");

   if (remove("birthday.tx1") != 0)
   {
      printf("Can't remove old datafile BIRTHDAY.TX1...");
   }

}
