<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">



<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[

function setTab(focusItem) {
    focusItem.focus();
}


function loadPO(LINK,PO) {

  var features = "scrollbars=yes,resizable=yes";
  var newlink = LINK + "?disValue=807&PONumber=" + PO; 
  var newLayer = open(newlink,"PO",features);
}

]]>
</xsl:comment>
</SCRIPT>


<HTML>
<HEAD>
     <TITLE>Show Commission Page</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<BODY onLoad="setTab(FORM1.POIDNUM)">



<CENTER><H1>Enter Commissions</H1></CENTER>
<P></P>

<xsl:choose>
<xsl:when test="MSI/ERROR[.='1']">
<H2>Could not find a PO matching the one entered!</H2>
<P></P>
</xsl:when>
</xsl:choose>

<xsl:choose>
<xsl:when test="MSI/ERROR[.='2']">
<H2>Need to select a REP or enter a PO!</H2>
<P></P>
</xsl:when>
</xsl:choose>


<H2>
<TABLE>
<TR><TD>Total Check Value </TD><TD>

<xsl:choose>
<xsl:when test="MSI/COMINFO/POComTable/i5[.!='']">
$<xsl:value-of select="format-number(sum(MSI/COMINFO/POComTable/i5), '###,##0.00')"/>
</xsl:when>
</xsl:choose>

</TD></TR>


<TR><TD>Check # </TD><TD><xsl:value-of select="MSI/CHECKNUM"/></TD></TR>
<TR><TD>Supplier </TD><TD><xsl:value-of select="MSI/SUPPLIER"/></TD></TR>
<TR><TD>Date Received </TD><TD><xsl:value-of select="MSI/DATERECV"/></TD></TR>
</TABLE>
</H2>

<FORM METHOD="POST" NAME="FORM1">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<INPUT type="hidden" name="disValue" value="802"></INPUT>


<TABLE>
<TR><TD>PO Number</TD><TD><INPUT NAME="POIDNUM" SIZE="10"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/DATA/d3"/></xsl:attribute></INPUT></TD></TR>
<TR><TD>Invoice Number</TD><TD><INPUT NAME="INVOICENUM" SIZE="10"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/DATA/d4"/></xsl:attribute></INPUT></TD></TR>
<TR><TD>Amount Received</TD><TD><INPUT NAME="AMOUNTRECV" SIZE="10"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/DATA/d5"/></xsl:attribute></INPUT></TD></TR>

<xsl:choose>
<xsl:when test="MSI/REPLIST/REP/REPNAME[.!='']">

<TR><TD>Associated Rep</TD><TD><SELECT NAME="REP">

<OPTION> 
	<xsl:attribute name="VALUE"></xsl:attribute>Choose Rep
</OPTION>

<xsl:for-each select="MSI/REPLIST/REP">
<xsl:sort select="REPNAME" data-type="text" order="ascending"/>
<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="REPID"/></xsl:attribute><xsl:value-of select="REPNAME"/>
</OPTION>
</xsl:for-each>

</SELECT></TD>
<TD>This is only needed when PO does not exist or to override PO</TD>
</TR>
</xsl:when>
</xsl:choose>



<TR><TD>Notes</TD><TD><INPUT NAME="NOTES" SIZE="20"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/DATA/d10"/></xsl:attribute></INPUT></TD></TR>
</TABLE>
<INPUT TYPE="SUBMIT" NAME="ENTER" VALUE="Enter"></INPUT>
</FORM>

<FORM METHOD="POST">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<TABLE>
	
		<TR>
			<TH/>
			<TH>PO Number</TH>
			<TH>Invoice Number</TH>
			<TH>Amount Received</TH>
			<TH>Rep ID</TH>		
			<TH>Notes</TH>
		</TR>
		<xsl:for-each select="MSI/COMINFO/POComTable">
			<TR>
			 <xsl:choose>
			 <xsl:when test="position() mod 2 = 1">
				 <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			 </xsl:when>
			 <xsl:otherwise>
				 <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			 </xsl:otherwise>
			 </xsl:choose>			

				<TD><INPUT TYPE="CheckBox">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i3"/></xsl:attribute>
				     </INPUT></TD>
				<TD><xsl:value-of select="i3"/></TD>
				<TD><xsl:value-of select="i4"/></TD>
				<TD>$<xsl:value-of select="i5"/></TD>
				<TD><xsl:value-of select="i9"/></TD>
				<TD><xsl:value-of select="i10"/></TD>
				
				<xsl:choose>
				<xsl:when test="i8[.='1']">
				<TD>
				<BUTTON>
				<xsl:attribute name="ONCLICK">loadPO(&quot;<xsl:value-of select="/MSI/LAYOUT/SERVLET"/>&quot;,&quot;<xsl:value-of select="i3"/>&quot;);</xsl:attribute>
				Reconcile PO		
				</BUTTON>
				</TD>
				</xsl:when>
				</xsl:choose>


			
			</TR>
		</xsl:for-each>
</TABLE>



<INPUT type="hidden" name="disValue" value="803"></INPUT>
<INPUT type="hidden" NAME="TOTALITEMS"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/COMINFO/FOOTER/TOTALCOUNT"/></xsl:attribute></INPUT>
<INPUT TYPE="SUBMIT" NAME="DELETE" VALUE="Delete Entries"></INPUT>
</FORM><P></P>




</BODY></HTML>
</xsl:template>

</xsl:stylesheet>
