<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Pay Rep</TITLE>
</HEAD>

<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY>
<xsl:attribute name="BGCOLOR"><xsl:value-of select="MSI/LAYOUT/BGCOLOR"/></xsl:attribute>
<xsl:attribute name="TEXT"><xsl:value-of select="MSI/LAYOUT/TEXT"/></xsl:attribute>
<xsl:attribute name="LINK"><xsl:value-of select="MSI/LAYOUT/LINK"/></xsl:attribute>
<xsl:attribute name="ALINK"><xsl:value-of select="MSI/LAYOUT/ALINK"/></xsl:attribute>
<xsl:attribute name="VLINK"><xsl:value-of select="MSI/LAYOUT/VLINK"/></xsl:attribute>
<xsl:attribute name="BACKGROUND"><xsl:value-of select="MSI/LAYOUT/BACKGROUND"/></xsl:attribute>

<!-- End of Include section -->



<!-- Page Specific Data -->
<!-- ***************************************************************************************** -->


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function reCalc() {
   form = document.COMMISSIONS;
   var field = form.CHECKTOTAL;  
   var items = form.elements;
   var sum = form.ADJUST.value*1;	

   	
   var i = 0;	
   for(i=0;i<items.length;i++)
   {
		var item = items[i];
		
		if(item != null)
		{
			if(item.type == "checkbox")
			{
			  			  if(item.checked)
			  {
					sum += item.value*1; 
			  }
			   			 
			}
		}
	}	   
   
	//
	// Change this to a dollar value
	//
	//	var sumString = '$' + ((Math.floor(sum)) ? 'test' + '.00' : (  (sum*10 == Math.floor(sum*10)) ? sum + '0' : sum)); 
	var sumString = '$' + ((Math.round(sum*100))/100);
     
	
 
	form.CHECKTOTAL.value=sumString;
}
]]>
</xsl:comment>
</SCRIPT>

<xsl:script>
<![CDATA[ 
    function Total(invoice)
    {
      items = invoice.selectNodes("MSI/COMINFO/POComTable");
      var sum2 = 0;
      
      var item = items.nextNode();		
      while (item)
      {
        var price = item.selectSingleNode("i5").nodeTypedValue;
        sum2 += comTotal(item);
	item = items.nextNode();
      }
      
      return sum2;
    }



    function comTotal(item)
    {
        var price = item.selectSingleNode("i5").nodeTypedValue;
        var com = item.selectSingleNode("/MSI/COMM").nodeTypedValue;
      
	var sum2 = price*1*com/100;
      
	return sum2;
    }


   ]]> 
 
</xsl:script> 



<CENTER><FONT FACE="Times New Roman" SIZE="6" COLOR="#FFFF99"><B>Current commissions received that have not been paid.</B></FONT></CENTER><P></P>
<A HREF=""></A><P></P>
<P></P>
<TABLE>

<TR>
<TD>Sales Rep:</TD>
<TD><xsl:value-of select="MSI/REPNAME"/></TD>
</TR>

<TR>
<TD>Check Number:</TD>
<TD><xsl:value-of select="MSI/CHECKNUM"/></TD>
</TR>

<TR>
</TR>

</TABLE>


<FORM METHOD="POST" NAME="COMMISSIONS">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<TABLE>
<TR>
<TD>Total Check:</TD>
<TD>
<INPUT TYPE="TEXT" NAME="CHECKTOTAL" readonly="yes" size="10">
<xsl:attribute name="VALUE"><xsl:eval>formatNumber(Total(this), "$#,##0.00")</xsl:eval></xsl:attribute>
</INPUT>
</TD>
</TR>

<TR>
<TD>Adjustments:</TD>
<TD><INPUT TYPE="TEXT" NAME="ADJUST" onBlur="reCalc();"></INPUT></TD>
</TR>

<TR>
<TD>Notes:</TD>
<TD><INPUT TYPE="TEXT" NAME="NOTES"></INPUT></TD>
</TR>
<P></P>

</TABLE>

Uncheck the payments that will not be paid at this time.
<TABLE BORDER="1">
		<TR>
			<TD><b></b></TD>
			<TD><b>PO Number</b></TD>
			<TD><b>Date Recevied</b></TD>
			<TD><b>Commission</b></TD>
			<TD><b>Rep Commission</b></TD>
			<TD><b>Notes</b></TD>
		</TR>
		
		<xsl:for-each select="MSI/COMINFO/POComTable" order-by="i2">
			<TR>
				<TD><INPUT TYPE="CheckBox" checked="yes" onClick="reCalc();">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:eval>comTotal(this)</xsl:eval></xsl:attribute>
				     </INPUT></TD>
				<TD><xsl:value-of select="i3"/></TD>
				<TD><xsl:value-of select="i2"/></TD>
				<TD>$<xsl:value-of select="i5"/></TD>
				<TD><xsl:eval>formatNumber(comTotal(this), "$#,##0.00")</xsl:eval></TD>
				<TD><xsl:value-of select="i10"/></TD>
				
				<INPUT type="hidden">
					<xsl:attribute name="NAME">PO<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i3"/></xsl:attribute>
				     </INPUT>
                        
				<INPUT type="hidden">
					<xsl:attribute name="NAME">CHECK<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i0"/></xsl:attribute>
				     </INPUT>

				<INPUT type="hidden">
					<xsl:attribute name="NAME">SUPPLIER<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i1"/></xsl:attribute>
				     </INPUT>
			
				<INPUT type="hidden">
					<xsl:attribute name="NAME">AMOUNT<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i5"/></xsl:attribute>
   	     </INPUT>
	
			</TR>
		</xsl:for-each>
</TABLE>



<INPUT type="hidden" name="disValue" value="806"></INPUT>
<INPUT type="hidden" NAME="TOTALITEMS"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/COMINFO/FOOTER/TOTALCOUNT"/></xsl:attribute></INPUT>
<INPUT TYPE="SUBMIT" NAME="Check" VALUE="Enter Check"></INPUT>
</FORM>


</BODY></HTML>

</xsl:template>
</xsl:stylesheet>

