/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.TagCache;
import org.apache.jasper.compiler.TagGeneratorBase;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.runtime.JspLoader;

public class TagBeginGenerator
extends TagGeneratorBase
implements ServiceMethodPhase {
    String prefix;
    String shortTagName;
    Hashtable attrs;
    TagLibraryInfoImpl tli;
    TagInfo ti;
    TagAttributeInfo[] attributes;
    String baseVarName;
    String thVarName;
    TagCache tc;
    TagData tagData;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$BodyTag;

    public TagBeginGenerator(String prefix, String shortTagName, Hashtable attrs, TagLibraryInfoImpl tli, TagInfo ti) throws JasperException {
        this.prefix = prefix;
        this.shortTagName = shortTagName;
        this.attrs = attrs;
        this.tli = tli;
        this.ti = ti;
        this.attributes = ti.getAttributes();
        this.baseVarName = TagGeneratorBase.getTagVarName(prefix, shortTagName);
        this.thVarName = "_jspx_th_" + this.baseVarName;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void generate(ServletWriter writer, Class phase) throws JasperException {
        this.generateServiceMethodStatements(writer);
    }

    public void generateServiceMethodStatements(ServletWriter writer) throws JasperException {
        TagGeneratorBase.TagVariableData top = TagGeneratorBase.topTag();
        String parent = top == null ? null : top.tagHandlerInstanceName;
        String evalVar = "_jspx_eval_" + this.baseVarName;
        TagGeneratorBase.tagBegin(new TagGeneratorBase.TagVariableData(this.thVarName, evalVar));
        writer.println("/* ----  " + this.prefix + ":" + this.shortTagName + " ---- */");
        writer.println(String.valueOf(this.ti.getTagClassName()) + " " + this.thVarName + " = new " + this.ti.getTagClassName() + "();");
        this.generateSetters(writer, parent);
        VariableInfo[] vi = this.ti.getVariableInfo(this.tagData);
        TagGeneratorBase.declareVariables(writer, vi, true, false, 1);
        writer.println("try {");
        writer.pushIndent();
        writer.println("int " + evalVar + " = " + this.thVarName + ".doStartTag();");
        boolean implementsBodyTag = (class$javax$servlet$jsp$tagext$BodyTag != null ? class$javax$servlet$jsp$tagext$BodyTag : (class$javax$servlet$jsp$tagext$BodyTag = TagBeginGenerator.class$("javax.servlet.jsp.tagext.BodyTag"))).isAssignableFrom(this.tc.getTagHandlerClass());
        TagGeneratorBase.declareVariables(writer, vi, false, true, 1);
        if (implementsBodyTag) {
            writer.println("if (" + evalVar + " == Tag.EVAL_BODY_INCLUDE)");
            writer.pushIndent();
            writer.println("throw new JspTagException(\"Since tag handler " + this.tc.getTagHandlerClass() + " implements BodyTag, it can't return Tag.EVAL_BODY_INCLUDE\");");
            writer.popIndent();
        } else {
            writer.println("if (" + evalVar + " == BodyTag.EVAL_BODY_TAG)");
            writer.pushIndent();
            writer.println("throw new JspTagException(\"Since tag handler " + this.tc.getTagHandlerClass() + " does not implement BodyTag, it can't return BodyTag.EVAL_BODY_TAG\");");
            writer.popIndent();
        }
        writer.println("if (" + evalVar + " != Tag.SKIP_BODY) {");
        writer.pushIndent();
        if (implementsBodyTag) {
            writer.println("try {");
            writer.pushIndent();
            writer.println("if (" + evalVar + " != Tag.EVAL_BODY_INCLUDE) {");
            writer.pushIndent();
            writer.println("out = pageContext.pushBody();");
            writer.println(String.valueOf(this.thVarName) + ".setBodyContent((BodyContent) out);");
            writer.popIndent();
            writer.println("}");
            writer.println(String.valueOf(this.thVarName) + ".doInitBody();");
        }
        writer.println("do {");
        writer.pushIndent();
        TagGeneratorBase.declareVariables(writer, vi, true, true, 0);
        TagGeneratorBase.declareVariables(writer, vi, false, true, 1);
    }

    private final void generateSetters(ServletWriter writer, String parent) throws JasperException {
        writer.println(String.valueOf(this.thVarName) + ".setPageContext(pageContext);");
        writer.println(String.valueOf(this.thVarName) + ".setParent(" + parent + ");");
        if (this.attributes.length != 0) {
            int i = 0;
            while (i < this.attributes.length) {
                String attrValue = (String)this.attrs.get(this.attributes[i].getName());
                if (attrValue != null) {
                    String attrName = this.attributes[i].getName();
                    if (this.attributes[i].canBeRequestTime() && JspUtil.isExpression(attrValue)) {
                        Method m = this.tc.getSetterMethod(attrName);
                        if (m == null) {
                            throw new JasperException(Constants.getString("jsp.error.unable.to_find_method", new Object[]{attrName}));
                        }
                        attrValue = JspUtil.getExpr(attrValue);
                        writer.println(String.valueOf(this.thVarName) + "." + m.getName() + "(" + attrValue + ");");
                    } else {
                        writer.println("JspRuntimeLibrary.introspecthelper(" + this.thVarName + ", \"" + attrName + "\",\"" + JspUtil.escapeQueryString(attrValue) + "\",null,null, false);");
                    }
                }
                ++i;
            }
        }
    }

    public void init(JspCompilationContext ctxt) throws JasperException {
        this.validate();
        this.tc = this.tli.getTagCache(this.shortTagName);
        if (this.tc == null) {
            this.tc = new TagCache(this.shortTagName);
            JspLoader cl = ctxt.getClassLoader();
            Class<?> clz = null;
            try {
                clz = cl.loadClass(this.ti.getTagClassName());
            }
            catch (Exception ex) {
                throw new JasperException(Constants.getString("jsp.error.unable.loadclass", new Object[]{this.ti.getTagClassName(), ex.getMessage()}));
            }
            this.tc.setTagHandlerClass(clz);
            this.tli.putTagCache(this.shortTagName, this.tc);
        }
    }

    void validate() throws JasperException {
        Hashtable attribs = (Hashtable)this.attrs.clone();
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].isRequired() && attribs.get(this.attributes[i].getName()) == null) {
                throw new JasperException(Constants.getString("jsp.error.missing_attribute", new Object[]{this.attributes[i].getName(), this.shortTagName}));
            }
            ++i;
        }
        Enumeration e = attribs.keys();
        while (e.hasMoreElements()) {
            String attr = (String)e.nextElement();
            boolean found = false;
            int i2 = 0;
            while (i2 < this.attributes.length) {
                if (attr.equals(this.attributes[i2].getName())) {
                    found = true;
                    if (this.attributes[i2].canBeRequestTime() && JspUtil.isExpression((String)attribs.get(attr))) {
                        attribs.put(attr, TagData.REQUEST_TIME_VALUE);
                    }
                }
                ++i2;
            }
            if (found) continue;
            throw new JasperException(Constants.getString("jsp.error.bad_attribute", new Object[]{attr}));
        }
        this.tagData = new TagData(attribs);
        if (!this.ti.isValid(this.tagData)) {
            throw new JasperException(Constants.getString("jsp.error.invalid_attributes"));
        }
    }
}

