/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class URLUtil {
    public static URL resolve(String s) throws MalformedURLException {
        URL resolve = null;
        if (s.indexOf("://") > -1 || s.indexOf("file:") > -1) {
            resolve = new URL(s);
        } else if (s.startsWith(File.separator) || s.startsWith("/") || s.length() >= 2 && Character.isLetter(s.charAt(0)) && s.charAt(1) == ':') {
            String fName = s;
            try {
                fName = new File(s).getCanonicalPath();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {}
            resolve = new URL("file", "", fName);
        } else {
            String path = String.valueOf(System.getProperty("user.dir")) + File.separator + s;
            resolve = new URL("file", "", path);
        }
        if (!resolve.getProtocol().equalsIgnoreCase("war") && resolve.getFile().toLowerCase().endsWith(".war")) {
            URL u;
            resolve = u = new URL("war:" + resolve.toString());
        }
        resolve = new URL(URLUtil.trim(resolve.toString(), ".", ".."));
        resolve = new URL(URLUtil.trim(resolve.toString(), "./"));
        return resolve;
    }

    private static String trim(String s, String t) {
        return URLUtil.trim(s, t, null);
    }

    private static String trim(String s, String r, String t) {
        while (s.endsWith(r) && (t == null ? true : s.endsWith(t) ^ true)) {
            int i = s.length() - r.length();
            s = s.substring(0, i);
        }
        return s;
    }
}

