/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.session.ApplicationSession;
import org.apache.tomcat.session.ServerSessionManager;
import org.apache.tomcat.util.StringManager;

public class ServerSession {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.session");
    private Hashtable values = new Hashtable();
    private Hashtable appSessions = new Hashtable();
    private String id;
    private long creationTime;
    private long thisAccessTime = this.creationTime = System.currentTimeMillis();
    private long lastAccessed = this.creationTime;
    private int inactiveInterval = -1;

    ServerSession(String id) {
        this.id = id;
    }

    void accessed() {
        this.lastAccessed = this.thisAccessTime;
        this.thisAccessTime = System.currentTimeMillis();
    }

    public ApplicationSession getApplicationSession(Context context, boolean create) {
        ApplicationSession appSession = (ApplicationSession)this.appSessions.get(context);
        if (appSession == null && create) {
            appSession = new ApplicationSession(this.id, this, context);
            this.appSessions.put(context, appSession);
        }
        return appSession;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    public int getMaxInactiveInterval() {
        return this.inactiveInterval;
    }

    public Object getValue(String name) {
        if (name == null) {
            String msg = this.sm.getString("serverSession.value.iae");
            throw new IllegalArgumentException(msg);
        }
        return this.values.get(name);
    }

    public Enumeration getValueNames() {
        return this.values.keys();
    }

    synchronized void invalidate() {
        Enumeration enumeration = this.appSessions.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ApplicationSession appSession = (ApplicationSession)this.appSessions.get(key);
            appSession.invalidate();
        }
    }

    public void putValue(String name, Object value) {
        if (name == null) {
            String msg = this.sm.getString("serverSession.value.iae");
            throw new IllegalArgumentException(msg);
        }
        this.removeValue(name);
        this.values.put(name, value);
    }

    synchronized void reap() {
        Enumeration enumeration = this.appSessions.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ApplicationSession appSession = (ApplicationSession)this.appSessions.get(key);
            appSession.validate();
        }
    }

    void removeApplicationSession(Context context) {
        this.appSessions.remove(context);
    }

    public void removeValue(String name) {
        this.values.remove(name);
    }

    public void setMaxInactiveInterval(int interval) {
        this.inactiveInterval = interval;
    }

    void validate() {
        int thisInterval;
        if (this.inactiveInterval != -1 && (thisInterval = (int)(System.currentTimeMillis() - this.lastAccessed) / 1000) > this.inactiveInterval) {
            this.invalidate();
            ServerSessionManager ssm = ServerSessionManager.getManager();
            ssm.removeSession(this);
        }
    }
}

