/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletContextFacade;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;

public class InvokerServlet
extends HttpServlet {
    private Context context;

    public void doError(HttpServletResponse response, String msg) throws ServletException, IOException {
        response.sendError(404, msg);
    }

    public void init() throws ServletException {
        ServletContextFacade facade = (ServletContextFacade)this.getServletContext();
        this.context = facade.getRealContext();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletWrapper wrapper;
        String requestPath = request.getRequestURI();
        String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        if (pathInfo == null) {
            pathInfo = request.getPathInfo();
        }
        String includedRequestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        boolean inInclude = false;
        inInclude = includedRequestURI != null;
        String servletName = "";
        String newServletPath = "";
        String newPathInfo = "";
        if (pathInfo != null && pathInfo.startsWith("/") && pathInfo.length() > 2) {
            servletName = pathInfo.substring(1, pathInfo.length());
            if (servletName.indexOf("/") > -1) {
                servletName = servletName.substring(0, servletName.indexOf("/"));
            }
            newServletPath = !inInclude ? String.valueOf(request.getServletPath()) + "/" + servletName : String.valueOf((String)request.getAttribute("javax.servlet.include.servlet_path")) + "/" + servletName;
            try {
                newPathInfo = inInclude ? includedRequestURI.substring(newServletPath.length(), includedRequestURI.length()) : requestPath.substring(this.context.getPath().length() + newServletPath.length(), requestPath.length());
                int i = newPathInfo.indexOf("?");
                if (i > -1) {
                    newPathInfo = newPathInfo.substring(0, i);
                }
                if (newPathInfo.length() < 1) {
                    newPathInfo = null;
                }
            }
            catch (Exception exception) {
                newPathInfo = null;
            }
        } else {
            this.doError(response, "Not enough information " + request.getRequestURI() + " " + pathInfo);
            return;
        }
        if ((wrapper = this.context.getServletByName(servletName)) == null) {
            wrapper = new ServletWrapper();
            wrapper.setContext(this.context);
            wrapper.setServletClass(servletName);
            wrapper.setServletName(servletName);
            try {
                this.context.addServlet(wrapper);
            }
            catch (TomcatException ex) {
                ex.printStackTrace();
            }
        }
        HttpServletRequestFacade requestfacade = (HttpServletRequestFacade)request;
        HttpServletResponseFacade responsefacade = (HttpServletResponseFacade)response;
        Request realRequest = requestfacade.getRealRequest();
        Response realResponse = realRequest.getResponse();
        String savedServletPath = null;
        String savedPathInfo = null;
        if (!inInclude) {
            savedPathInfo = realRequest.getPathInfo();
            savedServletPath = realRequest.getServletPath();
        } else {
            savedServletPath = (String)realRequest.getAttribute("javax.servlet.include.servlet_path");
            savedPathInfo = (String)realRequest.getAttribute("javax.servlet.include.path_info");
        }
        if (!inInclude) {
            realRequest.setServletPath(newServletPath);
            realRequest.setPathInfo(newPathInfo);
        } else {
            if (newServletPath != null) {
                realRequest.setAttribute("javax.servlet.include.servlet_path", newServletPath);
            }
            if (newPathInfo != null) {
                realRequest.setAttribute("javax.servlet.include.path_info", newPathInfo);
            }
            if (newPathInfo == null) {
                realRequest.removeAttribute("javax.servlet.include.path_info");
            }
        }
        wrapper.handleRequest(requestfacade, responsefacade);
        if (!inInclude) {
            realRequest.setServletPath(savedServletPath);
            realRequest.setPathInfo(savedPathInfo);
        } else {
            if (savedServletPath != null) {
                realRequest.setAttribute("javax.servlet.include.servlet_path", savedServletPath);
            } else {
                realRequest.removeAttribute("javax.servlet.include.servlet_path");
            }
            if (savedPathInfo != null) {
                realRequest.setAttribute("javax.servlet.include.path_info", savedPathInfo);
            } else {
                realRequest.removeAttribute("javax.servlet.include.path_info");
            }
        }
    }
}

