/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import javax.servlet.http.Cookie;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.SessionManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.CookieTools;

public class SessionInterceptor
extends BaseInterceptor
implements RequestInterceptor {
    static final char SESSIONID_ROUTE_SEP = '.';
    int debug = 0;
    ContextManager cm;

    public int beforeBody(Request rrequest, Response response) {
        String jvmRoute;
        String reqSessionId = response.getSessionId();
        if (this.debug > 0) {
            this.cm.log("Before Body " + reqSessionId);
        }
        if (reqSessionId == null) {
            return 0;
        }
        String sessionPath = rrequest.getContext().getPath();
        if (sessionPath.length() == 0) {
            sessionPath = "/";
        }
        if (!sessionPath.equals("/") && (jvmRoute = rrequest.getJvmRoute()) != null) {
            reqSessionId = String.valueOf(reqSessionId) + '.' + jvmRoute;
        }
        Cookie cookie = new Cookie("JSESSIONID", reqSessionId);
        cookie.setMaxAge(-1);
        cookie.setPath(sessionPath);
        cookie.setVersion(1);
        response.addHeader(CookieTools.getCookieHeaderName(cookie), CookieTools.getCookieHeaderValue(cookie));
        cookie.setVersion(0);
        response.addHeader(CookieTools.getCookieHeaderName(cookie), CookieTools.getCookieHeaderValue(cookie));
        return 0;
    }

    public void contextShutdown(Context ctx) throws TomcatException {
        if (ctx.getDebug() > 0) {
            ctx.log("Removing sessions from " + ctx);
        }
        ctx.getSessionManager().removeSessions(ctx);
    }

    public int requestMap(Request request) {
        String sessionId = null;
        Cookie[] cookies = request.getCookies();
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            if (cookie.getName().equals("JSESSIONID")) {
                sessionId = cookie.getValue();
                if ((sessionId = this.validateSessionId(request, sessionId)) != null) {
                    request.setRequestedSessionIdFromCookie(true);
                }
            }
            ++i;
        }
        String sig = ";jsessionid=";
        int foundAt = -1;
        if (this.debug > 0) {
            this.cm.log(" XXX RURI=" + request.getRequestURI());
        }
        if ((foundAt = request.getRequestURI().indexOf(sig)) != -1) {
            sessionId = request.getRequestURI().substring(foundAt + sig.length());
            request.setRequestURI(request.getRequestURI().substring(0, foundAt));
            sessionId = this.validateSessionId(request, sessionId);
            if (sessionId != null) {
                request.setRequestedSessionIdFromURL(true);
            }
        }
        return 0;
    }

    public void setContextManager(ContextManager cm) {
        this.cm = cm;
    }

    public void setDebug(int i) {
        System.out.println("Set debug to " + i);
        this.debug = i;
    }

    private String validateSessionId(Request request, String sessionId) {
        Context ctx;
        SessionManager sM;
        int idex;
        if (this.debug > 0) {
            this.cm.log(" Orig sessionId  " + sessionId);
        }
        if (sessionId != null && (idex = sessionId.lastIndexOf(46)) > 0) {
            sessionId = sessionId.substring(0, idex);
        }
        if (sessionId != null && sessionId.length() != 0 && (sM = (ctx = request.getContext()).getSessionManager()).findSession(ctx, sessionId) != null) {
            sM.accessed(ctx, request, sessionId);
            request.setRequestedSessionId(sessionId);
            if (this.debug > 0) {
                this.cm.log(" Final session id " + sessionId);
            }
            return sessionId;
        }
        return null;
    }
}

