/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Logger {
    public static final int FATAL = Integer.MIN_VALUE;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    public static final int DEBUG = 4;
    protected boolean custom;
    protected Writer sink = defaultSink;
    String path;
    protected String name;
    protected static Writer defaultSink = new PrintWriter(System.err);
    protected static Hashtable loggers = new Hashtable(5);
    private int level = 2;
    protected boolean timeStamp = true;

    public synchronized void close() {
        this.sink = null;
        loggers.remove(this.getName());
    }

    public abstract void flush();

    public static Logger getLogger(String name) {
        return (Logger)loggers.get(name);
    }

    public static Enumeration getLoggerNames() {
        return loggers.keys();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public int getVerbosityLevel() {
        return this.level;
    }

    public boolean isOpen() {
        return this.sink != null;
    }

    public boolean isTimestamp() {
        return this.timeStamp;
    }

    public final void log(String message) {
        this.log(message, 3);
    }

    public final void log(String message, int verbosityLevel) {
        if (this.matchVerbosityLevel(verbosityLevel)) {
            this.realLog(message);
        }
    }

    public static void log(String logName, String message) {
        Logger logger = Logger.getLogger(logName);
        if (logger != null) {
            logger.log(message);
        }
    }

    public static void log(String logName, String message, int verbosityLevel) {
        Logger logger = Logger.getLogger(logName);
        if (logger != null) {
            logger.log(message, verbosityLevel);
        }
    }

    public final void log(String message, Throwable t, int verbosityLevel) {
        if (this.matchVerbosityLevel(verbosityLevel)) {
            this.realLog(message, t);
        }
    }

    public boolean matchVerbosityLevel(int verbosityLevel) {
        return verbosityLevel <= this.getVerbosityLevel();
    }

    public void open() {
        if (this.path == null) {
            return;
        }
        try {
            File file = new File(this.path);
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            }
            this.sink = new FileWriter(this.path);
        }
        catch (IOException iOException) {
            System.err.print("Unable to open log file: " + this.path + "! ");
            System.err.println(" Using stderr as the default.");
            this.sink = defaultSink;
        }
    }

    public static void putLogger(Logger logger) {
        loggers.put(logger.getName(), logger);
    }

    protected abstract void realLog(String var1);

    protected abstract void realLog(String var1, Throwable var2);

    public static void removeLogger(Logger logger) {
        loggers.remove(logger.getName());
    }

    public void setCustomOutput(String value) {
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
            this.custom = true;
        } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
            this.custom = false;
        }
    }

    public static void setDefaultSink(Writer w) {
        defaultSink = w;
    }

    public void setName(String name) {
        this.name = name;
        Logger.putLogger(this);
    }

    public void setPath(String path) {
        if (File.separatorChar == '/') {
            this.path = path.replace('\\', '/');
        } else if (File.separatorChar == '\\') {
            this.path = path.replace('/', '\\');
        }
    }

    public void setTimestamp(String value) {
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
            this.timeStamp = true;
        } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
            this.timeStamp = false;
        }
    }

    public void setVerbosityLevel(int level) {
        this.level = level;
    }

    public void setVerbosityLevel(String level) {
        if ("warning".equalsIgnoreCase(level)) {
            this.level = 2;
        } else if ("fatal".equalsIgnoreCase(level)) {
            this.level = Integer.MIN_VALUE;
        } else if ("error".equalsIgnoreCase(level)) {
            this.level = 1;
        } else if ("information".equalsIgnoreCase(level)) {
            this.level = 3;
        } else if ("debug".equalsIgnoreCase(level)) {
            this.level = 4;
        }
    }
}

