#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                  	contacts  -- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered,gStack,gPrevCard
  put "contacts" into gStack
  if the short name of this stack <> gStack then exit openStack
  if gRegistered is empty then
    open stack "launcher"
  else
    lock screen
    if gPrevCard is not empty then
      go card gPrevCard
    else
      go first card
    end if
    saveData
    setArrows
    unlock screen with visual plain
  end if
end openStack

on clearCardOne
  put the number of field "fname" into firstField
  repeat with i = firstField to the number of fields
    if the short name of field i is "short" or the short name of field i is "long" then next repeat
    put empty into field i
  end repeat
  put 1 into field "record"
end clearCardOne

on openCard
  if the short name of this stack is "contacts" then
    saveData
  end if
end openCard

on closeCard
  global gDontSave
  if gDontSave then
    put false into gDontSave
    exit closeCard
  end if
  if the short name of this stack is "contacts" then
    checkData
  else
    set cursor to watch
    save this stack
  end if
end closeCard
  w            DeepSkyBlue    white        
       ^ Contact Tracker    
  W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U monaco  	 U monaco   U 
helvetica  
 W 
Helvetica  
 W 
Helvetica   W 
Helvetica   W 
Helvetica   U 
Helvetica  	 U 
Helvetica  
 U Arial 8records,atmain.mc
taskTracker,tasks.mc
passwords,password.mc
launcher,itmain.mc
launcher,sbdmain.mc
launcher,aetmain.mc
launcher,sbmain.mc
writer,whelper.mc
versions,version.mc
vehicleExp,vehexp.mc
invoiceTracker,invoice.mc
inventory,inventry.mc
scheduler,schedule.mc
contacts,contact.mc
calculator,calculat.mc
   B    	@          &        i           
  b FName label            l            First Name 
   LName label          c  l            
Last Name 
   cName label           0 l            
Company Name 
   label2                        Phones/Fax/Pagers 
  e label3           ^ l            Address 
   label4            (            City 
   label5                        Family or Associates 
   label6            7            State 
   label7          U  H            	Zip Code 
   label8            5            E-mail 
  g label9                        Contact Notes   w New Ex  on mouseUp
  global gRegistered,gUseBlankRecord
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    toplevel  "Register"
    exit mouseUp
  end if
  
  if gUseBlankRecord is empty then put false into gUseBlankRecord
  if (field "fname" is empty) and (field "lname" is empty) and (field "cname" is empty) then
    if gUseBlankRecord is false then
      answer information "You need to use this record before creating another."
    end if
    put false into gUseBlankRecord
    exit mouseUp
  end if
  
  lock screen
  lock messages
  go last
  create card
  put the number of this card into field "record"
  setArrows
  unlock screen with visual plain
end mouseUp
            	Lavender    & A             	     
  i recNumLabel    $on mouseUp
  goCardNum
end mouseUp
         E            	Record # 
  j fname  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
        
  Z         B  
   lname  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
        h           B  
   cname  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
        
 E          B  
   phones  )h            W        B        	`    @ s   U 
  l address  )h         
 s  )        B        	`    @   t  ' 
   city  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
        (           B  
   state  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
        /  $         B  
   zip  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
          V         B  
   email  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
        4           B  
   associates  )h            ;        B        	`    @ s   9     Schedule Event Ex  on mouseUp
  global gUseBlankRecord
  put true into gUseBlankRecord
  lock screen
  if the openStacks contains "Scheduler" then close stack "Scheduler"
  get the loc of this stack
  if item 1 of it < 215 then
    add 395 to item 1 of it
    set the loc of stack "scheduler" to it
  end if
  
  topLevel "scheduler"
  unlock screen with visual plain
  send mouseUp to button "new" of stack "scheduler"
end mouseUp
    	Lavender                  	     
   notes  )h         
          B        	`    @     
  r record  x    %on mouseUp
  goCardNum
end mouseUp

       Z  *         B 1   s First @V  
 on mouseUp
  global gVeffect
  lock screen
  go first
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    	Lavender      * ,  ?         	  B 	  o   t Prev @F  
 on mouseUp
  global gVeffect
  lock screen
  go prev
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    	Lavender     * ,  @         	  B   u Next @F  
 on mouseUp
  global gVeffect
  lock screen
  go next
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    	Lavender   ?  * ,  A         	  B   v Last @F  
 on mouseUp
  global gVeffect
  lock screen
  go last
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    	Lavender   e  * ,  B         	  B   x Delete Ex  aon mouseUp
  if the number of cards = 1 then
    if (field "fname" is empty) and (field "lname" is empty) and (field "cname" is empty) then
      answer information "There are no more records to delete."
    else
      lock screen
      clearCardOne
    end if
    exit mouseUp
  end if
  answer question "Delete all records or just this one?" with "All" or  "Just this one" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock messages
  put the number of this card -1 into cardNum
  
  if it is "All" then
    lock screen
    repeat with i = the number of cards of this stack down to 2
      set cursor to busy
      delete card i
    end repeat
    clearCardOne
    setArrows
    saveData
    unlock screen with visual plain
    exit mouseUp
  end if
  
  if it is "Just this one" then
    lock screen
    if the number of cards > 1 then
      delete this card
    else
      clearCardOne
    end if
    go card cardNum
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
            	Lavender   C& A             	       y Find Ex  on mouseUp
  global gFindStack, gFoundOne
  put "atFind" into zFindStack
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 220 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack zFindStack to it
  go card 1 of stack zFindStack
  show stack zFindStack
  select text of field "find" of stack zFindStack
end mouseUp
            	Lavender    @ A              	       z Sort Ex  on mouseUp
  answer question "Sort records by first name, last name or company name?" with \
      "Cancel" or "First"  or  "Last" or "Company"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock screen
  lock messages
  
  if it is "company" then
    sort this stack by field "lname"
    sort this stack by field "cname"
  end if
  if it is "first" then
    sort this stack by field "lname"
    sort this stack by field "fname"
  end if
  if it is "last" then
    sort this stack by field "fname"
    sort this stack by field "lname"
  end if
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
            	Lavender   C@ A              	       { Import Ex  on mouseUp
  put the number of cards into znum
  if (the number of cards = 1) and (field "fname" is empty) and (field "lname" is empty) and (field "cname" is empty) then
    put 1 into firstCard
  else
    answer question "Delete all records first or add to existing?" with "Delete" or "Add" or "Cancel"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Delete" then
      lock messages
      lock screen
      repeat with i = znum down to 2
        set cursor to busy
        delete card i
      end repeat
      put 1 into firstCard
      clearCardOne
      put false into renumberTasks
      unlock screen with visual plain
    else
      go card znum
      if znum = 1 then
        put 1.5 into znum
      end if
      put znum into firstCard
      put true into renumberTasks
    end if
  end if
  answer "Import Contact Tracker or Palm file?" with "Palm" or "Contact Tracker"
  if it is "Palm" then
    importPalm firstCard, renumberTasks -- in this script
  else
    importRecords firstCard, renumberTasks -- in this script
  end if
  saveData
  setarrows
  unlock screen with visual plain
  set cursor to watch
  save this stack
end mouseUp

on  importRecords  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a contacts records file to import." with "contact_records.txt"
  if the result is "Cancel" then exit to metacard
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    if word 1 of temp <> "First" then
      answer error "This is not a valid contacts records file. Try again."
      close file fileName
      exit to metaCard
    end if
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into field "fName"
      put item 2 of zline into field "lName"
      put item 3 of zline into field "cname"
      put addReturns(item 4 of zline) into field "address"
      put item 5 of zline into field "City"
      put item 6 of zline into field "State"
      put item 7 of zline into field "Zip"
      put item 8 of zline into field "email"
      put addReturns(item 9 of zline) into field "phones"
      put addReturns(item 10 of zline) into field "associates"
      put addReturns(item 11 of zline) into field "notes"
      
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importRecords

on  importPalm  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a palm contact file to import." with "contact export.txt"
  if the result is "Cancel" then exit to metacard
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    put line 1 of temp into zLabels
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      -- if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into field "fName"
      put item 2 of zline into field "lname"
      if item 3 of zline is not empty then
        put "nickname = " & item 3 of zline into field "notes"
      end if
      put item 4 of zline before field "fname"
      put space & item 5 of zline after field "lname"
      if item 6 of zline is not empty then
        put return & "title = " & item 6 of zline after field "notes"
      end if
      put item 7 of zline into field "cname"
      if item 8 of zline is not empty then
        put return & "division = " & item 8 of zline after field "notes"
      end if
      put item 10 of zline into field "address"
      if item 11 of zline is not empty then
        put return & item 11 of zline after field "address"
      end if
      put item 12 of zline into field "city"
      put item 13 of zline into field "state"
      put item 14 of zline into field "zip"
      
      repeat with n = 15 to 22
        if item n of zline is not empty then
          put return & item n of zLabels && "=" && item n of zline after field "notes"
        end if
      end repeat
      
      repeat with n = 23 to 34
        if n = 23 or n = 26 or n= 29 or n = 32 then
          put item n of zline & return after field "phones"
        else
          if item n of zline is not empty then
            if n = 25 or n = 28 or n = 31 then
              put "ext." && item n of zline & return after field "phones"
            else
              put item n of zline & return after field "phones"
            end if
          end if
        end if
      end repeat
      
      repeat with n = 35 to 36
        if item n of zline is not empty then
          put return & item n of zLabels && "=" && item n of zline after field "notes"
        end if
      end repeat
      
      put item 37 of zline into field "email"
      
      repeat with n = 38 to 51
        if item n of zline is not empty then
          put return & item n of zLabels && "=" && item n of zline after field "notes"
        end if
      end repeat
      
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importPalm

function addReturns temp
  repeat while offset(" | ",temp) > 0
    put offset(" | ",temp) into firstChar
    put firstChar + 2 into lastChar
    put return into char  firstChar to lastChar of temp
  end repeat
  return temp
end addReturns
            	Lavender    U A              	       | Export Ex  @on mouseUp
  global gElapsed
  if (the number of cards = 1) and (field "fname" is empty) and (field "lname" is empty) and (field "cname" is empty) then
    answer information "There are no records to export."
    exit mouseUp
  end if
  answer question "Export to Contact Tracker or Palm?" with "Cancel"  or "Palm" or "Contact Tracker "
  if it is "cancel" then exit mouseUp
  unlock screen
  if it is "Palm" then
    answer question "Export just this contact or all contacts?" with "Cancel" or "Just this one" or "All"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Just this one" then
      put the number of this card into whichCard
    else
      put "all" into whichCard
    end if
    
    ask file "Save records as... " with "palm_contacts.txt"
    if the result is "Cancel" then exit mouseUp
    unlock screen
    put checkExt(it) into fileName
    put empty into whichDate
    
    -- save data from all cards to txt file
    open file fileName for write
    if the result is empty then
      lock messages
      lock screen
      put true into noRecords
      set itemDelimiter to tab
      -- write "This is an export from Contact Tracker" & return to file fileName
      if whichCard is "all" then
        repeat with i = 1 to the number of cards
          set cursor to busy
          go card i
          put field  "fName" into temp
          put field  "lname" into item 2 of temp
          put field  "cName" into item 7 of temp
          repeat with n = 1 to 4
            put line n of field "phones" into item (21 + (n*3)) of temp
          end repeat
          repeat with n = 1 to 2
            put line n of field "address" into item (9 + n) of temp
          end repeat
          put field  "city" into item 12 of temp
          put field  "state" into item 13 of temp
          put field  "zip" into item 14 of temp
          put field  "email" into item 37 of temp
          put field "notes" into tnotes
          repeat while offset(return,tnotes) > 0
            put " | " into char offset(return,tnotes) of tnotes
          end repeat
          put tnotes into item 35 of temp
          
          write temp & return to file fileName
          
        end repeat
      else
        
        put field  "fName" into temp
        put field  "lname" into item 2 of temp
        put field  "cName" into item 7 of temp
        repeat with n = 1 to 4
          put line n of field "phones" into item (21 + (n*3)) of temp
        end repeat
        repeat with n = 1 to 2
          put line n of field "address" into item (9 + n) of temp
        end repeat
        put field  "city" into item 12 of temp
        put field  "state" into item 13 of temp
        put field  "zip" into item 14 of temp
        put field  "email" into item 37 of temp
        put field "notes" into tnotes
        repeat while offset(return,tnotes) > 0
          put " | " into char offset(return,tnotes) of tnotes
        end repeat
        put tnotes into item 35 of temp
        
        write temp & return to file fileName
      end if
      setarrows
      saveData
      unlock screen with visual plain
      close file fileName
    else
      answer "There was a problem saving this file." & return & the result & return & sysError()
    end if
    exit mouseUp
  end if
  
  answer question "Export just this contact or all contacts?" with "Cancel" or "Just this one" or "All"
  if it is "cancel" then exit mouseUp
  unlock screen
  if it is "Just this one" then
    put the number of this card into whichCard
    ask file "Save records as... " with "contact_" & field "lname" & ".txt"
  else
    put "all" into whichCard
    put the date into whichDate
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save records as... " with "all_contact_records_" & whichDate & ".txt"
  end if
  if the result is "Cancel" then exit mouseUp
  unlock screen
  put checkExt(it) into fileName
  put empty into whichDate
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    put true into noRecords
    if whichCard is "all" then
      write "First Name" & tab & "Last Name" & tab & "Company Name" & tab & "Address" & tab & "City" & tab & "State" & tab & "Zip Code" & tab \
          & "E-mail" & tab  & "Phones/Fax/Pagers" & "Associates" & tab & "Contact notes" & return to file fileName
      repeat with i = 1 to the number of cards
        set cursor to busy
        go card i
        put field "notes" into tnotes
        repeat while offset(return,tnotes) > 0
          put " | " into char offset(return,tnotes) of tnotes
        end repeat
        
        put field "address" into addresses
        repeat while offset(return,addresses) > 0
          put " | " into char offset(return,addresses) of addresses
        end repeat
        
        put field "phones" into phones
        repeat while offset(return,phones) > 0
          put " | " into char offset(return,phones) of phones
        end repeat
        
        put field "associates" into associates
        repeat while offset(return,associates) > 0
          put " | " into char offset(return,associates) of associates
        end repeat
        
        write field  "fName" & tab & field  "lName" & tab & field "cname" & tab & addresses & tab & field "City" & tab & field "State" & tab &  \
            field "zip" & tab & field "email"  & tab  & phones & tab & associates & tab & tnotes & return to file fileName
        
      end repeat
      setarrows
      saveData
    else -- just export this card
      
      write field  "fName" & return & field  "lName" & return & field  "cName" & return & field "address" & return & field "City" & return & field "State" & tab &  \
          field "zip" & return & field "email"  & return & field "phones" & return & field "associates" & return \
          & field "notes" & return to file fileName
    end if
    close file fileName
    unlock screen with visual plain
    
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
            	Lavender   CU A              	       } Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
    	Lavender    j A              	        Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "cHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "contact tracker", helpStack, zStack
end mouseUp
    	Lavender   Cj A              	        Quit ux   (on mouseUp
  quitSBTracker
end mouseUp
    	Lavender     A      Quit          	        Save Ux   Kon mouseUp
  set cursor to watch
  save this stack
  saveData
end mouseUp
    	Lavender   C A              	        List Contacts Ex  on mouseUp
  global gCurrentContact
  if the number of cards is 1 and field "fname" is empty then
    answer information "There are no records to report."
    exit mouseUp
  end if
  checkData
  lock screen
  put the number of this card into gCurrentContact
  if the openStacks contains "cLists" then close stack "cLists"
  setHeight "cLists"
  topLevel "cLists"
  setLoc "clists"
  send mouseUp to button "create report" of stack "cLists"
  unlock screen with visual plain
end mouseUp
    	Lavender                  	     
   start items  !h          t         B          
Main Menu }    Kon menuPick which
set cursor to watch
goSBTrackerStack which
end menuPick
    	Lavender    
       Small Business Tracker Menu   Activity && Expense Tracker
(Contact Tracker - Address Book
Schedule Tracker - Calendar
Task Tracker - To Do List
-
Inventory Tracker
Invoice Tracker
Password Tracker
Vehicle Expense Tracker
-
Universal Calculator
Version Tracker
Writer's Helper
Small Business Tracker Welcome
       	        size   a        <  Z
   short  )h  
       @   <           button "New"	254,294,319,316  (button "Schedule Event"	254,273,388,295  button "First"	242,250,284,294  button "Prev"	281,250,323,294  button "Next"	319,250,361,294  button "Last"	357,250,399,294   button "Delete"	323,294,388,316  button "Find"	254,320,319,338  button "Sort"	323,320,388,338   button "Import"	254,341,319,359   button "Export"	323,341,388,359  button "Prefs"	254,362,319,380  button "Help"	323,362,388,380  button "Quit"	254,383,319,401  button "Save"	323,383,388,401  'button "List Contacts"	254,411,388,433  "button "Main Menu"	10,411,234,433  +button "Area Code Locator"	254,116,388,138  #field "associates"	252,156,388,215  field "notes"	10,270,234,401  field "record"	346,223,388,247  field "label5"	246,135,386,159  $field "recNumLabel"	280,223,349,247  field "phones"	252,25,388,112       	`    @     : 
   long  )h  
          <           button "New"	254,405,319,427  (button "Schedule Event"	254,298,388,320  button "First"	242,357,284,401  button "Prev"	281,357,323,401  button "Next"	319,357,361,401  button "Last"	357,357,399,401   button "Delete"	323,405,388,427  button "Find"	254,431,319,449  button "Sort"	323,431,388,449   button "Import"	254,452,319,470   button "Export"	323,452,388,470  button "Prefs"	254,473,319,491  button "Help"	323,473,388,491  button "Quit"	254,494,319,512  button "Save"	323,494,388,512  'button "List Contacts"	254,522,388,544  "button "Main Menu"	10,522,234,544  +button "Area Code Locator"	254,132,388,154  #field "associates"	252,173,388,292  field "notes"	10,270,234,511  field "record"	346,329,388,353  field "label5"	246,152,386,176  $field "recNumLabel"	280,330,349,354  field "phones"	252,25,388,126       	`    @ 9   :    putLong Ex  
on mouseUp
  put "long" into whichField
  put empty into field whichField
  repeat with i = 1 to 17
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of button 22 & tab & the rect of button 22 after field whichField
  repeat with i = 22 to 24
    put return & the name of field i & tab & the rect of field i after field whichField
  end repeat
  put return & the name of field 7 & tab & the rect of field 7 after field whichField
  put return & the name of field 12 & tab & the rect of field 12 after field whichField
  put return & the name of field 16 & tab & the rect of field 16 after field whichField
end mouseUp
    	Lavender     X :              	        setLong Ex  
on mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
  show button "schedule event"
end mouseUp
    	Lavender   
 X :              	        	putShort Ex  
on mouseUp
  put "short" into whichField
  put empty into field whichField
  repeat with i = 1 to 17
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of button 22 & tab & the rect of button 22 after field whichField
  repeat with i = 22 to 24
    put return & the name of field i & tab & the rect of field i after field whichField
  end repeat
  put return & the name of field 7 & tab & the rect of field 7 after field whichField
  put return & the name of field 12 & tab & the rect of field 12 after field whichField
  put return & the name of field 16 & tab & the rect of field 16 after field whichField
end mouseUp
    	Lavender    C X :              	        	setShort Ex  
on mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
  hide button "schedule event"
end mouseUp
    	Lavender     X :              	       k Area Code Locator Ex   /on mouseUp
  topLevel "areacodes"
end mouseUp
    	Lavender     t              	       
 cLists  #on closeCard
  global gDontSave
  put true into gDontSave
  if the visible of group "font" then hide group "font"
end closeCard

function checkItems cardNum
  if field "project" of card cardNum of stack "records" is empty \
      OR field "task" of card cardNum of stack "records" is empty \
      OR field "elapsed" of card cardNum of stack "records" is empty then
    return true
  else
    return false
  end if
end checkItems

on collectData cardnum,invoice
  global gBillHours,gNbillHours, gExpenses,gDollars,gStack,gNotes,gDollarSign
  
  put field "start date" of card cardNum of stack "records"  into zDate
  delete item 3 of zDate
  put field "project" of card cardNum of stack "records" into zProject
  
  put field "task" of card cardNum of stack "records" into zTask
  if invoice and (item 2 of zTask is empty) then
    if offset(ztask,field "task")>0 then -- include this task
      if  the hilite of button "Show Rates" is false then
        put item 1 of field "task" of card cardNum of stack "records" into zTask
      end if
    else
      put "(non-billable activity)" into zTask
    end if
  else
    if the hilite of button "Show Rates" then
      put field "task" of card cardNum of stack "records" into zTask
    else
      put item 1 of field "task" of card cardNum of stack "records" into zTask
    end if
  end if
  
  set the numberFormat to 0.00
  put field "elapsed" of card cardNum of stack "records" into eTime
  put word 1 of eTime  into taskTime -- hours
  if the hilite of button 16 then -- "round times" then
    add roundoff(word 3 of eTime/60) to taskTime -- partial hours
  else
    add (word 3 of eTime/60) to taskTime -- partial hours
  end if
  
  if the number of items of field "task" of card cardNum of stack "records" > 1 then
    put item 2 of field "task" of card cardNum of stack "records" into rate
    add taskTime to gBillHours
    if offset("/hr",rate) = 0 then -- flat rate
      add rate to gDollars
    else
      delete char offset("/hr",rate) to length(rate) of rate
      add (taskTime * rate) to gDollars
    end if
  else
    add taskTime to gNbillHours
  end if
  
  put field "expense amount" of card cardNum of stack "records" into expAmount
  repeat with x = 1 to length(expAmount)
    if char x of expAmount is "-" then
      put true into dontAdd
      delete char x of expAmount
      exit repeat
    else
      put false into dontAdd
    end if
  end repeat
  repeat with x = 1 to length(expAmount)
    if not(char 1 of expAmount is a number) AND (char 1 of expAmount <> ".") then -- delete $ signs
      delete char 1 of expAmount
    else
      exit repeat
    end if
  end repeat
  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
    if dontAdd then
      put "Expense Total = " && gDollarSign & "-" & expAmount into  zExpenseTotal
      subtract expAmount from gExpenses
    else
      put "Expense Total = " && gDollarSign & expAmount into  zExpenseTotal
      add expAmount to gExpenses
    end if
    put "Expense Type = " && field "expense" of card cardNum of stack "records" into  zExpense
  end if
  
  if field "project" <> empty then
    put zDate & tab & zTask & tab & taskTime & return into temp
  else
    put zDate & tab & zProject & tab & zTask & tab & taskTime & return into temp
  end if
  
  if (field "task notes" of card cardNum of stack "records"  <> empty) and (the hilite of button "Show Activity Notes") then
    put "Activity Notes = " & field "task notes" of card cardNum of stack "records" into gNotes
    if length(gNotes) > 100 then
      createLines
    end if
    put gNotes & return after temp
  end if
  
  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
    put zExpense & return after temp
    if field "expense notes" of card cardNum of stack "records"  <> empty then
      put  "Expense Notes = " & field "expense notes" of card cardNum of stack "records" into gNotes
      if length(gNotes) > 100 then
        createLines
      end if
      put gNotes & return after temp
      -- else
      --  put  return after temp
    end if
    put zExpenseTotal & return after temp
  end if
  
  put return after temp
  put temp after field "report" of stack "output"
end collectData


on collectExpenseData cardnum,invoice
  global gBillHours,gNbillHours, gExpenses,gDollars,gStack,gNotes,gDollarSign
  
  put field "start date" of card cardNum of stack "records"  into zDate
  delete item 3 of zDate
  put field "project" of card cardNum of stack "records" into zProject
  put field "expense amount" of card cardNum of stack "records" into expAmount
  repeat with x = 1 to length(expAmount)
    if char x of expAmount is "-" then
      put true into dontAdd
      delete char x of expAmount
      exit repeat
    else
      put false into dontAdd
    end if
  end repeat
  
  repeat with x = 1 to length(expAmount)
    if not(char 1 of expAmount is a number) AND (char 1 of expAmount <> ".") then -- delete $ signs
      delete char 1 of expAmount
    else
      exit repeat
    end if
  end repeat
  if expAmount = 0 then exit collectExpenseData
  
  --  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
  if dontAdd then
    put gDollarSign & "-" & expAmount into  zExpenseTotal
    subtract expAmount from gExpenses
  else
    put gDollarSign & expAmount into  zExpenseTotal
    add expAmount to gExpenses
  end if
  put  field "expense" of card cardNum of stack "records" into  zExpense
  
  if field "project" <> empty then
    put zDate & tab & zExpense & tab & zExpenseTotal & return into temp
  else
    put zDate & tab & zProject & tab & zExpense & tab & zExpenseTotal & return into temp
  end if
  
  
  if field "expense notes" of card cardNum of stack "records"  <> empty then
    put  "Expense Notes = " & field "expense notes" of card cardNum of stack "records" into gNotes
    if length(gNotes) > 100 then
      createLines
    end if
    put gNotes & return after temp
  end if
  
  put return after temp
  put temp after field "report" of stack "output"
end collectExpenseData

on setTabs which
  global gTabs
  if gTabs is empty then
    if which is "wide" then
      put "150,320,500" into gTabs
      set the tabStops of field "report" of card 1 of stack "output" to 150,320,500,520
      set the tabStops of field "report" of card 2 of stack "output" to 150,320,500,520
    else
      put "200,425,450" into gTabs
      set the tabStops of field "report" of card 1 of stack "output" to 200,425,450
      set the tabStops of field "report" of card 2 of stack "output" to 200,425,450
    end if
  end if
end setTabs

on createLines
  global gNotes
  repeat while the number of chars of gNotes > 0
    put 100 into tooLong
    put char 1 to tooLong of gNotes into temp2
    if offset(return,temp2) = 0 then
      repeat while the number of chars of temp2 > 0
        if char tooLong of temp2 <> space then
          delete char tooLong of temp2
          subtract 1 from tooLong
        else
          exit repeat
        end if
      end repeat
    else
      put offset(return,temp2) - 1 into tooLong
    end if
    if length(gNotes) < 100 then
      put gNotes after temp
      exit repeat
    end if
    if tooLong < 1 then
      delete char 1 of gNotes
    else
      put char 1 to tooLong of temp2 & return after temp
      delete char 1 to tooLong of gNotes
    end if
  end repeat
  put temp into gNotes
end createLines

on checkTime
  put field "start"  into startTime
  put field "end"  into endTime
  if startTime is empty or endTime is empty then exit checkTime
  convert startTime to dateItems
  convert endTime to dateItems
  
  if item 4 of startTime > item 4 of endTime then
    add 24 to item 4 of endTime -- add 24 hours
    subtract 1 from item 3 of endTime
  end if
  if item 3 of startTime > item 3 of endTime then
    put daysofmonth(item 2 of startTime,item 1of startTime) into zdays
    add zdays to item 3 of endTime -- add about 30 days
    subtract 1 from item 2 of endTime
  end if
  if item 2 of startTime > item 2 of endTime then
    add 12 to item 2 of endTime -- add 12 months
    subtract 1 from item 1 of endTime
  end if
  
  repeat with i = 1 to 5
    if (item i of startTime > item i of endTime) then
      abort
      exit to metaCard
    end if
  end repeat
end checkTime

on abort
  global gStartDate, gEndDate, gDateField, gDateStack
  
  if gDateField is "start" then
    put gStartDate into field "start"
  else
    put gEndDate into field "end"
  end if
  answer error "The end date is before the start date. " & return & "Please enter a new date."
end abort

function spaces howmany
  repeat with i = 1 to howmany
    put space after temp
  end repeat
  return temp
end spaces

function roundoff numb
  set the numberFormat to 0.000
  put offset(".",numb) into decPos
  put char 1 to decPos of numb into zwhole
  put char decPos  to length(numb) of numb into zparts
  put field "roundoff" into z
  put z/2 into x
  put 0 into y
  put 0 into n
  repeat while y < 1.000
    add x to y
    if zparts < y then
      return (zwhole + (y-x))
    end if
    add x to y
    add 1 to n
  end repeat
  return (zwhole + 1)
end roundoff
  w        Black    DeepSkyBlue ffffff      white       	darkgray    
 ?         
Contact List    (  U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial   U 
Helvetica  	 U 
Helvetica   U Georgia   U Georgia   U Georgia  
 U Georgia   U Geneva   U LB Helvetica Black   U Swis721 BdCn BT   U Swis721 BdCnOul BT   U Swis721 BdOul BT   U Swis721 BdRnd BT   U Swis721 BlkRnd BT   U Swis721 BdRnd BT   U Swis721 BdRnd BT   U LB Helvetica Black  
 U Arial Black   U Arial Black  
 U 
Helvetica  
 U Andale Mono  
 U AGaramond SemiboldItalic  
 U AGaramond Semibold   U AGaramond Semibold   U AGaramond Italic   U 
AGaramond   U 	Capitals  
 U 	Capitals   U 	Capitals   U CB Helvetica Condensed Bold  
 U CB Helvetica Condensed Bold       	@          ?&                                      options   i           2   Current Contact @D  on mouseUp
  global gClistFsize
  
  lock screen
  if gClistFsize is empty then
    put the textSize of field "report" into gClistFsize
  end if
  set the textSize of field "report" to 14
  hide group "sort"
  hide group "opts1"
  show group "opts2"
  set the locktext of field "report" to false
  set the listBehavior of field "report" to false
  send mouseUp to button "create report"
  unlock screen with visual plain
end mouseUp
    	Lavender    w # y              	      
List Options  D     	Lavender      h              	      
All Contacts @D  on mouseUp
  global gClistFsize
  
  lock screen
  if gClistFsize is empty then
    put 10 into gClistFsize
  end if
  set the textSize of field "report" to gClistFsize
  show group "sort"
  show group "opts1"
  hide group "opts2"
  if the visible of button "done" then send mouseUp to button "done"
  set the locktext of field "report" to true
  send mouseUp to button "create report"
  unlock screen with visual plain
end mouseUp
    	Lavender    w  a              	     Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "cHelp" into helpStack
  goHelp "list contacts", helpStack, zStack
end mouseUp
    	Lavender    
 H             	        
Close Window Ex   on mouseUp
  if the visible of button "done" then send mouseUp to button "done"
  global gStack
  global gDontSave
  put true into gDontSave
  lock screen
  close this stack
  goStack gStack
  unlock screen with visual plain
end mouseUp
    	Lavender    [              	        Save as... Ux  on mouseUp
  
  if the visible of button "done" then send mouseUp to button "done"
  if the hilite of button "all contacts" then
    put the short date into whichDate
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save contact list as... " with "contact_list_" & whichDate & ".txt"
  else -- current contact
    put field "lname" of stack "contacts" into lname
    ask file "Save contact as... " with "contact_" & lname & ".txt"
  end if
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  
  open file fileName for write
  if the result is empty then
    write "Contact List as of " & the long date & return & return to file fileName
    if the hilite of button "all contacts" then
      set the itemDelimiter to tab
      put field report into temp
      repeat with i = 1 to the number of lines of temp
        delete item 6 to 7 of line i of temp
        write line i of temp & return to file fileName
      end repeat
    else
      write field "report" & return to file filename
    end if
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
    	Lavender     X             	        Print Ux   &on mouseUp
  printReport
end mouseUp
    	Lavender    H             	        Create Report Ex  on mouseUp
  global gCurrentContact,gContactTabs
  
  if the hilitedButtonName of group "options" is empty then
    set the hilitedButtonName of group "options" to "All Contacts"
  end if
  if the hilitedButtonName of group "sort" is empty then
    set the hilitedButtonName of group "sort" to "First Name"
  end if
  
  if the hilite of button "All Contacts" then
    if gContactTabs is empty then
      set the tabstops of field "report" to "90,210,375"
    else
      set the tabstops of field "report" to gContactTabs
    end if
    
    put  "First Name" & tab & "Last Name" & tab & "Company Name" into temp
    if the hilite of button "show e-mail"  then put tab & "E-mail Address" after temp
    put temp & return into field "report"
    
    set the itemDelimiter to tab
    put 1 into sortLine
    put the hilitedButtonName of group "sort" into sortBy
    if sortBy is "First name" then put "fname" into sortBy
    if sortBy is "last name" then put "lname" into sortBy
    if sortBy is "Company" then put "cname" into sortBy
    if sortBy is "Zip Code" then put "zip" into sortBy
    
    put true into nodata
    put the number of cards of stack "contacts" into zcards
    repeat with i = 1 to zcards
      if zcards > 50 then set cursor to busy
      --  if checkItems(i) then next repeat
      
      put field "fname" of card i of stack "contacts" into temp
      put field "lname" of card i of stack "contacts" into item 2 of temp
      put field "cname" of card i of stack "contacts" into item 3 of temp
      put field "zip" of card i of stack "contacts" into item 6 of temp
      put i into item 7 of temp
      put temp into line sortLine of zSorter
      add 1 to sortLine
      put false into nodata
    end repeat
    
    if nodata then
      answer information "There were no tasks found for these options."
      exit to metacard
    end if
    
    if sortBy is "fname" then
      sort lines of zSorter  by item 2 of each
      sort lines of zSorter  by item 1 of each
    end if
    if sortBy is "lname" then
      sort lines of zSorter by item 1 of each
      sort lines of zSorter  by item 2 of each
    end if
    if sortBy is "cname" then
      sort lines of zSorter  by item 2 of each
      sort lines of zSorter by item 3 of each
    end if
    if sortBy is "zip" then
      sort lines of zSorter  by item 2 of each
      sort lines of zSorter by item 6 of each
    end if
    
    repeat with n = 1 to the number of lines of zsorter
      put item 7 of line n of zsorter into cardNum
      if the hilite of button "show e-mail"  then
        put  field "email" of card cardNum of stack "contacts" into item 4 of line n of zsorter
      end if
      put field "phones" of card cardNum of stack "contacts" into zphones
      repeat while offset(return,zphones) > 0
        put tab into char offset(return,zphones) of zphones
      end repeat
      if zphones is empty then
        put line n of zsorter & return after field "report"
      else
        put line n of zsorter & return & tab & zphones & return after field "report"
      end if
      
      if the hilite of button "show address"  then
        put field "address" of card cardNum of stack "contacts" into zaddress
        if zaddress <> empty then
          repeat while offset(return,zaddress) > 0
            put comma & space into char offset(return,zaddress) of zaddress
          end repeat
        end if
        if field "city" of card cardNum of stack "contacts" <> empty then
          put comma & space & field "city" of card cardNum of stack "contacts" after zaddress
          put comma & space & field "state" of card cardNum of stack "contacts" after zaddress
          put space & item 6 of line n of zsorter after zaddress
          put tab & zaddress & return after field "report"
        end if
      end if
    end repeat
  else -- just current contact
    if the hilite of button "show return address" then
      put field "return address" & return & return Into temp
    else
      put return & return & return into temp
    end if
    put tab & tab & field "fname" of card gCurrentContact of stack "contacts" after temp
    put space & field "lname" of card gCurrentContact of stack "contacts" after temp
    put return & tab & tab & field "cname" of card gCurrentContact of stack "contacts" after temp
    put return & tab & tab & field "address" of card gCurrentContact of stack "contacts" after temp
    put return & tab & tab & field "city" of card gCurrentContact of stack "contacts" after temp
    if field "state" of card gCurrentContact of stack "contacts" <> empty then
      put comma & field "state" of card gCurrentContact of stack "contacts" after temp
    end if
    put space & space &  field "zip" of card gCurrentContact of stack "contacts" after temp
    if the hilite of button "Show E-mail, Phone & Notes" then
      put return & return & field "email" of card gCurrentContact of stack "contacts" after temp
      put return & field "phones" of card gCurrentContact of stack "contacts" after temp
      put return & field "associates" of card gCurrentContact of stack "contacts" after temp
      put return & field "notes" of card gCurrentContact of stack "contacts" after temp
    end if
    put temp into field "report"
  end if
end mouseUp
    	Lavender     t             	        bg  @h     	Lavender    	 + E            	   	        Save Ux   *on mouseUp
  save this stack
end mouseUp
    	Lavender    H             	        Font Ux  on mouseUp
  if the visible of button "done" then send mouseUp to button "done"
  lock screen
  put the fontNames into field "fonts"
  sort field "fonts"
  repeat with i = 1 to the number of lines of field "fonts"
    if the textfont of field "report" is line i of field "fonts" then
      set the hilitedlines of field "fonts" to i
      exit repeat
    end if
  end repeat
  put the textHeight of field "report" into field "lheight"
  show group "font"
  unlock screen with visual wipe right
end mouseUp
    	Lavender   J H             	     
   report 	x 	 
 )on mouseUp
  goReportLine 7
end mouseUp
        	 X+8 
 
 
 
    Z w                	`    @ # Y 6     sort   i          H   Company @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    	Lavender      X              	      	Zip Code @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    	Lavender    6 P              	      First Name @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    	Lavender      Y              	     Sort By  D     	Lavender     L              	      
Last Name @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    	Lavender    6 Y              	      opts2   a          A   Show E-mail, Phone & Notes @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    	Lavender     #               	        Show Return Address @E  on mouseUp
  if the hilite of me then
    set the disabled of button "zip code" to false
    if field "return address" is empty then
      send mouseUp to button "edit"
    else
      send mouseUp to button "create report"
    end if
  else
    set the disabled of button "zip code" to true
    set the hilitedButtonName of group "sort" to "First name"
    send mouseUp to button "create report"
  end if
end mouseUp
    	Lavender                    	        Edit Ex  
 on mouseUp
  lock screen
  show field "return address"
  show button "done"
  hide field "report"
  unlock screen with visual wipe down
  select the text of field "return address"
end mouseUp
    	Lavender     ,              	     
   instruction 	  
        8            HYou may edit the field below to make corrections or formatting changes.    opts1   i          A   Show E-mail @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    	Lavender     #               	       
Show Address @E  on mouseUp
  if the hilite of me then
    set the disabled of button "zip code" to false
  else
    set the disabled of button "zip code" to true
    set the hilitedButtonName of group "sort" to "First name"
  end if
  send mouseUp to button "create report"
end mouseUp
    	Lavender                    	    
   instruction 	  
        8            YClick any options to get an updated list. Click a name in the list to go to that record. 
   return address !x   on mouseUp
  put line (the hilitedLine of me) of me into therecord
  set the itemDelimiter to tab
  put item 7 of therecord into whichCard
  go card whichCard of stack "contacts"
end mouseUp
        	 X+ X 
 
 
 
    P  @            	`    @ # Y  V    Done Ex   on mouseUp
  send mouseUp to button "create report"
  lock screen
  hide me
  hide field "return address"
  show field "report"
  unlock screen with visual wipe up
end mouseUp
    	Lavender    \               	        size   a         $ Z
   short  )h 	 
        (  <           field "report"	9,88,564,400  button "Help"	10,408,82,431  %button "Close Window"	91,408,223,431  $button "Save as..."	232,408,320,431  button "Print"	411,408,483,431  'button "Create Report"	148,420,264,448  button "Save"	492,408,564,431  button "Font"	330,408,402,431       	`    @ g )  : 
   long  )h 	 
       (  <           field "report"	9,88,564,508  button "Help"	10,518,82,541  %button "Close Window"	91,518,223,541  $button "Save as..."	232,518,320,541  button "Print"	411,518,483,541  'button "Create Report"	148,420,264,448  button "Save"	492,518,564,541  button "Font"	330,518,402,541       	`    @  )  :    putLong Ex  
%on mouseUp
  put "long" into whichField
  put empty into field whichField
  put the name of field 3 & tab & the rect of field 3 into field whichField
  repeat with i = 15 to 21
    put return & the name of button i & tab & the rect of button i after field whichField
  end repeat
end mouseUp
    	Lavender    h :              	        setLong Ex  
kon mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
    	Lavender    h :              	        	putShort Ex  
&on mouseUp
  put "short" into whichField
  put empty into field whichField
  put the name of field 3 & tab & the rect of field 3 into field whichField
  repeat with i = 15 to 21
    put return & the name of button i & tab & the rect of button i after field whichField
  end repeat
end mouseUp
    	Lavender     h :              	        	setShort Ex  
lon mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
    	Lavender   ; h :              	        font   a            font bg E`   	Lavender                  	        bgrect   K@              v   
   fonts  )x   won mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "report" to line temp of me
end mouseUp
                      
.Keyboard  
AGaramond  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  B Friz Quadrata Bold  C Helvetica Condensed  	Capitals  CB Helvetica Condensed Bold  	Charcoal  Chicago  Comic Sans MS  Courier  Courier New  
FrenchScript  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  
Helvetica  Impact  	Kidprint  L Helvetica Light  LB Helvetica Black  
Lydian MT  Minion Web  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  	Palatino  Sand  Swing  Swis721 BdCn BT  Swis721 BdCnOul BT  Swis721 BdOul BT  Swis721 BdRnd BT  Swis721 BlkCn BT  Swis721 BlkOul BT  Swis721 BlkRnd BT  Swis721 BT  Swis721 Hv BT  Swis721 It BT  Swis721 LtCn BT  Swis721 Th BT  Symbol  Techno  Tekton  Tekton Bold  Textile  Times  Times New Roman  
Trebuchet MS  Verdana  	Webdings  
Wingdings  Zapf Dingbats       	`    @        Close Ex   `on mouseUp
  lock screen
  hide group "font"
  unlock screen with visual wipe left
end mouseUp
    	Lavender    `              	     
   inst 	                      +Pick a font face and size for your report.    sizes   i   on mouseUp
  set the textSize of field "report" to word 1 of the hilitedButtonName of me
  put the textHeight of field "report" into field "lheight"
end mouseUp
         z K   9 pt @D   	Lavender     8              	      10 pt @D   	Lavender     8              	      11 pt @D   	Lavender     8              	      12 pt @D   	Lavender     8              	      14 pt @D   	Lavender     8              	      16 pt @D   	Lavender     8              	   
   
instruction2 	         z  ,           KAfter making changes to the font or size, you may need to adjust the tabs. 
   label2 
         T             Line Height 
   lheight  7)x  on mouseUp
  put field "lheight" into temp
  put the hilitedButtonName of group "sizes" into tsize
  ask "Enter a new line height > " & tsize &"." with temp
  if it is empty or it is not a number or it < tsize then
    answer information "You must enter a number larger than the font size."
    exit mouseUp
  end if
  put it into field "lheight"
  set the textHeight of field "report" to it
end mouseUp
        '            13    Tabs Ex  on mouseUp
  global gContactTabs
  answer question "Set the tab stops to" with "Default" or "Custom"
  switch it
  case "Default"
    set the tabstops of field "report" to "100,225,375"
    put the tabstops of field "report" into gContactTabs
    break
    
  case "Custom"
    if gContactTabs is empty then put the tabstops of field "report" into gContactTabs
    ask "Set the tab stops of the report field to" with gContactTabs
    if it is empty then exit mouseUp
    put true into flag
    repeat with i = 1 to 3
      if item i of it is a number then
        put true into flag
      else
        put false into flag
      end if
    end repeat
    if flag then
      set the tabstops of field "report" to it
      put it into gContactTabs
    end if
  end switch
end mouseUp
    	Lavender   ` `              	        
Default Font Ex   on mouseUp
  set the hilitedButtonName of group "sizes" to "10 pt"
  send mouseUp to group "sizes"
  set the textfont of field "report" to  "Arial"
  send mouseUp to button "font"
end mouseUp
    	Lavender   < `              	        cHelp   on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
  hide group "devtools"
end closeStack

on closeCard
  -- trap
end closeCard

  w        Black    DeepSkyBlue ffffff      white       	darkgray    !w             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica    About Help   	@          w       	Tutorial   	@          w       Contact Tracker   	@          w       List Contacts   	@          w       Print   	@          w     Preferences   	@          w       Keyboard Shortcuts   	@          w      & Font   	@          w    / Adding a New Record   	@          w     Area Code Locator   	@          w    3 Background Color   	@          w     Button Colors   	@          w    D Default Settings   	@          w    H Deleting Records   	@          w    M Exporting Records   	@          w     
First Record   	@          w    V Highlight Color   	@          w    W Importing Records   	@          w     Last Record   	@          w    Z Look and Feel   	@          w     Next Record   	@          w     Prev Record   	@          w    g Quit   	@          w    h 	Record #   	@          w    i 
Registration   	@          w     Save As...   	@          w    n Save Record   	@          w    o Searching Records   	@          w     Sorting Records   	@          w    { Visual Effects   	@          w     Help Index   	@          w    !               help   i          t
   main  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(         xx    Contact Tracker 
  @          
  @          OThe Contact Tracker window is where you will add all your contact information. 
 @        Black    
 @      red   
 @        Black   3   Each "record" in Contact Tracker consists of the First Name, Last Name, Address, City, State, Zip Code, E-mail, Phones, Family and Contact notes. You can add new records or edit the information for any record at any time.    7You can enter notes of any length in the Notes field.  
       (
     ( 
     .    View your list of contacts by clicking the List Contacts button. There are several options in this window for displaying and sorting the contacts. You can also save them to a text file or Print them. See List Contacts  for more information. 
       *
     * 
     8 
      
      
 @      Blue   

        
         0Adding, Deleting, Searching and Sorting Records 
  @        /  
  @          +To add a new record click the New button.  
       
      
     ! 	  <You may delete one or all of the records by clicking the Delete button. You will be asked if you want to delete just the record you are on, all records, or just those older than a certain date. If you choose the last option you will be asked for a date. You may want to export the records, before deleting them all. 
       9
     9 
     ?    Search for text in any record by clicking Find. You can search for the first few characters of a word or complete words. You may also limit your search to words with the exact capitalization as the word you enter, by clicking "case sensitive". 
       *
     * 
     .   
         You can sort records by clicking the Sort button. You will be asked if you want to sort the records by Date or Project. All records are renumbered after sorting. 
       %
     % 
     ) M
     v 
     w *  
         Import and Exporting Records 
  @           You can import or export the records to a tab delimited text file by clicking the Import or Export button. There are a couple of reasons you might want to do this: 
       R
     R 
     X 
     \ 
     b A  
         1) Rather than archiving the whole program, you might want to export all the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.    P3) If you use the Palm Desktop program, you can import or export your contacts.    The exported file is called contact_records.txt with contains the data for all the records. You can change this name if you wish. Be sure to make a note of its location.  
       
 @      Red   
     / S
 @      Blue   (   You can export one or all records, or records that are newer or older than a certain date. See Exporting Records for more information. 
       _
  @      _ 
     p   
         Other Buttons 
  @        
   lClick the Area Code Locator button in the Contact Tracker window to find out where an area code is located. 
       

 @      Blue  
 
      
 @      Red  * 
     @ *
     j    To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
         XYou can go directly to the Schedule Tracker tool by clicking the Schedule Event button. 
       A
     A 
     O   
        vYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Schedule Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q {
      
      
      
      4
     
     
    % 
    ) /
 @      Blue X X
     0
     
        The Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Time Format. For more information see Preferences. 
       
      
     	 
  @       
     1 p
  @       
         /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    mThe Save button saves your data. All records are saved automatically when going to another record or window. 
       
      
      d   The Quit button saves the data and quits the program. You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      .
     6 n         Area Code Locator 
  @           lClick the Area Code Locator button in the Contact Tracker window to find out where an area code is located. 
       

     
 
      
 @      Red  * 
     @ *
     j    rEnter the area code and then click the Search button. A list of major cities in that area code will be displayed. 
       '
     ' 
     - D   8Use the Reset button to clear the list and start again. 
       
      
     
 *   Alternately, you can scroll through the list of cities provided to look up the area code. You can also type the first few letters of the city into the field provided, to get the list to scroll to a particular part of the list.    fThe area code list was current as of about 1/1/2001. No claims are made to the accuracy of this list.    About Help 
  @        
  
  @          !Welcome to Contact Tracker Help. 
 @        Black        Listed in this Help system are all the features, fields and buttons of Contact Tracker. (Buttons are things you click on and fields contain text.) 
         You can click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

      
 @      Blue   Y
    < W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R   
         Each "record" in Contact Tracker consists of the First Name, Last Name, Address, City, State, Zip Code, E-mail, Phones, Family and Contact notes. You can add new records or edit the information for any record at any time.    \Use the buttons at the top of this Help window to learn more about the following subjects:  
       #
     # 
     ' 4   iThe Contact Tracker window is where you add Name, Address and Phone information. You may also add notes. 
       
  @       
      U  
         `The List Contacts window is where you can view, print or save your contact list as a text file. 
       
  @       

      N  
         The Preferences window is where you can change background and button colors, time formats, and the general "look and feel" of the program.  
       
  @       
      |   jAlmost every button in this program has a keyboard shortcut. For more information see Keyboard Shortcuts. 
       V
  @      V 
     h    IThere's an extensive tutorial available by clicking the Tutorial button. 
       8
  @      8 
     @    iThe newest version of this software is available at http://productivity-software/sbtracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470      	Tutorial 
  @          
  @          QHere's a quick tutorial for those just getting started with the Contact Tracker. 
 @        Black    P   Each "record" in Contact Tracker consists of the First Name, Last Name, Address, City, State, Zip Code, E-mail, Phones, Family and Contact notes. You can add new records or edit the information for any record at any time.    bTo add a new record click the New button. Then fill in all the information about the new contact. 
       
      
     ! @   View your list of contacts by clicking the List Contacts button. There are several options in this window for displaying and sorting the contacts. You can also save them to a text file or Print them. See List Contacts  for more information. 
       *
     * 
     8 
      
      
 @      Blue   

        
         Other features: 
  @          uYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Contact Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q z
      
      
      
      4
     
     
    $ 
    ( /
 @      Blue W X
     0
     
       
         lClick the Area Code Locator button in the Contact Tracker window to find out where an area code is located. 
       

 @      Blue  
 
      
 @      Red  * 
     @ *
     j    Search for text in any record by clicking the Find button. You can search for the first part of a word (partial words) or one or more whole words. If capitalization matters, click the "case sensitive" button. 
       .
     . 
     2   
         Sort all the records by first last or company name by clicking the Sort button. You will be asked which to choose which field to sort by. 
       C
     C 
     G B   Delete one or all of the records by clicking the Delete button. You will be asked which records you want to delete. For more information see Deleting Records. 
       1
     1 
     7 V
  @         You may want to export the records by clicking Export. You can then import the data into a spreadsheet or word processing program. You can export the data for archiving purposes too. You can Import the saved data back into Contact Tracker at any time. You will want to export your data when updating to a newer version of Contact Tracker. For more information see Exporting Records and Importing Records. 
       /
     / 
     5 
      
      
  @     l 
    } 
  @      
       
         To access the Preferences window, click the Prefs button. You can change the highlight, button and background colors, time format, etc. For more information see Preferences. 
       ,
     , 
     1 p
  @         
  @         WIf your screen is larger than 640x480, the Contact Tracker window will open in Tall Windows mode. This allows for slightly larger buttons and fields near the bottom of the screen. If you have a small screen, this feature is not available. If for some reason you prefer shorter windows, you can turn this feature off in the Preferences window. 
       +
 @      Red  + 
     A 
 @        Black  O 
     [ 
  @     C 
    N   
        You can close the current window by using the Control + w (or command + w on the Mac) key combination. It is usually better to use the Close Window button, if there is one, or choose another tool from the Small Business Tracker Menu instead of using this shortcut though. 
       
      
      :
      
      '  
         The Save button saves your data. All records are saved automatically when going to another record or when you Quit the program. You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      f
     n 
     r |  
         5To access the help system, click on the Help button. 
       (
     ( 
     ,   
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
         XYou can go directly to the Schedule Tracker tool by clicking the Schedule Event button. 
       A
     A 
     O    \For more information, check the Help Index or any of the buttons at the top of this window. 
        
 @        Black    

     * 1  
         You can use the Save As... button below, to save any or all of the text in the help system, as either a .txt or .html file, for reading or printing. Saving the text in .html format allows you to view the formatted help text in your web browser. 
       
      
      z
 @      Blue   _  
               Keyboard Shortcuts 
  @          
  @          )Many buttons have a keyboard equivalent. 
 @        Black    (  
  @          Shortcuts are indicated by the letter of the button that is underlined. Just press the letter on your keyboard to activate the button.    cIf a keyboard shortcut does not work, try pressing the tab key and then the shortcut letter again. 
  @        b   If you are typing notes, many of the following shortcuts will not work unless you also hold down the Alt key (or Command key on the Macintosh).   CYou can also use the Tab key to move between most of the buttons and editable fields of each window. (Buttons are things you click on, fields are places where text is entered or displayed.) Buttons will appear with a dotted rectangle when they are active. Then you can press the return or enter key to activate the button.    In any field that you can type in, you can also use the standard Cut (Ctrl - x), Copy (Ctrl - c) and Paste (Ctrl - v) keyboard shortcuts.    "Contact Tracker window shortcuts: 
 @        Black    
      
 New - n  Delete - d  List Contacts - l  	Save - s  	Quit - q    $Area Code Locator window shortcuts: 
 @        Black    
      
 Search - s  Close Window - c  	Help - h     List Contacts window shortcuts: 
        	Help - h  Save as - v  	Font - f  
Print - p  	Save - s  Close Window - c  'Move up in list of projects - Up arrow  +Move down in list of projects - Down arrow    Help window shortcuts: 
        About Help - a  List Contacts - l  Contact Tracker - r  Keyboard Shortcuts- k  
Tutorial - t  Preferences - p  Help Index - h  Back to Previous Topic - b  Search Help - s  Close Window - c         / Adding a New Record 
  @           kTo add a new record click the New button. Then fill in all your contact's information including any notes. 
       
      
     ! I     List Contacts 
  @        
  
  @          dEasily create lists of contacts by clicking the List Contacts button in the Contact Tracker window. 
       /
     / 
     = 
 @      Red  L    You can list All Contacts or just the Current Contact by clicking the appropriate radio button at the top of the List Contacts window.  
       

     
 
      

     & 
     5 <
 @      Red  q 
        When All Contacts is selected, the list can show just the contact's name, address and phones, or you can choose the options of Show Address and Show E-mail. The list can be sorted by clicking one of the Sort By radio buttons. The choices are First Name, Last name, Company and Zip Code.  If You can only sort by  Zip Code if the Show Address options is checked. Click any contact in  the list to go directly to its record. 
       
      
      n
      
      
      

      .
      
       
      
     
     

     
    9 
    A 
    I 
    U Q  JChoosing Current Contact displays two new options, Show Return Address and Show E-mail, Phone and Notes. The first option is designed to allow easy printing of an envelope for a single contact. Click the Edit button to enter your return address.  The second option allows you to print out all the information on a single contact. 
       	
     	 
      
     2 
     G 
     J 
     i c
      
      y   The font face, size, line height and tab stops of the list can be modified by clicking the Font button. See Font  for more information. 
       [
     [ 
     _ 

 @      Blue  l 
     p    :You can print the task list by clicking the Print button. 
       ,
     , 
     1    `To save the list as a text file for importing into another program click the Save as... button. 
       M
     M 

     W     W Importing Records 
  @           You can import previously exported records by clicking the Import button in the Contact Tracker window. First you will be asked if you want to Delete all existing records before importing or Add the imported records to the existing ones.  
       ;
     ; 
     A 
 @      Red  _ 
 @        Black  ` 
     f )
      
      *
      
      ,  
         You then will be asked if you want to import a Contact Tracker or a Palm export file. Next you will be asked to locate the text file to import.  
         
         To export records from the Palm Desktop program, choose Export from the File menu, select Contacts from the Which Module menu, choose Tab & return from the Delimiters menu and then click OK. 
          ,See Exporting Records for more information. 
       
  @       
          M Exporting Records 
  @          You can export the records to a text file by clicking the Export button. First you will be asked if you want to export to a Contact Tracker file or a Palm file. If you want to import your contacts into the Palm Desktop program then choose Palm. Otherwise choose Contact Tracker. 
       :
     : 
     @   
         (To import records into the Palm Desktop program, choose Import from the File menu, open the file exported from Contact Tracker, select Contacts from the Fields menu, choose Tab & Return from the Delimiters menu and click OK.) 
         
        5Next you will be asked if you want export All records or Just this one. If you choose All then all records will be exported. If you choose Just this one then only the current record will be exported. Records are exported in a tab delimited format, so they can be easily imported into many other applications. 
       *
     * 
     5 
     9 

     F 
     V 
     Y 2
      

      0
 @      Blue   l  
         If there are no records found to be exported, you will see a message to that effect, but a file will still be written to disk. To avoid confusion, you may want to delete that file. 
          @There are a couple of reasons you might want to export records: 
  @        ? 1) Rather than archiving the whole program, you might want to export all (or some of) the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.    P3) If you use the Palm Desktop program, you can import or export your contacts.   
  @          The exported file is called contact_records.txt which contains the data for all the records in a tab delimited format. You can change this name if you wish. Be sure to make a note of its location. 
       
 @      Red   
  @      , 
     / n
  @       '       Print 
  @          
  @         ?You can print either All Contacts or just the Current Contact by clicking List Contacts button in the Contact Tracker window. Then click the appropriate radio button at the top of the List Contacts window. After selecting from the following options,  print the list or the current contact by clicking the Print button. 
       
      
     ! 

     . 
     = 

     J 

     W 
 @      Red  f 
     ~ :
 @      Red   
      e
    1 
    6   When All Contacts is selected, the list can show just the contact's name, address and phones, or you can choose the options of Show Address and Show E-mail. The list can be sorted by clicking one of the Sort By radio buttons. The choices are First Name, Last name, Company and Zip Code. You can only sort by  Zip Code if the Show Address options is checked. Click any contact in  the list to go directly to its record. 
       
      
      n
      
      
      

      .
      
       
      
     
     

     
    5 
    = 
    E 
    Q Q  IChoosing Current Contact displays two new options, Show Return Address and Show E-mail, Phone and Notes. The first option is designed to allow easy printing of an envelope for a single contact. Click the Edit button to enter your return address. The second option allows you to print out all the information on a single contact. 
       	
     	 
      
     2 
     G 
     J 
     i c
      
      x   The font face, size, line height and tab stops of the list can be modified by clicking the Font button. See Font  for more information. 
       [
     [ 
     _ 

 @      Blue  l 
     p     g Quit 
  @           You can quit (or exit) the program at any time by clicking the Quit button. All data will be saved before quitting.  You can quit the program from any window by using the Control + Q (or command + q on the Macintosh) key combination. 
       ?
     ? 
     C       & Font 
  @          
         You may want to adjust the font, size or line height of the schedule text by clicking the Font button. Choose a new font by clicking its name in the font list. 
       Z
     Z 
     ^ A  
         Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change.  
         
         Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       3
     3 {  You can also set the tab stops of the list text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      !
     @ 
     G 
     \ 
     _ *
      
      
      
      
 @      Blue n O  
 @      Blue      QReset the font face and size to 10 pt Arial by clicking the Default Font button. 
 @        Black    <
 @        Black  < 
 @        Black  H     
          i 
Registration 
  @          'To register Small Business Tracker, click the Small Business Tracker Menu button and choose Small Business Tracker Welcome. Then click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       .
     . 
     I 
     [ 
     \ 
     { 
      

      
         HYou can also review the License Agreement from the Registration window. 
       
      
     )         o Searching Records 
  @          You can search records for particular text by clicking the Find button. A dialog will ask for a partial or whole word to search for. You can find the beginning of a word or phrase by using the partial words option. To find an exact word or phrase, use the whole words option. 
       ;
     ; 
     ? 
      

      2
      
        You can also specify that you want your search to be case sensitive (i.e., a search for "UNIX" will not find "unix"). Click the checkbox next to this option to enable it. 
       5
     5 
     C g   [You can go directly to the first record with a particular date by clicking the Date label. 
       N
     N 
     S      Preferences 
  @          
  @          ?There are several preferences you can set for Contact Tracker. 
 @        Black    >   XTo access the Preferences window, click the Prefs button in the Contact Tracker window. 
       ,
     , 
     1 
 @      Red  @ 
     V   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
      
      e
     v 

      a
      	
      H
  @     2 
    D   You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C   -There is a visual effect that helps to indicate the movement from one record to another in the Contact Tracker window when using the arrow buttons or keys. Some people find this effect annoying or slow. Other people think it is great. So you can choose to turn it On or Off in the Preferences window. 
       n
 @      red  n 
     u 
     
    
 
     
     
  @      
    +   
         If your screen is larger than 640x480, the A&E Tracker window will open in Tall Windows mode. This allows for slightly larger buttons and fields near the bottom of the screen. The report window will also be taller.  
       +
 @      Red  + 
     = 
 @      Blue  K 
     W   
        The Open new tools in a different window? button allows you to choose if you want each tool to open in a new, separate window or if you want each new tool to open in the same window as the current tool. Opening new tools in new windows sometimes creates too many open windows on the screen for some people. Some tools, such as the Universal Calculator,  always open in a new window. 
       
      %
     )U   WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <        V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the Contact Tracker window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O 
 @      red  m 
     t 
      
      F         
First Record 
  @           |Go the first record (the record with the lowest number) by clicking the First button (the one with the left arrow and bar). 
       H
     H 
     M .  
         IThe First Record and Prev Record buttons are hidden on the first record. 
       H        H Deleting Records 
  @          You can delete some or all records by clicking the Delete button. You will be asked if you want to delete Just this one record, Older records or All records. If you choose Older then you will be asked for a date. This feature is useful when you have many old records that you do not need to keep. You will probably want to export the old records first. See Exporting Records for more information. 
       3
     3 
     9 1
     j 

     w 	
      
      
      
      
  @     e 
    v         D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	      Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G         Save As... 
  @        
  You can use the Save as... button at the bottom of this window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. See About Help for more information about printable versions of this Help system. 
       
      

      
 @      Blue   Y
    5 \
  @      

     C  
         \In the Contact Tracker window, the Save as... button exports the Task List to a text file.  
       
 @      Red   
      
     # 

     - 
     A 	
     J   { Visual Effects 
  @          *There is a visual effect that helps to indicate the movement from one record to another in the Contact Tracker window when using the arrow keys. Some people found this effect annoying or slow. Other people thought is was great. So you may now choose to turn it On or Off in the Preferences window. 
       n
 @      red  n 
     u 
     
     
     
     
  @      
    (    See also Record #. 
       	
 @      Blue  	 	   Sorting Records 
  @           You can sort records by Date Entered, Deadline or Priority  by clicking the Sort button in the Contact Tracker window.  All records are renumbered after sorting. 
       
      
     . 
     2 
     : 
     L 
     P 
 @      red  ^ 
     u ,    n Save Record 
  @           You can save all the data in the record window by clicking the Save button. All data is saved automatically when going to another record or when quitting the program. 
       ?
     ? 
     C c        h 	Record # 
  @          Each Record in Contact Tracker has a number. This number may change when you add or delete records. You can go directly to a particular record by clicking the Record # field or label. Or you can use the arrow buttons to go the First Record, Prev Record, Next Record or Last Record. 
       -
  @      - 6
     c <
      
      <
  @       
      
  @       
      
  @       
    	 
  @     
 
        The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
          See also Visual Effects. 
       	
 @      Blue  	    Prev Record 
  @           {Go the previous record (the record with the next lowest number) by clicking the Prev button (the one with the left arrow). 
       P
     P 
     T &   The First Record and Prev Record buttons are hidden on the first record. You can also use the arrow keys to move from one record to the next or previous record.  
            Next Record 
  @           yGo the next record (the record with the next highest number) by clicking the Next button (the one with the right arrow). 
       M
     M 
     Q '   The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
           Z Look and Feel 
  @        
  aIn the Preferences window, the Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
  @       
      
      

     , e
      

      a
      	
     H
  @     M 
    _          Last Record 
  @           |Go the last record (the record with the highest number) by clicking the Last button (the one with the right arrow and bar). 
       H
     H 
     L /   GThe Last Record and Next Record buttons are hidden on the last record. 
       F       Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &    About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
    	Lavender      e             	        List Contacts Ex   Qon mouseUp
  lock screen
  push card
  go card the short name of me
end mouseUp
    	Lavender    t  d             	         Keyboard Shortcuts Ex   Oon mouseUp
  lock screen
push card
  go card "Keyboard Shortcuts"
end mouseUp
    	Lavender                   	        	Tutorial Ex   Eon mouseUp
  lock screen
push card
  go card "Tutorial"
end mouseUp
    	Lavender     " P             	        Contact Tracker Ex   Non mouseUp
  lock screen
  push card
  go card "Contact Tracker"
end mouseUp
    	Lavender    ` "              	        Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
    	Lavender     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
    	Lavender     <              	        Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
    	Lavender     <              	        Search Help Ex  ]on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 320 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack "atFind" to it
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "atFind"
end mouseUp
            	Lavender     l             	        Save as... Ex   on mouseUp
  global gStackName
  
  insert the script of button "SaveHelp" of stack "Launcher" into back
  put "Contact Tracker Help" into gStackName
  exportHelp
  remove the script of button "SaveHelp" of stack "Launcher" from back
end mouseUp
    	Lavender     Q              	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
    	Lavender     y             	       	 	devtools   a         tH   
 Save Ex   *on mouseUp
  save this stack
end mouseUp
    	Lavender    x Q              	        go next Ex   'on mouseUp
  go next card
end mouseUp
    	Lavender    \x Q              	        delete Ex   +on mouseUp
  delete this card
end mouseUp
    	Lavender   x 2              	       
 go prev Ex   'on mouseUp
  go prev card
end mouseUp
    	Lavender    x Q              	           K        
  f          K        ^             K           j          K                    K        
   T    
  ! index  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Help  Adding a New Record  Area Code Locator  Background Color  Button Colors  Contact Tracker  Default Settings  Deleting Records  Exporting Records  
First Record  Font  Highlight Color  Importing Records  Keyboard Shortcuts  Last Record  List Contacts  Look and Feel  Next Record  Preferences  Prev Record  Print  Quit  	Record #  
Registration  Save As...  Save Record  Searching Records  Sorting Records  	Tutorial  Visual Effects         	`    @ ` Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    New Button EpGon mouseUp
sort this stack by field "main"
  beep
end mouseUp


  repeat with i = 1 to the number of cards
    put empty into field "main" of card i
  end repeat

repeat with i = 1 to the number of lines of field index
  if there is a card line i of field index then next repeat
  else answer line i of field index
end repeat
          `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
        D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
         ` 8             	        reindex and sort EpMon mouseUp
  put empty into field "index"
  repeat with i = 1 to the number of cards
    if char 1 of field "main" of card i <> "x" then
      set the name of card i to line 1 of field "main" of card i
      put line 1 of field "main" of card i  & return after field "index"
    end if
  end repeat
  sort field "index"
end mouseUp
        T               	           K        s  e      a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
      DeepSkyBlue    2 @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
    	Lavender    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
    	Lavender     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@   	Lavender      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
      DeepSkyBlue   @ % d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
           % d  z                
     @                     %Import Contact Tracker or Palm file?   z icon BP on mouseUp
end mouseUp
    	Lavender      , (         	      Contact Tracker D`   	Lavender      6             	      Palm D`   	Lavender     6 @            	      Delete D`   	Lavender     6 I            	      Cancel D`   	Lavender   T 6 L            	      y D`   	Lavender     4 '            	      x D`   	Lavender    i 4 '            	      w D`   	Lavender      4 )            	      
areacodes   Ion closeCard
  global gDontSave
  put true into gDontSave
end closeCard
  w            DeepSkyBlue    white        < ,         Area Code Locator      U Arial   U Arial   U 
Helvetica       	@          ,                               Search Mx  &on mouseUp
  put stripSpaces(field "code") into zCode
  if zCode is empty then exit mouseUp
  put empty into field "cities"
  put field "cityList" into zList
  set cursor to watch
    repeat forever
      put lineOffset(zCode,zList) into i
      if i = 0 then exit repeat
      set itemdelimiter to tab
      if item 2 of line i of zList = zCode then
        put item 1 of line i of zList & return after field "cities"
      end if
      delete line i of zList
    end repeat
  sort field "cities"
  delete last char of field "cities"
  if field "cities" is empty then put "No cities found." into field "cities"
end mouseUp

function stripSpaces which
  if char 1 of which is space then delete char 1 of which
  if last char of which is space then delete last char of which
  return which
end stripSpaces
    	Lavender    h 3 d             	        
Close Window Ex  on mouseUp
 -- generateCityList
   close this stack
end mouseUp

on generateCityList
  put empty into field "citylist"
  repeat with i = 1 to the number of lines of field "allcodes"
    put line i of field "allcodes" into temp
    put word 1 of temp into zCode
    put word 2 of temp into zState
    delete word 1 to 2 of temp
    set itemdelimiter to "|"
    repeat with n = 1 to the number of items of temp
      set cursor to busy
      put item n of temp into zCity
      if char 1 of zCity is space then delete char 1 of zCity
      if last char of zCity is space then delete last char of zCity
      put zCity & comma && zState & tab & zCode & return after field "cityList"
    end repeat
  end repeat
  sort field "citylist"
end generateCityList
    	Lavender                  	     
   label1            R            
Area Code 
   cities 	h          ^  h                  	`    @   _  f 
   instruction           8            &Enter an Area Code then click Search.    Reset Ex   on mouseUp
  put empty into field "code"
  put empty into field "cities"
  put empty into field "jump"
  set the scroll of field "cityList" to 0
end mouseUp
    	Lavender     3 5              	     
   	cityList )h                       Aberdeen, SD	605  Abilene, KS	913  Abilene, TX	915  Abington, PA	215  Abington, PA	267  Adrian, MI	517  Aiken, SC	803  Akron, OH	234  Akron, OH	330  Alameda, CA	510  Albany, CA	510  Albany, GA	229  Albany, NY	518  Albany, OR	541  Albuquerque, NM	505  Alexandria, LA	318  Alexandria, MN	320  Alexandria, VA	571  Alexandria, VA	703  Alhambra, CA	626  Alice, TX	361  Aliquippa, PA	724  Allentown, PA	484  Allentown, PA	610  Alliance, NE	308  Altadena, CA	626  Altamonte Springs, FL	407  Alton, IL	618  Altoona, PA	814  Amarillo, TX	806  Americus, GA	229  
Ames, IA	515  Anaheim, CA	714  Anchorage, AK	907	  Anderson, IN	765  Anderson, SC	864  Andover, MN	763  Andover, OH	440  Angleton, TX	979  Ann Arbor, MI	734  Annandale, VA	571  Annandale, VA	703  Annapolis, MD	410  Anniston, AL	256	  Anoka, MN	763  Antioch, CA	925  Appleton, WI	920  Arcadia, CA	526  Ardmore, OK	580  Arlington Heights, IL	847  Arlington, CA	951  Arlington, MA	781  Arlington, TX	682  Arlington, TX	817  Arlington, VA	571  Arlington, VA	703  Arrowhead, CA	909  Arroyo Grande, CA	508  Artesia, CA	310  Arthabaska, QC	819  Arvada, CO	303  Arvada, CO	720  Asheville, NC	828  Ashland, KS	316  Ashland, KY	606  Aspen, CO	970  Astoria, OR	503  Atascadero, CA	508  Atchison, KS	913  Athens, GA	706  Atherton, CA	650  Atlanta, GA	404  Atlanta, GA	678  Atlanta, GA	770  Atlantic City, NJ	609  Auburn, AL	334  Auburn, CA	530  Auburn, ME	207  Auburn, NY	315  Auburn, WA	253  Augusta, GA	706  Augusta, KS	316  Augusta, ME	207  Aurora, CO	303  Aurora, CO	720  Aurora, IL	630  Austin, MN	507  Austin, TX	512  Avila, CA	805	  Azusa, CA	626  Baffin Island, NT	867  Bainbridge Island, WA	206  Baker Lake, NU	867  Baker, CA	760  Baker, LA	225  Bakersfield, CA	661  Baldwin Park, CA	626  Ballwin, MO	314  Ballwin, MO	636  Baltimore, MD	410  Baltimore, MD	443  Banff, AB	403	  Bangor, ME	207  Banning, CA	951  Barre, VT	802  Barrie, ON	705  Barrigada, GU	671  Barstow, CA	619  Bartlesville, OK	918  Bartow, FL	863  Bathurst, NB	506  Baton Rouge, LA	225  Battle Creek, MI	616  Bay City, MI	989  Bay City, TX	979  Bay Pines, FL	727  Bayamon, PR	787  Bayonne, NJ	201  Baytown, TX	281  Baytown, TX	832  Beaumont, TX	409  Beaverton, OR	503  Beaverton, OR	971  Bedford, NS	902  Bedford, OH	216  Bedford, TX	682  Bedford, TX	817  Beech Grove, IN	317  Beeville, TX	361  
Bell, CA	562  Bellaire, TX	713  Belleville, IL	618  Belleville, ON	613  Bellevue, NE	402  Bellevue, WA	425  Bellflower, CA	562  Bellingham, WA	360  Beloit, WI	608  Belvedere, CA	415  Bennington, VT	802  Bensalem, PA	215  Bensalem, PA	267  Berkeley, CA	510  Berwyn, IL	708  Bessemer, AL	205  Bethel Park, PA	412  Bethesda, MD	240  Bethesda, MD	301  Bethlehem, PA	484  Bethlehem, PA	610  Bettendorf, IA	563  Beverly Hills, CA	310  Big Bear Lake, CA	909  Billings, MT	406  Biloxi, MS	228  Binghamton, NY	607  Birmingham, AL	205  Bishop, CA	760  Bismarck, ND	701  Blacksburg, VA	540  Blair, NE	402  Bloomington, IL	309  Bloomington, IN	812  Bloomington, MN	952  Blythe, CA	760  Blytheville, AR	870	  Boca Raton, FL	561  Boise, ID	208  Boone, NC	828  Borger, TX	806  Boron, CA	760   Borrego, CA	760  Bossier City, LA	318  Boston, MA	617  Boston, MA	857  Boulder City, NV	702  Boulder Creek, CA	831  Boulder, CO	303  Boulder, CO	720  Bowie, MD	240  Bowie, MD	301  Bowling Green, KY	270  Boynton Beach, FL	561  Bradenton, FL	941  Brainerd, MN	218  Brampton, ON	905  Brandon, FL	813  Brandon, MB	204  Brawley, CA	760  
Brea, CA	714  Bremerton, WA	360  Brentwood, NY	631  Brick, NJ	732  Bridgeport, CA	760  Bridgeport, CT	203  Bridgeton, MO	314  Bridgeton, NJ	856  Brigham City, UT	435  Bristol, CT	860  Bristol, PA	215  Bristol, TN	423  Brockton, MA	508  Brockton, MA	774  Broken Arrow, OK	918  Bronx, NY	347  Bronx, NY	718  Bronx, NY	917  Brookfield, WI	262  Brookings, SD	605  Brooklyn, NY	347  Brooklyn, NY	718  Brooklyn, NY	917  Brownsville, TN	731  Brownsville, TX	956  Bryan, TX	409  Bryan, TX	979  Buena Park, CA	714  Buffalo, NY	716  Burbank, CA	818  Burke, VA	571  Burke, VA	703  Burlingame, CA	650  Burlington, IA	319  Burlington, NC	336  Burlington, VT	802  Burnsville, MN	952  Butte, MT	406  Caguas, PR	787  Calexico, CA	760  Calgary, AB	403  California City, CA	760  Calimesa, CA	909  Calipatria, CA	760  Camarillo, CA	805  Cambria, CA	805  Cambridge, MA	617  Cambridge, MA	857  Camden, NJ	856  Camp Hill, PA	570  Campbel, CA	408  Campbellton, NB	506  Campo, CA	805  Canoga Park, CA	818  Canon City, CO	719  Canton, MI	734  Canton, OH	234  Canton, OH	330  Canyon Country, CA	661  Cape Coral, FL	941  Cape Girardeau, MO	573  Capistrano, CA	949  Capitola, CA	831  Carbondale, IL	618  Carlisle, PA	717  Carlsbad, CA	760  Carmel, CA	831  Carmel, IN	317  Carmichael, CA	916  Carolina, PR	787  Carpinteria, CA	661  Carroll, IA	712  Carrollton, GA	706  Carson City, NV	775  Carson, CA	310  Carthage, MO	417  
Cary, NC	919  Casa Grande, AZ	520	  Casper, WY	307  Castaic, CA	661  Castro Valley, CA	510  Castroville, CA	831  Cedar City, UT	435  Cedar Falls, IA	319  Cedar Rapids, IA	319  Center, TX	936  Central Islip, NY	631  Cerritos, CA	562  Chalmette, LA	504  Champaign, IL	217  Champlin, MN	763  Chandler, AZ	480  Chapel Hill, NC	919  Charleston, SC	843  Charleston, WV	304  Charlotte, NC	704  Charlotte, NC	980  Charlottetown, PE	902  Chateauguay, QC	450  Chatsworth, CA	818  Chattanooga, TN	423  Cheektowaga, NY	716  Cherry Hill, NJ	856  Chesapeake, VA	757  Chester, PA	484  Chester, PA	610  Chesterfield, MO	636  Chesterfield, VA	804  Cheyenne, WY	307  Chicago, IL	312  Chicago, IL	773  Chico, CA	530  Chicopee, MA	413  Chicoutimi, QC	418  Chowchilla, CA	559  Christiansted, VI	340  Chula Vista, CA	619  Churchill, MB	204  Cicero, IL	708  Cincinnati, OH	513  Citrus Heights, CA	916  Claremont, CA	909  Clarksdale, MS	662  Clarksville, TN	931  Claymont, DE	302  Clearlake, CA	707  Clearwater, FL	727  Clementon, NJ	856  Cleveland, OH	216  Cleveland, OH	440  Cleveland, TN	423  Clifton Park, NY	518  Clinton Township, MI	810  Clinton, IA	563  Clinton, MS	601  Clinton, TN	865  Clovis, CA	559  Coalinga, CA	559  Cobourg, ON	905  Cockrell Hill, TX	214  College Station, TX	409  College Station, TX	979  Colorado Springs, CO	719  Colton, CA	909  Columbia, MD	410  Columbia, MD	443  Columbia, MO	573  Columbia, SC	803  Columbia, TN	931  Columbus, GA	706  Columbus, IN	812  Columbus, MS	662  Columbus, OH	614  Colusa, CA	530  Compton, CA	310  Concord, CA	925  Concord, NC	704  Concord, NC	980  Concord, NH	603  Conroe, TX	936  Converse, TX	210  Cookeville, TN	931  Copperas Cove, TX	254  Coraopolis, PA	412  Corner Brook, NF	709  Cornwall, ON	613  Corona, CA	951  Coronado, CA	619  Corpus Christi, TX	361  Corvallis, OR	541  Costa Mesa, CA	949  Cottage Grove, MN	651  Council Bluffs, IA	712  Covina, CA	626  Covington, GA	706  Covington, KY	859  Covington, LA	985  Cranbrook, BC	250  Cranston, RI	401  Crestview, FL	850  Cudahy, WI	414  Culver City, CA	310  Cupertino, CA	408  Cypress, CA	714  Dallas, TX	214  Dallas, TX	469  Dallas, TX	972  Daly City, CA	650	  Danville, CA	925  Dartmouth, NS	902  Davenport, IA	563  Davis, CA	530  Dawson, YT	867  Dayton, OH	937  Daytona Beach, FL	386  Dearborn Heights, MI	313  Dearborn, MI	313  Death Valley, CA 	760  Decatur, AL	256  Decatur, GA	404  Decatur, IL	217  Dededo, GU	671  Deerfield Beach, FL	954  Dekalb, IL	815  Del Mar, CA	858  Del Rio, TX	830  Deland, FL	386  Delano, CA	661  Delaware, OH	740  Delray Beach, FL	561  Denton, TX	940  Denver, CO	303  Denver, CO	720  Derry, NH	603  Des Moines, IA	515  Desert Hot Springs, CA	760  Detroit, MI	248  Detroit, MI	313  Detroit, MI	810  Dickinson, ND	701  Dinuba, CA	559  Dixon, CA	707  Dodge City, KS	620  Dorchester, MA	617  Dorchester, MA	857  Dothan, AL	334  Dover, DE	302  Dover, NH	603  Downers Grove, IL	630  Downey, CA	562  Drummondville, QC	819  Dryden, ON	807  Duarte, CA	626  Dublin, CA	925  Dublin, GA	478  Dubuque, IA	563  Duluth, MN	218  Dulzura, CA	760  Duncan, OK	580  Dunsmuir, CA	530  Durango, CO	970  Durham, NC	919  Dyersburg, TN	731  Dyersburg, TN	901  Eagle Pass, TX	830  Easley, SC	864  East Lansing, MI	517  East Orange, NJ	973  East Saint Louis, IL	618  Eastchester, NY	845  Eau Claire, WI	715  Eden Prairie, MN	952  Edgewater, FL	386  Edison, NJ	732  Edmond, OK	405  Edmonton, AB	780  El Cajon, CA	619  El Centro, CA	760   El Cerrito, CA	510  El Dorado, AR	870  El Dorado, KS	316  El Monte, CA	626  El Paso, TX	915  El Segundo, CA	310  Elgin, IL	847  Elisnore, CA	951  Elizabeth, NJ	908  Elk River, MN	763  
Elko, NV	775  Ellenwood, GA	404  Elmhurst, IL	630  Elmira, NY	607  Elyria, OH	440  Emeryville, CA	510  Emporia, KS	620  Encinitas, CA	760  Encino, CA	818  
Enid, OK	580  
Erie, PA	814  Escanaba, MI	906  Escondido, CA	760  Essex Junction, VT	802  Euclid, OH	216  Euclid, OH	440  Eugene, OR	541  Euless, TX	682  Euless, TX	817  Eunice, LA	337  Eureka, CA	707  Eustis, FL	352  Evanston, IL	847  Evansville, IN	812  Everett, WA	425  Exeter, CA	559  Fair Oaks, CA	916  Fairbanks, AK	907  Fairborn, OH	937  Fairdale, KY	502  Fairfax, CA 	415	  Fairfield, AL	205  Fairfield, CA	707  Fairfield, IA	641  Fairfield, OH	513  Fairport, NY	716  Fall River, MA	508  Fall River, MA	774  Fallbrook, CA 	760  Fargo, ND	701  Faribault, MN	507  Farmingdale, NY	516  Farmingdale, NY	631  Fayetteville, AR	501  Fayetteville, NC	910  Federal Way, WA	253  Felton, CA	831  Felton, DE	302  Fenton, MO	314  Fenton, MO	636  Fergus Falls, MN	218  Fillmore, CA	805  Findlay, OH	419  Fitchburg, MA	351  Fitchburg, MA	978  Flagstaff, AZ	520  Flatwoods, KY	606  Flint, MI	810  Florence, AL	256  Florence, KY	859  Florence, SC	843  Florissant, MO	314  Flushing, NY	347  Flushing, NY	718  Flushing, NY	917  Folsom, CA	916  Fond du Lac, WI	920  Fontana, CA	909  Forest Park, GA	404  Forestville, CA	707  Fort Bragg, CA	707  Fort Bragg, NC	910  Fort Collins, CO	970  Fort Dodge, IA	515  Fort Frances, ON	807  Fort Lauderdale, FL	954  Fort Myer, VA	571  Fort Myer, VA	703  Fort Myers, FL	941  Fort Qu Appelle, SK	306  Fort Saskatchewan, AB	780  Fort Smith, AR	501  Fort Smith, NT	867  Fort Walton Beach, FL	850  Fort Wayne, IN	219  Fort Worth, TX	682  Fort Worth, TX	817  Fortuna, CA	707  Fountain, CO	719  Framingham, MA	508  Framingham, MA	774  Frankfort, KY	502  Franklin, TN	615  Franklin, WI	414  Frazier Park, CA	661  Frederick, MD	240  Frederick, MD	301  Fredericton, NB	506  Frederiksted, VI	340  Freeport, IL	815  Freeport, TX	979  Fremont, CA	510  Fremont, NE	402  Fresno, CA	559  Fullerton, CA	714  Furnace Creek, CA	760  Gadsden, AL	256  Gainesville, FL	352  Gainesville, TX	940	  Gallatin, TN	615  Galveston, TX	409  Gambling, LA	318  Garden City, KS	620  Garden Grove, CA	714  Gardena, CA	310  Garland, TX	469  Garland, TX	972  
Gary, IN	219  Gastonia, NC	704  Gastonia, NC	980  Georgetown, KY	502  Georgetown, TX	512  Germantown, TN	901  Gillette, WY	307  Gilroy, CA	408  Glendale, AZ	623  Glendale, CA	818  Glendora, CA	626  Goldsboro, NC	919  Gonzales, TX	210  Goose Creek, SC	843  Grand Falls, NF	709  Grand Forks, ND	701  Grand Island, NE	308  Grand Junction, CO	970  Grand Rapids, MI	231  Grand Rapids, MI	616  Grand Terrace, cA	909  Grande Prairie, AB	780  Grandview, MO	816  Grandville, MI	231  Granite City, IL	618  Grass Valley, CA	530  Great Bend, KS 	316	  Great Falls, MT	406  Greeley, CO	970  Green Bay, WI	920  Greensboro, NC	336  Greensburg, PA	724  Greenville, MS	662  Greenville, NC	252  Greenville, SC	864  Greenville, TX	903  Greenwood, IN	317  Greenwood, MS	662  Greenwood, SC	864  Gresham, OR	503  Gresham, OR	971  Grosse Ile, MI	734  Grove City, OH	614  Guernsey, OH	740  Gulfport, MS	228  Hagatna, GU	671  Haines City, FL	863  Halifax, NS	902  Hamilton, OH	513  Hamilton, ON	905  Hammond, IN	219  Hammond, LA	985  Hampton, VA	757  Hanford, CA	559  Hannibal, MO	573  Harlingen, TX	956  Harrisburg, PA	717  Harrison, MI	989  Harrisonburg, VA	540  Hartford, CT	860  Hartford, CT	860  Hastings, MN	651  Hattiesburg, MS	601  Havelock, NC	252  Haverhill, MA	351  Haverhill, MA	978  Hawthorne, CA	310  
Hays, KS	785  Hayward, CA	510  Hazleton, PA	570  Helena, MT	406  Hemet, CA	909  Hempstead, NY	516  Henderson, KY	270  Henderson, NV	702  Hendersonville, TN	615  Hermosa Beach, CA 	310	  Hesperia, CA	760  Hialeah, FL	305  Hialeah, FL	786  Hibbing, MN	218  Hickory, NC	828  Hicksville, NY	516  High Point, NC	336  Highland Park, TX	214  Hillsboro, OR	971  
Hilo, HI	808  Hollister, CA	831  Hollywood, FL	954  
Holt, MI	517  Holtville, CA	760  Holyoke, MA	413  Homestead, FL	305  Homestead, FL	786  Honolulu, HI	808  Hopewell, VA	804  Hopkins, MN	952  Hopkinsville, KY	270  "Hot Springs National Park, AR	501  Houma, LA	985  Houston, TX	281  Houston, TX	713  Houston, TX	832  Hueneme, CA	805  
Hull, QC	819  Humble, TX	713  Humboldt, SK	306  Huntington Beach, CA	714  Huntington Park, CA	323  Huntington Station, NY	631  Huntington, WV	304  Huntsville, AL	256  Huntsville, TX	936  Hutchinson, KS	620  Hutchinson, MN	320  Hyder, AK	250  Idaho Falls, ID	208  Idylwild, CA	951  Ile Perrot, QC	514  Imperial Beach, CA	619  Independence, MO	816  Indianapolis, IN	317  Indio, CA	760  Inglewood, CA	310  Inver Grove Heights, MN	651  
Iola, KS	316  Iowa City, IA	319  Iqaluit, NU	867  Iron Mountain, MI	906  Irvine, CA	949  Irving, TX	469  Irving, TX	972  Irvington, NJ	973  Irwin, PA	724  Islip,  NY 	631  Ithaca, NY	607  Jackson, MI	517  Jackson, MS	601  Jackson, TN	731  Jackson, TN	901  Jacksonville Beach, FL	904  Jacksonville, FL	904  Jacksonville, NC	910  Jamaica, NY	347  Jamaica, NY	718  Janesville, WI	608  Jasper, AB	780  Jefferson City, MO	573  Jenison, MI	231  Jenison, MI	616  Jersey City, NJ	201  Johnson City, NY	607  Johnson City, TN	423  Joliet, IL	815  Jonesboro, AR	870  Joplin, MO	417  Joshua Tree, CA	760  Junction City, KS	785  Juneau, AK	907  Kailua, HI	808  Kalamazoo, MI	616  Kamloops, BC	250  Kaneohe, HI	808  Kankakee, IL	815  Kannapolis, NC	704  Kannapolis, NC	980  Kansas City, KS	913  Kansas City, MO	816  Kearney, NE	308  Kelowna, BC	250  Kenai, AK	907  Kenner, LA	504  Kennewick, WA	509  Kenora, ON	807  Kenosha, WI	262  
Kent, OH	234  
Kent, OH	330  
Kent, WA	253  
Kent, WA	360  Kernville, CA	760  Kerrville, TX	830  Key West, FL	305  Killeen, TX	254  Kingsburg, CA	559  Kingshill, VI	340  Kingsport, TN	423  Kingsville, TX	361  Kinston, NC	252  Kirkland, WA	425  Kirksville, MO	660  Kissimmee, FL	407  Kitchener, ON	519  Knoxville, TN	865  Knoxville, TN	931  Kokomo, IN	765  La Canada, CA	818  La Crescenta, CA	818  La Crosse, WI	608  La Habra, CA	562  La Jolla, CA	858  La Mesa, CA	619  La Place, LA	985  La Puente, CA	626  La Verne, CA	909  Labrador City-wabush, NF	709  Lachine, QC	514  Lady Lake, FL	352  Lafayette, IN	765  Lafayette, LA	337  Lagrange, GA	706  Laguna Beach, CA	949  Laguna Niguel, CA	949  Lake Arrowhead, CA	909  Lake Charles, LA	337  Lake Jackson, TX	979  Lake Station, IN	219  Lake Wales, FL	863  Lakeland, FL	863  Lakeville, MN	952  Lakewood, CA	562  Lakewood, NJ	732  Lakewood, OH	216  Lancaster, CA	661  Lancaster, OH	740  Lancaster, PA	717  Lansing, MI	517  Laramie, WY	307  Laredo, TX	956  Largo, FL	727  Las Cruces, NM	505  Las Vegas, NV	702  Laughlin, NV	702  Laval, QC	450  Lawrence, KS	785  Lawrence, MA	351  Lawrence, MA	978  Lawton, OK	580  Leavenworth, KS	913  Lebanon, MO	417  Lebanon, PA	717  Lees Summit, MO	816  Leesburg, FL	352  Lemoore, CA	559  Lenoir, NC	828  Lethbridge, AB	403  Levis, QC	418  Levittown, NY	516  Levittown, PA	215  Levittown, PA	267  Lewiston, ID	208  Lewiston, ME	207  Lexington, KY	859  Lexington, TN	731  
Lima, OH	419  Lincoln, NE	402  Linden, NJ	908  Little Rock, AR	501  Livermore, CA	925  Livonia, MI	248  Livonia, MI	734  
Lodi, CA	209  Logan, UT	435  Lomita, CA	310  Lompoc, CA	805  London, ON	519  Lone Pine, CA 	760	  Long Beach, CA	562  Long Beach, MS	228  Longview, TX	903  Lorain, OH	440  Los Angeles, CA	213  Los Angeles, CA	323  Louisville, KY	502  Loveland, CO	970  Lowell, MA	351  Lowell, MA	978  Lubbock, TX	806  Lufkin, TX	936  Lumberton, NC	910  
Lutz, FL	813  Lynwood, CA	562  Macon, GA	478  Madera, CA	559  Madison, WI	608  Malden, MA	339  Malden, MA	781  Manchester, CT	860  Manchester, NH	603  Manhattan Beach, CA	310  Manhattan, KS	785  Manhattan, NY	212  Manhattan, NY	646  Manhattan, NY	917  Mankato, MN	507  Mansfield, LA	318  Mansfield, OH	419  Maple Heights, OH	216  Marietta, GA	678  Marietta, GA	770  Marion, OH	740  Mariposa, CA	559  Marquette, MI	906  Marrero, LA	504  Marshall, MO	660  Marshalltown, IA	641  Marshfield, WI	715  Marystown, NF	709  Marysville, CA	530  Maryville, TN	865  Maywood, CA	310  Mc Keesport, PA	412  McAllen, TX	956  McPherson, KS	316  Meadville, PA	814  Mechanicsburg, PA	717  Mechanicsville, VA	804  Medford, MA	339  Medford, MA	781  Medford, OR	541  Medicine Hat, AB	403  Melbourne, FL	321  Memphis, TN	901  Mendocino, CA	707   Menominee, MI	906  Mentor, OH	440  Merced, CA	209  Mercer Island, WA	206  Meridian, MS	601  Merritt Island, FL	321  Merritt Island, FL	407  
Mesa, AZ	480  Mesquite, TX	469  Mesquite, TX	972  Metairie, LA	504  Miami, FL	305  Miami, FL	786  Middlesboro, KY	606  Middletown, NY	845  Middletown, OH	513  Midland, MI	989  Midland, TX	915  Milbrea, CA	650  Mill Valley, CA	415  Milledgeville, GA	478  Millington, TN	901  Milpitas, CA	408  Milwaukee, WI	414  Mineral Wells, TX	940  Minneapolis, MN	612  Minnetonka, MN	952  Minot, ND	701  Mirabel, QC	450  Miramichi, NB	506  Mission Viejo, CA	949  Missoula, MT	406  Missouri City, TX	281  Missouri City, TX	832  Moberly, MO	660  Mobile, AL	334  Modesto, CA	209  Mojave, CA	661  Moline, IL	309  Monroe, LA	318  Monroeville, PA	412  Monrovia, CA 	626	  Montebello, CA	323  Monterey, CA	831  Montgomery, AL	334  Montgomery, GA	912  Montreal, QC	514  Montrose, CA 	818	  Moorhead, MN	218  Moorpark, CA	805  Moose Jaw, SK	306  
Mora, MN	320  Morehead, KY	606  Moreno Valley, CA	909  Morganton, NC	828  Morgantown, WV	304  Moro Bay, CA	805  Moss Point, MS	228  Mount Airy, NC	336  Mount Holly, NJ	609  Mount Pleasant, MI	989  Mount Pleasant, SC	843  Mount Vernon, NY	914  Mountain View, CA	650  Mulberry, CA	831  Mulvane, KS	316  Muncie, IN	765  Murfreesboro, TN	615  Murrieta, CA	951  Muscatine, IA	563  Muskegon, MI	231  Muskogee, OK	918  Myrtle Beach, SC	843  Nacogdoches, TX	936  Nampa, ID	208  Nanaimo, BC	250  
Napa, CA	707  Naperville, IL	630  Naples, FL	941  Nashua, NH	603  Nashville, TN	615  Nashville, TN	931  Nassau, NY	516  National City, CA	619  Needles, CA	760  New Albany, IN	812  New Bedford, MA	508  New Bedford, MA	774  New Berlin, WI	262  New Braunfels, TX	830  New Britain, CT	860  New City, NY	845  New City, NY	914  New Haven, CT	203  New Iberia, LA	337  New Kensington, PA	724  New Orleans, LA	504  New Rochelle, NY	914  New Smyrna Beach, FL	386  New Westminster, BC	604  New York, NY	212  New York, NY	646  New York, NY	917  Newark, DE	302  Newark, NJ	973  Newark, OH	740  Newburgh, NY	845  Newhall, CA	661  Newport Beach, CA	949  Newport News, VA	757  Newport, KY	859  Newton, BC	604  Newton, IA	641  Newton, KS	316  Newton, MA	617  Newton, MA	857  Niagara Falls, NY	716  Niagara Falls, ON	905  Nipigon, ON	807  
Nixa, MO	417  Noblesville, IN	317  Nogales, AZ	520  Norco, CA	951  Norfolk, VA	757  Normal, IL	309  Norman, OK	405  North Augusta, SC	803  North Bay, ON	705  North Bergen, NJ	201  North Hollywood, CA	818  North Hollywood, CA	818  North Las Vegas, NV	702  North Little Rock, AR	501  North Miami Beach, FL	305  North Miami Beach, FL	786  North Platte, NE	308  North Richland Hills, TX	682  North Richland Hills, TX	817  Northport, AL	205  Northridge, CA	818  Norwalk, CA	562  Norwalk, CT	203  Nottingham, MD	410  Nottingham, MD	443  Novato, CA	415  Oak Creek, WI	414  Oak Lawn, IL	708  Oak Park, IL	708  Oak Ridge, TN	865  Oakland, CA	510  Ocala, FL	352  Oceanside, CA	760  Odessa, TX	915  Ogdan, UT	801  
Ojai, CA	805  Oklahoma City, OK	405  Olathe, KS	913  Olympia, WA	360  Omaha, NE	402  Ontario, CA	909  Opa Locka, FL	786  Opelika, AL	334  Opelousas, LA	337  Orange, CA	714  
Orem, UT	801  Orinda, CA	925  Orland Park, IL	708  Orlando, FL	321  Orlando, FL	407  Ormond Beach, FL	386  Oshkosh, WI	920  Oskaloosa, IA	641  Ottawa, KS	913  Ottawa, ON	613  Ottumwa, IA	641  Owensboro, KY	270  Oxford, OH	513  Oxnard, CA	805  Oyster Bay, NY	516  Pacific Beach, CA	858  Pacifica, CA	650  Pacoima, CA	818  Paducah, KY	270  
Pala, CA	760  Palm Bay, FL	321  Palm Desert, CA	760  Palm Springs, CA	760  Palmdale, CA	661  Palo Alto, CA	650  Pampa, TX	806  Panama City, FL	850  Paradise, CA	530  Paramount, CA	562  Parkersburg, WV	304  Pasadena, CA	626  Pasadena, TX	281  Pasadena, TX	713  Pasadena, TX	832  Pascagoula, MS	228  Paso Robles, CA	805  Passaic, NJ	973  Paterson, NJ	973  Pauma Valley, CA	760  Pawtucket, RI	401  Peabody, MA	351  Peabody, MA	978  Pebble Beach, CA	831  Pensacola, FL	850  Peoria, AZ	623  Peoria, IL	309  Perry, GA	478  Petaluma, CA	707  Peterborough, ON	705  Petersburg, VA	804  Pharr, TX	956  Phenix City, AL	334  Philadelphia, PA	215  Philadelphia, PA	267  Phoenix, AZ	480  Phoenix, AZ	520  Phoenix, AZ	602  Phoenix, AZ	623  Pico Rivera, CA	562  Pine Bluff, AR	870  Pinellas Park, FL	727  Piqua, OH	937  Piscataway, NJ	732  Pismo Beach, CA 	805	  Pittsburg, CA	925  Pittsburg, KS	620  Pittsburgh, PA	412  Pittsfield, MA	413  Placenita, CA	714  Placerville, CA	530  Plainfield, NJ	908  Plainview, TX	806  Plano, TX	469  Plano, TX	972  Plant City, FL	813  Plantation, FL	904  Pleasanton, CA	925  Pleasantville, NJ	609  Pocatello, ID	208  Pointe Claire, QC	514  Pomona, CA 	909	  Pompano Beach, FL	954  Ponca City, OK	580  Ponce, PR	787  Pontiac, MI	248  Port Charlotte, FL	941  Port Coquitlam, BC	604  Port Saint Lucie, FL	561  Portage, MI	616  Porterdale, GA	678  Porterdale, GA	770  Porterville, CA	559  Portland, ME	207  Portland, OR	503  Portland, OR	971  Poughkeepsie, NY	845  Poway, CA	858	  Prairieville, LA	225  Princeton, MN	763  Providence, RI	401  Provo, UT	801  Pueblo, CO	719  Puyallup, WA	253  Quebec City, QC	418  Queens, NY	347  Queens, NY	718  Queensbury, NY	518  Quincy, IL	217  Quincy, MA	617  Quincy, MA	857  Racine, WI	262  Raleigh, NC	919  Ramona, CA	760  Rancho Cordova, CA	916  Rancho Cucamonga, CA	909  Rancho Santa Fe, CA	858  Rankin Inlet, NU	867  Rapid City, SD	605  Reading, PA	484  Reading, PA	610  Red Bluff, CA	530  Red Deer, AB	403  Redding, CA	530  Redford, MI	313  Redlands, CA 	909	  Redmond, WA	425  Redondo Beach, CA	310  Redwood City, CA	650	  Regina, SK	306  
Reno, NV	775  Renton, WA	425  Reseda, CA	818  Reynoldsburg, OH	614  Rialto, CA	909  Richland, WA	509  Richmond, BC	604  Richmond, CA	510  Richmond, IN	765  Richmond, KY	859  Richmond, VA	804  Rio Rancho, NM	505  Riverside, CA	909  Riviere Du Loup, QC	418  Roanoke, VA	540  Rochester, MN	507  Rochester, NY	716  Rochester, OH	440  Rock Hill, SC	803  Rock Island, IL	309  Rock Springs, WY	307  Rockford, IL	815  Rockville, MD	240  Rockville, MD	301  Rocky Mount, NC	252  
Rome, GA	706  
Rome, NY	315  Rosemead, Ca	626  Roseville, CA	916  Roswell, GA	678  Roswell, GA	770  Roswell, NM	505  Round Rock, TX	512  Ruston, LA	318  Rutland, VT	802  Sacramento, CA	916	  Saginaw, MI	989  Saint Charles, MO	636  Saint Cloud, MN	320  Saint George, UT	435  Saint John, NB	506  Saint Joseph, MO	816  Saint Louis, MO	314  Saint Paul, MN	651  Saint Peters, MO	636  Saint Petersburg, FL	727  Salem, OR	503  Salem, OR	971  Salem, VA	540  Salida, CO	719  Salina, KS	785  Salinas, CA	831  Salisbury, NC	704  Salisbury, NC	980  Salt Lake City, UT	801  San Angelo, TX	915  San Anselmo, CA	415  San Antonio, TX	210  San Bernardino, CA	909  San Bruno, CA	650  San Carlos, CA	650  San Clemente, CA	949  San Diego, CA	619  San Fernando, CA	818  San Francisco, CA	415  San Gabriel, CA	626  San Jacinto, CA	909  San Jose, CA	408  San Juan Capistrano, CA	949  San Juan, PR	787  San Leandro, CA	510  San Luis Obispo, CA	805  San Marcos, TX	512  San Mateo, CA	650  San Paula, CA	805  San Pedro, CA	310  San Rafael, CA	415  San Ramon, CA	925  San Simeon, CA	805  San Ysidro, CA	619 	  Sandusky, OH	419  Sandy, UT	801  Santa Ana, CA	714  Santa Barbara, CA	805  Santa Catalina, CA	310  Santa Clara, CA	408	  Santa Cruz, CA	831  Santa Fe, NM	505  Santa Maria, CA	805  Santa Monica, CA	310  Santa Rosa, CA	707  Sapulpa, OK	918  Sarasota, FL	941  Saratoga, CA	408  Saskatoon, SK	306  Saticoy, CA	805  Saugus, CA	661  Sault Sainte Marie, MI	906  Sault Ste Marie, ON	705  Sausality, CA	415  Savannah, GA	912  Schaumburg, IL	847  Schenectady, NY	518  Schertz, TX	210  Scottdale, GA	404  Scottsbluff, NE	308  Scottsdale, AZ	480  Scranton, PA	570  Seaside, CA	831  Seattle, WA	206  Sebastopol, CA	707  Sedalia, MO	660  Seguin, TX	830  Sequoia, CA	559  Sevierville, TN	865  Shasta, CA	530  Shawnee Mission, KS	913  Sheboygan, WI	920  Shelbyville, KY	502  Sherbrooke, QC	819  Sherman Oaks, CA	818  Sherman, TX	903  Sherwood Park, AB	780  Shreveport, LA	318  Sierra Madre, CA	626  Sierra Vista, AZ	520  Sikeston, MO	573  Silver Spring, MD	240  Silver Spring, MD	301  Silverlake, WA	206  Simi Valley, CA	805  Sioux City, IA	712  Sioux Falls, SD	605  Slidell, LA	985  Smyrna, GA	678  Smyrna, GA	770  Solana Beach, CA	858  Soldotna, AK	907  Soledad, CA 	831	  Solvang, CA	805  Somerset, KY	606  Sonoma, CA	707  Sonora, CA	209  South Bend, IN	219  South Gate, CA	323  South Houston, TX	713  South Milwaukee, WI	414  South Saint Paul, MN	651  South San Francisco, CA	650  South Tahoe, CA	530  Southfield, MI	248  Sparks, NV	775  Sparrows Point, MD	410  Sparrows Point, MD	443  Spartanburg, SC	864  Spencer, IA	712  Spokane, WA	509  Spring Valley, CA	619  Spring, TX	281  Spring, TX	832  Springfield, IL	217  Springfield, MA	413  Springfield, MO	417  Springfield, OH	937  Springfield, OR	541  St Catherine, QC	450  St Genevieve, QC	514  St Georges De Beauce, QC	418  St John, VI	340  St Johns, NF	709  St Marc Sur Richelieu, QC	450  St Thomas, VI	340  Stafford, VA	540  Stamford, CT	203  State College, PA	814  Staten Island, NY	347  Staten Island, NY	718  Stephenville, TX	254  Sterling Heights, MI	810  Stevens Point, WI	715  Stillwater, OK	405  Stockton, CA	209  Storm Lake, IA	712  Stratford, ON	519  Sudbury, ON	705  Suisun, CA	707  Sulphur, LA	337  Sumter, SC	803  Sun City Center, FL	813  Sun City West, AZ	623  Sun City, AZ	623  Sun Prairie, WI	608  Sun Valley, NV	775  Sunnymead, CA 	909	  Sunnyvale, CA	408  Superior, WI	715  Sydney, NS	902  Syracuse, NY	315  Syracuse, NY	607  Tacoma, WA	253  
Taft, CA	661  Tahoe City, CA 	530	  Tallahassee, FL	850  Tampa, FL	813  Tamuning, GU	671  Taylor, MI	313  Taylor, TX	512  Tecete, CA 	619	  Tehachapi, CA 	661	  Tempe, AZ	480  Temple City, CA 	626	  Temple, TX	254  Terre Haute, IN	812  Texarkana, TX	903  Texas City, TX	409  Thomasville, GA	229  Thompson, MB	204  Thousand Oaks, CA	805  Thunder Bay, ON	807  Tifton, GA	229  Tillamook, OR	503  Titusville, FL	321  Titusville, FL	407  Toledo, OH	419  Toms River, NJ	732  Tooele, UT	435  Topeka, KS	785  Toronto, ON	416  Toronto, ON	647  Torrance, CA	310  Trabuco, CA	949  Tracy, CA 	209	  Traverse City, MI	231  Trenton, NJ	609  Trois Rivieres, QC	819  
Troy, MI	248  
Troy, NY	518  Truckee, CA	530  Truro, NS	902  Tucker, GA 	678	  Tucker, GA 	770	  Tucson, AZ	520  Tulare, CA	559  Tulsa, OK	918  Tupelo, MS	662  Turlock, CA	209  Tuscaloosa, AL	205  Tustin, CA	714 Tustin, CA	949 
       

    
 
       Twentynine Palms, CA	760  Tyler, TX	903  Ukiah, CA	707	  Union City, CA 	510	  Union City, NJ	201  Union City, TN	731  Union, NJ	908  Universal City, TX	210  University Park, PA	814  University Park, TX	214  Upland, CA	909  Upper Darby, PA	484  Upper Darby, PA	610  Urbana, IL	217  Urbandale, IA	515  Utica, NY	315  Vacaville, CA	707  
Vail, CO	970  Valdosta, GA	229  Vallejo, CA	707  Van Nuys, CA	818  Vancouver, BC	604  Vancouver, WA	360  Vashon, WA	206  Venice, CA 	310	  Ventura, CA	805	  Vernon, TX	940  Vicksburg, MS	601  Victoria, BC	250  Victoria, TX	361  Vineland, NJ	856  Virginia Beach, VA	757  Visalia, CA 	559	  Vista, CA	760  W. Los Angeles, CA	562  
Waco, TX	254  Waipahu, HI	808  Walker, LA	225  Walla Walla, WA	509  Walnut Creek, CA	925  Waltham, MA	339  Waltham, MA	781  Warminster, PA	215  Warminster, PA	267  Warner Robins, GA	478  Warren, MI	810  Warren, OH	234  Warren, OH	330  Warrensburg, MO	660  Warwick, RI	401  Wasco, CA	661  Washington, DC	202  Washington, PA	724  Waterbury, CT	203  Waterloo, IA	319  Waterloo, ON	519  Watertown, NY	315  Watertown, SD	605  Watson Lake, YT	867  Watsonville, CA	831  Waukegan, IL	847  Waukesha, WI	262  Wausau, WI	715  Wellington, ON	613  West Babylon, NY	631  West Covina, CA	626  West Des Moines, IA	515  West Hollywood, CA	323  West Jordan, UT	801  West Medford, MA	339  West Memphis, AR	870  West New York, NJ	201  West Palm Beach, FL	561  Westerville, OH	614  Westfield, MA	413  Westfield, NJ	908  Westland, MI	734  Westminster, CA	714  Westminster, CO	303  Westminster, CO	720  Westmorland, CA	760  Weston, FL	954  Weymouth, MA	339  Weymouth, MA	781  Wheaton, IL	630  Wheeling, WV	304  White Plains, NY	914  Whitehorse, YT	867  Whittier, CA	562  Whittier, CA	626 
      

     
  Wichita Falls, TX	940  Wichita, KS	316  Wilkes Barre, PA	570  Williamsport, PA	570  Willingboro, NJ	609  Willits, CA 	707	  Willmar, MN	320  Willows, CA	530  Wilmington, CA	310  Wilmington, DE	302  Wilmington, NC	910  Wilson, NC	252  Winchester, MA	617  Windsor Mill, MD	410  Windsor Mill, MD	443  Windsor, ON	519  Winkler, MB	204  Winnipeg, MB	204  Winona, MN	507  Winston Salem, NC	336  Winter Haven, FL	863  Woodbridge, NJ	908  Woodland Hills, CA	818  Woodland, CA	530  Woodside, CA	650  Woonsocket, RI	401  Worcester, MA	508  Worcester, MA	774  Worthington, OH	614  Xenia, OH	937  Yakima, WA	509  Yellowknife, NT	867  
Yigo, GU	671  Yonkers, NY	914  Yosemite, CA	559  Youngstown, OH	234  Youngstown, OH	330  Yountville, CA	707  Yreka, CA	530  Yuba City, CA	530  Yukon, OK	405  
Yuma, AZ	520  Zachary, LA	225  Zanesville, OH	740         	`    @      
   	allcodes  !h           T         I201	NJ	Union City | West New York | Jersey City | Bayonne | North Bergen  202	DC	Washington  ?203	CT	New Haven | Bridgeport | Waterbury | Norwalk | Stamford  ;204	MB	Winkler | Thompson | Churchill | Brandon | Winnipeg  5205	AL	Fairfield | Tuscaloosa | Bessemer | Northport  I206	WA	Seattle | Silverlake | Vashon | Bainbridge Island | Mercer Island  7207	ME	Augusta | Portland | Auburn | Lewiston | Bangor  :208	ID	Pocatello | Idaho Falls | Boise | Nampa | Lewiston  4209	CA	Merced | Lodi | Stockton | Turlock | Modesto  D210	TX	San Antonio | Universal City | Gonzales | Converse | Schertz  212	NY	Manhattan | New York  213	CA	Los Angeles  @214	TX	Cockrell Hill | Highland Park | Dallas | University Park  C215	PA	Philadelphia | Abington | Levittown | Bensalem | Warminster  ?216	OH	Bedford | Cleveland | Euclid | Lakewood | Maple Heights  ;217	IL	Urbana | Quincy | Decatur | Champaign | Springfield  =218	MN	Hibbing | Brainerd | Fergus Falls | Moorhead | Duluth  ?219	IN	Hammond | Lake Station | Gary | Fort Wayne | South Bend  =225	LA	Baker | Prairieville | Zachary | Baton Rouge | Walker  @228	MS	Moss Point | Gulfport | Biloxi | Long Beach | Pascagoula  ;229	GA	Albany | Thomasville | Americus | Tifton | Valdosta  F231	MI	Grand Rapids | Traverse City | Grandville | Muskegon | Jenison  3234	OH	Akron | Warren | Kent | Canton | Youngstown  @240	MD	Silver Spring | Rockville | Bowie | Frederick | Bethesda  7248	MI	Detroit | Pontiac | Troy | Livonia | Southfield  
250	AK	Hyder  ;250	BC	Cranbrook | Kelowna | Victoria | Kamloops | Nanaimo  >252	NC	Rocky Mount | Kinston | Greenville | Wilson | Havelock  7253	WA	Tacoma | Federal Way | Auburn | Kent | Puyallup  >254	TX	Temple | Killeen | Copperas Cove | Stephenville | Waco  <256	AL	Gadsden | Decatur | Florence | Anniston | Huntsville  =262	WI	Kenosha | Brookfield | Racine | Waukesha | New Berlin  C267	PA	Philadelphia | Abington | Levittown | Bensalem | Warminster  F270	KY	Hopkinsville | Paducah | Henderson | Bowling Green | Owensboro  =281	TX	Spring | Baytown | Missouri City | Houston | Pasadena  @301	MD	Silver Spring | Rockville | Bowie | Frederick | Bethesda  7302	DE	Wilmington | Claymont | Dover | Felton | Newark  8303	CO	Denver | Westminster | Aurora | Boulder | Arvada  E304	WV	Huntington | Charleston | Wheeling | Parkersburg | Morgantown  B305	FL	Homestead | Hialeah | Miami | North Miami Beach | Key West  C306	SK	Humboldt | Fort Qu Appelle | Regina | Moose Jaw | Saskatoon  =307	WY	Casper | Rock Springs | Cheyenne | Laramie | Gillette  F308	NE	Grand Island | Kearney | Alliance | North Platte | Scottsbluff  <309	IL	Peoria | Moline | Bloomington | Rock Island | Normal  >310	CA	Torrance | Inglewood | Santa Monica | Compton | Carson  312	IL	Chicago  @313	MI	Detroit | Dearborn Heights | Dearborn | Taylor | Redford  ?314	MO	Saint Louis | Florissant | Bridgeton | Ballwin | Fenton  4315	NY	Utica | Rome | Auburn | Syracuse | Watertown  8316	KS	Newton | Mulvane | Augusta | Wichita | El Dorado  E317	IN	Indianapolis | Carmel | Beech Grove | Greenwood | Noblesville  @318	LA	Shreveport | Alexandria | Bossier City | Ruston | Monroe  F319	IA	Iowa City | Cedar Rapids | Cedar Falls | Waterloo | Burlington  >320	MN	Hutchinson | Alexandria | Willmar | Mora | Saint Cloud  D321	FL	Orlando | Palm Bay | Titusville | Melbourne | Merritt Island  P323	CA	Montebello | Los Angeles | Huntington Park | West Hollywood | South Gate  3330	OH	Akron | Warren | Kent | Canton | Youngstown  <334	AL	Dothan | Montgomery | Auburn | Phenix City | Opelika  I336	NC	Greensboro | Burlington | Mount Airy | High Point | Winston Salem  C337	LA	Lafayette | Opelousas | New Iberia | Sulphur | Lake Charles  <339	MA	Waltham | Malden | Medford | West Medford | Weymouth  F340	VI	Christiansted | Kingshill | St Thomas | St John | Frederiksted  =347	NY	Staten Island | Flushing | Jamaica | Brooklyn | Bronx  ;351	MA	Haverhill | Lawrence | Fitchburg | Lowell | Peabody  ;352	FL	Ocala | Lady Lake | Eustis | Gainesville | Leesburg  ;360	WA	Olympia | Bremerton | Kent | Vancouver | Bellingham  A361	TX	Corpus Christi | Beeville | Alice | Kingsville | Victoria  L386	FL	Ormond Beach | Edgewater | Daytona Beach | New Smyrna Beach | Deland  @401	RI	Pawtucket | Warwick | Woonsocket | Providence | Cranston  4402	NE	Omaha | Bellevue | Fremont | Blair | Lincoln  >403	AB	Red Deer | Banff | Lethbridge | Medicine Hat | Calgary  ?404	GA	Atlanta | Scottdale | Ellenwood | Forest Park | Decatur  <405	OK	Oklahoma City | Edmond | Norman | Stillwater | Yukon  :406	MT	Billings | Helena | Butte | Missoula | Great Falls  M407	FL	Kissimmee | Orlando | Altamonte Springs | Titusville | Merritt Island  A408	CA	Cupertino | Milpitas | Santa Clara | Sunnyvale | San Jose  C409	TX	Beaumont | Texas City | Galveston | College Station | Bryan  I410	MD	Baltimore | Nottingham | Columbia | Sparrows Point | Windsor Mill  I412	PA	Mc Keesport | Pittsburgh | Monroeville | Coraopolis | Bethel Park  A413	MA	Chicopee | Westfield | Holyoke | Springfield | Pittsfield  C414	WI	South Milwaukee | Milwaukee | Cudahy | Oak Creek | Franklin  G415	CA	San Francisco | Novato | Mill Valley | San Rafael | San Anselmo  416	ON	Toronto  8417	MO	Springfield | Carthage | Nixa | Joplin | Lebanon  Q418	QC	Riviere Du Loup | Levis | St Georges De Beauce | Quebec City | Chicoutimi  6419	OH	Lima | Findlay | Sandusky | Toledo | Mansfield  D423	TN	Cleveland | Bristol | Kingsport | Chattanooga | Johnson City  8425	WA	Kirkland | Everett | Bellevue | Redmond | Renton  A435	UT	Saint George | Brigham City | Logan | Cedar City | Tooele  5440	OH	Lorain | Mentor | Elyria | Cleveland | Euclid  I443	MD	Baltimore | Nottingham | Columbia | Sparrows Point | Windsor Mill  L450	QC	St Catherine | Mirabel | Chateauguay | St Marc Sur Richelieu | Laval  4469	TX	Plano | Garland | Mesquite | Irving | Dallas  >478	GA	Macon | Perry | Warner Robins | Dublin | Milledgeville  6480	AZ	Mesa | Scottsdale | Chandler | Tempe | Phoenix  ?484	PA	Bethlehem | Reading | Allentown | Upper Darby | Chester  _501	AR	Fayetteville | Fort Smith | Hot Springs National Park | Little Rock | North Little Rock  D502	KY	Louisville | Shelbyville | Georgetown | Fairdale | Frankfort  8503	OR	Portland | Salem | Beaverton | Gresham | Astoria  =504	LA	New Orleans | Kenner | Chalmette | Metairie | Marrero  B505	NM	Albuquerque | Rio Rancho | Las Cruces | Santa Fe | Roswell  E506	NB	Saint John | Fredericton | Bathurst | Campbellton | Miramichi  9507	MN	Mankato | Rochester | Faribault | Winona | Austin  D508	MA	Brockton | Framingham | Worcester | Fall River | New Bedford  =509	WA	Spokane | Yakima | Kennewick | Walla Walla | Richland  9510	CA	Richmond | Hayward | Oakland | Berkeley | Fremont  >512	TX	Austin | San Marcos | Round Rock | Taylor | Georgetown  ?513	OH	Cincinnati | Hamilton | Fairfield | Oxford | Middletown  F514	QC	Ile Perrot | Lachine | Montreal | Pointe Claire | St Genevieve  D515	IA	Fort Dodge | Ames | West Des Moines | Urbandale | Des Moines  E516	NY	Oyster Bay | Hempstead | Hicksville | Farmingdale | Levittown  8517	MI	Lansing | Jackson | East Lansing | Holt | Adrian  ?518	NY	Troy | Queensbury | Clifton Park | Schenectady | Albany  ;519	ON	Windsor | Kitchener | London | Waterloo | Stratford  R520	AZ	Nogales | Tucson | Casa Grande | Sierra Vista | Phoenix | Flagstaff | Yuma  6530	CA	Redding | Yuba City | Davis | Chico | Woodland  >540	VA	Harrisonburg | Roanoke | Blacksburg | Stafford | Salem  ;541	OR	Medford | Springfield | Corvallis | Eugene | Albany  7559	CA	Clovis | Fresno | Tulare | Madera | Porterville  V561	FL	Boca Raton | Delray Beach | West Palm Beach | Boynton Beach | Port Saint Lucie  ;562	CA	Norwalk | Downey | Long Beach | Lakewood | Whittier  >563	IA	Dubuque | Davenport | Bettendorf | Clinton | Muscatine  E570	PA	Scranton | Camp Hill | Williamsport | Wilkes Barre | Hazleton  >571	VA	Alexandria | Fort Myer | Burke | Annandale | Arlington  H573	MO	Hannibal | Sikeston | Cape Girardeau | Jefferson City | Columbia  5580	OK	Lawton | Duncan | Enid | Ponca City | Ardmore  >601	MS	Jackson | Hattiesburg | Clinton | Meridian | Vicksburg  602	AZ	Phoenix  5603	NH	Manchester | Dover | Concord | Nashua | Derry  H604	BC	Vancouver | Newton | Port Coquitlam | Richmond | New Westminster  C605	SD	Brookings | Rapid City | Aberdeen | Sioux Falls | Watertown  ?606	KY	Ashland | Flatwoods | Middlesboro | Morehead | Somerset  >607	NY	Elmira | Johnson City | Ithaca | Syracuse | Binghamton  ?608	WI	Sun Prairie | La Crosse | Janesville | Madison | Beloit  K609	NJ	Trenton | Willingboro | Mount Holly | Pleasantville | Atlantic City  ?610	PA	Bethlehem | Reading | Allentown | Upper Darby | Chester  612	MN	Minneapolis  3613	ON	Belleville | Ottawa | Wellington | Cornwall  H614	OH	Westerville | Columbus | Worthington | Grove City | Reynoldsburg  G615	TN	Nashville | Murfreesboro | Gallatin | Hendersonville | Franklin  C616	MI	Grand Rapids | Battle Creek | Portage | Kalamazoo | Jenison  9617	MA	Boston | Cambridge | Quincy | Dorchester | Newton  I618	IL	Belleville | Alton | East Saint Louis | Carbondale | Granite City  J619	CA	National City | San Diego | Chula Vista | Spring Valley | El Cajon  C620	KS	Dodge City | Garden City | Emporia | Hutchinson | Pittsburg  >623	AZ	Sun City | Sun City West | Peoria | Glendale | Phoenix  C626	CA	Alhambra | Baldwin Park | Pasadena | El Monte | West Covina  @630	IL	Aurora | Naperville | Downers Grove | Wheaton | Elmhurst  S631	NY	West Babylon | Central Islip | Farmingdale | Huntington Station | Brentwood  F636	MO	Saint Charles | Chesterfield | Saint Peters | Ballwin | Fenton  ?641	IA	Oskaloosa | Ottumwa | Fairfield | Newton | Marshalltown  646	NY	Manhattan | New York  647	ON	Toronto  R650	CA	Redwood City | South San Francisco | San Mateo | Daly City | Mountain View  V651	MN	Saint Paul | South Saint Paul | Hastings | Inver Grove Heights | Cottage Grove  ?660	MO	Sedalia | Kirksville | Moberly | Marshall | Warrensburg  K661	CA	Palmdale | Santa Clarita | Bakersfield | Lancaster | Canyon Country  ?662	MS	Greenville | Tupelo | Clarksdale | Greenwood | Columbus  6671	GU	Dededo | Yigo | Barrigada | Hagatna | Tamuning  :678	GA	Smyrna | Atlanta | Marietta | Roswell | Porterdale  H682	TX	Fort Worth | Arlington | Bedford | Euless | North Richland Hills  :701	ND	Minot | Bismarck | Grand Forks | Dickinson | Fargo  I702	NV	Boulder City | Henderson | Laughlin | Las Vegas | North Las Vegas  >703	VA	Alexandria | Fort Myer | Burke | Annandale | Arlington  ?704	NC	Charlotte | Concord | Gastonia | Salisbury | Kannapolis  E705	ON	North Bay | Sault Ste Marie | Barrie | Peterborough | Sudbury  5706	GA	Augusta | Columbus | Lagrange | Athens | Rome  ;707	CA	Vallejo | Santa Rosa | Fairfield | Napa | Vacaville  ;708	IL	Cicero | Oak Lawn | Berwyn | Orland Park | Oak Park  P709	NF	St Johns | Corner Brook | Grand Falls | Labrador City-wabush | Marystown  D712	IA	Storm Lake | Spencer | Carroll | Council Bluffs | Sioux City  >713	TX	South Houston | Bellaire | Houston | Pasadena | Humble  I714	CA	Huntington Beach | Santa Ana | Garden Grove | Fullerton | Anaheim  C715	WI	Superior | Eau Claire | Wausau | Marshfield | Stevens Point  D716	NY	Rochester | Cheektowaga | Niagara Falls | Fairport | Buffalo  C717	PA	Lancaster | Carlisle | Lebanon | Mechanicsburg | Harrisburg  =718	NY	Staten Island | Flushing | Jamaica | Brooklyn | Bronx  B719	CO	Salida | Fountain | Pueblo | Colorado Springs | Canon City  8720	CO	Denver | Westminster | Aurora | Boulder | Arvada  D724	PA	Greensburg | Aliquippa | New Kensington | Irwin | Washington  I727	FL	Bay Pines | Clearwater | Largo | Saint Petersburg | Pinellas Park  B731	TN	Jackson | Brownsville | Union City | Lexington | Dyersburg  ;732	NJ	Edison | Brick | Piscataway | Lakewood | Toms River  <734	MI	Ann Arbor | Grosse Ile | Canton | Livonia | Westland  ;740	OH	Marion | Newark | Zanesville | Lancaster | Delaware  F757	VA	Hampton | Newport News | Norfolk | Virginia Beach | Chesapeake  ;760	CA	Oceanside | Escondido | Hesperia | Carlsbad | Vista  :763	MN	Champlin | Elk River | Princeton | Andover | Anoka  9765	IN	Muncie | Kokomo | Lafayette | Richmond | Anderson  :770	GA	Smyrna | Atlanta | Marietta | Roswell | Porterdale  773	IL	Chicago  D774	MA	Brockton | Framingham | Worcester | Fall River | New Bedford  7775	NV	Carson City | Reno | Elko | Sparks | Sun Valley  N780	AB	Edmonton | Jasper | Fort Saskatchewan | Sherwood Park | Grande Prairie  9781	MA	Waltham | Arlington | Malden | Medford | Weymouth  >785	KS	Topeka | Salina | Junction City | Lawrence | Manhattan  C786	FL	Homestead | Hialeah | Miami | North Miami Beach | Opa Locka  6787	PR	Carolina | San Juan | Ponce | Bayamon | Caguas  ;801	UT	Sandy | Salt Lake City | West Jordan | Provo | Orem  B802	VT	Rutland | Essex Junction | Bennington | Barre | Burlington  =803	SC	Columbia | Aiken | Rock Hill | Sumter | North Augusta  H804	VA	Richmond | Petersburg | Mechanicsville | Hopewell | Chesterfield  F805	CA	Thousand Oaks | Simi Valley | Ventura | Santa Barbara | Oxnard  7806	TX	Amarillo | Plainview | Lubbock | Borger | Pampa  >807	ON	Fort Frances | Thunder Bay | Kenora | Nipigon | Dryden  4808	HI	Honolulu | Hilo | Waipahu | Kailua | Kaneohe  F810	MI	Flint | Detroit | Warren | Clinton Township | Sterling Heights  F812	IN	Columbus | Evansville | New Albany | Bloomington | Terre Haute  =813	FL	Brandon | Lutz | Plant City | Sun City Center | Tampa  D814	PA	Meadville | University Park | Altoona | State College | Erie  8815	IL	Dekalb | Rockford | Freeport | Joliet | Kankakee  K816	MO	Kansas City | Grandview | Saint Joseph | Independence | Lees Summit  H817	TX	Fort Worth | Arlington | Bedford | Euless | North Richland Hills  @818	CA	Reseda | Glendale | Burbank | Van Nuys | North Hollywood  G819	QC	Hull | Arthabaska | Trois Rivieres | Sherbrooke | Drummondville  8828	NC	Asheville | Hickory | Lenoir | Morganton | Boone  A830	TX	Eagle Pass | Del Rio | Kerrville | New Braunfels | Seguin  ?831	CA	Monterey | Seaside | Watsonville | Salinas | Santa Cruz  =832	TX	Spring | Baytown | Missouri City | Houston | Pasadena  K843	SC	Charleston | Mount Pleasant | Myrtle Beach | Florence | Goose Creek  E845	NY	Middletown | Eastchester | Poughkeepsie | Newburgh | New City  D847	IL	Waukegan | Schaumburg | Elgin | Evanston | Arlington Heights  M850	FL	Pensacola | Tallahassee | Panama City | Crestview | Fort Walton Beach  ?856	NJ	Vineland | Camden | Cherry Hill | Clementon | Bridgeton  9857	MA	Boston | Cambridge | Quincy | Dorchester | Newton  C858	CA	Poway | Rancho Santa Fe | La Jolla | Del Mar | Solana Beach  =859	KY	Florence | Newport | Covington | Richmond | Lexington  B860	CT	Manchester | Hartford | New Britain | W Hartford | Bristol  C863	FL	Lake Wales | Haines City | Bartow | Winter Haven | Lakeland  @864	SC	Greenville | Greenwood | Spartanburg | Anderson | Easley  A865	TN	Clinton | Sevierville | Maryville | Knoxville | Oak Ridge  0867	NT	Baffin Island | Yellowknife | Fort Smith  +867	NU	Rankin Inlet | Iqaluit | Baker Lake  6867	YT	Dawson | Watson Lake | Whitehorse | Whitehorse  G870	AR	Pine Bluff | West Memphis | Blytheville | El Dorado | Jonesboro  ?901	TN	Germantown | Memphis | Jackson | Millington | Dyersburg  6902	NS	Sydney | Bedford | Halifax | Truro | Dartmouth  902	PE	Charlottetown  ;903	TX	Longview | Texarkana | Tyler | Sherman | Greenville  )904	FL	Jacksonville | Jacksonville Beach  5905	ON	Cobourg | Hamilton | Brampton | Niagara Falls  M906	MI	Iron Mountain | Marquette | Sault Sainte Marie | Escanaba | Menominee  9907	AK	Fairbanks | Anchorage | Kenai | Soldotna | Juneau  ;908	NJ	Plainfield | Westfield | Union | Linden | Elizabeth  O909	CA	Riverside | San Bernardino | Ontario | Moreno Valley | Rancho Cucamonga  I910	NC	Wilmington | Jacksonville | Fort Bragg | Fayetteville | Lumberton  912	GA	Savannah  G913	KS	Olathe | Kansas City | Shawnee Mission | Leavenworth | Atchison  G914	NY	Mount Vernon | White Plains | Yonkers | New City | New Rochelle  9915	TX	El Paso | Midland | San Angelo | Odessa | Abilene  M916	CA	Citrus Heights | Rancho Cordova | Sacramento | Carmichael | Roseville  :917	NY	Manhattan | Flushing | Brooklyn | New York | Bronx  @918	OK	Broken Arrow | Tulsa | Sapulpa | Bartlesville | Muskogee  9919	NC	Raleigh | Goldsboro | Cary | Durham | Chapel Hill  @920	WI	Oshkosh | Fond du Lac | Appleton | Green Bay | Sheboygan  A925	CA	Pleasanton | Livermore | Walnut Creek | Concord | Antioch  C931	TN	Cookeville | Nashville | Clarksville | Knoxville | Columbia  ;936	TX	Center | Huntsville | Lufkin | Nacogdoches | Conroe  7937	OH	Dayton | Springfield | Xenia | Piqua | Fairborn  E940	TX	Vernon | Wichita Falls | Mineral Wells | Denton | Gainesville  G941	FL	Sarasota | Fort Myers | Bradenton | Port Charlotte | Cape Coral  K949	CA	Irvine | Laguna Niguel | Costa Mesa | Mission Viejo | Newport Beach  D952	MN	Hopkins | Minnetonka | Burnsville | Eden Prairie | Lakeville  N954	FL	Weston | Hollywood | Fort Lauderdale | Pompano Beach | Deerfield Beach  :956	TX	Pharr | Harlingen | McAllen | Brownsville | Laredo  D970	CO	Greeley | Loveland | Fort Collins | Grand Junction | Durango  :971	OR	Portland | Salem | Beaverton | Hillsboro | Gresham  4972	TX	Plano | Garland | Mesquite | Irving | Dallas  =973	NJ	Passaic | East Orange | Paterson | Irvington | Newark  ;978	MA	Haverhill | Lawrence | Fitchburg | Lowell | Peabody  D979	TX	Bay City | Angleton | Lake Jackson | College Station | Bryan  ?980	NC	Charlotte | Concord | Gastonia | Salisbury | Kannapolis  8985	LA	Hammond | Slidell | Covington | Houma | La Place  @989	MI	Midland | Harrison | Bay City | Mount Pleasant | Saginaw                 	`    @  	  R 
   label2           H              Major cities in this area code. 
   
instruction2                        ,Or find a city starting with the letters...    Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "cHelp" into helpStack
  goHelp "Area Code Locator", helpStack, zStack
end mouseUp
    	Lavender     H             	     
   code  )x   on enterInField
  send mouseUp to button "search"
end enterInField

on returnInField
  send mouseUp to button "search"
end returnInField
         2 B           
   jump  )x  on enterInField
  findcity
end enterInField

on returnInField
  findcity
end returnInField

on keyUp
  findcity
end keyUp

on deleteKey
  findcity
end deleteKey

on findcity
  put me into searchstring
  put lineOffset(return & searchstring, field "cityList") into zline
  set the scroll of field "cityList" to zline * the effective textHeight of field "cityList"

  if zline is 0 and me is not empty then
    beep 1
    delete last char of me
    keyUp
  end if
end findcity
          *              New Button Ep?on mouseUp
  put 0 into cacount
  repeat with i = the number of lines of field "zlist" down to 1
    if item 2 of line i  of field "zlist" contains "CA" then add 1 to cacount
    if line i  of field "zlist" is empty then delete line i  of field "zlist"
    if first char of item 2 of line i  of field "zlist" is not space then
      put space before item 2 of line i  of field "zlist"
    end if
    put line i  of field "zlist" into temp
    put item 1 to 2 of temp & tab & item 3 of temp into line i  of field "zlist"
    put i
  end repeat
  put i && cacount
end mouseUp
    	Lavender    t d              	      