#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                  calculator  S-- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered,gStack,gPrevCard
  put "calculator" into gStack
  if the short name of this stack <> gStack then exit openStack
  if gRegistered is empty then
    open stack "launcher"
  else
    lock screen
    if gPrevCard is not empty then
      go card gPrevCard
    else
      go last card
    end if
    unlock screen with visual plain
  end if
end openStack

on closeStack
  set cursor to watch
  save this stack
end closeStack

on arrowKey
  --trap
end arrowKey

function stripCommas znumb
  repeat while offset(",",znumb)>0
    delete char offset(",",znumb) of znumb
  end repeat
  return znumb
end stripCommas

function setNumFormat znumb -- to limit length of measurement numbers to 9 chars
  put offset(".",znumb) into decplace
  if decPlace = 0 then return setNumber(znumb,1)
  repeat with i = 9 down to 1
    if decplace > i then
      delete char (decplace + 9 - i) to length(znumb) of znumb
      return setNumber(znumb,1)
    end if
  end repeat
end setNumFormat
  w         dd CornflowerBlue    white        
       ^ Universal Calculator      U 
Helvetica   U 
Helvetica   W 
Helvetica   U 
Helvetica   U Arial   W 
Helvetica   W 
Helvetica   W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U Arial Black   U Arial Black   U Andale Mono   U Arial   U Andale Mono 8records,atmain.mc
taskTracker,tasks.mc
passwords,password.mc
launcher,itmain.mc
launcher,sbdmain.mc
launcher,aetmain.mc
launcher,sbmain.mc
writer,whelper.mc
versions,version.mc
vehicleExp,vehexp.mc
invoiceTracker,invoice.mc
inventory,inventry.mc
scheduler,schedule.mc
contacts,contact.mc
calculator,calculat.mc
    numbers   	P9on openCard
  set the height of button "=" to the height of button "clear"
  set the width of button "=" to the width of button "clear"
end openCard

on keyDown which
  switch which
  case "+"
    computeNumber which
    break
  case "-"
    computeNumber which
    break
  case "/"
    computeNumber which
    break
  case "x"
    computeNumber which
    break
  case "*"
    computeNumber which
    break
  case "="
    computeNumber which
    break
  case "."
    if offset(".", field "number") = 0 then
      put which after field "number"
    end if
    break
  default
    if which is a number then
      put which after field "number"
    end if
  end switch
  pass keyDown
end keyDown

on computeNumber zsymbol
  global gSubTotal,gNegNum,gOperatorPending
  
  if gOperatorPending is not empty then -- not working yet
    put gOperatorPending into zsymbol
    put empty into gOperatorPending
  end if
  
  put length(field "tape") -1 into zChar
  if zsymbol = "=" AND char zChar of field "tape" is "^" then exit computeNumber
  
  put field "places" into n
  put "0." into temp
  repeat with i = 1 to n
    put "#" after temp
  end repeat
  set the numberFormat to temp
  
  put 0 into zLine
  put field "number" into zNum
  if zNum is empty or zNum is not a number then
    if field "tape" is empty or last line of field "tape" is empty then --or gSubTotal is empty then --**
      put "0" && zsymbol & return after field "tape"
      put 0 into gSubTotal
    else
      put  zsymbol  into word 2 of last line of field "tape"
      if word 1 of last line of field "tape" is a number then
        put field "sub total" into temp
        repeat with i = 1 to length(temp)
          if char i of temp is comma then
            delete char i of temp
          end if
        end repeat
        put temp into gSubTotal
      else
        put 0 into gSubTotal
      end if
    end if
  else -- field number <> empty
    if field "tape" is empty or gSubTotal is empty then
      put zNum into gSubTotal
      put zNum into field "sub total"
      put zNum && zSymbol & return after field "tape"
    else
      put the number of lines of field "tape" into zLine
      put zNum && zSymbol & return after field "tape"
    end if
  end if
  
  if zLine > 0 then
    put word 2 of line zLine of field "tape" into operator
    switch operator
    case "+"
      add zNum to gSubTotal
      break
    case "-"
      subtract zNum from gSubTotal
      break
    case "x"
      put gSubTotal * zNum into gSubTotal
      break
    case "*"
      put gSubTotal * zNum into gSubTotal
      break
    case "/"
      if zNum = 0 then
        answer warning "Can't divide by 0."
        put 0 into gSubTotal
      else
        put gSubTotal / zNum into gSubTotal
      end if
      break
    end switch
  end if
  
  put gSubTotal into temp
  put length(temp) into subl
  put offset(".",temp) into decPlace
  if decPlace > 0 then
    put char decPlace to subl of temp into decTemp -- decimal portion of gSubTotal
    delete char decPlace to subl of temp
    subtract (subl - decPlace + 1) from subl
  end if
  
  repeat forever -- add commas to temp for display
    if char 1 of temp is "-" then subtract 1 from subl
    if subl <= 3 then
      put temp before subTotal
      exit repeat
    else
      if char 1 of temp is "-" then add 1 to subl
      put comma & char (subl - 2) to subl of temp before subTotal
      delete char (subl - 2) to subl of temp
      subtract 3 from subl
    end if
  end repeat
  
  if decPlace > 0 then
    put subTotal & decTemp into field "sub total"
  else
    put subTotal into field "sub total"
  end if
  if zsymbol is "=" then
    put gSubTotal && "^" & return after field "tape"
    put empty into gSubTotal
  end if
  put empty into field "number"
  set the scroll of field "tape" to (the formattedHeight of field "tape" - the height of field "tape")
end computeNumber
                                                                        M   Dates   	Pfunction daysofmonth zmonth, zyear
  put "1,3,5,7,8,10,12" into longMonth
  repeat with i = 1 to the number of items of longMonth
    if item i of longMonth is zmonth then
      return 31
    end if
  end repeat
  if zmonth = 2 then -- Feb
    if zyear/4 = trunc(zyear/4) then
      return 29
    else
      return 28
    end if
  else -- all other months
    return 30
  end if
end daysofmonth

on checkDate zField
  
  if field zfield is empty then
    put the long date into temp
  else
    put field zfield into temp
  end if
  
  convert temp to short date
  ask "Enter a Date" with temp
  if it is empty then exit checkDate
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit checkDate
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit checkDate
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit checkDate
      end if
    end if
  end if
  put it into temp
  
  convert temp to dateitems
  put the date into temp2
  convert temp2 to dateitems
  put item 1 of temp2 into zyear
  if offset("/",temp) > 0 then
    set itemDelimiter to "/"
    put zyear into item 3 of temp
    convert temp to long date
    put temp into field "date"
    convert temp to dateitems
    set itemDelimiter to comma
  end if
  convert temp to long date
  put temp into field zfield
end checkDate
               [  \  ]  ^  _  `  a  c  b  f  g  h  n  o                                       Length   	P
on computeLength which
  ask "Enter the number of " & which with field which
  if it is empty then exit to metacard
  if it is a number then
    put it into temp
  else
    answer "You must enter numbers only."
    exit to metacard
  end if
  -- first convert to meters
  switch which
  case "inches"
    put temp * .0254 into meters
    put temp / 12 into zfeet
    break
  case "feet"
    put temp * .3048 into meters
    put temp * 1 into zfeet
    break
  case "miles"
    put temp * 1609.3 into meters
    put temp * 5280 into zfeet
    break
  case "cm"
    put temp * .01 into meters
    put meters * 3.2808 into zfeet
    break
  case "meters"
    put temp * 1 into meters
    put meters * 3.2808 into zfeet
    break
  case "km"
    put temp * 1000 into meters
    put meters * 3.2808 into zfeet
    break
  end switch
  
  set numberFormat to 0.##########
  put setNumFormat(meters * 100) into field "cm"
  put setNumFormat(zfeet * 12) into field "inches"
  
  put setNumFormat(meters * 1) into field "meters"
  put setNumFormat(zfeet) into field "feet"
  
  put setNumFormat(zfeet / 5280) into field "miles"
  put setNumFormat(meters * .001) into field "km"
  
  put setNumFormat(temp) into field which
end computeLength

on computeVolume which
  if which is "ozv" then
    ask "Enter the number of oz" with field which
  else
    ask "Enter the number of " & which with field which
  end if
  if it is empty then exit to metacard
  if it is a number then
    put it into temp
  else
    answer "You must enter numbers only."
    exit to metacard
  end if
  -- first convert to liters
  switch which
  case "ozv"
    put temp * .9463 / 32 into liters
    put temp / 32 into zquart
    break
  case "quarts"
    put temp * .9463 into liters
    put temp into zquart
    break
  case "gals"
    put temp * .9463 * 4 into liters
    put temp * 4 into zquart
    break
  case "ml"
    put temp * .001 into liters
    put (liters * 1.0567) into zquart
    break
  case "liters"
    put temp * 1 into liters
    put (liters * 1.0567) into zquart
    break
  case "kl"
    put temp * 1000 into liters
    put (liters * 1.0567) into zquart
    break
  end switch
  
  set numberFormat to 0.##########
  put setNumFormat(liters * 1000) into field "ml"
  put setNumFormat(zquart * 32) into field "ozv"
  
  put setNumFormat(liters * 1) into field "liters"
  put setNumFormat(zquart) into field "quarts"
  
  put setNumFormat(zquart * .25) into field "gals"
  put setNumFormat(liters * .001) into field "kl"
  
  put setNumFormat(temp) into field which
end computeVolume

on computeWeight which
  if which is "ozw" then
    ask "Enter the number of oz" with field which
  else
    ask "Enter the number of " & which with field which
  end if
  if it is empty then exit to metacard
  if it is a number then
    put it into temp
  else
    answer "You must enter numbers only."
    exit to metacard
  end if
  -- first convert to kg
  switch which
  case "ozw"
    put temp * 28.3495 * .001 into kg
    put temp / 16 into zlbs
    break
  case "lbs"
    put temp * .4536 into kg
    put temp into zlbs
    break
  case "tons"
    put temp * .9072 * 1000 into kg
    put temp * 2000 into zlbs
    break
  case "g"
    put temp * .001 into kg
    put kg * 2.2046 into zlbs
    break
  case "kg"
    put temp * 1 into kg
    put kg * 2.2046 into zlbs
    break
  case "mton"
    put temp * 1000 into kg
    put kg * 2.2046 into zlbs
    break
  end switch
  
  set numberFormat to 0.##########
  put setNumFormat(kg * 1000) into field "g"
  put setNumFormat(zlbs * 16) into field "ozw"
  
  put setNumFormat(kg * 1) into field "kg"
  put setNumFormat(zlbs) into field "lbs"
  
  put setNumFormat(zlbs * .0005) into field "tons"
  put setNumFormat(kg * .001) into field "mton"
  
  put setNumFormat(temp) into field which
end computeWeight
                                              !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @     Time   	PVon computeTime
  put field "time" into ltime
  if ltime is empty then
    put the time into ltime
    put the time into field "time"
  end if
  put field "dcity" into dcity -- destination
  put field "ocity" into ocity -- origin
  if ocity is empty then
    answer "Choose a city from the list on the left."
    exit computeTime
  end if
  if dcity is empty then
    answer "Choose a city from the list on the right."
    exit computeTime
  end if
  convert ltime to dateitems
  put item 4 of ltime into zhour
  put item 5 of ltime into zmins
  
  set itemdelimiter to tab
  put item 2 of field "dcity" into dadjust
  put item 2 of field "ocity" into oadjust
  put char 1 to 2 of dadjust into dhrs
  put char 4 to 5 of dadjust into dmins
  put char 1 to 2 of oadjust into ohrs
  put char 4 to 5 of oadjust into omins
  set itemdelimiter to comma
  
  if the hilite of button "ddst" then add 1 to dhrs
  if the hilite of button "odst" then add 1 to ohrs
  put dhrs - ohrs + zhour  into dhour
--  put dhrs && ohrs && zhour  && dhour --**
  add omins to zmins
  if zmins > 60 then
    subtract 60 from zmins
    add 1 to dhour
  end if
  if dhour < 0 then -- yesterday
    set the hilite of button "yesterday" to true
    set the hilite of button "today" to false
    set the hilite of button "tomorrow" to false
    add 24 to dhour
  else
    if dhour >= 24 then -- tomorrow
      set the hilite of button "tomorrow" to true
      set the hilite of button "yesterday" to false
      set the hilite of button "today" to false
      subtract 24 from dhour
    else -- today
      set the hilite of button "today" to true
      set the hilite of button "yesterday" to false
      set the hilite of button "tomorrow" to false
    end if
  end if
  put dhour into item 4 of ltime
  put zmins into item 5 of ltime
  convert ltime to time
  put ltime into field "dtime"
end computeTime
                                                        	Currency   	PBon openCard
  global gDollarSign
  put gDollarSign && "Amount" into field "dollarsLabel"
end openCard

on computeDiscount
  set the numberFormat  to 0.00
  put stripCommas(field "pamount") into znumber
  if zNumber is empty then exit computeDiscount
  if zNumber < 0 then
    answer "Negative numbers not allowed."
    exit computeDiscount
  end if
  if the label of button "discount" is not a number then set the label of button "discount" to 0
  if the label of button "salesTax" is not a number then set the label of button "salesTax" to 0
  
  if not the hilite of button "set discount" then
    put zNumber * the label of button "discount" into zdiscount
    put setNumber(zdiscount) into field "discount"
  end if
  put znumber - stripCommas(field "discount") into zsubTotal
  put setNumber(zsubTotal) into field "subTotal"
  if NOT the hilite of button "tax" then
    put zNumber * the label of  button "salesTax" into zsalesTax
    put setNumber(zsalesTax) into field "salesTax"
  else
    put the label of button "salesTax" * zsubTotal into zsalesTax
    put setNumber(zsalesTax) into field "salesTax"
  end if
  put setNumber(zsalesTax +  zsubTotal) into field "result"
end computeDiscount

on computeMoney which
  global gDollarSign
  if gDollarSign is "$" then put "dollar" into lc
  else put gDollarSign into lc
  -- set numberFormat to 0.00 ####
  if which is "exchange" then
    ask "Enter the exchange rate per " & lc with field which
    if it is empty then exit to metacard
    put stripCommas(it) into temp
    if temp < 0 then
      answer "Negative numbers not allowed."
      exit computeMoney
    end if
    if temp is a number then
      put it into field "exchange"
      if field "dollars" is empty AND field "amount" is empty then
        exit to metaCard
      end if
    else
      answer "You must enter numbers only."
      exit to metacard
    end if
    
    if field "amount" is empty then
      put setNumber(temp * stripCommas(field "dollars")) into field "amount"
    else
      answer "Change " & lc & "s or other currency amount?" with (lc & "s") or "Other Currency Amount"
      if it is "Other Currency Amount" then
        put setNumber(temp * stripCommas(field "dollars")) into field "amount"
      else
        put setNumber(stripCommas(field "amount") / temp) into field "dollars"
      end if
    end if
  end if
  
  if which is "dollars" then
    ask "Enter the number of " & lc & "s" with field which
    if it is empty then exit to metacard
    put stripCommas(it) into temp
    if temp < 0 then
      answer "Negative numbers not allowed."
      exit computeMoney
    end if
    if temp is a number then
      put setNumber(temp) into field "dollars"
      if field "exchange" is empty  then
        exit to metaCard
      else
        put setNumber(temp * stripCommas(field "exchange")) into field "amount"
      end if
    else
      answer "You must enter numbers only."
      exit to metacard
    end if
  end if
  
  if which is "amount" then
    set the numberformat to 0.00
    ask "Enter the amount of currency to convert to " & lc & "s" with field which
    if it is empty then exit to metacard
    put stripCommas(it) into temp
    if temp < 0 then
      answer "Negative numbers not allowed."
      exit computeMoney
    end if
    if temp is a number then
      put setNumber(temp) into field "amount"
      if field "exchange" is empty  then
        exit to metaCard
      else
        put setNumber(temp / stripCommas(field "exchange")) into field "dollars"
      end if
    else
      answer "You must enter numbers only."
      exit to metacard
    end if
  end if
end computeMoney
                 A  B  C  D  I  E  F  G  H  J  K  L  p  q  r      x      w  z        s    y           bg   i         
   bgfield  	`               	 P                                  Quit ex   (on mouseUp
  quitSBTracker
end mouseUp
      cyan   q I      Quit         	       	 Save Ex   @on mouseUp
  set cursor to watch
  save this stack
end mouseUp
      cyan   Vq I             	       
 	Register Ex   5on mouseUp
      topLevel "UC Register"
end mouseUp
      cyan    rs X             	        Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
      cyan    
q I             	        Numbers @Ex   7on mouseUp
  go card the short name of me
end mouseUp
      cyan      H              	        Dates @Ex   7on mouseUp
  go card the short name of me
end mouseUp
      cyan    \  <              	        Times @Ex   )on mouseUp
  go card "time"
end mouseUp
      cyan      <              	        Length @ex   7on mouseUp
  go card the short name of me
end mouseUp
      cyan      f      Measurement          	        	Currency @Ex   7on mouseUp
  go card the short name of me
end mouseUp
      cyan   I  L              	        Help Ex  on mouseUp
  lock screen
  get the loc of this stack
  put the short name of this card into whichCard
  switch whichCard
  case "numbers"
    put "About the Number calculator" into whichCard
    break
  case "dates"
    put "About the Date calculator" into whichCard
    break
  case "time"
    put "About the Time calculator" into whichCard
    break
  case "length"
    put "About the LVW calculator" into whichCard
    break
  case "currency"
    put "About the currency calculator" into whichCard
    break
  end switch
  put the short name of this stack into zStack
  put "ucHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  go card whichCard of stack HelpStack
  topLevel HelpStack
  unlock screen with visual plain
end mouseUp
      cyan    q I             	        Print Ex  on mouseUp
  if (the platform contains "Mac") and the number of this card is 1 then
    answer "Printing not supported for numbers calculator."
    exit to metaCard
  end if
  if (the platform contains "Mac") or (the platform contains "Win") then
    answer printer
    if the result is "Cancel" then
      exit to metaCard
    end if
  else
    answer "Printing not supported"
    exit to metaCard
  end if
  lock screen
  if the number of this card > 1 then
    hide group "bg"
    repeat with i = 1 to the number of buttons
      if the short name of button i = "help" then hide button i
      if the short name of button i contains "reset" then hide button i
    end repeat
    put the backgroundcolor of this stack into temp
    set the backgroundcolor of this stack to white
    print this card
    close printing
    set the backgroundcolor of this stack to temp
    show group "bg"
    repeat with i = 1 to the number of buttons
      if the short name of button i = "help" then show button i
      if the short name of button i contains "reset" then show button i
    end repeat
  else
    insert the script of button "PrintField" of stack "Launcher" into back
    put last line of field "tape" into temp
    put field "sub total" into last line of field "tape"
    printfield empty,field "tape",empty,"tape"
    put temp into last line of field "tape"
    remove the script of button "PrintField" of stack "Launcher" from back
  end if
  unlock screen with visual plain
end mouseUp
      cyan    ]q I             	        
Main Menu }   Oon menuPick which
  set cursor to watch
  goSBTrackerStack which
end menuPick
      cyan    	       Small Business Tracker Menu   Activity && Expense Tracker
Contact Tracker - Address Book
Schedule Tracker - Calendar
Task Tracker - To Do List
-
Inventory Tracker
Invoice Tracker
Password Tracker
Vehicle Expense Tracker
-
(Universal Calculator
Version Tracker
Writer's Helper
Small Business Tracker Welcome
       	        
Close Window Ux   +on mouseUp
  close this stack
end mouseUp
      cyan                   	     
   number 
h          +                 + Ex  " `on mouseUp
  put the short name of the target into zsymbol
  computeNumber zsymbol
end mouseUp
      cyan     T               	        - Ex  $ `on mouseUp
  put the short name of the target into zsymbol
  computeNumber zsymbol
end mouseUp
      cyan     w               	        4 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan     w               	        5 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan    I w               	        6 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan    v w               	        7 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan     T               	        8 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan    I T               	        9 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan    v T               	        x Ex   `on mouseUp
  put the short name of the target into zsymbol
  computeNumber zsymbol
end mouseUp
      cyan                    	     
   
sub total 7
x   [on mouseUp
  ask "You may copy this number from here." with field "sub total"
end mouseUp
        ,                 0 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan                    	        00 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan    I                	         . Ex  * ron mouseUp
    if offset(".", field "number") = 0 then
      put "." after field "number"
    end if
end mouseUp
      cyan    v                	        / Ex   `on mouseUp
  put the short name of the target into zsymbol
  computeNumber zsymbol
end mouseUp
      cyan                    	        = Mx  $ `on mouseUp
  put the short name of the target into zsymbol
  computeNumber zsymbol
end mouseUp
      cyan    t  L              	        Clear Ex   on mouseUp
  global gSubTotal,gLastComp
  if field "number" is empty then
    put empty into gSubTotal
    put empty into gLastComp
    put empty into field "sub total"
    put return & "cleared"  & return & return after field "tape"
    set the scroll of field "tape" to (the formattedHeight of field "tape" - the height of field "tape")
  else
    put empty into field "number"
  end if
end mouseUp
      cyan      N             	        
Clear All Ex    on mouseUp
  global gSubTotal,gLastComp
  put empty into gLastComp
  put empty into gSubTotal
  put empty into field "number"
  put empty into field "tape"
  put empty into field "sub total"
end mouseUp
      cyan                  	     
   label1 
         0 4            Total 
   label2 
         L b            # of decimals 
   places x   on mouseUp
  ask "Enter a new number of decimals." with field "places"
  if it is a number then put it into field "places"
end mouseUp
        L             2    Font... Ex   hon mouseUp
  put the fontNames into field "fonts"
  sort field "fonts"
  show group "font"
end mouseUp
      cyan    P X             	        Save as... Ex  on mouseUp
  ask file "Save this calculation as..." with "calculator.txt"
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  open file fileName for write
  if the result is empty then
    write field "tape" to file fileName
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
      cyan   0P `             	     
   label1 	          * P            Length 
   label2 	          E P            inches 
   inches 	x   =on mouseUp
  computeLength the short name of me
end mouseUp
        D E \             
   label3 	          E ?            feet 
   feet 	x   =on mouseUp
  computeLength the short name of me
end mouseUp
         E V             
   label5 	          e P            cm 
   label6 	          e \            meters 
   cm 	x   =on mouseUp
  computeLength the short name of me
end mouseUp
        7 e \             
   meters 	x   =on mouseUp
  computeLength the short name of me
end mouseUp
         e O                Help Ex 	 
 on mouseUp
  answer information "Click any field in this group, then enter a number. " \ 
      & return & "All the other fields will be automatically updated."  \
      & return & "10 mm = 1 cm." 
end mouseUp
      cyan    - <              	     
   label4 	         E P            miles 
   label7 	        $ e +            km 
   miles 	x   =on mouseUp
  computeLength the short name of me
end mouseUp
       D E O             
   km 	x   =on mouseUp
  computeLength the short name of me
end mouseUp
       D e O             
    label8 	                       Volume (Liquid)   !    K&        |           " Reset2 ex 	 
 on mouseUp
  put empty into field "ozv"
  put empty into field "quarts"
  put empty into field "gals"
  put empty into field "ml"
  put empty into field "liters"
  put empty into field "kl"
end mouseUp
      cyan   V  <      Reset          	       # Reset Ex 	 
 on mouseUp
put empty into field "inches"
put empty into field "feet"
put empty into field "miles"
put empty into field "cm"
put empty into field "meters"
put empty into field "km"
end mouseUp
      cyan   V - <              	       $ Help Ex 	 
 on mouseUp
  answer information "Click any field in this group, then enter a number. " \
      & return & "All the other fields will be automatically updated."
end mouseUp
      cyan     <              	     
  % label9 	           P            oz 
  & label11 	           P            quarts 
  ' label12 	          ,            gals 
  ( ozv 	x   =on mouseUp
  computeVolume the short name of me
end mouseUp
        6  O             
  ) quarts 	x   =on mouseUp
  computeVolume the short name of me
end mouseUp
          O             
  * gals 	x   =on mouseUp
  computeVolume the short name of me
end mouseUp
       D  O             
  + label10 	           P            ml 
  , label13 	           H            liters 
  - label14 	        $              kl 
  . ml 	x   =on mouseUp
  computeVolume the short name of me
end mouseUp
        6  O             
  / liters 	x   =on mouseUp
  computeVolume the short name of me
end mouseUp
          O             
  0 kl 	x   =on mouseUp
  computeVolume the short name of me
end mouseUp
       D  O             
  1 label15 	                       Weight (AVDP)   2    K&        |           3 Reset3 ex 	 
 on mouseUp
  put empty into field "ozw"
  put empty into field "lbs"
  put empty into field "tons"
  put empty into field "g"
  put empty into field "kg"
  put empty into field "mton"
end mouseUp
      cyan   V  <      Reset          	       4 Help Ex 	 
 on mouseUp
  answer information "Click any field in this group, then enter a number. " \
      & return & "All the other fields will be automatically updated." & return &\
"(AVDP) = customary weight which is not equal to apothecary weight."
end mouseUp
      cyan     <              	     
  5 label16 	          T            oz 
  6 label17 	         7 P            g 
  7 label18 	          P            lbs 
  8 label19 	         7 P            kg 
  9 label20 	         '            tons 
  : label21 	        7 +            mtons 
  ; ozw 	x   =on mouseUp
  computeWeight the short name of me
end mouseUp
        6 b             
  < lbs 	x   =on mouseUp
  computeWeight the short name of me
end mouseUp
         X             
  = tons 	x   =on mouseUp
  computeWeight the short name of me
end mouseUp
       D O             
  > g 	x   =on mouseUp
  computeWeight the short name of me
end mouseUp
        67 b             
  ? kg 	x   =on mouseUp
  computeWeight the short name of me
end mouseUp
        7 X             
  @ mton 	x   =on mouseUp
  computeWeight the short name of me
end mouseUp
       D7 O             
  A label11 	          (             Money Exchange 
  B 
dollarsLabel 	          @ O            
$ Dollars 
  C label13 	         u @ i            Exchange rate 
  D label14 	          @ a            Currency type   E Help Ex 	 
 on mouseUp
  answer information "Enter an exchange rate and a currency type. " \
      & return & "Then click on the first or last field and enter an amount." \
      & return & "The other field will be automatically calculated."
end mouseUp
      cyan    - <              	     
  F dollars 	x   <on mouseUp
  computeMoney the short name of me
end mouseUp
         V \             
  G 	exchange 	x   <on mouseUp
  computeMoney the short name of me
end mouseUp
        | V Q             
  H 	currency  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
         V X             J Reset Ex 	 
 on mouseUp
  put empty into field "dollars"
  put empty into field "exchange"
  put empty into field "currency"
  put empty into field "amount"
end mouseUp
      cyan   V - <              	     
  K amount 	x   <on mouseUp
  computeMoney the short name of me
end mouseUp
       4 V [               L    K&        x|        z z
  [ label1 	          *             !Add or subtract days from a date 
  \ label2 	         < ` P            start date 
  ] date 	x   +on mouseUp
  checkDate "date"
end mouseUp
         `              
  ^ label3 	         P  `            result 
  _ result  )x   Zon enterInField
  -- trap
end enterInField

on returnInField
  -- trap
end returnInField
                         ` Help Ex 	 
on mouseUp
  answer information "Enter a start date by clicking Today, Edit or Choose." & return &\
      "Next enter a number of days by selecting from the menu or by typing. " \
      & return & "Then click either the Add or Subtract button."
end mouseUp
      cyan    - <              	       a Reset Ex 	 
 on mouseUp
  put empty into field "date"
  put empty into field "result"
  set the label of button "days" to 7
  set the traversalOn of button "days" to true
end mouseUp
      cyan   V - <              	       b days )u on keyup
  if the label of me > 10000 then
    answer "Enter a number less than 10001."
    set the label of me to 0
  end if
  if the label of me < 0 then
    answer "Enter a number greater than 0."
    set the label of me to 0
  end if
end keyup
      cyan      D      7    3
5
7
14
21
30
60
90 
      	     
  c label4 	         T ~ H            days   f Today Ex 	 
 >on mouseUp
  put the long date into field "date"
end mouseUp
      cyan     L (              	       g Edit Ex 	 
 7on mouseUp
  send mouseUp to field "date"
end mouseUp
      cyan     L (              	       h Choose Ex 	 
ton mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "date" into gStartDate
  put "date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
      cyan     L 2              	       n add Ex    eon mouseUp
  if field "date" is empty then exit mouseUp
  put field "date" into temp
  convert temp to dateitems
  
  put the label of button "days" into znum
  if znum is not a number then
    set the label of button "days" to 0
    exit mouseUp
  end if
  add znum to item 3 of temp
  convert temp to long date
  put temp into field "result"
end mouseUp
      cyan      <              	       o 	subtract Ex    lon mouseUp
  if field "date" is empty then exit mouseUp
  put field "date" into temp
  convert temp to dateitems
  
  put the label of button "days" into znum
  if znum is not a number then
    set the label of button "days" to 0
    exit mouseUp
  end if
  subtract znum from item 3 of temp
  convert temp to long date
  put temp into field "result"
end mouseUp
      cyan     L              	     
  p label22 	                       Discounts and Sales Tax 
  q label23 
           I            Amount 
  r label24 
         	  | 0           Percent Discount  (.10 = 10%)   w Help Ex 	 
mon mouseUp
  answer information "1. Choose a percent from the Discount menu by selecting or typing" \
      & return & "2. Choose a Rate from the Sales Tax menu by selecting or typing" \
      & return & "3. Click the Compute Discount & Tax button and enter a number" \
      & return & "4. Click any field to enter a new number and get a new result."
end mouseUp
      cyan     <              	       z Reset2 ex 	 
Non mouseUp
  put empty into field "pamount"
  put empty into field "discount"
  put empty into field "subtotal"
  put empty into field "salestax"
  put empty into field "result"
  -- set the hilite of button "tax" to true
  -- set the label of button "discount" to ".10"
  --  set the label of button "salesTax" to ".07"
end mouseUp
      cyan   V  <      Reset          	        	discount )}  on focusOut
  if the label of me > 1 then
    put the label of me into temp
    set the label of me to temp/100
  end if
  if the label of me is not a number  or the label of me < 0 then
    set the label of me to 0
  else
    set the hilite of button "set discount" to false
  end if
end focusOut

on menuPick
  set the hilite of button "set discount" to false
  computeDiscount
end menuPick
      cyan      T      0    0
.05
.10
.15
.20
.25
.50
.75 
      	        Numbers  DX   "on mouseUp
  -- trap
end mouseUp
              cyan      D              	   	        Dates EX   "on mouseUp
  -- trap
end mouseUp
              cyan    ]  8              	        Measurement EX   "on mouseUp
  -- trap
end mouseUp
              cyan     
 `              	        	salesTax )}   on menuPick
  computeDiscount
end menuPick

on focusOut
  if the label of me is not a number then set the label of me to 0
  if the label of me < 0 then set the label of me to 0
end focusOut
      cyan      T      .075    )0
.05
.06
.07
.075
.08
.085
.09
.095
.10 
      	     
   label28 
         @ L            Total 
   label27 
         	  | 0           
Sales Tax  (.075 = 7.5%) 
  x label25 
           L            
Sub Total 
  I label15 	        4 @ d            
Other Amount    Compute Discount & Tax Ex  on mouseUp
  ask "Enter an amount" with field "pamount"
  if it is empty then exit mouseUp
  if it is a number then
    put setNumber(it) into field "Pamount"
    computeDiscount
  else
    answer warning "You did not enter a number. Try again."
  end if
end mouseUp
      cyan     @              	     
   label26 
          U            + Sales Tax 
   label27 
           L            - Discount 
   	salesTax 	h        4 [             
   result  )h        4@ [                tax @e   *on mouseUp
  computeDiscount
end mouseUp
      cyan            Compute tax on Sub Total          	    
  y 	subTotal 	h        4  [             
  s pamount 	x  on mouseUp
  ask "Enter an amount" with field "pamount"
  if it is empty then exit mouseUp
  put validateNumber(it) into temp
  if temp < 0 then
    answer "Negative numbers not allowed."
    exit mouseUp
  end if
  if temp is a number then
    put setNumber(temp) into field "Pamount"
    computeDiscount
  else
    answer warning "You did not enter a number. Try again."
  end if
end mouseUp
       4  [             
   	discount 	x  on mouseUp
  ask "Enter a discount." with field "discount"
  if it is empty then exit mouseUp
  if it < 0 then
    delete char 1 of it
  end if
  put validateNumber(it) into temp
  if temp is a number then
    put setNumber(temp) into field "discount"
    set the hilite of button "set discount" to true
    computeDiscount
  else
    answer warning "You did not enter a number. Try again."
  end if
end mouseUp
       4  [                   K&        |            Today Ex 	 
 eon mouseUp
  put the long date into field "cdate"
  send calculateDate to field "cdate"
end mouseUp
      cyan      (              	        Edit Ex 	 
 8on mouseUp
  send mouseUp to field "cdate"
end mouseUp
      cyan      (              	        Choose Ex 	 
von mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "cdate" into gStartDate
  put "cdate" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
      cyan      2              	     
   cdate 	x  on mouseUp
  checkDate "cdate"
  calculateDate
end mouseUp

on calculateDate
  put field "cdate" into temp
  convert temp to dateitems
  put the date into temp2
  convert temp2 to dateitems
  put item 1 of temp2 into zyear
  if offset("/",temp) > 0 then
    set itemDelimiter to "/"
    put zyear into item 3 of temp
    convert temp to long date
    put temp into field "cdate"
    convert temp to dateitems
    set itemDelimiter to comma
  end if
  put item 1 of temp into zyear
  put item 2 of temp into zmonth
  put item 3 of temp into zday
  put 0 into nday
  if zmonth > 1 then
    repeat with i = 1 to (zmonth-1)
      add daysofmonth(i, zyear) to nday
    end repeat
  end if
  add zday to nday
  put nday into field "doy"
  put trunc(nday/7)  + 1 into zweek
  if zweek > 52 then put 52 into zweek
  put zweek into field "woy"
  put 52 - zweek into field "wleft"
  if zyear/4 = trunc(zyear/4) then
    put 366 - nday into field "dleft"
  else
    put 365 - nday into field "dleft"
  end if
end calculateDate
        	              
   label2 	         T	 /            date 
   label2 	         5' P            day of year 
   doy 	h         ' 0             
   label2 	         ' e            days left in year 
   dleft 	h        ,' 0                Help Ex 	 
 on mouseUp
  answer information "Enter a date by clicking Today, Edit or Choose." & return &\
      "The other numbers are entered automatically."
end mouseUp
      cyan   
  <              	        Reset2 ex 	 
 on mouseUp
  put empty into field "cdate"
  put empty into field "doy"
  put empty into field "dleft"
  put empty into field "woy"
  put empty into field "wleft"
end mouseUp
      cyan   T  <      Reset          	     
   label2 	         ,C P            
week of year 
   woy 	h         C 0             
   label2 	         C m            weeks left in year 
   wleft 	h        ,C 0                	Currency EX   "on mouseUp
  -- trap
end mouseUp
              cyan   H 
 H              	        3 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan    v                	        2 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan    I                	        1 Ex    Hon mouseUp
  put the short name of me after field "number"
end mouseUp
      cyan                    	        Times EX   "on mouseUp
  -- trap
end mouseUp
              cyan     
 0              	        Edit Ex 	 
 7on mouseUp
  send mouseUp to field "time"
end mouseUp
      cyan     p "              	     
   time label           p H            Local Time 
   label2 	          @ 0           sChoose a local time and then pick a city from the list on the left. Then choose a city from the list on the right. 
   origin )x  yon mouseUp
  global gHLineNum
  put the hilitedlines of me into gHLineNum
  put line (the hilitedLines of me) of me into field "ocity"
  computeTime
end mouseUp

on arrowKey which
  global gHLineNum,gStack
  if gHLineNum is empty then
    put the hilitedlines of me into gHLineNum
  end if
  put the number of lines of me into numLines
  if which is "up" then
    if gHLineNum > 1 then
      subtract 1 from gHLineNum
    end if
  end if
  if which is "down" then
    if gHLineNum < numLines then
      add 1 to gHLineNum
    end if
  end if
  put line gHLineNum of me into field "ocity"
  computeTime
  pass arrowkey
end arrowKey

                        Addis Ababa	11:00	  Adelaide	17:30	  Aden	11:00	  Aklavik	01:00	  Algiers	09:00	  
Amman	10:00	  Amsterdam 	09:00	  Anadyr 	22:00	  Anchorage	-1:00	  Ankara 	12:00	  Antananarivo	11:00	  Asuncion	04:00	  Athens 	12:00	  Atlanta	03:00	  Baghdad	11:00	  Bangkok	15:00	  Barcelona 	11:00	  Beijing	16:00	  Beirut 	12:00	  Belgrade 	11:00	  Berlin 	11:00	  Bogota	03:00	  Boston	03:00	  Brasilia	00:00	  Brisbane	18:00	  Brussels 	11:00	  Bucharest 	12:00	  Budapest 	11:00	  Buenos Aires	00:00	  
Cairo	10:00	  Calcutta	13:30	  Canberra	18:00	  Cape Town	10:00	  Caracas	04:00	  Casablanca	08:00	  Chatham Island	20:45	  Chicago	02:00	  Copenhagen 	11:00	  Darwin	17:30	  Denver	01:00	  Detroit	03:00	  
Dhaka	14:00	  Dublin 	10:00	  Edmonton	01:00	  Frankfurt(Ger) 	11:00	  Geneva 	09:00	  Guatemala	02:00	  Halifax	04:00	  
Hanoi	15:00	  Harare	10:00	  Havana	03:00	  Helsinki 	10:00	  Hong Kong	16:00	  Honolulu	-2:00	  Houston	02:00	  Indianapolis	03:00	  Islamabad	13:00	  Istanbul 	12:00	  Jakarta	15:00	  Jerusalem	10:00	  Johannesburg	10:00	  
Kabul	12:30	  Kamchatka 	22:00	  Kathmandu	13:45	  Khartoum	11:00	  Kingston	03:00	  Kiritimati	22:00	  Kuala Lumpur	16:00	  Kuwait City	11:00	  La Paz	04:00	  
Lagos	09:00	  Lima	03:00	  Lisbon 	10:00	  London 	10:00	  Los Angeles	00:00	  Madrid 	11:00	  Managua	02:00	  Manila	16:00	  Melbourne	18:00	  Mexico City	02:00	  Minneapolis	02:00	  Minsk 	12:00	  Montevideo	00:00	  Montgomery	02:00	  Montreal	03:00	  Moscow 	13:00	  Mumbai	13:30	  Nairobi	11:00	  Nassau	03:00	  New Delhi	13:30	  New Orleans	02:00  New York	03:00  Oslo 	09:00  
Ottawa	03:00  
Paris 	09:00  Perth	16:00  Phoenix	01:00  Prague 	11:00  Rangoon	14:30  Reykjavik	08:00  Rio de Janeiro	00:00  
Riyadh	11:00  Rome 	11:00  San Francisco	00:00  San Juan	04:00  San Salvador	02:00  Santiago	04:00  Santo Domingo	04:00  Sao Paulo	00:00  Seattle	00:00  Seoul	17:00  Shanghai	16:00  Singapore	16:00  
Sofia 	12:00  St. Paul	02:00  Stockholm 	11:00  Suva	20:00  
Sydney	18:00  
Taipei	16:00  Tallinn	10:00  Tashkent	13:00  Tegucigalpa	02:00  Tehran 	13:30  Tokyo	17:00  Toronto	03:00  Vancouver	00:00  Vienna 	11:00  Vladivostok 	20:00  Warsaw 	11:00  Washington DC	03:00  Wellington	20:00  Winnipeg	02:00  Zagreb 	11:00  Zrich 	11:00         	`    @         
Yesterday @D	       cyan   < l d              	  	        Today @D	       cyan   < | d              	      	Tomorrow @D	       cyan   <  d              	      oDST @e   &on mouseUp
  computeTime
end mouseUp
      cyan            Daylight Savings Time          	        dDST @e   &on mouseUp
  computeTime
end mouseUp
      cyan            Daylight Savings Time          	     
   ocity 	h                              
   dcity 	h                        
   label1 	          *             #Find out what time it is anywhere.    Now Ex 	 
 Gon mouseUp
  put the time into field "time"
  computeTime
end mouseUp
      cyan    d p "              	        Help Ex 	 
 on mouseUp
  answer information "Enter a time by clicking Edit or Now." & return &\
      "Next select a city from the list. " & return &\
      "Use the Daylight Savings Time " & return & \
      "checkboxes to adjust times. " \
    end mouseUp
      cyan    - <              	        Reset Ex 	 
Jon mouseUp
  put empty into field "time"
  put empty into field "dtime"
  put empty into field "ocity"
  put empty into field "dcity"
  set the hilite of button "odst" to false
  set the hilite of button "ddst" to false
  set the hilitedLines of field "origin" to 0
  set the hilitedLines of field "destination" to 0
end mouseUp
      cyan   V - <              	     
   time label           n t            Destination Time 
   time  
x   on mouseUp
  
  put "time" into whichField
  put "" into altField
  put "Time" into prompt
  put "" into defaultTime
  put false into OKtoEmpty
  
  setTime whichfield,prompt,altField,defaultTime,OKtoEmpty
  
  computeTime
end mouseUp
          ^           
   dtime  
h           ^           
   destination )x  yon mouseUp
  global gHLineNum
  put the hilitedlines of me into gHLineNum
  put line (the hilitedLines of me) of me into field "dcity"
  computeTime
end mouseUp

on arrowKey which
  global gHLineNum,gStack
  if gHLineNum is empty then
    put the hilitedlines of me into gHLineNum
  end if
  put the number of lines of me into numLines
  if which is "up" then
    if gHLineNum > 1 then
      subtract 1 from gHLineNum
    end if
  end if
  if which is "down" then
    if gHLineNum < numLines then
      add 1 to gHLineNum
    end if
  end if
  put line gHLineNum of me into field "dcity"
  computeTime
  pass arrowkey
end arrowKey

                        Addis Ababa	11:00	  Adelaide	17:30	  Aden	11:00	  Aklavik	01:00	  Algiers	09:00	  
Amman	10:00	  Amsterdam 	09:00	  Anadyr 	22:00	  Anchorage	-1:00	  Ankara 	12:00	  Antananarivo	11:00	  Asuncion	04:00	  Athens 	12:00	  Atlanta	03:00	  Baghdad	11:00	  Bangkok	15:00	  Barcelona 	11:00	  Beijing	16:00	  Beirut 	12:00	  Belgrade 	11:00	  Berlin 	11:00	  Bogota	03:00	  Boston	03:00	  Brasilia	00:00	  Brisbane	18:00	  Brussels 	11:00	  Bucharest 	12:00	  Budapest 	11:00	  Buenos Aires	00:00	  
Cairo	10:00	  Calcutta	13:30	  Canberra	18:00	  Cape Town	10:00	  Caracas	04:00	  Casablanca	08:00	  Chatham Island	20:45	  Chicago	02:00	  Copenhagen 	11:00	  Darwin	17:30	  Denver	01:00	  Detroit	03:00	  
Dhaka	14:00	  Dublin 	10:00	  Edmonton	01:00	  Frankfurt(Ger) 	11:00	  Geneva 	09:00	  Guatemala	02:00	  Halifax	04:00	  
Hanoi	15:00	  Harare	10:00	  Havana	03:00	  Helsinki 	10:00	  Hong Kong	16:00	  Honolulu	-2:00	  Houston	02:00	  Indianapolis	03:00	  Islamabad	13:00	  Istanbul 	12:00	  Jakarta	15:00	  Jerusalem	10:00	  Johannesburg	10:00	  
Kabul	12:30	  Kamchatka 	22:00	  Kathmandu	13:45	  Khartoum	11:00	  Kingston	03:00	  Kiritimati	22:00	  Kuala Lumpur	16:00	  Kuwait City	11:00	  La Paz	04:00	  
Lagos	09:00	  Lima	03:00	  Lisbon 	10:00	  London 	10:00	  Los Angeles	00:00	  Madrid 	11:00	  Managua	02:00	  Manila	16:00	  Melbourne	18:00	  Mexico City	02:00	  Minneapolis	02:00	  Minsk 	12:00	  Montevideo	00:00	  Montgomery	02:00	  Montreal	03:00	  Moscow 	13:00	  Mumbai	13:30	  Nairobi	11:00	  Nassau	03:00	  New Delhi	13:30	  New Orleans	02:00  New York	03:00  Oslo 	09:00  
Ottawa	03:00  
Paris 	09:00  Perth	16:00  Phoenix	01:00  Prague 	11:00  Rangoon	14:30  Reykjavik	08:00  Rio de Janeiro	00:00  
Riyadh	11:00  Rome 	11:00  San Francisco	00:00  San Juan	04:00  San Salvador	02:00  Santiago	04:00  Santo Domingo	04:00  Sao Paulo	00:00  Seattle	00:00  Seoul	17:00  Shanghai	16:00  Singapore	16:00  
Sofia 	12:00  St. Paul	02:00  Stockholm 	11:00  Suva	20:00  
Sydney	18:00  
Taipei	16:00  Tallinn	10:00  Tashkent	13:00  Tegucigalpa	02:00  Tehran 	13:30  Tokyo	17:00  Toronto	03:00  Vancouver	00:00  Vienna 	11:00  Vladivostok 	20:00  Warsaw 	11:00  Washington DC	03:00  Wellington	20:00  Winnipeg	02:00  Zagreb 	11:00  Zrich 	11:00         	`    @ ?    
   tape 
h          +                    	`    @  ,     M font   a         xP   N font bg E`     cyan     |H              	       O bgrect   K@              <    
  P fonts  )x   on mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "tape" to line temp of me
  set the textfont of field "number" to line temp of me
  set the textfont of field "sub total" to line temp of me
end mouseUp
                      
.Keyboard  
AGaramond  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  B Friz Quadrata Bold  C Helvetica Condensed  	Capitals  CB Helvetica Condensed Bold  	Charcoal  Chicago  Comic Sans MS  Courier  Courier New  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  
Helvetica  Impact  L Helvetica Light  LB Helvetica Black  Minion Web  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  	Palatino  Sand  Swis721 BdCn BT  Swis721 BdCnOul BT  Swis721 BdOul BT  Swis721 BdRnd BT  Swis721 BlkCn BT  Swis721 BlkOul BT  Swis721 BlkRnd BT  Swis721 BT  Swis721 Hv BT  Swis721 It BT  Swis721 LtCn BT  Swis721 Th BT  Symbol  Techno  Tekton  Tekton Bold  Textile  Times  Times New Roman  
Trebuchet MS  Verdana  	Webdings  
Wingdings  Zapf Dingbats   Q    	`    @        R Close Ex   ,on mouseUp
  hide group "font"
end mouseUp
      cyan    A L              	     
  S inst 	                      +Pick a font face and size for your report.   T sizes   i   on mouseUp
  put word 1 of the hilitedButtonName of me into temp
  set the textSize of field "tape" to temp
  set the textSize of field "number" to temp
  set the textSize of field "sub total" to temp
end mouseUp
          @   U 9 pt @D     cyan      8              	     V 10 pt @D     cyan      8              	     W 11 pt @D     cyan      8              	     X 12 pt @D     cyan      8              	    Y 14 pt @D     cyan      8              	     Z 16 pt @D     cyan     8              	   
   label1b 	                       Day/Week of Year Calculator    
set discount @e  (on mouseUp
  if the hilite of me then
    ask "Enter a discount." with field "discount"
    if it is empty then exit mouseUp
    if it < 0 then
      delete char 1 of it
    end if
    put validateNumber(it) into temp
    if temp is a number then
      put setNumber(temp) into field "discount"
      set the label of button "discount" to 0
      computeDiscount
      set the hilite of me to true
    else
      answer warning "You did not enter a number. " & return &\
          "Try clicking on the discount field."
    end if
  end if
end mouseUp
      cyan           "Fixed discount instead of percent          	     	    a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
   dd CornflowerBlue    @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
      cyan    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
      cyan     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@     cyan      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
   dd CornflowerBlue  O  d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
             d  z                
     @                      You must enter numbers only.   z icon BP on mouseUp
end mouseUp
      cyan      , (         	      OK D`     cyan    R 6 4            	      AU$s D`     cyan     6 B            	      dollar D`     cyan   < 6 C            	      z D`     cyan     4 '            	      y D`     cyan     4 '            	      x D`     cyan    i 4 '            	      w D`     cyan      4 )            	      ucHelp   on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
  hide group "devtools"
end closeStack

on closeCard
  -- trap
end closeCard
  w        Black dd CornflowerBlue ffffff      white       	darkgray   
 w             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica    About Help   	@          w       Universal Calculator   	@          w       Preferences   	@          w      & About the Number calculator   	@          w      ' About the Date calculator   	@          w       About the Time calculator   	@          w      ( About the LVW calculator   	@          w      ) About the Currency calculator   	@          w      1 Adjusting the Date   	@          w    3 Background Color   	@          w     Button Colors   	@          w    D Default Settings   	@          w     Font...   	@          w    U Help   	@          w    V Highlight Color   	@          w     	Printing   	@          w    g Quit   	@          w    i 
Registration   	@          w     Save As...   	@          w    n Save   	@          w     Help Index   	@          w    !             help   i          t
   main  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(        ) About the Currency calculator 
  @           Money Exchange 
 @      Blue       RYou can convert any currency to any other currency if you know the exchange rate.    e1. Enter the number of dollars (or other currency) that you want to convert into the $ Amount field. 
       U
     U 
     ]    2. Click the Exchange rate field to enter an exchange rate. For instance, if you get 4.5 of the other currency for each dollar, enter 4.5 into the Exchange rate field 
       

     
 

         >3. Enter the Currency type if desired. This step is optional. 
       

     
 

      #   MThe Other Amount will be automatically entered after completing step 1 or 2. 
       
      
      <   You may also enter a number in the Other Amount field to calculate the number of dollars. The $ Amount  field will automatically be updated. 
       #
     # 
     / /
     ^ 	
     g %   Discounts and Sales Tax 
 @      Blue       You can figure discounts and sales tax by using this calculator. You can use the Percent Discount menu by picking a preset amount or by tying a number into the field. 
       Q
     Q 
     a E   TPick a Sales Tax from the drop down menu or enter a number directly into the field. 
       
      	
      C   Enter a number into the Amount field by either clicking that field or the Compute Discount & Tax button. All the other fields will automatically be filled in. 
       
      
      ,
     J 
     ` >   You can also enter a fixed discount by entering an amount and then clicking the Discount field. After entering a new discount amount a new total will be calculated. Clicking the Fixed discount instead of percent button does the same thing. 
       P
     P 
     X Z
      "
         Normally tax is computed on the Sub Total amount, but sometimes you may want the tax computed on the original amount. If this is the case for you, uncheck the Compute tax on Sub Total button. A new total will be calculated. 
       
      
      (      ( About the LVW calculator 
  @           You can convert any Length, Volume or Weight with this converter. Just click on any field, enter a number, and the other five corresponding fields will automatically be filled in.    About the Time calculator 
  @           gYou can find out time differences between many major cities in the world by using the time calculator.   Enter a Local Time by clicking the Now or Edit  button. Then select a city from the list on the left. Usually this will be a city in your time zone. Then select a city from the list on the right. If the city you want is not in the list, pick a city that is in the same time zone. The time for the city on the right will be displayed in the Destination Time field. The relative date for the destination time is displayed by the hilite of the Yesterday, Today and Tomorrow buttons. 
       
      
      
     # 
     ' 
     * 
     .&
    T 
    d U
     
     	   If either the Local Time or Destination Time is currently observing Daylight Savings Time, click the checkbox below the appropriate time fields. 
       
      

      
      
     , 
     D 
     Y 7  ' About the Date calculator 
  @           TYou can add or subtract any number of days from any date by using this handy tool.    Enter a start date by clicking the Today, Edit or Choose button. For more information see Adjusting the Date. Then enter a number of days or choose a number from the drop down menu. Finally, click the add or subtract button. Your answer will appear in the result field. 
       
      

      
     # 
     ( 
     * 
     . 
     2 
     8 "
 @      Blue  Z 
     l 
     m 
      
      @
      
      
      
      (
      
        ATo find out the day and week of the year for a particular date,   ;enter a date by clicking the Today, Edit or Choose button. 
       
      
      
      
     " 
     $ 
     ( 
     , 
     2  2The other fields will be filled in automatically.   & About the Number calculator 
  @           VThe number calculator is very similar to other number calculators you may have used.    MYou can enter numbers and operators (+, -, * ,x, /, =) by clicking the buttons or by using the keyboard. For your convenience both the x key and the * (shift 8) key perform multiplication. Both the return or enter keys do the same thing as clicking the = button. Buttons are things you click on, fields are things that contain text. 
 @      Blue    U
 @      Blue  U 
 @      Blue  g 
 @      Red  h 
 @      Blue  i 
 @      Blue   
 @      Blue   	
     E   _If you make a mistake after entering a number, click the Clear button to clear the calculator. 
       9
     9 
     >     5To clear all the fields, click the Clear All button. 
       #
     # 	
     ,    eYou can change the font face and size of all the fields in this window, by clicking the Font button. 
       X
     X 
     \   1The large field to the right is referred to as the Tape field. You can save the Tape field as a text file or print it directly from this window. Click the Save as... button to export the Tape field as a text file so that you can open it in another program. Click the Print button to print the Tape field. 
       
      

      f
     
        =You can change the number of decimal places by entering a different number in the # of decimals field. For instance, if you are calculating dollars, then 2 decimal places makes sense (12.34). For more accuracy, you can change the number of decimals to a higher number (i.e., 5 would result in numbers like 12.34567). 
       R
     R 

     _    You can copy the number in the total field by clicking the total field and pressing Control + C (or Command + C on the Macintosh). You can then paste the number into some other program by pressing Control + V (or Command + V on the Macintosh).  
       T
     T 
     [ j
      
      (       xx   1 Adjusting the Date 
  @           Click the Today button to enter the correct date. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       

     
 
      T
     c 
     g F  
Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the current record. 
       
      
     %      About Help 
  @        
  
  @          &Welcome to Universal Calculator Help. 
 @        Black    %   Listed in the Help Index are all the features, fields and buttons of Universal Calculator. (Buttons are things you click on and fields contain text.) 
       
 @        Black   

      }  You can click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

      
 @      Blue   Y
    < W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R    iThe newest version of this software is available at http://productivity-software/sbtracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470     U Help 
  @           bClicking the Help button at the bottom of a window will take you to a Help window for that topic. 
       

     
 
      P   sThere are Help buttons in many other places which will give you a quick hint about the functionality of that area. 
       

     
 
      d   Universal Calculator 
  @          
  @          MThe Universal Calculator window has several different calculation abilities. 
 @        Black    L   Click the Numbers button to calculate numbers with a traditional number calculator. You can enter the numbers and operators by clicking, or by using the keyboard. For more information see About the Number calculator. 
       

     
 
      
 @      Blue   
        
         Click the Dates button to add or subtract days from a particular date. You can enter the start date and choose or enter any number of days. For more information see About the Date calculator. 
       

     
 
      
 @      Blue   
        
         ~Click the Times button to find out what time it is anywhere in the world. For more information see About the Time calculator. 
       

     
 
      T
 @      Blue  c 
     |   
         Click the Measurement button to convert various weights and measures. You can enter a number into any field and get five conversions automatically. For more information see About the LVW calculator. 
       

     
 
      
 @      Blue   
        
         Click the Currency button to calculate currency exchange or Discounts and Sales Tax computations. You can choose any percent discount and sales tax rate. For more information see About the Currency calculator. 
       

     
 
      
 @      Blue   
        
         Other Buttons 
  @        
   The Preferences button brings up the Preferences window, where you can change Background colors and Button colors as well as the Time Format. For more information see Preferences. 
       
      
      
  @      % 
     7 p
  @       
        
         To register Small Business Tracker, click the Register button. Read the instructions for getting a registration number. When you receive your number, fill in your full name and the registration number. You will then be able to continue using the software. 
       .
     . 
     6   
         /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    "The Save button saves your data.  
       
      
         7The Quit button saves the data and quits the program.  
       
      
      .  
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _          Preferences 
  @          
  @          HThere are several preferences you can set for the Universal Calculator. 
 @        Black    G   cTo access the Preferences window, click the Preferences button in the Universal Calculator window. 
       ,
     , 
     7 
  @      F 
     a    jThe Time Format defaults to AM/PM, but if you would want times displayed in 24 hour format, click 24 Hrs. 
       
      
      Z  You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C    WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <        g Quit 
  @           You can quit (or exit) the program at any time by clicking the Quit button. You may also type Control + Q (or Command + Q on the Macintosh) to quit. 
       ?
     ? 
     C Q         	Printing 
  @           cThe Print button allows you to print the entire window in all windows except  the Numbers window.  
       
      
     	 Y   bIn the Numbers window, only the large field to the right, with all the calculations, is printed.  
       
      
      S  i 
Registration 
  @          'To register Small Business Tracker, click the Small Business Tracker Menu button and choose Small Business Tracker Welcome. Then click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       .
     . 
     I 
     [ 
     \ 
     { 
      

      
         HYou can also review the License Agreement from the Registration window. 
       
      
     )         n Save 
  @           You can save all the data in the Universal Calculator window by clicking the Save button. All data is saved automatically when going to another window or when quitting the program. 
       M
     M 
     Q c         Save As... 
  @        
  The large field to the right is referred to as the Tape field. You can save the Tape field as a text file or print it directly from this window. Click the Save as... button to export the Tape field as a text file so that you can open it in another program.  
       
      

      \  V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the Universal Calculator window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O 
  @      ] 
     y 
      
      F         Font... 
  @          
         Before printing you may want to adjust the font or size Tape field text by clicking the Font... button. Choose a new font by clicking its name in the font list. 
       X
     X 
     _ A  
         Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change.  
           D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	      Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G           Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &    About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
      cyan     " U             	        Universal Calculator Ex   Son mouseUp
  lock screen
  push card
  go card "Universal Calculator"
end mouseUp
      cyan    d "              	        Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
      cyan     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
      cyan     <              	        Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
      cyan     <              	        Search Help Ex  ]on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 320 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack "atFind" to it
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "atFind"
end mouseUp
              cyan     l             	        Save as... Ex   on mouseUp
  global gStackName
  
  insert the script of button "SaveHelp" of stack "Launcher" into back
  put "Universal Calculator Help" into gStackName
  exportHelp
  remove the script of button "SaveHelp" of stack "Launcher" from back
end mouseUp
      cyan     Q              	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
      cyan     y             	        	devtools   a         tH    Save Ex   *on mouseUp
  save this stack
end mouseUp
      cyan    x Q              	        go next Ex   'on mouseUp
  go next card
end mouseUp
      cyan    \x Q              	        delete Ex   +on mouseUp
  delete this card
end mouseUp
      cyan   x 2              	        go prev Ex   'on mouseUp
  go prev card
end mouseUp
      cyan    x Q              	        Numbers Ux   Zon mouseUp
  lock screen
  push card
  go card "About the number calculator"
end mouseUp
      cyan      E             	        Dates Ux   Xon mouseUp
  lock screen
  push card
  go card "About the date calculator"
end mouseUp
      cyan    T  4             	        Times Ux   Xon mouseUp
  lock screen
  push card
  go card "About the time calculator"
end mouseUp
      cyan      8             	        Measure Ux   Won mouseUp
  lock screen
  push card
  go card "About the LVW calculator"
end mouseUp
      cyan      H             	        	Currency Ux   \on mouseUp
  lock screen
  push card
  go card "about the currency calculator"
end mouseUp
      cyan     H             	           K           X          K        `             K           j    
  ! index  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Help  About the Currency calculator  About the Date calculator  About the LVW calculator  About the Number calculator  About the Time calculator  Adjusting the Date  Background Color  Button Colors  Default Settings  Font...  Help  Highlight Color  Preferences  	Printing  Quit  
Registration  Save  Save As...  Universal Calculator       	`    @ ` Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    reindex & sort Epuon mouseUp
  put empty into field "index"
  repeat with i = 1 to the number of cards
    if char 1 of field "main" of card i is not "x" then
      put line 1 of field "main" of card i & return after field "index"
      set the name of card i to line 1 of field "main" of card i 
    end if
  end repeat
  delete last char of field "index"
  sort field "index"
end mouseUp
          `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
        D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
         ` 8             	           K        	  H          K        Q  9          K          L          K         I          K          <     