/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.util.Ascii;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.MessageBytes;

public class MessageString
extends MessageBytes {
    protected String str;

    public MessageString() {
    }

    public MessageString(String s) {
        this.str = s;
    }

    public MessageString(byte[] b, int off, int len) {
        super(b, off, len);
    }

    public boolean equals(String s) {
        return this.str != null ? this.str.equals(s) : super.equals(s);
    }

    public boolean equals(byte[] b, int off, int len) {
        if (this.str != null) {
            String s = this.str;
            if (len != s.length()) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (b[off++] != s.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(b, off, len);
    }

    public boolean equalsIgnoreCase(String s) {
        return this.str != null ? this.str.equalsIgnoreCase(s) : super.equalsIgnoreCase(s);
    }

    public boolean equalsIgnoreCase(byte[] b, int off, int len) {
        if (this.str != null) {
            String s = this.str;
            if (len != s.length()) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (Ascii.toLower(b[off++]) != Ascii.toLower(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equalsIgnoreCase(b, off, len);
    }

    public int getBytes(byte[] buf, int buf_offset) {
        if (this.str != null) {
            int len = this.str.length();
            byte[] strBytes = this.str.getBytes();
            System.arraycopy(strBytes, 0, buf, buf_offset, len);
            return len;
        }
        return super.getBytes(buf, buf_offset);
    }

    public boolean isSet() {
        return this.str != null || super.isSet();
    }

    public int length() {
        return this.str != null ? this.str.length() : super.length();
    }

    public void reset() {
        super.reset();
        this.str = null;
    }

    public void setBytes(byte[] b, int off, int len) {
        super.setBytes(b, off, len);
        this.str = null;
    }

    public void setString(String s) {
        super.reset();
        this.str = s;
    }

    public boolean startsWith(String s) {
        return this.str != null ? this.str.startsWith(s) : super.startsWith(s);
    }

    public long toDate(HttpDate d) throws IllegalArgumentException {
        if (this.str != null) {
            d.parse(this.str);
            return d.getTime();
        }
        return super.toDate(d);
    }

    public int toInteger() throws NumberFormatException {
        return this.str != null ? Integer.parseInt(this.str) : super.toInteger();
    }

    public String toString() {
        return this.str != null ? this.str : super.toString();
    }

    public void write(ServletOutputStream out) throws IOException {
        if (this.str != null) {
            out.print(this.str);
        } else {
            super.write((OutputStream)out);
        }
    }
}

