/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.SessionManager;
import org.apache.tomcat.session.ApplicationSession;
import org.apache.tomcat.session.Reaper;
import org.apache.tomcat.session.ServerSession;
import org.apache.tomcat.util.SessionIdGenerator;
import org.apache.tomcat.util.StringManager;

public class ServerSessionManager
implements SessionManager {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.session");
    private static ServerSessionManager manager = new ServerSessionManager();
    protected int inactiveInterval = -1;
    private Hashtable sessions = new Hashtable();
    private Reaper reaper = Reaper.getReaper();

    private ServerSessionManager() {
        this.reaper.setServerSessionManager(this);
        this.reaper.start();
    }

    public void accessed(Context ctx, Request req, String id) {
        ApplicationSession apS = (ApplicationSession)this.findSession(ctx, id);
        if (apS == null) {
            return;
        }
        ServerSession servS = apS.getServerSession();
        servS.accessed();
        apS.accessed();
        req.setSession(apS);
    }

    public HttpSession createSession(Context ctx) {
        String sessionId = SessionIdGenerator.generateId();
        ServerSession session = new ServerSession(sessionId);
        this.sessions.put(sessionId, session);
        if (this.inactiveInterval != -1) {
            session.setMaxInactiveInterval(this.inactiveInterval);
        }
        return session.getApplicationSession(ctx, true);
    }

    public HttpSession findSession(Context ctx, String id) {
        ServerSession sSession = (ServerSession)this.sessions.get(id);
        if (sSession == null) {
            return null;
        }
        return sSession.getApplicationSession(ctx, false);
    }

    public static ServerSessionManager getManager() {
        return manager;
    }

    synchronized void reap() {
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ServerSession session = (ServerSession)this.sessions.get(key);
            session.reap();
            session.validate();
        }
    }

    synchronized void removeSession(ServerSession session) {
        String id = session.getId();
        session.invalidate();
        this.sessions.remove(id);
    }

    public void removeSessions(Context context) {
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ServerSession session = (ServerSession)this.sessions.get(key);
            ApplicationSession appSession = session.getApplicationSession(context, false);
            if (appSession == null) continue;
            appSession.invalidate();
        }
    }

    public void setSessionTimeOut(int minutes) {
        if (minutes != -1) {
            this.inactiveInterval = minutes * 60;
        }
    }
}

