/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.tomcat.core.ResponseImpl;

public class HttpResponseAdapter
extends ResponseImpl {
    protected OutputStream sout;
    protected StringBuffer statusSB = new StringBuffer();
    protected StringBuffer headersSB = new StringBuffer();
    static final byte[] CRLF = new byte[]{13, 10};

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        this.sout.write(buffer, pos, count);
    }

    public void endHeaders() throws IOException {
        super.endHeaders();
        this.sendStatus(this.status, ResponseImpl.getMessage(this.status));
        Enumeration e = this.headers.names();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] values = this.headers.getHeaders(name);
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                this.headersSB.setLength(0);
                this.headersSB.append(name).append(": ").append(value).append("\r\n");
                this.sout.write(this.headersSB.toString().getBytes("8859_1"));
                ++i;
            }
        }
        this.sout.write(CRLF, 0, 2);
        this.sout.flush();
    }

    public void recycle() {
        this.sout = null;
        this.statusSB.setLength(0);
        this.headersSB.setLength(0);
    }

    protected void sendStatus(int status, String message) throws IOException {
        this.statusSB.append("HTTP/1.0 ").append(status);
        if (message != null) {
            this.statusSB.append(" ").append(message);
        }
        this.statusSB.append("\r\n");
        this.sout.write(this.statusSB.toString().getBytes("8859_1"));
        this.statusSB.setLength(0);
    }

    public void setOutputStream(OutputStream os) {
        this.sout = os;
    }
}

