/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.objectserver;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.distribution.ServerConsole;
import org.nakedobjects.utility.ConfigurationParameters;

public class AWTConsole
extends Frame
implements ServerConsole {
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$objectserver$AWTConsole == null ? (class$org$nakedobjects$objectserver$AWTConsole = AWTConsole.class$("org.nakedobjects.objectserver.AWTConsole")) : class$org$nakedobjects$objectserver$AWTConsole));
    public static final String WIDTH = "nakedobjects.awt-console.width";
    public static final String HEIGHT = "nakedobjects.awt-console.height";
    public static final int DEFAULT_WIDTH = 600;
    public static final int DEFAULT_HEIGHT = 350;
    private Server server;
    private TextArea log;
    private Button quit;
    private ActionListener buttonAction;
    static /* synthetic */ Class class$org$nakedobjects$objectserver$AWTConsole;

    public AWTConsole() {
        super("Object Server Console");
        this.buildGUI();
        this.show();
    }

    private void addButtons() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 0, 10, 0));
        this.add((Component)panel, "South");
        Button button = new Button("Blank");
        panel.add(button);
        this.buttonAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTConsole.this.clearLog();
            }
        };
        button.addActionListener(this.buttonAction);
        button = new Button("Classes");
        panel.add(button);
        this.buttonAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTConsole.this.listClasses();
            }
        };
        button.addActionListener(this.buttonAction);
        button = new Button("Cache");
        panel.add(button);
        this.buttonAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTConsole.this.listCachedObjects();
            }
        };
        button.addActionListener(this.buttonAction);
        button = new Button("C/Cache");
        panel.add(button);
        this.buttonAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTConsole.this.clearCache();
            }
        };
        button.addActionListener(this.buttonAction);
        this.quit = new Button("Quit");
        panel.add(this.quit);
        this.buttonAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWTConsole.this.quit();
            }
        };
        this.quit.addActionListener(this.buttonAction);
    }

    private void buildGUI() {
        this.log = new TextArea();
        this.add(this.log);
        this.addButtons();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension();
        Insets insets = this.getInsets();
        dimension2.width = ConfigurationParameters.getInstance().getInteger(WIDTH, 600);
        dimension2.height = ConfigurationParameters.getInstance().getInteger(HEIGHT, 350);
        Rectangle rectangle = new Rectangle(dimension2);
        rectangle.x = dimension.width - dimension2.width - insets.right;
        rectangle.y = 0 + insets.top;
        ((Component)this).setBounds(rectangle);
    }

    private void clearCache() {
        this.server.getObjectStore().clearCache();
    }

    private void clearLog() {
        this.log.setText("");
    }

    public void close() {
        this.dispose();
    }

    public void init(Server server) {
        this.server = server;
        this.log("Console in control of " + server);
    }

    private void listCachedObjects() {
        Enumeration enumeration = this.server.getObjectStore().cache();
        this.log("Cached objects:-");
        while (enumeration.hasMoreElements()) {
            NakedObject nakedObject = (NakedObject)enumeration.nextElement();
            this.log("  " + nakedObject.getClassName() + "[" + (nakedObject.isResolved() ? "" : "~") + nakedObject.getOid() + "] " + nakedObject.title());
        }
        this.log();
    }

    private void listClasses() {
        try {
            Enumeration enumeration = this.server.getObjectStore().classes();
            this.log("Loaded classes:-");
            while (enumeration.hasMoreElements()) {
                NakedClass nakedClass = (NakedClass)enumeration.nextElement();
                this.log("  " + nakedClass);
            }
            this.log();
        }
        catch (ObjectStoreException objectStoreException) {
            LOG.error((Object)("Error listing classes " + objectStoreException.getMessage()));
        }
    }

    public void log() {
        this.log.append("\n");
    }

    public void log(String string) {
        this.log.append(string + '\n');
        LOG.info((Object)string);
    }

    public void quit() {
        this.server.shutdown();
        this.close();
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

