/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.Server;

class IsLastInstanceRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private NakedObject pattern;
    private Object from;

    public IsLastInstanceRequest(NakedObject nakedObject, NakedObject nakedObject2) {
        this.pattern = nakedObject;
        this.from = nakedObject2.getOid();
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            NakedObject nakedObject = nakedObjectStore.getObject(this.from);
            this.response = new Boolean(nakedObjectStore.isLastInstance(this.pattern, nakedObject));
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public boolean isFirst() throws ObjectStoreException {
        this.sendRequest();
        return (Boolean)this.response;
    }

    public String toString() {
        return "Is first instance [pattern=" + this.pattern + ",test=" + this.from + "]";
    }
}

