/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.collection;

import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.collection.AbstractNakedCollection;
import org.nakedobjects.object.control.Allow;
import org.nakedobjects.object.control.Permission;
import org.nakedobjects.object.control.Veto;

public abstract class TypedCollection
extends AbstractNakedCollection {
    private Class type;

    public TypedCollection(Class clazz) {
        this.type = clazz;
    }

    public Class getType() {
        return this.type;
    }

    public String type() {
        return NakedClass.getNakedClass(this.type).getName();
    }

    public Permission canAdd(NakedObject nakedObject) {
        if (this.contains(nakedObject)) {
            return new Veto("Collection cannot have duplicate objects");
        }
        if (this.getType().isAssignableFrom(nakedObject.getClass())) {
            return Allow.DEFAULT;
        }
        return new Veto("Object cannot be added because it is not of the type " + this.getType().getName());
    }

    public Permission canRemove(NakedObject nakedObject) {
        if (this.contains(nakedObject)) {
            return Allow.DEFAULT;
        }
        return Veto.DEFAULT;
    }
}

