// winbmp.c by Bill Buckels 1994
// a limited function windows bmp file editor

// Project Notes:
// ==============

// Compiler Notes:
// ===============

// Microsoft C Compiler 6.00A - Compiled in the Large Memory Model
// Microsoft Linker 5.13
// Microsoft Resource Compiler 3.10
// Microsoft Windows SDK Version 3.1
// Microsoft Help Compiler 3.10.505

// The version of nmake that I am using reported compiler out of
// heap space when I attempted to build winbmp. I produced the program
// using a batch file called WinMake.Bat to work around my problem.

// Bugs:
// =====

// The Rectangle Areas are a potential for problems with
// different display resolutions and window styles.
// Everything lines up fine on my Windows, but border styles may
// affect the matrix calculations and there may be
// rounding errors if your windows runs differently from mine.

// There will always be bugs.

// History :
// =========

// WinBmp was initially developed to convert MS-DOS text screens
// to bmp files. An earlier application similar to winbmp called
// winimg was originally written to convert text screens to the
// GEM .IMG image format for use with Ventura Publisher.

// I later rewrote WinImg to save
// .BMP format images and called the new application WinBmp.
// The name is not very imaginative but it is easy to remember.

// WinBmp then evolved between my own ideas for increased
// functionality and requests by my only other user, a
// programmer by the name of Ray Pattison, who used WinImg and its
// MS-DOS companion frame grabber GRABSV extensively for producing
// documentation.

// It also became clear to me during the final stages of writing WinBmp
// that Windows is capable of pretty competent MS-DOS screen
// aquisitions simply using the Clipboard Services.

// As I added clipboard and text file support to WINBMP, I also
// realized that an additional application
// was needed to provide support in Windows for MS-DOS text editing.
// The MS-DOS character set is usually not used in Windows and this
// has created problems when documenting changes to MS-DOS screens.

// Reports containing printer control characters were also a problem
// and cannot be properly represented without cleanup.

// WinBmp's size limitation of a single MS-DOS screen did not lend
// itself to adapt readily to text editing.

// In fact, WinBmp had reached the End of the Road, and with the exception
// of the features added for this version, probably can go no further.

// The Text Editor for MS-DOS text that resulted out of the things
// that WinBmp cannot be is called WinOem. There is some duplication in
// functionality between WinBmp and WinOem, but each has its own special
// Task. I have said almost all I want to at this time about WinOem.

// Summary of Added Features for WinBmp Version 2.0
// ================================================

// This version of Winbmp uses an 8 x 16 OEM style internal raster font
// which it expands to 8 x 19 to convert text or BSAVED images to
// windows bitmap files with a more or less corrected aspect ratio
// to approximate what we expect to see in DOS.

// Version 2 also allows text to be pasted from the Windows Clipboard
// which lets DOS Screen Text copied to the clipboard
// from a DOS window be converted to Monochrome BITMAPs.

// This version also allows bitmaps to be pasted to the clipboard
// for export to applications like Windows Write.

// A color title image is converted from a text screen and
// displayed during Startup and About WinBmp. This color feature
// is not altogether superfluous as the functionality to display
// BSVAVED screen-grabs in color can also be used with the Windows
// clipboard to produce a color bitmap of the MS-DOS screen which
// looks more accurate than what Windows usually provides.

// For Use During MARK FRAGMENT Mode...

// A text entry dialog has been added and support for extended
// OEM character entry through the F1-F10 Function Keys has also
// been added.

// Colored Screens were added to distinguish the difference
// between Reversing an Area permanently and Marking an area.
// When neither function is active, the screen is white.
// When marking an area, the screen is blue.
// When Reversing an area, the screen is yellow.
// This works around Ray's complaint that groups of cells could
// not be reversed.

// Much of the Data that was in the program in earlier versions
// has been moved into the resource file. This may not mean a
// to the user, but it makes the program easier to read for me.

// The code has also been cleaned-up alot for version 2
// but there is still alot of standard C used
// and of course alot of room for improvement.

// These notes are not complete by any means. I am sorry if I missed
// something that is important to you.

// Summary of Added Features for WinBmp Version 3.0
// ================================================

// Added PTX Support
// Added CLIPBOARD Aquisition of Color MS-DOS Screens
// Enabled Moving of Window (Previously it was fixed on center.)

#include <windows.h>
#include <mmsystem.h>
#include <commdlg.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <stdarg.h>
#include "winbmp.h"

HDC    hdcMine;                   // global device context
HICON  myicon;
HANDLE hInst;                     // instance handle
char lpszDialogBuf[INPUTSIZE];    // user's input buffer

// RCDATA resource handles
// title screen
LPSTR   lpMyTitle;
HRSRC   hMyTitleloc;
HGLOBAL hMyTitleRes;

// conversion font
LPSTR   lpMyFont;
HRSRC   hMyFontloc;
HGLOBAL hMyFontRes;

// keycode substitution resource
HRSRC   hMyFastloc;
HGLOBAL hMyFastRes;

// the 8 x 16 OEM character set bitmaps
typedef struct{
    unsigned char b[256][F_HEIGHT];
}RAMFONT;
RAMFONT far *lpRamFont;

// the FastKeys keyboard codes
typedef struct{
    unsigned char b[12][10];
}FASTKEYS;
FASTKEYS far *lpFastKeys;

unsigned char cbBuffer[4001];                   // global file read buffer

// re: MYBITMAPINFO
// a structure for a static bitmap header of 2 colors
// we approach this rgb quad reference in two different ways here
// either this way... where we say specifically what we want
// by creating a new type with enough room to store the extra 4 bytes
// that we need to store color number 2
typedef struct tagMYBITMAPINFO
{
    BITMAPINFOHEADER bmiHeader;
    RGBQUAD          bmiColors[2];
} MYBITMAPINFO;

// re: VGABITMAPINFO
// a structure for a static bitmap header of 16 colors
typedef struct
{
    BITMAPINFOHEADER bmiHeader;
    RGBQUAD          bmiColors[16];
} VGABITMAPINFO;


BITMAPFILEHEADER bmfhead;
MYBITMAPINFO     bmp;
VGABITMAPINFO    vga;

// re: LPBITMAPINFOHEADER lpbi, lpbcolor
// or in the case if the dynamically allocated versions of this
// where we allocate past the end of the structure
LPBITMAPINFOHEADER lpbi;
unsigned char far *lpinfo;

LPBITMAPINFOHEADER lpbcolor;
unsigned char far *lpColorInfo;

// BITMAP data to copy to the clipboard
HANDLE hData = NULL;
LPSTR  lpData;
LONG   dwDataSize;
BYTE huge *hpBmpBuffer;       // pointer to the image block

// Text data to copy from the clipboard
HANDLE hClipData;                 // handle to clip data
LPSTR  lpClipData;                // pointer to clip data

// directory list globals
char szCustFilterSpec[MAXCUSTFILTER];     // custom filter buffer
OPENFILENAME ofn;                         // struct. passed to GetOpenFileName
static char PathName[128] = "\0";         // ofn global
static char FileName[128] = "\0";         // ofn global

// filter string for dir. listings
char far *szFilterSpec;

// filter string variables for different types of filename dialogs

static char szAnySpec[128]
          = "Bsaved Screens(*.BSV)\0*.BSV\0"
            "BMP Files(*.BMP)\0*.BMP\0"
            "Any Old Files(*.*)\0*.*\0";

static char szTxtSpec[128]
          = "Text Files(*.Txt)\0*.Txt\0"
            "Any Old Files(*.*)\0*.*\0";

static char szBmpSpec[128]
          = "BMP Files(*.BMP)\0*.BMP\0";

static char szBsvSpec[128]
          = "BSaved Screens(*.BSV)\0*.BSV\0"
            "Ptx Screens(*.PTX)\0*.PTX\0"
            "Any Old Files(*.*)\0*.*\0";

static char szPtxSpec[128]
          = "Ptx Screens(*.PTX)\0*.PTX\0"
            "BSaved Screens(*.BSV)\0*.BSV\0"
            "Any Old Files(*.*)\0*.*\0";

// command status strings for menu title
static char szOLDTEXT[67]="\0";
char *lpNONE    ="WINBMP Copyright \251 Bill Buckels 1994-1999";
char *lpLOAD    ="Loading Bitmap...";
char *lpSAVE    ="Saving Bitmap...";
char *lpCONVERT ="Converting Text Screen...";
char *lpIMPORT  ="Importing BSaved Image...";
char *lpDELETE  ="Deleting files...";
char *lpPASTE   ="Pasting Text from Clipboard...";
char *lpCOPY    ="Copying Bitmap to Clipboard...";
char *lpCLIP    ="Marking Fragment Area...";
char *lpREVERSE ="Reversing Cells In Bitmap...";
char *lpCOLOR   ="Displaying BSAVED Image in Color...";
char *lpABOUT   ="About WINBMP Copyright \251 Bill Buckels 1994-1999";
char *lpHELP    ="Displaying WINBMP Help...";
char *lpLICENCE ="Displaying WINBMP Licencing Agreement...";


char *lpRegister =
"WINBMP Version 3.0\n"
"Copyright \251 Bill Buckels 1994-1999.\n"
"A Special Purpose monochrome BMP File Editor.\n\n"
"WINMP is distributed as ShareWare. Registration is $10.00 per computer. "
"You must register with the Author after 30 days, or you must remove "
"WINBMP and all associated files from your computer. Send registration in "
"the form of cheque or money order to:\n\n"
"\t\tBill Buckels\n"
"\t\t589 Oxford Street\n"
"\t\tWinnipeg, Manitoba, Canada R3M 3J2\n\n"
"Email: bbuckels@escape.ca\n"
"WebSite: http://www.escape.ca/~bbuckels\n\n"
"Distribution of this program for profit without the express permission "
"of the author is not permitted.";

// Global Flags For Editing Functions
BOOL TITLED      =FALSE;
BOOL STARTED     =FALSE;
BOOL COLORMODE   =FALSE;
BOOL BSVMODE     =FALSE;
BOOL REVERSEMODE =FALSE;
BOOL CLIPMODE    =FALSE;
BOOL CLIPSTART   =FALSE;
BOOL CLIPMOVE    =FALSE;
BOOL HELPACTIVE  =FALSE;

HANDLE hAccTable;                        // handle to accelerator table

HBITMAP hMenuBitmap0;
HBITMAP hMenuBitmap1;
HBITMAP hMenuBitmap2;
HBITMAP hMenuBitmap3;
HBITMAP hMenuBitmap4;
HBITMAP hMenuBitmap5;
HBITMAP hMenuBitmap6;
HBITMAP hMenuBitmap7;
HBITMAP hMenuBitmap8;
HBITMAP hMenuBitmap9;
HBITMAP hMenuBitmap10;
HBITMAP hMenuBitmap11;
HBITMAP hMenuBitmap12;

WPARAM  IDM_CURRENTBMP=IDM_BITMAP1;

// global metric variables for graphics editing functions
int xborder=0,yborder=0;
int startx=0,starty=0,endx=0,endy=0;
RECT newrect, oldrect, temprect;

unsigned char bsvtest[4000]; // buffer used when loading .BSV and .PTX files

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
    {
    HWND        hWnd;
    MSG         msg ;
    WNDCLASS    wc ;
    WORD        wParam;
    int x1=0,y1=0,yfactor;
    int xwidth,yheight;

    hInst = hInstance;

    if (!hPrevInstance)
          {
          myicon=LoadIcon(hInst, "MyIcon");
          wc.style         = CS_HREDRAW | CS_VREDRAW ;
          wc.lpfnWndProc   = WndProc ;
          wc.cbClsExtra    = 0 ;
          wc.cbWndExtra    = 0 ;
          wc.hInstance     = hInstance;
          wc.hIcon         = myicon;
          wc.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wc.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wc.lpszMenuName  = "WINBMP" ;
          wc.lpszClassName = "WINBMP" ;

          RegisterClass (&wc) ;
    }

    // center the svga display
    xwidth=GetSystemMetrics(SM_CXSCREEN);
    yheight=GetSystemMetrics(SM_CYSCREEN);

    xborder=GetSystemMetrics(SM_CXBORDER)*2;
    if(xwidth>BMP_MAXX)x1= (xwidth-BMP_MAXX)/2 -xborder;
    xwidth=BMP_MAXX+xborder+xborder;
    xborder/=2;

    yborder = GetSystemMetrics(SM_CYBORDER)*2;
    yfactor = GetSystemMetrics(SM_CYCAPTION);
    if(yheight>VGA_MAXY)y1=(yheight-BMP_MAXY)/2 -yborder-yfactor;
    yheight= BMP_MAXY+yborder+yfactor+yfactor;
    yborder/=2;

    hAccTable = LoadAccelerators(hInst, "WinBmpAcc");


    hWnd = CreateWindow ("WINBMP", lpNONE,
              WS_MAXIMIZE|WS_MINIMIZEBOX|
              WS_CAPTION|WS_POPUPWINDOW,
              x1,y1,
              xwidth,yheight,
              NULL, NULL, hInstance, NULL) ;

    if(wParam=GetSystemMenu(hWnd,FALSE))
            {

// Allow them to move the window
//              DeleteMenu(wParam, SC_MOVE,        MF_BYCOMMAND);

              DeleteMenu(wParam, SC_SIZE,        MF_BYCOMMAND);
              DeleteMenu(wParam, SC_RESTORE,     MF_BYCOMMAND);
              DeleteMenu(wParam, SC_NEXTWINDOW,  MF_BYCOMMAND);
              DeleteMenu(wParam, SC_PREVWINDOW,  MF_BYCOMMAND);
            }

    hdcMine=GetDC(hWnd);
    ShowWindow (hWnd, nCmdShow) ;
    UpdateWindow (hWnd) ;
    InitPic(hInstance);

    while (GetMessage(&msg, NULL, 0, 0))
       {
         if (!TranslateAccelerator(hWnd, hAccTable, &msg))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg); 
            }
        }

    FreePic(hInstance);
    ReleaseDC(hWnd,hdcMine);

    return msg.wParam ;
}

long far PASCAL WndProc (HWND hWnd, WORD message, WORD wParam, LONG lParam)
{

       // WndProc contains the menu and mouse handling methods
       // The Command Messages Are Processed with command handlers

       PAINTSTRUCT ps;
       unsigned mx, my;
       HMENU hMenu;
       WORD wFastSet, wFastChar;
       unsigned char c;


     switch (message)
	  {

            case WM_CREATE:

            hMenu = CreateMenu();
            // Use bitmaps for menu items
            hMenuBitmap0  = LoadBitmap(hInst, "own0");
            hMenuBitmap1  = LoadBitmap(hInst, "own1");
            hMenuBitmap2  = LoadBitmap(hInst, "own2");
            hMenuBitmap3  = LoadBitmap(hInst, "own3");
            hMenuBitmap4  = LoadBitmap(hInst, "own4");
            hMenuBitmap5  = LoadBitmap(hInst, "own5");
            hMenuBitmap6  = LoadBitmap(hInst, "own6");
            hMenuBitmap7  = LoadBitmap(hInst, "own7");
            hMenuBitmap8  = LoadBitmap(hInst, "own8");
            hMenuBitmap9  = LoadBitmap(hInst, "own9");
            hMenuBitmap10 = LoadBitmap(hInst, "own10");
            hMenuBitmap11 = LoadBitmap(hInst, "own11");
            hMenuBitmap12 = LoadBitmap(hInst, "own12");
            AppendMenu(hMenu, MF_BITMAP|MF_DISABLED,IDM_BITMAP0,
                       (LPSTR)(LONG) hMenuBitmap0);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP1,
                       (LPSTR)(LONG) hMenuBitmap1);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP2,
                       (LPSTR)(LONG) hMenuBitmap2);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP3,
                       (LPSTR)(LONG) hMenuBitmap3);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP4,
                       (LPSTR)(LONG) hMenuBitmap4);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP5,
                       (LPSTR)(LONG) hMenuBitmap5);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP6,
                       (LPSTR)(LONG) hMenuBitmap6);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP7,
                       (LPSTR)(LONG) hMenuBitmap7);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP8,
                       (LPSTR)(LONG) hMenuBitmap8);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP9,
                       (LPSTR)(LONG) hMenuBitmap9);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP10,
                       (LPSTR)(LONG) hMenuBitmap10);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP11,
                       (LPSTR)(LONG) hMenuBitmap11);
            AppendMenu(hMenu, MF_BITMAP, IDM_BITMAP12,
                       (LPSTR)(LONG) hMenuBitmap12);


            ModifyMenu(GetMenu(hWnd),2, MF_POPUP | MF_BYPOSITION,
                       (WORD) hMenu, "Fast &Keys");
            CheckMenuItem(GetMenu(hWnd), IDM_CURRENTBMP, MF_CHECKED);
            return 0L;;

         case WM_SYSCOMMAND :

                      // moving of window is not allowed
// Allow them to move the window
//                      if((wParam &0xfff0)==SC_MOVE)return 0L;
                      if((wParam &0xfff0)==SC_MAXIMIZE)return MyPaintMethod();
                      break;

         case WM_INITMENU:

             // enable and disable menu commands relative to the
             // current editing activity and program status
             if (wParam == GetMenu(hWnd))
             {
                if (OpenClipboard(hWnd))
                 {
                     // allow pasting of text only if text is available
                     if (IsClipboardFormatAvailable(CF_TEXT)  ||
                         IsClipboardFormatAvailable(CF_OEMTEXT))
                         EnableMenuItem(wParam, IDM_PASTE, MF_ENABLED);
                     else
                         EnableMenuItem(wParam, IDM_PASTE, MF_GRAYED);
                     CloseClipboard();

                 }
                if (STARTED!=TRUE)
                 {
                    // if we haven't started yet editing is disabled
                    EnableMenuItem(wParam, IDM_REVERSE, MF_GRAYED);
                    EnableMenuItem(wParam, IDM_ENTRY,   MF_GRAYED);
                    EnableMenuItem(wParam, IDM_SAVE,    MF_GRAYED);
                    EnableMenuItem(wParam, IDM_COLOR,   MF_GRAYED);
                    EnableMenuItem(wParam, IDM_CLIP,    MF_GRAYED);
                    EnableMenuItem(wParam, IDM_COPY,    MF_GRAYED);

                 }
                 else
                 {
                    // if a color image is being displayed
                    // editing is turned off
                    if(COLORMODE == TRUE)
                    {
                     EnableMenuItem(wParam, IDM_COLOR,   MF_ENABLED);
                     CheckMenuItem(wParam,  IDM_COLOR,   MF_CHECKED);
                     EnableMenuItem(wParam, IDM_LOAD,    MF_GRAYED);
                     EnableMenuItem(wParam, IDM_SAVE,    MF_GRAYED);
                     EnableMenuItem(wParam, IDM_IMPORT,  MF_GRAYED);
                     EnableMenuItem(wParam, IDM_PTX,     MF_GRAYED);
                     EnableMenuItem(wParam, IDM_CONVERT, MF_GRAYED);
                     EnableMenuItem(wParam, IDM_DELETE,  MF_GRAYED);
//                     EnableMenuItem(wParam, IDM_COPY,    MF_GRAYED);
                     EnableMenuItem(wParam, IDM_PASTE,   MF_GRAYED);
                     EnableMenuItem(wParam, IDM_REVERSE, MF_GRAYED);
                     EnableMenuItem(wParam, IDM_ENTRY,   MF_GRAYED);
                     EnableMenuItem(wParam, IDM_SAVE,    MF_GRAYED);
                     EnableMenuItem(wParam, IDM_CLIP,    MF_GRAYED);
                    }
                    else
                    {
                     EnableMenuItem(wParam, IDM_LOAD,    MF_ENABLED);
                     EnableMenuItem(wParam, IDM_SAVE,    MF_ENABLED);
                     EnableMenuItem(wParam, IDM_IMPORT,  MF_ENABLED);
                     EnableMenuItem(wParam, IDM_PTX,     MF_ENABLED);
                     EnableMenuItem(wParam, IDM_CONVERT, MF_ENABLED);
                     EnableMenuItem(wParam, IDM_DELETE,  MF_ENABLED);
                     EnableMenuItem(wParam, IDM_COPY,    MF_ENABLED);
                     EnableMenuItem(wParam, IDM_REVERSE, MF_ENABLED);
                     EnableMenuItem(wParam, IDM_ENTRY,   MF_ENABLED);
                     EnableMenuItem(wParam, IDM_SAVE,    MF_ENABLED);
                     EnableMenuItem(wParam, IDM_CLIP,    MF_ENABLED);
                     CheckMenuItem(wParam,  IDM_COLOR,   MF_UNCHECKED);

                     // the current editing command is checked when active
                     if(REVERSEMODE==TRUE)
                      CheckMenuItem(wParam, IDM_REVERSE, MF_CHECKED);
                     else
                      CheckMenuItem(wParam, IDM_REVERSE, MF_UNCHECKED);

                     if(CLIPMODE==TRUE)
                      CheckMenuItem(wParam, IDM_CLIP, MF_CHECKED);
                     else
                      CheckMenuItem(wParam, IDM_CLIP, MF_UNCHECKED);

                     if(BSVMODE==TRUE)
                      EnableMenuItem(wParam, IDM_COLOR, MF_ENABLED);
                     else
                      EnableMenuItem(wParam, IDM_COLOR, MF_GRAYED);
                   }
                 }
                 return 0L;
             }
             return (TRUE);

         case WM_LBUTTONUP:

            // we look for left-button-up only when reversing an area
            // since reversing an area is more final than marking it for
            // fragmentation.

            // the reverse operation is done in a single step
            // whereas fragmentation is ongoing until it is turned off
            // or cancelled by another command

                           if( STARTED  !=TRUE  || REVERSEMODE!=TRUE ||
                               CLIPMOVE !=TRUE  || COLORMODE  ==TRUE)break;

                            mx =  LOWORD(lParam);
                            my =  HIWORD(lParam);
                            RectRestore();
                            if(mx < xborder)mx = xborder;
                            if(my < yborder)my = yborder;
                            if(mx > (BUF_MAXX+xborder))mx=BUF_MAXX+xborder;
                            if(my > (BUF_MAXY+yborder))my=BUF_MAXY+xborder;
                            mx -=xborder;
                            my -=yborder;
                            endx=(mx/C_WIDTH)*C_WIDTH+C_ENDWIDTH;
                            endy=(my/C_HEIGHT)*C_HEIGHT+C_ENDHEIGHT;
                            if(endx<=startx || endy<=starty)
                            {
                              RectClear();
                              return 0L;
                            }
                            startx +=xborder;
                            endx   +=xborder;
                            starty +=yborder;
                            endy   +=yborder;
                            my  = starty;
                            for(;;)
                            {
                               mx=startx;
                               for(;;)
                               {

                                 PaintPic(xborder,yborder,mx,my);
                                 mx+=C_WIDTH;
                                 if(mx>endx)break;
                               }
                               my+=C_HEIGHT;
                               if(my>endy)break;
                            }
                            RectClear();
                            return 0L;



         case WM_RBUTTONUP :

            // allow a right button press to release a fragmented area
            // ignore a right button press if reversing a group of cells

            if(CLIPMODE==FALSE || STARTED==FALSE || COLORMODE==TRUE)break;
                            RectRestore();
                            RectClear();
                            return 0L;

         case WM_MOUSEMOVE  :
                             // if we are reversing an area or clipping
                            // an area we dynamically move the reversed box

                            if(STARTED  == FALSE || CLIPSTART == FALSE  ||
                               CLIPMOVE == FALSE || COLORMODE == TRUE   ||
                              (REVERSEMODE == FALSE && CLIPMODE == FALSE))
                               break;

                            mx =  LOWORD(lParam);
                            my =  HIWORD(lParam);
                            if(mx < xborder)break;
                            if(my < yborder)break;
                            if(mx > (BUF_MAXX+xborder))break;
                            if(my > (BUF_MAXY+yborder))break;
                            mx -=xborder;
                            my -=yborder;
                            endx=(mx/C_WIDTH)*C_WIDTH+C_ENDWIDTH;
                            endy=(my/C_HEIGHT)*C_HEIGHT+C_ENDHEIGHT;
                            if(endx<=startx || endy<=starty)break;
                            RectMove(startx,starty,endx,endy);
                            return 0L;

         case WM_LBUTTONDOWN:
                            if((CLIPMODE==FALSE && REVERSEMODE == FALSE) ||
                                STARTED==FALSE  || COLORMODE == TRUE)break;

                            mx =  LOWORD(lParam);
                            my =  HIWORD(lParam);
                            if(mx < xborder)break;
                            if(my < yborder)break;
                            if(mx > (BUF_MAXX+xborder))break;
                            if(my > (BUF_MAXY+yborder))break;
                            mx -=xborder;
                            my -=yborder;

                            if(CLIPSTART == FALSE)
                              {
                              startx=(mx/C_WIDTH)*C_WIDTH;
                              starty=(my/C_HEIGHT)*C_HEIGHT;
                              endx=startx+C_ENDWIDTH;
                              endy=starty+C_ENDHEIGHT;
                              CLIPSTART = TRUE;
                              CLIPMOVE  = TRUE;
                              RectMove(startx,starty,endx,endy);
                              return 0;
                              }

                            if(REVERSEMODE == TRUE)break;

                            CLIPMOVE = FALSE;
                            endx=(mx/C_WIDTH)*C_WIDTH+C_ENDWIDTH;
                            endy=(my/C_HEIGHT)*C_HEIGHT+C_ENDHEIGHT;
                            if(endx<=startx || endy<=starty)
                            {
                                RectRestore();
                                RectClear();
                                return 0;
                            }
                            RectMove(startx,starty,endx,endy);
                            return 0L;

         case WM_COMMAND:

           // if we are displaying a BSV file in color
           // we suspend image editing and loading until color display
           // is turned off and image editting is restored
           if(COLORMODE == TRUE)
            {
                if(wParam != IDM_COLOR   &&
                   wParam != IDM_ABOUT   &&
                   wParam != IDM_LICENCE &&
                   wParam != IDM_HELP    &&
                   wParam != IDM_COPY    &&
                   wParam != IDM_EXIT)   break;
            }

            // fastkeys selection option
            for(;;)
            {
              if(wParam<IDM_BITMAP1 || wParam>IDM_BITMAP12)break;
              CheckMenuItem(GetMenu(hWnd), IDM_CURRENTBMP, MF_UNCHECKED);
              IDM_CURRENTBMP = wParam;
              CheckMenuItem(GetMenu(hWnd), IDM_CURRENTBMP, MF_CHECKED);
              return 0L;
            }

            // fastkeys area fill option
            for(;;)
            {
                if(wParam<IDK_FASTSET1 || wParam>IDK_FASTSET10)break;
                wFastSet  = IDM_CURRENTBMP - IDM_BITMAP1;
                wFastChar = wParam         - IDK_FASTSET1;
                c=lpFastKeys[0].b[wFastSet][wFastChar];
                MyFastEntry(hWnd,c);
                return 0L;
            }

           // command message handler switch
           switch(wParam)
            {

                case IDM_ENTRY  : return MyEntry(hWnd);
                case IDM_LOAD   : return MyLoad(hWnd);
                case IDM_SAVE   : return MySave(hWnd);
                case IDM_IMPORT :
                case IDM_PTX    :
                                  return MyImport(hWnd, wParam);
                case IDM_CONVERT: return MyConvert(hWnd);
                case IDM_DELETE : return MyDelete(hWnd);
                case IDM_EXIT   : DestroyWindow(hWnd);     return 0L;
                case IDM_PASTE  : if(MyPaste(hWnd))break;  return 0L;
                case IDM_CLIP   : return MyClip(hWnd);
                case IDM_REVERSE: return MyReverse(hWnd);
                case IDM_COPY   : if(MyCopy(hWnd))break;   return 0L;
                case IDM_COLOR  : return MyColor(hWnd);
                case IDM_ABOUT  : return MyAbout(hWnd);
                case IDM_LICENCE: return MyLicence(hWnd);
                case IDM_HELP   : return MyHelp(hWnd);
            }
           break;

        case WM_PAINT:

           BeginPaint(hWnd,&ps);
           MyPaintMethod();
           EndPaint(hWnd,&ps);
           return 0L;

        case WM_DESTROY:

           if(HELPACTIVE!=FALSE)WinHelp(hWnd,"WINBMP.HLP",HELP_QUIT,0L);
           HELPACTIVE = FALSE;
            DeleteObject(hMenuBitmap0);
            DeleteObject(hMenuBitmap1);
            DeleteObject(hMenuBitmap2);
            DeleteObject(hMenuBitmap3);
            DeleteObject(hMenuBitmap4);
            DeleteObject(hMenuBitmap5);
            DeleteObject(hMenuBitmap6);
            DeleteObject(hMenuBitmap7);
            DeleteObject(hMenuBitmap8);
            DeleteObject(hMenuBitmap9);
            DeleteObject(hMenuBitmap10);
            DeleteObject(hMenuBitmap11);
            DeleteObject(hMenuBitmap12);
           PostQuitMessage (0);
           return 0L;
          }

     return DefWindowProc (hWnd, message, wParam, lParam) ;
}


int InitPic(HANDLE hInstance)
{
    unsigned char vgapalette[]={
        0x00, 0x00, 0x00,
        0x00, 0x00, 0xAA,
        0x00, 0xAA, 0x00,
        0x00, 0xAA, 0xAA,
        0xAA, 0x00, 0x00,
        0xAA, 0x00, 0xAA,
        0xAA, 0xAA, 0x00,
        0xAA, 0xAA, 0xAA,
        0x55, 0x55, 0x55,
        0x55, 0x55, 0xFF,
        0x55, 0xFF, 0x55,
        0x55, 0xFF, 0xFF,
        0xFF, 0x55, 0x55,
        0xFF, 0x55, 0xFF,
        0xFF, 0xFF, 0x55,
        0xFF, 0xFF, 0xFF};

    unsigned mysize,i,j,k;
    unsigned long *templong;
    unsigned char *cbuf, *dbuf;

    mysize=sizeof(BITMAPINFOHEADER);
    lpbi=malloc(mysize+MONOMAP);
    memset(lpbi,0,mysize+MONOMAP);

    lpinfo=malloc(BUFPAD_MAXY*INPUTSIZE);              // the image buffer
    memset(lpinfo,0x00,(unsigned)BUFPAD_MAXY*INPUTSIZE);

    lpbi[0].biSize=40L;
    lpbi[0].biWidth= BMP_MAXX;
    lpbi[0].biHeight=BMP_MAXY;
    lpbi[0].biPlanes=1;
    lpbi[0].biBitCount=1;
    lpbi[0].biCompression=BI_RGB;
    lpbi[0].biSizeImage=(DWORD)INPUTSIZE*BMP_MAXY;
    lpbi[0].biClrUsed=2;

    cbuf=(char *)(&lpbi[0].biSize);
    templong=(unsigned long *)&cbuf[mysize];           // color table
    templong[1]=(unsigned long)255<<16|255<<8|255;     // white background

    lpbcolor=malloc(mysize+64);
    lpColorInfo=malloc(BMP_MAXX);

    vga.bmiHeader.biSize=lpbcolor[0].biSize=40L;
    vga.bmiHeader.biWidth=lpbcolor[0].biWidth=BMP_MAXX;
    lpbcolor[0].biHeight=1;
    vga.bmiHeader.biHeight=BMP_MAXY;
    vga.bmiHeader.biPlanes=lpbcolor[0].biPlanes=1;
    vga.bmiHeader.biBitCount=lpbcolor[0].biBitCount=4;
    vga.bmiHeader.biCompression=lpbcolor[0].biCompression=BI_RGB;
    lpbcolor[0].biSizeImage=(DWORD)320;
    vga.bmiHeader.biSizeImage=(DWORD)320L*BMP_MAXY;
    vga.bmiHeader.biXPelsPerMeter=lpbcolor[0].biXPelsPerMeter=0;
    vga.bmiHeader.biYPelsPerMeter=lpbcolor[0].biYPelsPerMeter=0;
    vga.bmiHeader.biClrUsed=lpbcolor[0].biClrUsed=16;
    vga.bmiHeader.biClrImportant=lpbcolor[0].biClrImportant=0;

    // Set-up a standard 16 color palette
    cbuf=(char *)(&lpbcolor[0].biSize);
    dbuf=(unsigned char *)&cbuf[mysize];
    j=0;
    k=0;
    for(i=0;i<16;i++)
        {
        vga.bmiColors[i].rgbReserved = dbuf[k+3] = 0;
        vga.bmiColors[i].rgbRed      =dbuf[k+2] = vgapalette[j++];   // red
        vga.bmiColors[i].rgbGreen    =dbuf[k+1] = vgapalette[j++];   // green
        vga.bmiColors[i].rgbBlue     =dbuf[k]   = vgapalette[j++];   // blue
        k+=4;
        }

    if(hMyFontloc=FindResource(hInstance,"MYFONT",RT_RCDATA))
     {
        if(hMyFontRes=LoadResource(hInstance,hMyFontloc))
        {
            lpMyFont=LockResource(hMyFontRes);
            lpRamFont = (RAMFONT far *)&lpMyFont[0];
        }
     }
     RectClear();
     if(hMyTitleloc=FindResource(hInstance,"MYSCREEN",RT_RCDATA))
     {
        if(hMyTitleRes=LoadResource(hInstance,hMyTitleloc))
        {
             lpMyTitle=LockResource(hMyTitleRes);
        }
     }

    if(hMyFastloc=FindResource(hInstance,"FASTKEYS",RT_RCDATA))
     {
        if(hMyFastRes=LoadResource(hInstance,hMyFastloc))
        {
            lpFastKeys=(FASTKEYS far *)LockResource(hMyFastRes);
        }
     }

     ShowTitle(lpMyTitle, NULL);
     TITLED = TRUE;
     SetCursor(LoadCursor(NULL,IDC_ARROW));
     return 0;
}

int FreePic(HANDLE hInstance)
{
    free(lpColorInfo);
    free(lpbcolor);

    free(lpinfo);
    free(lpbi);

    UnlockResource(hMyTitleRes);
    FreeResource(hMyTitleRes);

    UnlockResource(hMyFontRes);
    FreeResource(hMyFontRes);

    UnlockResource(hMyFastRes);
    FreeResource(hMyFastRes);

    return 0;

}

int InitDialog(HWND hWnd,WORD DirType)
{
    int i;

    // fill in fields of OPENFILENAME struct.
    // depending on what kind of file we are processing

    if(FileName[0] !=0)
    {
      for(i=0;FileName[i]!=0;i++)if(FileName[i]=='.')FileName[i]=0;
    }
    switch(DirType)
    {
        case DIR_TEXT:
                        szFilterSpec=(char far *)&szTxtSpec[0];
                        if(FileName[0]!=0)strcat(FileName,".txt");break;
        case DIR_BMP :
                        szFilterSpec=(char far *)&szBmpSpec[0];
                        if(FileName[0]!=0)strcat(FileName,".bmp");break;
        case DIR_BSV :
                        szFilterSpec=(char far *)&szBsvSpec[0];
                        if(FileName[0]!=0)strcat(FileName,".bsv");break;
        case DIR_PTX :
                        szFilterSpec=(char far *)&szPtxSpec[0];
                        if(FileName[0]!=0)strcat(FileName,".ptx");break;
        default      :
                        szFilterSpec=(char far *)&szAnySpec[0];
                        if(FileName[0]!=0)strcat(FileName,".bsv");
    }

    ofn.lStructSize       = sizeof(OPENFILENAME);
    ofn.hwndOwner         = hWnd;
    ofn.lpstrFilter       = szFilterSpec;
    ofn.lpstrCustomFilter = szCustFilterSpec;
    ofn.nMaxCustFilter	  = MAXCUSTFILTER;
    ofn.nFilterIndex	  = 1;
    ofn.lpstrFile         = FileName;
    ofn.nMaxFile          = MAXFILENAME;
    ofn.lpstrInitialDir   = PathName;
    ofn.Flags             = OFN_HIDEREADONLY;
    ofn.lpfnHook          = NULL;
    ofn.lpstrTitle        = (LPSTR)"Select/Enter Filename";


    return 0;
}

long far PASCAL MyPaintMethod()
{
   if(STARTED==TRUE)
    {
      if(COLORMODE==TRUE)
        {
           ShowTitle((LPSTR)cbBuffer, NULL);
        }
      else
        {
           ShowPic(xborder,yborder);
           if(CLIPMODE==TRUE || CLIPMOVE==TRUE)
             {
                RectRestore();
             }
         }
     }
    else
     {
      if(TITLED==TRUE)ShowTitle(lpMyTitle, NULL);
     }
     return 0L;
}


int LoadPic(LPSTR mypic)
{
    HWND        hWnd ;

    unsigned int BytesPerLine;
    unsigned bmpwidth,bmpdepth;
    FILE *bmpfile;
    unsigned char *ptr;
    unsigned i;

    if((bmpfile=fopen(mypic,"rb"))==NULL)
    {
     hWnd=GetActiveWindow();
     MessageBeep(MB_ICONEXCLAMATION);
     MessageBox(hWnd,"Problems Were Encountered Opening The File.",
                     mypic,MB_ICONEXCLAMATION);
     return -1;
     }

    fread((char *)&bmfhead.bfType,
                   sizeof(BITMAPFILEHEADER),1,bmpfile);
    fread((char *)&bmp.bmiHeader.biSize,
                   sizeof(MYBITMAPINFO),1,bmpfile);
    ptr=(char *)&bmfhead.bfType;


    // check for a monochrome bitmap
    if(ptr[0] != 'B' || ptr[1]  != 'M' ||
       bmp.bmiHeader.biPlanes   !=  1  ||
       bmp.bmiHeader.biBitCount !=  1  ||
       bmp.bmiHeader.biCompression != BI_RGB||
       bmfhead.bfOffBits !=62L)
        {
         fclose(bmpfile);
         hWnd=GetActiveWindow();
         MessageBeep(MB_ICONEXCLAMATION);
         MessageBox(hWnd,
                    "Not a monochrome BMP file!\n"
                    "Format is not supported...",
                     mypic,MB_ICONEXCLAMATION);
         return -1;
        }

    bmpwidth = (unsigned)bmp.bmiHeader.biWidth;

    if(bmpwidth > BMP_MAXX)
    {    fclose(bmpfile);
         hWnd=GetActiveWindow();
         MessageBeep(MB_ICONEXCLAMATION);
         MessageBox(hWnd,"Image is over 640 pixels in width...",
                     mypic,MB_ICONEXCLAMATION);
         return -1;
     }

    bmpdepth = (unsigned)bmp.bmiHeader.biHeight;
    if(bmpdepth>BMP_MAXY)bmpdepth=BMP_MAXY;
    BytesPerLine = bmpwidth/8;
    if(bmpwidth%8!=0)BytesPerLine++;
    while((BytesPerLine%4)!=0)BytesPerLine++;

    SetCursor(LoadCursor(NULL,IDC_WAIT));

    memset(lpinfo,0,BUFPAD_MAXY*INPUTSIZE);
    fseek(bmpfile,(long)bmfhead.bfOffBits,SEEK_SET);
    for(i=0;i<bmpdepth;i++)
    {

        ptr=(unsigned char far *)&lpinfo[i*INPUTSIZE];
        fread(ptr,BytesPerLine,1,bmpfile);
    }
    fclose(bmpfile);
    SetCursor(LoadCursor(NULL,IDC_ARROW));

    return 0;
}

// copy a file into view from the bitmap
int ShowPic(WORD X, WORD Y)
{
   SetCursor(LoadCursor(NULL,IDC_WAIT));
   SetDIBitsToDevice(hdcMine,X,Y,BMP_MAXX,BMP_MAXY,
                             0, 0, 0, BMP_MAXY, // height
                             (LPSTR)lpinfo,
                             (PBITMAPINFO)lpbi,
                              DIB_RGB_COLORS);

   SetCursor(LoadCursor(NULL,IDC_ARROW));

   return 0;

}

int ConvertPic(LPSTR mypic)
{
    HWND        hWnd ;
    unsigned char bsvheader[7]={
    '\xfd','\x00','\xb8','\x00','\x00','\xA0','\x0F'};
    FILE *bsvfile;
    unsigned char *ptr,*cgaptr;
    unsigned i,j,x,y,k;
    unsigned char c,d,e;

    // PTX support added
    BOOL bPTX = FALSE;
    unsigned int byteoff=0,secondoff=1,packet;
    unsigned char byte,bytecount;
    int wordcount,target;

    if((bsvfile=fopen(mypic,"rb"))==NULL)
    {
     hWnd=GetActiveWindow();
     MessageBeep(MB_ICONEXCLAMATION);
     MessageBox(hWnd,"Problems Were Encountered Opening The File.",
                     mypic,MB_ICONEXCLAMATION);
     return -1;
    }


    fread(bsvtest,7,1,bsvfile);
    for(i=0;i<5;i++)
    {
        if(bsvtest[i]!=bsvheader[i])
        {

          rewind(bsvfile);
          fread(bsvtest,128,1,bsvfile);
          if (bsvtest[0]==0 && bsvtest[1]==3 &&
              bsvtest[2]==1 && bsvtest[3]==16) {
            bPTX = TRUE;
            break;
          }

          hWnd=GetActiveWindow();
          MessageBeep(MB_ICONEXCLAMATION);
          MessageBox(hWnd,"Format is not supported...",
                           mypic,MB_ICONEXCLAMATION);
          fclose(bsvfile);
          return -1;
        }
    }

    // support for PTX files added
    if (bPTX == TRUE) {
      target = fread(bsvtest,1,4000,bsvfile);
      wordcount=0;
      do{ bytecount=1;                        /* start with a seed count */
          byte=bsvtest[wordcount];
          wordcount++;
                                              /* check to see if its raw */
          if(0xC0 == (0xC0 &byte)){           /* if its not, run encoded */
            bytecount= 0x3f &byte;
            byte=bsvtest[wordcount];
            wordcount++;
          }
          for(packet=0;packet<bytecount;packet++){
            if(byteoff<4000){
              cbBuffer[byteoff]=byte;
              byteoff+=2;
            }
            else{
              if (secondoff<4000) {
                cbBuffer[secondoff]=byte;
                secondoff+=2;
              }
            }
          }

        }while(wordcount<target);
    }
    else {
      fread((char *)&cbBuffer[0],4000,1,bsvfile);
    }
    fclose(bsvfile);
    SetCursor(LoadCursor(NULL,IDC_WAIT));
    memset(lpinfo,0,(unsigned)BUFPAD_MAXY*INPUTSIZE);

    for(i=0;i<ROW_MAX;i++)
    {
      cgaptr = (unsigned char far *)&cbBuffer[i*160];
      // loop for each scanline
      k=0;
      for(y=0;y<F_HEIGHT;y++)
       {
        j=i*C_HEIGHT+k;
        ptr=(unsigned char far *)&lpinfo[(BUF_MAXY-j)*INPUTSIZE];
        for(x=0;x<INPUTSIZE;x++)               // get the next font band
        {
            c=cgaptr[x*2];
            d=cgaptr[x*2+1];
            e=lpRamFont[0].b[c][y];
            if((d&0xf)!=0)e^=0xff;  // assume reverse video black text
            ptr[x]=e;
        }
        k++;
        // aspect ratio adjustment
        if(y==2||y==8||y==13)
         {
        j=i*C_HEIGHT+k;
        ptr=(unsigned char far *)&lpinfo[(BUF_MAXY-j)*INPUTSIZE];
        for(x=0;x<INPUTSIZE;x++)               // get the next font band
        {
            c=cgaptr[x*2];
            d=cgaptr[x*2+1];
            e=lpRamFont[0].b[c][y];
            if((d&0xf)!=0)e^=0xff;  // assume reverse video black text
            ptr[x]=e;
        }
        k++;
         }
       }
    }
    SetCursor(LoadCursor(NULL,IDC_ARROW));
    return 0;
}


int mygets(unsigned char far *ptr,int cnt,FILE far *fp)
{
    int i,c;

    i=0;
    ptr[0]=0;
    c=fgetc(fp);

    for(;;)
    {
       if(c==EOF)return EOF;
       if(c==13||c==10)
       {
          c=fgetc(fp);
          if(c!=10)ungetc(c,fp);
          break;
       }

       ptr[i]=c;
       i++;
       ptr[i]=0;
       if(i<cnt)
       {
        c=fgetc(fp);
        continue;
       }
       break;
    }
return i;
}

int ConvertTxt(LPSTR mypic)
{
    HWND        hWnd ;
    FILE *txtfile;
    unsigned i,j,x,y,k;
    unsigned char c,e;
    unsigned char *ptr;

    if((txtfile=fopen(mypic,"rb"))==NULL)
    {
     hWnd=GetActiveWindow();
     MessageBeep(MB_ICONEXCLAMATION);
     MessageBox(hWnd,"Problems Were Encountered Opening The File.",
                     mypic,MB_ICONEXCLAMATION);
     return -1;
     }


    SetCursor(LoadCursor(NULL,IDC_WAIT));
    memset(lpinfo,0xff,(unsigned)BUFPAD_MAXY*INPUTSIZE);

   for(i=0;i<ROW_MAX;i++)
   {
    for(x=0;x<INPUTSIZE;x++)cbBuffer[x]=0;
    if(mygets(cbBuffer,512,txtfile)==EOF)
    {
      for(x=0;x<81;x++)cbBuffer[x]=0;
    }
    else
    {
      cbBuffer[INPUTSIZE]=0;
      for(x=0;x<INPUTSIZE;x++)if(cbBuffer[x]==10||cbBuffer[x]==13)cbBuffer[x]=0;
    }
    // loop for each scanline
    k=0;
    for(y=0;y<F_HEIGHT;y++)
     {

      j=i*C_HEIGHT+k;
      ptr=(unsigned char far *)&lpinfo[(BUF_MAXY-j)*INPUTSIZE];
      for(x=0;x<INPUTSIZE;x++)               // get the next font band
      {
          c=cbBuffer[x];
          e=lpRamFont[0].b[c][y];
          if(e!=0)ptr[x]=e^0xff;
      }
      k++;

      // aspect ratio adjustment
      if(y==2||y==8||y==13)
       {
         j=i*C_HEIGHT+k;
         ptr=(unsigned char far *)&lpinfo[(BUF_MAXY-j)*INPUTSIZE];
         for(x=0;x<INPUTSIZE;x++)               // get the next font band
          {
           c=cbBuffer[x];
           e=lpRamFont[0].b[c][y];
           if(e!=0)ptr[x]=e^0xff;
          }
         k++;
      }
     }
    }
    fclose(txtfile);
    SetCursor(LoadCursor(NULL,IDC_ARROW));
    return 0;
}

int SavePic(LPSTR mybmp)
{
    // save a bmp file
    HWND hWnd ;
    unsigned int BytesPerLine;
    FILE *bmpfile;
    unsigned y,i;
    unsigned char far *ptr;
    unsigned xoffset,yoffset;
    unsigned x1,x2,y1,y2;
    unsigned hres,vres;

    // make sure the files we save have a BMP extension
    y=0;
    for(i=0;mybmp[i]!=0;i++)
    {
        if(mybmp[i]=='.')
        {
            i++;mybmp[i]='b';
            i++;mybmp[i]='m';
            i++;mybmp[i]='p';
            i++;mybmp[i]=0;
            y++;
            break;
        }
    }
    if(y==0)
    {
            mybmp[i]='.';
            i++;mybmp[i]='b';
            i++;mybmp[i]='m';
            i++;mybmp[i]='p';
            i++;mybmp[i]= 0;
    }

    if((bmpfile=fopen(mybmp,"rb"))!=NULL)
     {
         fclose(bmpfile);
         hWnd=GetActiveWindow();
         MessageBeep(MB_ICONEXCLAMATION);
         if(MessageBox(hWnd,"BMP file Already Exists.\n\nOverwrite?",
                    mybmp,MB_YESNO)==IDNO)return -1;
      }


    if((bmpfile=fopen(mybmp,"wb"))==NULL)
     {
         hWnd=GetActiveWindow();
         MessageBeep(MB_ICONEXCLAMATION);
         MessageBox(hWnd,"A Problem occurred while saving the image.",
                    mybmp,MB_ICONEXCLAMATION);
         return -1;
      }


   SetCursor(LoadCursor(NULL,IDC_WAIT));

   hres=BMP_MAXX;
   vres=BMP_MAXY;
   BytesPerLine=INPUTSIZE;
   y1=0;
   y2=BMP_MAXY;
   xoffset=0;

   if(CLIPMODE == TRUE && CLIPSTART == TRUE)
   {

    x1= oldrect.left   -xborder;
    y1= oldrect.top    -yborder;
    x2= oldrect.right  -xborder+1;
    y2= oldrect.bottom -yborder+1;
    hres    = x2-x1;
    vres    = y2-y1;
    xoffset = x1/8;
    BytesPerLine = hres/8;
    while((BytesPerLine%4)!=0)BytesPerLine++;
    }
    // Create a simple non-compressed monochrome bit-map.
    // This is nothing more than a dump of video memory
    // which is loaded from the bottom up.

    // In its simplest state which is the Windows Standard
    // There is absolutely nothing elegant about this format.
    // They are not typically found in a compressed state.

    // There is a minimum of information in the BMP file.
    // Load coordinates are not provided for and typically
    // as seen below, many fields are unused or self evident.

    // 1. Set the defaults for the file header.
    //    This is evidently a non variant structure.
    ptr=(char *)&bmfhead.bfType;
    ptr[0] = 'B';                   // signature = BM
    ptr[1] = 'M';
    bmfhead.bfSize =  0L;           // File Size =
    bmfhead.bfSize += BytesPerLine; // 8 pixels per byte DW boundary
    bmfhead.bfSize *= vres;         // X number of rasters
    bmfhead.bfSize +=  62L;         // + Header

    bmfhead.bfReserved1 = 0;        // set next 2 to 0
    bmfhead.bfReserved2 = 0;        // (typical default)
    bmfhead.bfOffBits=62L;          // standard monochrome header
                                    // offset to bitmap data
    // 2. Set the defaults for the Info Header
    //    Some of these are variant fields depending on the number of
    //    entries in the RGB Quad Structure.

    //    2 color images have 2 RGB Quad Entries
    //    16 color images have 16
    //    256 color images have 256
    //    16.7 million color images have none. The color information
    //         for these is the 24 bit RGB triple values in the image data

    // In this case we force the RGB Quad to 2 colors since
    //   we are only dealing with a monochrome image.
    //   Some of this stuff does not get used and is typically set to 0

    bmp.bmiHeader.biSize          = 40L;      // info header size

    bmp.bmiHeader.biWidth         = 0L;
    bmp.bmiHeader.biHeight        = 0L;
    bmp.bmiHeader.biWidth        += hres;    // pixels
    bmp.bmiHeader.biHeight       += vres;    // rasters

    bmp.bmiHeader.biPlanes        = 1;       // device planes (always 1)
    bmp.bmiHeader.biBitCount      = 1;       // bits per pixel = 1
    bmp.bmiHeader.biCompression   = BI_RGB;  // no compression
    bmp.bmiHeader.biSizeImage     = bmfhead.bfSize - 62;
    bmp.bmiHeader.biXPelsPerMeter = 0L;
    bmp.bmiHeader.biYPelsPerMeter = 0L;
    bmp.bmiHeader.biClrUsed       = 0L;
    bmp.bmiHeader.biClrImportant  = 0L;

    // 3. black and white monochrome colors (foreground and background?)
    bmp.bmiColors[0].rgbRed       = 0;   // color 0 is black
    bmp.bmiColors[0].rgbGreen     = 0;
    bmp.bmiColors[0].rgbBlue      = 0;
    bmp.bmiColors[0].rgbReserved  = 0;
    bmp.bmiColors[1].rgbRed       = 255; // color 1 is white
    bmp.bmiColors[1].rgbGreen     = 255;
    bmp.bmiColors[1].rgbBlue      = 255;
    bmp.bmiColors[1].rgbReserved  = 0;

    // 4. Write the header
    fwrite((char *)&bmfhead.bfType,
                   sizeof(BITMAPFILEHEADER),1,bmpfile);
    fwrite((char *)&bmp.bmiHeader.biSize,
                   sizeof(MYBITMAPINFO),1,bmpfile);

    y=y2;
    if(y>BMP_MAXY)y=BMP_MAXY;
    for(;;)
     {
         y--;
         yoffset=(BUF_MAXY-y)*INPUTSIZE;
         yoffset+=xoffset;
         ptr=(unsigned char far *)&lpinfo[yoffset];
         fwrite(ptr,BytesPerLine,1,bmpfile);
         if(y==y1 || y<1)break;
     }

    fclose(bmpfile);
    SetCursor(LoadCursor(NULL,IDC_ARROW));
    MessageBeep(MB_ICONEXCLAMATION);
    return 0;
}

int KillPic(LPSTR mybmp)
{
    HWND hWnd ;
    FILE *fp;


    hWnd=GetActiveWindow();

    if((fp=fopen(mybmp,"rb"))==NULL)
     {
       MessageBeep(MB_ICONEXCLAMATION);
       MessageBox(hWnd,"File Was Not Found!",
                    mybmp,MB_OK);
                    return -1;
     }
   
    MessageBeep(MB_ICONEXCLAMATION);
    if(MessageBox(hWnd,"Are You Sure You Want To Delete The File?",
                    mybmp,MB_YESNO)==IDNO)return -1;
    remove(mybmp);
    return 0;
}


int PaintPic(WORD X, WORD Y, int mx, int my)
{
   // reverse video an 8 x 19 cell based on mouse coordinates
   // update the bitmap in memory
   // then realize the change on the display
   // doing it this way gurantees that the display can be drawn-on
   // without affecting our stored image.
   // changes registered to the stored image are permanent for the session.
   unsigned xoff,yoff,y;
   unsigned char temp;

   mx -= X;
   my -= Y;
   if(my>BUF_MAXY || my < 0)return 0;
   if(mx>BUF_MAXX || mx < 0)return 0;

   xoff=mx/C_WIDTH;
   mx= xoff*C_WIDTH;
   my=((my/C_HEIGHT)*C_HEIGHT);
   yoff = my;

   // reverse the bytes in the bitmap in memory
   for(y=0;y<C_HEIGHT;y++)
    {
      yoff = BUF_MAXY-(my+y);
      yoff *= INPUTSIZE;
      yoff += xoff;
      temp = lpinfo[yoff];
      lpinfo[yoff]=(temp^0xff);
    }

   // update the display
   yoff-=xoff;
   SetDIBitsToDevice(hdcMine,X+mx,Y+my,C_WIDTH,C_HEIGHT,mx,my,my,C_HEIGHT,
                     (LPSTR)lpinfo+yoff,(PBITMAPINFO)lpbi,DIB_RGB_COLORS);
   return 0;

}


int ShowTitle(LPSTR ColorBuffer, BYTE huge *hpColorInfo)
{
    // If the GlobalInfo Buffer is NULL
    // ShowTitle displays the title image or a color image of the
    // Bsaved File if one is in the buffer.
    // Otherwise creates a BitMap in the Buffer.

    // create a standard VGA colorband for each scanline and realize the
    // text screen that is initially stored in the buffer
    // a line at a time (to save memory).

    // effectively, the memory bitmap that we use for this is only
    // a scanline in height.

    // the speed of converting this information directly onto
    // the device context in a single operation using whatever the
    // native mode happens to be might have been a better method but
    // we would have needed to deal with native storage formats.

    // ShowTitle uses the vga as a base mode. 16 colors is all we need.

    unsigned i,j,k,l;
    unsigned y = 0;
    LPSTR ptr;
    unsigned char *colorptr,c,d,dold,temp;
    unsigned char background,foreground;
    BOOL bGlobal = TRUE;

    if (NULL == hpColorInfo) {
      y = yborder;
      bGlobal = FALSE;
    }

    SetCursor(LoadCursor(NULL,IDC_WAIT));
    // set initial color to black
    dold = 0;
    foreground = 0;
    background = 0;

    // loop 25 rows - one for each character line in the text screen
    for(l=0;l<ROW_MAX;l++)
    {
      // loop for each scanline on the display
      for(i=0;i<F_HEIGHT;i++)
      {
        // loop 80- columns
        ptr = (LPSTR) ColorBuffer+(l*160);
        colorptr = (unsigned char far *)&lpColorInfo[0];

        for(j=0;j<INPUTSIZE;j++)             // get the next font band
        {
            c=*ptr++;                 // character
            d=*ptr++;                 // attribute pair

            // check last color used and reset color index if changed
            if(dold!=d)
            {
              dold = d;
              foreground = (d&0x0f);
              background = (d>>4);
            }
            // get the bitmap for this character band from the font array
            temp = lpRamFont[0].b[c][i];
            for(k=0;k<C_WIDTH;k++)
            {
              if((temp>>(7-k))&1)
               {
                 if(k%2)
                 {
                  *colorptr++ |= foreground;
                 }
                 else
                 {
                  *colorptr= foreground<<4;
                 }
              }
              else
              {
                 if(k%2)
                 {
                  *colorptr++ |= background;
                 }
                 else
                 {
                  *colorptr= background<<4;
                 }
              }
            }
        }


        // display the color band for this line
        if (bGlobal == FALSE)
          SetDIBitsToDevice(hdcMine,xborder,y,BMP_MAXX,1,0, 0, 0, 1,
                  (LPSTR)lpColorInfo,(PBITMAPINFO)lpbcolor,DIB_RGB_COLORS);
        else
          hmemcpy((BYTE huge *)&hpColorInfo[320L * (BUF_MAXY-y)],
            (BYTE huge *)&lpColorInfo[0], 320);


        y++; // increment scanline counter by one
        // aspect ratio adjustment
        // display the line twice when we must stretch the font
        if(i==2||i==8||i==13)
        {
           if (bGlobal == FALSE)
             SetDIBitsToDevice(hdcMine,xborder,y,BMP_MAXX,1,0, 0, 0, 1,
                   (LPSTR)lpColorInfo,(PBITMAPINFO)lpbcolor,DIB_RGB_COLORS);
           else
             hmemcpy((BYTE huge *)&hpColorInfo[320L * (BUF_MAXY-y)],
                    (BYTE huge *)&lpColorInfo[0], 320);

             y++;
        }
      }
    }
    SetCursor(LoadCursor(NULL,IDC_ARROW));
    return 0;
}

int ColorFlip(WORD ColorNum)
{
    unsigned long *templong;
    char *cbuf;
    unsigned mysize;

    mysize=sizeof(BITMAPINFOHEADER);
    cbuf=(char *)(&lpbi[0].biSize);
    templong=(unsigned long *)&cbuf[mysize];           // color table

    switch(ColorNum)
    {
    case 1:
    templong[0]=0L;                                    // black...
    templong[1]=(unsigned long)255<<16|255<<8;         // yellow background
    break;
    case 2:
    templong[0]=0L;                                    // black...
    templong[1]=(unsigned long)255<<8|255;             // cyan...
    break;
    case 0:
    default:
    templong[0]=0L;                                    // black...
    templong[1]=(unsigned long)255<<16|255<<8|255;     // white background
    break;
    }
    return 0;
}

void RectClear()
{
    oldrect.left   =0;
    oldrect.top    =0;
    oldrect.right  =0;
    oldrect.bottom =0;
    newrect.left   =0;
    newrect.top    =0;
    newrect.right  =0;
    newrect.bottom =0;
    startx =0;
    starty =0;
    endx   =0;
    endy   =0;
    CLIPSTART = FALSE;
    CLIPMOVE  = FALSE;
}

int RectRestore()
{

    if(oldrect.left == 0 && oldrect.right == 0 &&
       oldrect.top  == 0 && oldrect.bottom == 0)
       return 0;

    oldrect.right++;
    oldrect.bottom++;

    InvertRect(hdcMine,&oldrect);

    oldrect.right--;
    oldrect.bottom--;

    return 0;
}

int RectMove(int x1,int y1,int x2,int y2)
{
    newrect.left   =x1+xborder;
    newrect.top    =y1+yborder;
    newrect.right  =x2+xborder;
    newrect.bottom =y2+yborder;

    if(newrect.left == oldrect.left && newrect.right == oldrect.right &&
       newrect.top  == oldrect.top && newrect.bottom == oldrect.bottom)
       return 0;

      oldrect.right++;
      oldrect.bottom++;
      newrect.right++;
      newrect.bottom++;

    if(oldrect.left == newrect.left && oldrect.top == newrect.top)
    {

      // 1. right side
      if(oldrect.right > newrect.right)   // erase the old one if too far
      {
        temprect.left   = newrect.right;
        temprect.right  = oldrect.right;
        temprect.top    = oldrect.top;
        temprect.bottom = oldrect.bottom;

      }
      else                                 // or make a new one if not
      {
        temprect.left   = oldrect.right;
        temprect.right  = newrect.right;
        temprect.top    = newrect.top;
        temprect.bottom = newrect.bottom;

      }

      InvertRect(hdcMine,&temprect);

      // 2. Bottom
      temprect.right      = temprect.left;
      temprect.left       = oldrect.left;
      if(oldrect.bottom > newrect.bottom)  // erase the old one if too far
      {
        temprect.top    = newrect.bottom;
        temprect.bottom = oldrect.bottom;
      }
      else
      {
        temprect.top    = oldrect.bottom;
        temprect.bottom = newrect.bottom;
      }
      InvertRect(hdcMine,&temprect);

    }
    else
    {
      // last resort...
      InvertRect(hdcMine,&oldrect);
      InvertRect(hdcMine,&newrect);

    }

    newrect.right--;
    newrect.bottom--;

    oldrect.left   =x1+xborder;
    oldrect.top    =y1+yborder;
    oldrect.right  =x2+xborder;
    oldrect.bottom =y2+yborder;

    return 0;
}

long far PASCAL MyImport(HWND hWnd, WORD wParam)
{
    GetWindowText(hWnd,szOLDTEXT,66);
    SetWindowText(hWnd,lpIMPORT);
    switch(wParam) {
      case IDM_PTX:
        InitDialog(hWnd,DIR_PTX);
        break;
      case IDM_IMPORT:
      default:
        InitDialog(hWnd,DIR_BSV);
    }
    if(GetOpenFileName ((LPOPENFILENAME)&ofn))
    {
      RectClear();
      ColorFlip(0);
      if(!ConvertPic(ofn.lpstrFile))
      {
        STARTED   = TRUE;
        BSVMODE   = TRUE;
        COLORMODE = FALSE;
        ShowPic(xborder,yborder);
      }
      else
      {
       if(REVERSEMODE==TRUE || CLIPMODE==TRUE)showpic(xborder,yborder);
      }
      CLIPMODE    =FALSE;
      REVERSEMODE =FALSE;
      SetWindowText(hWnd,lpNONE);
    }
    else
    {
      SetWindowText(hWnd,szOLDTEXT);
    }
    return 0L;

}

// calls ConvertTxt
long far PASCAL MyConvert(HWND hWnd)
{
   GetWindowText(hWnd,szOLDTEXT,66);
   SetWindowText(hWnd,lpCONVERT);
   InitDialog(hWnd,DIR_TEXT);
   if(GetOpenFileName ((LPOPENFILENAME)&ofn))
    {
      RectClear();
      ColorFlip(0);
      if(!ConvertTxt(ofn.lpstrFile))
      {
             BSVMODE   = FALSE;
             STARTED   = TRUE;
             ShowPic(xborder,yborder);
      }
      else
      {
         if(REVERSEMODE==TRUE || CLIPMODE==TRUE)showpic(xborder,yborder);
      }
      CLIPMODE    =FALSE;
      REVERSEMODE =FALSE;
      SetWindowText(hWnd,lpNONE);
    }
    else
    {
        SetWindowText(hWnd,szOLDTEXT);
    }
    return 0L;
}

long far PASCAL MyReverse(HWND hWnd)
{
   WORD wParam;

   wParam == GetMenu(hWnd);
   if(CLIPMODE == TRUE)
   {
       RectRestore();
       CLIPMODE = FALSE;
       CheckMenuItem(wParam, IDM_CLIP, MF_UNCHECKED);
   }
   if(REVERSEMODE==TRUE)
   {
        if(CLIPMOVE == TRUE)RectRestore();
        REVERSEMODE = FALSE;
        ColorFlip(0);
        ShowPic(xborder,yborder);
        SetWindowText(hWnd,lpNONE);
        CheckMenuItem(wParam, IDM_REVERSE, MF_UNCHECKED);
    }
   else
   {
        REVERSEMODE = TRUE;
        SetWindowText(hWnd,lpREVERSE);
        ColorFlip(1);
        ShowPic(xborder,yborder);
        CheckMenuItem(wParam, IDM_REVERSE, MF_CHECKED);
    }
   RectClear();
   return 0L;

}

long far PASCAL MyClip(HWND hWnd)
{
    WORD wParam;

    wParam == GetMenu(hWnd);
    if(REVERSEMODE == TRUE)
     {
         if(CLIPMOVE == TRUE)RectRestore();
         REVERSEMODE = FALSE;
         CheckMenuItem(wParam, IDM_REVERSE, MF_UNCHECKED);
     }
    if(CLIPMODE == TRUE)
     {
         RectRestore();
         ColorFlip(0);
         ShowPic(xborder,yborder);
         CLIPMODE = FALSE;
         SetWindowText(hWnd,lpNONE);
         CheckMenuItem(wParam, IDM_CLIP, MF_UNCHECKED);
      }
    else
     {
         CLIPMODE = TRUE;
         SetWindowText(hWnd,lpCLIP);
         ColorFlip(2);
         ShowPic(xborder,yborder);
         CheckMenuItem(wParam, IDM_CLIP, MF_CHECKED);
     }
    RectClear();
    return 0L;

}

long far PASCAL MyColor(HWND hWnd)
{
     if(BSVMODE   == FALSE)return 0L;
     if(COLORMODE == FALSE)
     {
        SetWindowText(hWnd,lpCOLOR);
        COLORMODE = TRUE;
        ShowTitle((LPSTR)cbBuffer, NULL);
        return 0L;
     }
     COLORMODE = FALSE;
     ShowPic(xborder,yborder);
     if( REVERSEMODE != TRUE && CLIPMODE != TRUE)
     {
        SetWindowText(hWnd,lpNONE);
     }
     else
     {
        if(CLIPMODE==TRUE || CLIPMOVE==TRUE)
         {
           RectRestore();
         }
        if(REVERSEMODE==TRUE)SetWindowText(hWnd,lpREVERSE);
        else SetWindowText(hWnd,lpCLIP);
     }
     return 0L;
}


long far PASCAL MyLoad(HWND hWnd)
{
    GetWindowText(hWnd,szOLDTEXT,66);
    SetWindowText(hWnd,lpLOAD);
    InitDialog(hWnd,DIR_BMP);
    if(GetOpenFileName ((LPOPENFILENAME)&ofn))
    {
      SetWindowText(hWnd,lpLOAD);
      RectClear();
      ColorFlip(0);
      if(!LoadPic(ofn.lpstrFile))
      {
         BSVMODE     = FALSE;
         STARTED     = TRUE;
         ShowPic(xborder,yborder);
      }
      else
      {
         if(REVERSEMODE==TRUE || CLIPMODE==TRUE)showpic(xborder,yborder);

       }
       REVERSEMODE =FALSE;
       CLIPMODE    =FALSE;
       SetWindowText(hWnd,lpNONE);
    }
    else
    {
       SetWindowText(hWnd,szOLDTEXT);
    }
    return 0L;
}


long far PASCAL MySave(HWND hWnd)
{
    GetWindowText(hWnd,szOLDTEXT,66);
    SetWindowText(hWnd,lpSAVE);
    InitDialog(hWnd,DIR_BMP);
    if(GetOpenFileName ((LPOPENFILENAME)&ofn))SavePic(ofn.lpstrFile);
    SetWindowText(hWnd,szOLDTEXT);
    return 0L;
}

long far PASCAL MyDelete(HWND hWnd)
{
    GetWindowText(hWnd,szOLDTEXT,66);
    SetWindowText(hWnd,lpDELETE);
    InitDialog(hWnd,DIR_ANY);
    if(GetOpenFileName ((LPOPENFILENAME)&ofn))KillPic(ofn.lpstrFile);
    SetWindowText(hWnd,szOLDTEXT);
    return 0L;
}

long far PASCAL MyHelp(HWND hWnd)
{
    SetCursor(LoadCursor(NULL,IDC_WAIT));
    GetWindowText(hWnd,szOLDTEXT,66);
    SetWindowText(hWnd,lpHELP);
    HELPACTIVE = WinHelp(hWnd,"WINBMP.HLP",HELP_CONTENTS,0L);
    SetWindowText(hWnd,szOLDTEXT);
    SetCursor(LoadCursor(NULL,IDC_ARROW));
    return 0L;
}

long far PASCAL MyLicence(HWND hWnd)
{
    GetWindowText(hWnd,szOLDTEXT,66);
    SetWindowText(hWnd,lpLICENCE);
    MessageBox(hWnd, lpRegister, "WINBMP Licencing Agreement",
                    MB_ICONINFORMATION);
    SetWindowText(hWnd,szOLDTEXT);
    return 0L;
}

long far PASCAL MyAbout(HWND hWnd)
{
    GetWindowText(hWnd,szOLDTEXT,66);
    SetWindowText(hWnd,lpABOUT);
    if(TITLED==TRUE && STARTED == TRUE)ShowTitle(lpMyTitle, NULL);
    MessageBox(hWnd, lpRegister, lpABOUT, MB_ICONINFORMATION);
    if(STARTED==TRUE)
    {
      if(COLORMODE==TRUE)
        {
           ShowTitle((LPSTR)cbBuffer, NULL);
        }
      else
        {
           ShowPic(xborder,yborder);
           if(CLIPMODE==TRUE || CLIPMOVE==TRUE)
             {
                RectRestore();
             }
         }
    }
    SetWindowText(hWnd,szOLDTEXT);
    return 0L;

}

long far PASCAL MyPaste(HWND hWnd)
{
    FILE *fp;
    int i,c;

    // if there is text in the clipboard
    // write it to a temporary file
    // then use the standard text file conversion to display the file
    GetWindowText(hWnd,szOLDTEXT,66);
    SetWindowText(hWnd,lpPASTE);

    if(OpenClipboard(hWnd))
     {
         // get text from the clipboard
         if (!(hClipData = GetClipboardData(CF_OEMTEXT)))
         {
           CloseClipboard();
           MessageBox(hWnd,"No Text In Clipboard!",
                            NULL,
                            MB_ICONHAND | MB_SYSTEMMODAL);
           SetWindowText(hWnd,szOLDTEXT);
           return -1L;
         }
         if (!(lpClipData = GlobalLock(hClipData)))
         {
            CloseClipboard();
            MessageBox(hWnd,"Out Of Memory!",
                            NULL,
                            MB_ICONHAND | MB_SYSTEMMODAL);
            SetWindowText(hWnd,szOLDTEXT);
            return -1L;

         }
         if((fp=fopen("WINBMP.PST","wb"))==NULL)
         {
          GlobalUnlock(hClipData);
          CloseClipboard();
          MessageBox(hWnd,"Unable to create temporary paste file!",
                            "WINBMP.PST",
                            MB_ICONHAND | MB_SYSTEMMODAL);

            SetWindowText(hWnd,szOLDTEXT);
            return -1L;
         }

         for(i=0;(c=lpClipData[i])!=0;i++)
         {
           fputc(c,fp);
           if(i>32766)
           {
            fputc(13,fp);fputc(10,fp);break;
           }
         }
         fclose(fp);
         GlobalUnlock(hClipData);
         CloseClipboard();
         if(!ConvertTxt("WINBMP.PST"))
         {
          SetWindowText(hWnd,lpNONE);
          STARTED     =TRUE;
          REVERSEMODE =FALSE;
          CLIPMODE    =FALSE;
          BSVMODE     =FALSE;
          RectClear();
          ColorFlip(0);
          ShowPic(xborder,yborder);
         }
         else
         {
           SetWindowText(hWnd,szOLDTEXT);
         }
         remove("WINBMP.PST");

    }
    else
    {
         MessageBox(hWnd,"Clipboard not available!",
                            NULL,
                            MB_ICONHAND | MB_SYSTEMMODAL);
         SetWindowText(hWnd,szOLDTEXT);
         return -1L;

    }
    return 0L;

}

long far PASCAL MyCopy(HWND hWnd)
{
   // copy a DIB of the screen or of the selected area to the clipboard
   unsigned int BytesPerLine;
   unsigned y,i;
   unsigned char far *src, *dest;
   unsigned xoffset,yoffset;
   unsigned x1,x2,y1,y2;
   unsigned hres,vres;
   long ctr;

   GetWindowText(hWnd,szOLDTEXT,66);
   SetWindowText(hWnd,lpCOPY);
   SetCursor(LoadCursor(NULL,IDC_WAIT));

   hres=BMP_MAXX;
   vres=BMP_MAXY;
   BytesPerLine=INPUTSIZE;
   y1=0;
   y2=BMP_MAXY;
   xoffset=0;

   if(COLORMODE == TRUE) {
      dwDataSize =  0L;           // File Size =
      dwDataSize += 320L;         // 2 pixels per byte DW boundary
      dwDataSize *= vres;         // X number of rasters
      dwDataSize += 64L;          // + Header
   }
   else {
      if(CLIPMODE == TRUE && CLIPSTART == TRUE)
      {
        x1= oldrect.left   -xborder;
        y1= oldrect.top    -yborder;
        x2= oldrect.right  -xborder+1;
        y2= oldrect.bottom -yborder+1;
        hres    = x2-x1;
        vres    = y2-y1;
        xoffset = x1/8;
        BytesPerLine = hres/8;
        while((BytesPerLine%4)!=0)BytesPerLine++;
      }

      dwDataSize =  0L;           // File Size =
      dwDataSize += BytesPerLine; // 8 pixels per byte DW boundary
      dwDataSize *= vres;         // X number of rasters
      dwDataSize += 40L;          // + Header

   }

    // use the filesize for a global block size + a little extra
    hData = GlobalAlloc(GMEM_MOVEABLE, (dwDataSize+320L) );
    if(hData == NULL)
    {
      MessageBox(hWnd,"Out Of Memory!",NULL,MB_ICONHAND | MB_SYSTEMMODAL);
      SetWindowText(hWnd,szOLDTEXT);
      SetCursor(LoadCursor(NULL,IDC_ARROW));
      return -1L;
    }

    hpBmpBuffer = GlobalLock(hData);

    if(hpBmpBuffer == NULL)
    {
       MessageBox(hWnd,"Out Of Memory!",NULL,MB_ICONHAND | MB_SYSTEMMODAL);
       SetCursor(LoadCursor(NULL,IDC_ARROW));
       SetWindowText(hWnd,szOLDTEXT);
       return -1L;

     }

    lpData = (LPSTR)&hpBmpBuffer[0];

   if (COLORMODE == TRUE) {
      // color clipboard bmp routine
      // copy the header into the memory block to pass to the clipboard

      y=sizeof(VGABITMAPINFO);
      src=(unsigned char far *)&vga.bmiHeader.biSize;
      dest=(unsigned char far *)&lpData[0];
      for(i=0;i<y;i++)*dest++=*src++;

      // realize the color bitmap in the global buffer
      ShowTitle((LPSTR)cbBuffer, (BYTE huge *)&hpBmpBuffer[y]);
   }
   else {

    // monochrome bmp clipboard routine

    dwDataSize -= 40;
    bmp.bmiHeader.biSize          = 40L;      // info header size

    bmp.bmiHeader.biWidth         = 0L;
    bmp.bmiHeader.biHeight        = 0L;
    bmp.bmiHeader.biWidth        += hres;    // pixels
    bmp.bmiHeader.biHeight       += vres;    // rasters

    bmp.bmiHeader.biPlanes        = 1;       // device planes (always 1)
    bmp.bmiHeader.biBitCount      = 1;       // bits per pixel = 1
    bmp.bmiHeader.biCompression   = BI_RGB;  // no compression
    bmp.bmiHeader.biSizeImage     = dwDataSize;
    bmp.bmiHeader.biXPelsPerMeter = 0L;
    bmp.bmiHeader.biYPelsPerMeter = 0L;
    bmp.bmiHeader.biClrUsed       = 0L;
    bmp.bmiHeader.biClrImportant  = 0L;

    bmp.bmiColors[0].rgbRed       = 0;   // color 0 is black
    bmp.bmiColors[0].rgbGreen     = 0;
    bmp.bmiColors[0].rgbBlue      = 0;
    bmp.bmiColors[0].rgbReserved  = 0;
    bmp.bmiColors[1].rgbRed       = 255; // color 1 is white
    bmp.bmiColors[1].rgbGreen     = 255;
    bmp.bmiColors[1].rgbBlue      = 255;
    bmp.bmiColors[1].rgbReserved  = 0;

    // copy the header into the memory block to pass to the clipboard
    y=sizeof(MYBITMAPINFO);
    src=(unsigned char far *)&bmp.bmiHeader.biSize;
    dest=(unsigned char far *)&lpData[0];
    for(i=0;i<y;i++)*dest++=*src++;

    // now copy the bitmap to the memory block
    ctr=0L;
    y=y2;
    if(y>BMP_MAXY)y=BMP_MAXY;
    for(;;)
     {
      y--;
      yoffset=(BUF_MAXY-y)*INPUTSIZE;
      yoffset+=xoffset;
      src=(unsigned char far *)&lpinfo[yoffset];
      for(i=0;i<BytesPerLine;i++)*dest++=src[i];
      if(y==y1 || y<1)break;
      ctr+=BytesPerLine;
      if(ctr<dwDataSize)continue;
      break;
     }
   }

   // release the bitmap to the clip board...
   GlobalUnlock(hData);
   if (OpenClipboard(hWnd))
     {

                  EmptyClipboard();
                  SetClipboardData(CF_DIB, hData);
                  CloseClipboard();
     }
   hData = NULL;
   SetWindowText(hWnd,szOLDTEXT);
   SetCursor(LoadCursor(NULL,IDC_ARROW));

   return 0L;
}

// paint an area with FastKeys
long far PASCAL MyFastEntry(HWND hWnd, unsigned char c)
{
    int mx,mx2,my,my2;


     if(CLIPMODE != TRUE  || CLIPSTART != TRUE ||
        CLIPMOVE != FALSE || COLORMODE != FALSE)
        {
                MessageBox(hWnd,
                    "Sorry... You cannot Fill Text with Fast Keys until "
                    "you mark the Fast Text Area using "
                    "the Mark Fragment Area option.\n\n"
                    "You can use Fast Text only during the Mark "
                    "Fragment Area Option.",
                    lpNONE, MB_ICONSTOP);

            return 0L;
        }
        RectRestore();
        my  = starty;
        my2 = endy;
        mx2 = endx;
        for(;;)
        {
           mx  = startx;
           for(;;)
           {
             PutFast(mx,my,c);
             mx+=C_WIDTH;
             if(mx>mx2)break;
            }
            my+=C_HEIGHT;
            if(my>my2)break;
        }
        RectRestore();

     return 0L;
}


long far PASCAL MyEntry(HWND hWnd)
{
     FARPROC lpProc;                     // far pointer to callback

     if(CLIPMODE != TRUE  || CLIPSTART != TRUE ||
        CLIPMOVE != FALSE || COLORMODE != FALSE)
        {
                MessageBox(hWnd,
                    "Sorry... You cannot enter text until "
                    "you mark the Text Entry Origin using "
                    "the Mark Fragment Area option.\n\n"
                    "You can enter text only during the Mark "
                    "Fragment Area Option.",
                    lpNONE, MB_ICONSTOP);

            return 0L;
        }

     lpProc = MakeProcInstance(EntryDlgProc, hInst);
     DialogBox(hInst, "TextEntryBox", hWnd, lpProc);
     InvalidateRect(hWnd, NULL, TRUE);   // repaint everything
     UpdateWindow(hWnd);                 // force WM_PAINT message
     FreeProcInstance(lpProc);
     return 0L;
}

//
// EntryDlgProc - callback function for "Text Entry..." dialog
//
BOOL FAR PASCAL EntryDlgProc(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam)
{
    unsigned char c;
    int i, mx, my;

    switch (wMsg) 
    {
        case WM_INITDIALOG:                 // dialog box initialization
            return (TRUE);                  // signal message processed

        case WM_COMMAND:                    // command received
            if(wParam == IDOK)              // OK button clicked?
            {                               // yes, retrieve text
              lpszDialogBuf[0]=0x00;
              GetDlgItemText(hDlg, IDD_EDITTEXT, lpszDialogBuf, INPUTSIZE-1);
              mx = startx;
              my = starty;
              for(i=0;(c=lpszDialogBuf[i])!=0;i++)
               {
                   PutLetter(mx,my,c);
                   mx+=C_WIDTH;
               }
              lpszDialogBuf[0]=0x00;
              EndDialog(hDlg, TRUE);        // signal text accepted
            }
            else if(wParam == IDD_CANCEL)   // Cancel button clicked?
            {
                                           // Input was cancelled
               EndDialog(hDlg, FALSE);     // signal text not accepted
            }
    }
    return(FALSE);                         // signal message not processed
}

// put an ascii character without updating
int PutLetter(int mx, int my,unsigned char c)
{
   unsigned xoff,yoff,y;
   unsigned char temp;
   int i;

   if(my>BUF_MAXY || my < 0)return 0;
   if(mx>BUF_MAXX || mx < 0)return 0;

   xoff=mx/C_WIDTH;

   y=0;
   for(i=0;i<F_HEIGHT;i++)
    {
      yoff = BUF_MAXY-(my+y);
      yoff *= INPUTSIZE;
      yoff += xoff;
      temp = lpRamFont[0].b[c][i];
      lpinfo[yoff]=(temp^0xff);y++;

      if(i==2||i==8||i==13)
      {
        yoff = BUF_MAXY-(my+y);
        yoff *= INPUTSIZE;
        yoff += xoff;
        lpinfo[yoff]=(temp^0xff);y++;
       }
    }

   return 0;

}

// paint an ascii character and update the display
int PutFast(int mx, int my,unsigned char c)
{
   unsigned xoff,yoff,y;
   unsigned char temp;
   int i;

   if(my>BUF_MAXY || my < 0)return 0;
   if(mx>BUF_MAXX || mx < 0)return 0;

   xoff=mx/C_WIDTH;
   yoff = my;

   y=0;
   for(i=0;i<F_HEIGHT;i++)
    {
      yoff = BUF_MAXY-(my+y);
      yoff *= INPUTSIZE;
      yoff += xoff;
      temp = lpRamFont[0].b[c][i];
      lpinfo[yoff]=(temp^0xff);y++;

      if(i==2||i==8||i==13)
      {
        yoff = BUF_MAXY-(my+y);
        yoff *= INPUTSIZE;
        yoff += xoff;
        lpinfo[yoff]=(temp^0xff);y++;
       }
    }

   // update the display
   yoff-=xoff;  // window the byte
   SetDIBitsToDevice(hdcMine,xborder+mx,yborder+my,
                             C_WIDTH,C_HEIGHT,mx,my,my,C_HEIGHT,
                     (LPSTR)lpinfo+yoff,(PBITMAPINFO)lpbi,DIB_RGB_COLORS);
   return 0;

}
