/*     unixmail.c -- Handle unix mail
	This file is part of Paperboy, an offline mail/newsreader for Windows
	Copyright (C) 1995  Michael H. Vartanian
		vart@clark.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <ctype.h>
#include "unixmail.h"
#include "soup.h"
#include "error.h"
#include "areas.h"
#include "structs.h"
#include "msgs.h"

int getbinmailstarts (FILE * fin, struct llareas * area)
{
	unsigned long length, pos;
	struct llmsg * cur;

	
	assert(fin!=NULL);
	assert(area!=NULL);
	assert(area->head==NULL);

	rewind(fin);
	cur=NULL;

	while (!feof(fin))
	{
		length=0;
		length+= (fgetc(fin) * 256L *256L * 256L);
		if feof(fin) break;
		length+= (fgetc(fin) * 256L *256L);
		length+= (fgetc(fin) * 256L);
		length+= (fgetc(fin));
		pos=ftell(fin);
		fseek(fin,length,SEEK_CUR);     /* Goto next message, clears feof*/

		if (length>0)
		{               
			/* Add to head of linked list */
			cur=(struct llmsg *)malloc(sizeof(struct llmsg));
			if (cur==NULL) { errortext="getbinmailstarts: struct llmsg"; return ERRMEM; }
			memset(cur,0,sizeof(struct llmsg));     /* zero it out */
			cur->magic=MSGMAGIC;
			cur->next=area->head;
			area->head=cur;
			cur->start=pos;
			cur->length=length;
		}
	}
	
	return 0;
}
	

int getunixmailstarts (FILE * fin, struct llareas * area)
{
	char line[MAXLINE];
	long pos;
	struct llmsg * cur;

	assert(fin!=NULL);
	assert(area!=NULL);
	assert(area->head==NULL);

	rewind(fin);
	cur=NULL;

	while (!feof(fin))
	{
		/* Get start and end of message */
		pos=ftell(fin);
		fgetlf(sizeof(line)-1,fin,line);
		if (feof(fin)) break;

		if (strncmp(line,MAILHEAD,strlen(MAILHEAD))==0)
		{
			if (cur!=NULL)
			{
			/* Figure out length of previous one */
				cur->length=pos - cur->start;
			}

			/* Add to head of linked list */
			cur=(struct llmsg *)malloc(sizeof(struct llmsg));
			if (cur==NULL) { errortext="getunixmailstarts: struct llmsg"; return ERRMEM; }
			memset(cur,0,sizeof(struct llmsg));     /* zero it out */
			cur->magic=MSGMAGIC;
			cur->next=area->head;
			area->head=cur;

			cur->start=pos;
			cur->length=0;          /* To be calculated at next message */
		}
	}

	if (cur!=NULL)
	{
	/* Figure out length of previous one */
		cur->length=ftell(fin) - cur->start;
	}

	return 0;
}

int parseunixmail (struct llareas * area)
{
/* Unixmail begins each message with a "From " */
	FILE * fin;
	int     result;

	area->head=NULL;        /* No message yet */

	/*      Open the file */
	assert(area->prefix!=NULL);
	fin=fopen(area->prefix,"rb");  /* MS-DOS likes it binary */
	if (fin==NULL) { errortext="parseunixmail: .MSG file not found"; return ERRIO; }

	result=getunixmailstarts(fin,area);     /* An index file would definetly have this */
	if (result) return result;

	result=getheaders(fin,area);    /* An index file might have this */
	if (result) return result;

	fclose(fin);
	return 0;
}

    
int parsebinmail (struct llareas * area)
{
/* binary mail begins with length in big-endian format */
	FILE * fin;
	int     result;

	area->head=NULL;        /* No message yet */

	/*      Open the file */
	assert(area->prefix!=NULL);
	fin=fopen(area->prefix,"rb");  /* MS-DOS likes it binary */
	if (fin==NULL) 
		/* return ERRIO; */
		return 0;

	result=getbinmailstarts(fin,area);      /* An index file would definetly have this */
	if (result) return result;

	result=getheaders(fin,area);    /* An index file might have this */
	if (result) return result;

	fclose(fin);
	return 0;
}

    
