/***************************************************************************
  Video
  Video mode routines, trial and error legal mode detection
  PJB August 29, 1993, Internet mail to d91-pbr@nada.kth.se
  Copyright 1993, All Rights Reserved
  Free source, use at your own risk.
  If modified, please state so if you pass this around.

  Intended for Turbo Vision, easily rehacked.

   Use checkVideoType to initialize before you call any
    other procedures or access any variables in this unit.

   Use scanEVGAModes only on EGA and VGA compatible cards, or else
    the results might be misleading. Check this before you use
    scanEVGAModes.

  If the video card is VERY old, the computer might crash since the
  BIOSes weren't designed to handle "illegal" video modes back then...

  For full VESA, Video7 support, use only setSpecialVideoMode and
  getSpecialVideoMode from this unit.

  You can overlay this unit.
  See CONFIG.PAS for a description of all conditional defines.

***************************************************************************/

#define Uses_TCommandSet

#include <tv.h>
#include <dos.h>
#include <views.h>

#include "video.h"
#include "vesa.h"


ushort Seg0040 = 0x0040;
ushort SegB000 = 0xB000;
ushort SegB800 = 0xB800;


Boolean video7;
VideoTypes videoType;
#ifdef TOYVESASUPPORT
 ushort dontClearVideoModeFlag = 0x80;
#endif
SpecialVideoTypes videoTypesToCheck = vtVesa | vtVideo7;


ModeSet initVGAModes()
{
  ModeSet temp;

  for (int i=0; i<256; i++)
    temp.disableCmd(i);
  temp.enableCmd(2);
  temp.enableCmd(3);
  temp.enableCmd(7);
  return temp;
}

ModeSet initStandardTextModes()
{
  ModeSet temp=initVGAModes();

  temp.enableCmd(8);
  for (int i=20; i<256; i++)
    temp.enableCmd(i);
  return temp;
}

ModeSet initVESAModes()
{
  ModeSet temp;

  for (int i=0; i<256; i++)
    temp.disableCmd(i);
  for (i=8; i<0xD; i++)
    temp.enableCmd(i);
  return temp;
}

ModeSet standardTextModes = initVGAModes();
ModeSet vgaModes          = initStandardTextModes();
ModeSet vesaModes 	  = initVESAModes();


 #ifdef TOYVIDEO7SUPPORT
  /*******************************************************************
    Test for the presence of a Video7 or HP video card
  *******************************************************************/
  uchar v7orHPInstalled()
  {
    asm {
	mov  ax,0x6F00
	xor  bx,bx
	int  0x10

	mov  al,V7Installed
	cmp  bx,'V7'
	je   Fin

	mov  al,HPInstalled
	cmp  bx,'HP'
	je   Fin

	mov  al,0
    }
      Fin:
    return _AL;
  }
 #endif


  /*******************************************************************
    Set video mode using VESA, Video7 or BIOS, if supported and present
  *******************************************************************/
  void setSpecialVideoMode(ushort mode)
  {
    asm {
        mov  ax,mode

       #ifdef TOYVESASUPPORT
	cmp  vesaVersion,0
        je   noVesa
    }
    setVesaMode(mode);
    asm {
	cmp  al,0x4F               /* Supported? */
        je   fin

        mov  bx,mode
	test bh,0x7F
        jne  fin

	mov  al,bh
	and  al,0x80
	or   al,bl
       #endif
    }

      noVesa:
    asm {
       #ifdef TOYVIDEO7SUPPORT
        cmp  video7,False
	je   go
	mov  bl,al
	mov  ax,0x6F05
       #endif
    }

      go:
    asm {
	int  0x10
    }
      fin:
  }


  /*******************************************************************
    Retrive current video from VESA, Video7 or plain BIOS
  *******************************************************************/
  ushort getSpecialVideoMode()
  {
    asm {
       #ifdef TOYVESASUPPORT
        cmp  vesaVersion,0
        je   noVesa
    }
    getVesaMode();
    asm{
	and  ah,0x7F

	#ifdef toyV7UniVesaKludge
         #ifdef TOYVIDEO7SUPPORT
          cmp  video7,False
          je   noV7Test
	 #endif
	 cmp  ax,1         /* Boring bad VESA driver returns this on V7 */
         je   noVesa
    }

      noV7Test:
    asm {
	#endif

	cmp  bx,0x4F                 /* Success? */
        je   fin
    }

      noVesa:
    asm {
       #endif

       #ifdef TOYVIDEO7SUPPORT
        cmp  video7,False
        je   noV7

	mov  ax,0x6F04
	int  0x10

        jmp  clearAH
       #endif
    }

      noV7:
    asm {
	mov  ah,0x0F
	int  0x10
    }

      clearAH:
    asm {
	and  ax,0x7F
    }
      fin:
    return _AX;
  }


  /*******************************************************************
    Vesa present?
  *******************************************************************/
 #ifdef TOYVESASUPPORT
  void checkVesa()
  {
    detectVesaVersion();
    if (vesaVersion)
      dontClearVideoModeFlag=0x8000;
  }
 #endif


  /*******************************************************************
    Video 7 card?
  *******************************************************************/
 #ifdef TOYVIDEO7SUPPORT
  void checkVideo7()
  {
    video7=Boolean(v7orHPInstalled()!=0);
  }
 #endif


  /*******************************************************************
    EGA, VGA or Other?
  *******************************************************************/
  void checkEVGA()
  {
    asm {
	push bp

        mov  videoType,OTHER
	mov  ax,0x1200
	mov  bx,0x10
	mov  cx,0xFFFF
	int  0x10

	inc  cx
        je   fin               /* No EGA support */

        mov  videoType,EGA

	mov  ax,0x1A00
	int  0x10
	cmp  al,0x1A
        jne  fin               /* Not a VGA or PS/2 type card */

	cmp  bl,7
	jae  vga               /* VGA, MCGA */

	cmp  bl,4               /* EGA */
        jae  fin

	mov  videoType,OTHER    /* Something else */
        jmp  fin
	}
      vga:
	asm {
        mov  videoType,VGA
	}
      fin:
	asm {
	pop  bp
    }
  }


  /*******************************************************************
    Check which of VESA, Video7, VGA and EGA are present
  *******************************************************************/
  void checkVideoType()
  {
   #ifdef TOYVESASUPPORT
    if (videoTypesToCheck & vtVesa)
      checkVesa();
   #endif
   #ifdef TOYVIDEO7SUPPORT
    if (videoTypesToCheck & vtVideo7)
      checkVideo7();
   #endif
    checkEVGA();
  }


  /*******************************************************************
    Calculate the video mode's number of scan lines
  *******************************************************************/
  int getCurrentScanLines()
  {
    asm {
	mov  es,Seg0040
        mov  al,es:[crtRows]
	inc  al
        mov  ah,es:[crtPoints]
	mul  ah
    }
    return _AX;
  }


  /*******************************************************************
     Change to another font on the video card
     Available fonts are:
       8x8:  EGA, VGA         (Internal8x8Font)
       8x14: EGA, VGA         (Internal8x14Font)
       8x16:      VGA         (Internal8x16Font)
  *******************************************************************/
  void useInternalFont(uchar font)
  {
    asm {
	push bp
	mov  ah,0x11
        mov  al,font
	mov  bl,0
	int  0x10
	pop  bp
    }
  }


  /*******************************************************************
    Define your own characters
    Points: Character height
    First: First char to define
    Count: Chars to define
    Font points to an array of character bitmaps,
    ASCII <First> first, <Points> bytes per char, top to bottom.
  *******************************************************************/
  void loadUserFont(uchar points, int first, int count, void *font)
  {
 #ifdef DPMI
    void *real, *protected;

    if GetDosMem(Real, Protected, Points*Count) then
    {
      MemMove(Font, Protected, Points*Count);
 #endif
      asm {
	push bp
	mov  ax,0x1110
	mov  bl,0                 // First definition block
        mov  bh,points
        mov  cx,count
        mov  dx,first
       #ifdef DPMI
	mov  RealRegs.RealEBP.Word,0

	mov  si,Real.Word+2
	mov  RealRegs.RealES.Word,si

	push 0x10
	call RealModeInterrupt
       #else
        les  bp,font
	int  0x10
       #endif
	pop  bp
      }
 #ifdef DPMI
      GlobalDOSFree(Seg(Protected^));
    }
 #endif
  }


  /*******************************************************************
    Turn the display OFF
  *******************************************************************/
  void noRefresh()
  {
    asm {
	cli
	mov    es,Seg0040
        mov    dx,es:[addr6845]
	add    dx,0x0006

	in     al,dx
	mov    bx,dx
	mov    dx,0x03C0
	mov    al,0x12
	out    dx,al
        jmp    delay
	}
      delay:
	asm {
	xor    al,al
	out    dx,al
	xchg   dx,bx
	in     al,dx
	xchg   dx,bx

	mov    al,0x20
	out    dx,al
	sti
    }
  }

  /*******************************************************************
    Test to see if we're in text mode.
    NB: Turbo Vision supports a maximum of 132 columns (see the
    definitions of TDrawBuffer/maxViewWidth)
  *******************************************************************/
  Boolean isProbablyTextMode()
  {
    return Boolean(
      (Mem(Seg0040,crtWidth)>=40) && (Mem(Seg0040,crtWidth)<=maxViewWidth) &&
      (Mem(Seg0040,crtRows)>20) && (Mem(Seg0040,crtRows)<100) &&
      (MemW(Seg0040,crtSize)!=0) &&
      (Mem(Seg0040,crtWidth)*Mem(Seg0040,crtRows)*4>MemW(Seg0040,crtSize)));
  }


  /*******************************************************************
    This function is used to determine if the video memory segment
    starts at B000 (mono) or B800 (color).
  *******************************************************************/
  Boolean isColorMode()
  {
    return Boolean(MemW(Seg0040,addr6845)==0x03D4);
  }


  /*******************************************************************
    void ScanEVGAModes(First:byte; AddMode:AddModeProc);
      First:   First video mode to try
      AddMode: Procedure to call for each valid text video mode.

      ScanEVGAModes attempts to find out what video modes are available.
      It tries to set every video mode possible, checking to see if
      the BIOS put valid data for a text mode in the BIOS data segment.
      ScanVideoModes starts at mode First and works its way up to mode
      127. Every time a valid Text video mode is found, AddMode is called.

       AddMode must be a FAR void of the type AddModeProc.

  *******************************************************************/
  void scanEVGAModes(ushort modeOffset, ModeSet modesToCheck, AddModeProc addMode)
  {
    ushort  mode, rows, columns;

    for (mode=0; mode<=127; mode++)
      if (modesToCheck.has(mode))
      {
        setSpecialVideoMode(modeOffset+mode | dontClearVideoModeFlag);
        noRefresh();

        rows=Mem(Seg0040,crtRows)+1;
        columns=Mem(Seg0040,crtWidth);
        if (isProbablyTextMode() && (modeOffset+mode==getSpecialVideoMode()))
          addMode(modeOffset+mode, rows, columns,
                  Mem(Seg0040,crtPoints), isColorMode());
      }
  }


/***************************************************************************
  Video state object
***************************************************************************/

  /*******************************************************************
    Attempt to save current video state
  *******************************************************************/
  void VideoState::save()
  {
    mode=getSpecialVideoMode();
    lines=Mem(Seg0040,crtRows);
    charHeight=Mem(Seg0040,crtPoints);
  }


  /*******************************************************************
    Attempt to restore previous video state
  *******************************************************************/
  void VideoState::restore()
  {
    setSpecialVideoMode(mode);

    if (lines!=Mem(Seg0040,crtRows))
      switch (charHeight)
      {
        case 14: useInternalFont(internal8x14Font); break;
        case 16: useInternalFont(internal8x16Font); break;
	default:
          useInternalFont(internal8x8Font);
      }
  }
