/***************************************************************************
  ModeDialog unit
  A dialog displaying available video modes, supporting routines
  PJB August 30, 1993, Internet mail to d91-pbr@nada.kth.se
  Copyright PJB 1993, All Rights Reserved.
  Free source, use at your own risk.
  If modified, please state so if you pass this around.

  If you want to omit certain video modes from the list, change the
  AddMode void to include a test (e.g. if Columns<80 ) Exit...)

  Turbo Vision works in 40 columns, but the SelectVideoMode dialog does
  not (it is too wide, selecting Preview will shrink the dialog).

  You can overlay this unit and put TSelectVideoModeDialog in a
  resource file. Here is what to do with a resource file:

    TVideoList::setup();
    selectVideoMode(PSelectVideoModeDialog(RezFile.get('VideoModeDialog')));


  See VIDEOTST for a demonstration of this unit.

***************************************************************************/

#define Uses_TApplication
#define Uses_TEvent
#define Uses_TMouse
#define Uses_TScreen
#define Uses_TStringCollection
#include <tv.h>
#include <strstream.h>
#include <iomanip.h>

#include <math.h>
#include "toycfg.h"
#include "modedlg.h"
#include "tvvideo.h"
#include "vesa.h"
#include "video.h"


const
  cmPreview = 1000,
  cmRescan  = 1001;


// SelectVideoModeDialog GetData/SetData operates on this
struct {
  TListBoxRec videoListBox;
} videoModeDataRec;


//
//  Delay for Ticks 18ths of a second, calling Idle
//

void wait(ushort ticks)
{
  ushort finish;

  finish=MemW(Seg0040,0x6C)+ticks;
  while (finish-MemW(Seg0040,0x6C)<=ticks)
    TApplication::application->idle();
}


//
//  This procedure will be called by scanEVGAModes with
//  new mode information.
//

void far TVideoList::addMode(ushort mode, ushort rows, ushort columns,
                 ushort charHeight, Boolean color)
{
  if (columns>=80 && TVideoList::count<maxVideoModes)
  {
    modes[count].mode=mode;
    modes[count].columns=columns;
    modes[count].rows=rows;
    modes[count].charHeight=charHeight;
    modes[count].color=color;
    count++;


    char        str[80];
    ostrstream  line(str, sizeof str);

    line
      << setw(3) << hex << mode << "h  "
      << setw(3) << dec << columns
      << "x"
      << rows
      << "  "
      << setw(2) << charHeight << "p"
      << "  ";

    if (mode==TDisplay::smBW80)
      line << "b/w";
    else
      if (color)
        line << "color";
      else
        line << "mono";

    line << (char)0;
    list->insert(newStr(str));
  }
}



int TVideoList::count=0;
Boolean TVideoList::hasToScan=True;
TStringCollection *TVideoList::list=0;
ModeDataRec TVideoList::modes[maxVideoModes];
const char * const TVideoList::name = "TVideoList";


//
//  Simple example of how to find a reasonably similar video mode
//  Tries to weigh width and height differently.
//

ushort TVideoList::findSimilarVideoMode(uchar columns, uchar rows, Boolean color)
{
  ushort diff;
  ushort oldDiff=999;
  ushort mode=TScreen::screenMode;

  for (int i=0; i<count; i++)
  {
    diff=abs(modes[i].rows-rows)+
          abs(modes[i].columns-columns)/2 +
          20*(ushort)(modes[i].color!=color);

    if (diff<oldDiff)
    {
      oldDiff=diff;
      mode=modes[i].mode;
    }
  }
  return mode;
}


//
//  Scan for video modes and add to videoList
//

void TVideoList::setup()
{
  if (hasToScan)    // Check for previous list...
  {
    hasToScan=False;
    list = new TStringCollection(20,10);

   #ifdef TOYVESASUPPORT
    if (vesaScanningPossible())
    {
      //
      //  Add standard modes if necessary, Marek Bojarski's idea
      //
      if (!standardInfoAvailable)
      {
        TMouse::hide();
        scanEVGAModes(0, standardTextModes, addMode);
        setSpecialScreenMode(TScreen::screenMode);
        TMouse::show();
      }
      scanVesaModes(addMode);
    }
    else
   #endif
    {
      TMouse::hide();

      scanEVGAModes(0, vgaModes, addMode);

     #ifdef TOYVESASUPPORT   // If not vesaScanningPossible
      if (vesaVersion!=0)
        scanEVGAModes(0x100, vesaModes, addMode);
     #endif

      // Restore Turbo Vision screen
      setSpecialScreenMode(TScreen::screenMode);
      TMouse::show();
    }
  }
  videoModeDataRec.videoListBox.collection=list;
}


//
//  These routines save mode information on a stream. They are meant
//  to be used with an init or configuration file
//

void TVideoList::write(opstream& os)
{
  os << list;
  os.writeBytes(&modes, sizeof(modes));
}

void *TVideoList::read(ipstream& is)
{
  is >> list;
  is.readBytes(&modes, sizeof(modes));
  return this;
}

TStreamable *TVideoList::build()
{
  return new TVideoList(streamableInit);
}


//
//  Let the user select a video mode
//

void selectVideoModeDialog()
{
  selectVideoMode(new TSelectVideoModeDialog());
}


static ushort execDialog(TWindow *D, void *p=0)
{
  if (p)
    D->setData(p);

  ushort cm=TApplication::application->execView(D);

  if (p)
    D->getData(p);

  return cm;
}



//
//  Dialog already created, now execute it
//

void selectVideoMode(TSelectVideoModeDialog *d)
{
  for (int i=0; i<TVideoList::count; i++)
    if (TVideoList::modes[i].mode==TScreen::screenMode)
      videoModeDataRec.videoListBox.focused=i;

  if (execDialog(d, &videoModeDataRec)==cmOK)
    if (TVideoList::count>0)
      setSpecialScreenMode(TVideoList::modes[videoModeDataRec.videoListBox.focused].mode);
}





//
//   The mode dialog
//

TSelectVideoModeDialog::TSelectVideoModeDialog() :
       TDialog(TRect(14, 7, 66, 24), "Select Video Mode"),
       TWindowInit(TSelectVideoModeDialog::initFrame)

{
 TView *control;
 options |= ofCentered;

 control = new TScrollBar(TRect(32, 3, 33, 15));
 insert(control);

 videoListBox = new TListBox(TRect(5, 3, 32, 15), 1, (TScrollBar*)control);
 insert(videoListBox);

   insert(new TLabel(TRect(4, 2, 16, 3), "~V~ideo modes", videoListBox));

 control = new TButton(TRect(37, 3, 48, 5), "~P~review", cmPreview, bfDefault);
// control->helpCtx = hcPreview;
 insert(control);

 control = new TButton(TRect(37, 6, 48, 8), "O~K~", cmOK, bfNormal);
// control->helpCtx = hcOK;
 insert(control);

 control = new TButton(TRect(37, 11, 48, 13), "~R~escan", cmRescan, bfNormal);
// control->helpCtx = hcRescan;
 insert(control);

 control = new TButton(TRect(37, 8, 48, 10), "Cancel", cmCancel, bfLeftJust);
// control->helpCtx = hcCancel;
 insert(control);

 control = new TButton(TRect(37, 14, 48, 16), "Help", cmHelp, bfNormal);
// control->helpCtx = hcSelectVideoMode;
 insert(control);

 selectNext(False);
}


//
//  Events
//

void TSelectVideoModeDialog::handleEvent(TEvent& event)
{
  TDialog::handleEvent(event);

  if (event.what & evMessage)
  {
    switch (event.message.command)
    {
      case cmListItemSelected:      /* Mouse double clicked in list */
      case cmPreview:
      {
        ushort oldMode=TScreen::screenMode;
        setSpecialScreenMode(TVideoList::modes[videoListBox->focused].mode);
        wait(previewTime);
        setSpecialScreenMode(oldMode);
	break;
      }
      case cmRescan:
        TVideoList::hasToScan=True;
        TVideoList::list=0;
        TVideoList::setup();
        videoListBox->newList(TVideoList::list);
	break;
      default:
	return;
    }
    clearEvent(event);
  }
}

const char * const TSelectVideoModeDialog::name = "TSelectVideoModeDialog";

void TSelectVideoModeDialog::write( opstream& os )
{
 TDialog::write( os );
 os << videoListBox;
}

void *TSelectVideoModeDialog::read( ipstream& is )
{
 TDialog::read( is );
 is >> videoListBox;
 return this;
}

TStreamable *TSelectVideoModeDialog::build()
{
    return new TSelectVideoModeDialog( streamableInit );
}

// From here to end of file may be removed if TSelectVideoModeDialog will not be streamed.

TStreamableClass RModeDialog( TSelectVideoModeDialog::name,
			TSelectVideoModeDialog::build,
			__DELTA(TSelectVideoModeDialog)
                      );

__link(RButton)
__link(RLabel)
__link(RListBox)
__link(RModeDialog)
__link(RScrollBar)

