/**********************************************************/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/*
CAUTION: Compile using LARGE memory model!!!!!
*/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/**********************************************************/

#include <stdio.h>

#include "sb16io.h"

/**********************************************************/
/* basic block length (samples per block):
too sort ==> too much interrupts per second.
too long ==> too much record-to-playback delay.  */
/* #define N 400 */
#define N 4096  /* shareware version only supports this */

/* sampling rate */
/*#define SRATE 8000*/
#define SRATE 7500  /* shareware version only supports this */

/**********************************************************/
/* callback function. whenever a new block (length N) is full,
this callback is called (at interrupt-time, so be carefull with
what you do!). */

void mifunc( void )
{
	UINT i;
	INT8 * v8;
	INT16 * v16;

	v8 = sb16io_get8(SB16IO_NOWAIT);  /* get SB 8 bits buffer */
	v16 = sb16io_get16(SB16IO_NOWAIT);  /* get SB 16 bits buffer */
	/* we have used NOWAIT mode, because we are at interrupt time!!
	moreover, this callback has been called because there is a new
	recorded buffer. */


	/* copy input to output, but alternate inverts one sample
	(+ - + - + - ...) This is equivalent to a Nyquist freq.
	modulation, so the frequency spectrum is inverted (low
	frequencies become high, and high frec. become low). */
	for (i=0; i<N; i++) {  /* we asume N is even!! */
		v16[i] = (((INT16)v8[i]) << 8);
		i++;
		v16[i] = -(((INT16)v8[i]) << 8);
	}
}

/**********************************************************/

int main( void )
{
	int err;

	printf("Sample program to record & play concurrently using SB16.\n"
		"In this program, recording is done using 8 bit signed samples, and\n"
		"playback uses 16 bit signed samples. The playback signal is a\n"
		"spectrum-inverted copy of the input signal (low freqs. goes\n"
		"to high freqs. and viceversa).\n"
		"Press ENTER to continue...");
	fgetc(stdin);

	/* prepare sb16 */
	err = sb16io_open(SB16IO_RECORD8,  /* 8 bit record & 16 bit playback */
			SRATE,    /* sampling rate (must be the same for 8 & 16 bits) */
			SB16IO_MONO8,  /* mono 8 bit (recording) */
			SB16IO_MONO16,  /* mono 16 bit (playback) */
			N,             /* basic block length */
			mifunc);      /* user callback to process basic blocks */

	if (err) {  /* sb16io_open() returns 0 if no error */
		printf("error initializing\n");
		return 1;
	}

	sb16io_start();  /* start record&play */

	/* now do whatever you want, sb is working in background */
	printf("press ENTER to stop...");
	fgetc(stdin);

	/* stop & free sb16 */
	sb16io_close();

	return 0;
}

/**********************************************************/

