/**********************************************************/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/*
CAUTION: Compile using LARGE memory model!!!!!
*/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/**********************************************************/

#include <stdio.h>

#include "sb16io.h"

/**********************************************************/
/* basic block length (samples per block):
too sort ==> too much interrupts per second.
too long ==> too much record-to-playback delay.

The blockleght N implies 'logical samples', so that in stereo
mode, N stereo logical 16bit samples are actually N*2 16 bit
samples.
A stereo logical sample is (left+right) channels sample. */
/*#define N 200 */
#define N 4096   /* Shareware version only supports this */

/* sampling rate */
/*#define SRATE 8000*/
#define SRATE 7500  /* Shareware version only supports this */

/**********************************************************/
/* callback function. whenever a new block (length N) is full,
this callback is called (at interrupt-time, so be carefull with
what you do!). */

void mifunc( void )
{
	UINT i;
	INT8 * v8;
	INT16 * v16;

	v8 = sb16io_get8(SB16IO_NOWAIT);  /* get SB 8 bits buffer */
	v16 = sb16io_get16(SB16IO_NOWAIT);  /* get SB 16 bits buffer */
	/* we have used NOWAIT mode, because we are at interrupt time!!
	moreover, this callback has been called because there is a new
	recorded buffer. */

	/* copy half buffer to left channel, and the other half, to
	right chanel */

	/* we asume N is even!! */

	/* first half buffer to left channel, and 0 to right channel */
	for (i=0; i<N/2; i++) {
		v16[i*2] = (((INT16)v8[i]) << 8);  /* left */
		v16[i*2+1] = 0;                    /* right */
	}
	/* second half buffer to right channel, and 0 to left channel */
	for (i=N/2; i<N; i++) {
		v16[i*2] = 0;        /* left */
		v16[i*2+1] = (((INT16)v8[i]) << 8);  /* right */
	}
}

/**********************************************************/

int main( void )
{
	int err;

	printf("Sample program to record & play concurrently using SB16.\n"
		"In this program, recording is done using 8 bit MONO signed samples\n"
		"and playback using 16 bit STEREO signed samples.\n"
		"The recorded mono samples are alternatively sent to left\n"
		"and right playback channel in short blocks.\n"
		"Press ENTER to continue...");
	fgetc(stdin);

	/* prepare sb16 */
	err = sb16io_open(SB16IO_RECORD8,  /* 8 bit record & 16 bit playback */
			SRATE,    /* sampling rate (must be the same for 8 & 16 bits) */
			SB16IO_MONO8,  /* mono 8 bit (recording) */
			SB16IO_STEREO16,  /* mono 16 bit (playback) */
			N,             /* basic block length */
			mifunc);      /* user callback to process basic blocks */

	if (err) {  /* sb16io_open() returns 0 if no error */
		printf("error initializing\n");
		return 1;
	}

	sb16io_start();  /* start record&play */

	/* now do whatever you want, sb is working in background */
	printf("press ENTER to stop...");
	fgetc(stdin);

	/* stop & free sb16 */
	sb16io_close();

	return 0;
}

/**********************************************************/

