
_TEXT   SEGMENT WORD PUBLIC 'CODE'
_TEXT   ENDS

_DATA SEGMENT WORD PUBLIC 'DATA'        
_DATA   ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
;GLOBAL UNINITIATED DATA GOES HERE
_BSS    ENDS

DGROUP  GROUP CONST,_BSS,_DATA
;
        ASSUME DS:DGROUP,SS:DGROUP

;EXTRN EXTERNAL SUBROUTINE CALLS GO HERE
;
; _digplay FAR Procedure for C Written by John A. Ball  July 24, 1995
;
;Plays back sound using DIGPAK drivers
;
;       int     digplay(SNDSTRUC far *sndplay);
;
;       error=digplay(SNDSTRUC far *sndplay);
;
_TEXT   SEGMENT
        ASSUME CS:_TEXT
        PUBLIC _digplay
                
_digplay PROC FAR

PARMA           EQU [BP+6]      ;Sound Structure Pointer
PARMB           EQU [BP+10]
PARMS           EQU 4           ;Number of bytes for local storage

BUFFERPNT       EQU [BP-4]      ;LOCAL VARIABLES GO HERE

        PUSH BP                 ;Save stack Frame
        MOV BP,SP
        SUB SP,PARMS            ;MAKE SPACE FOR LOCAL VARIABLE (INT) ON STACK
        PUSHF
        PUSH DS                 ;Save registers
        PUSH ES
        PUSH SI        
        
        JMP OVERDATA
PENDING_FLAG   LABEL   WORD
PENDING_FLAG_ADDR      DD 0     ;Location of sound pending flag

OVERDATA:
        LES DI,PARMA            ;GET SOUND STRUCTURE POINTER
        MOV BUFFERPNT,DI        ;AND SAVE
        MOV DI,ES
        MOV BUFFERPNT+2,DI
;        
        MOV AX,0688h            ; Function #1 Digplay
        LDS SI,BUFFERPNT
        INT 66H

IOWAIT:
        INT 28H                 ;MS-DOS idle handler
        MOV AX,1680H
        INT 2FH                 ;MS-DOS idle call

        MOV AH,01H              ;See if key pressed
        INT 16H
        JZ DMA_DONE
        MOV AX,0
        INT 16H                 ;Get the pressed key
        CMP AL,31H              ;See if 1 KEY was pressed?
        JE DONE
        CMP AL,1BH              ;See if ESC key hit?
        JNE DMA_DONE
        MOV AX,068FH            ;Stop all sound
        INT 66H
        MOV AX,0FFFFH           ;EXIT ERROR CODE
        JMP EXIT

DMA_DONE:
        PUSH DS
        LDS SI,BUFFERPNT        ;Check Is Playing Flag
        LDS BX,[SI+6]           ;Get address of flag
        MOV AX,[BX]             ;Get Flag
        OR AX,AX                ;and see if zero?
        POP DS
        JZ DONE
        MOV AX,0689H
        INT 66H
        OR AX,AX
        JZ DONE
        JMP IOWAIT

DONE:   MOV AX,0                ;OK
EXIT:
RESTORE:
        POP SI                  ;Restore registers
        POP ES
        POP DS
        POPF
        ADD SP,PARMS            ;RESTORE SP
        POP BP                  ;RESTORE BP
        RET                     ;RETURN FAR


_digplay  ENDP
_TEXT   ENDS        
        END

