/*
  movies.c - Display Movie Select's movcard.dat file.

  Jason Hood, 30 October, 1 - 9 November, 2000.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


#define MOVCARD "db/movcard.dat"
#define RATING	0x25
#define LENGTH	0x26
#define CATEG	0x28
#define SUBCAT	0x2a
#define TITLE	0x32

#define TITLEIDX "db/movietit.nx1"
#define TITLEREF "db/movietit.in1"

#define CATEGS	 16
#define RATINGS   6


FILE*  file;
long*  idx;
int    idxs;
long*  movie;
int    movies;
char** subcat;
int    subcats;
char*  rating[] = { "?", "G", "PG", "PG-13", "R", "NC-17", "X", "??" };

struct
{
  int	id;
  char* name;
}
categ[] =
{
  { 0x0064, "Adventures" },
  { 0x0078, "Comedy" },
  { 0x0082, "Drama" },
  { 0x0087, "Horror Suspense" },
  { 0x00A0, "Sci-Fi/Fantasy" },
  { 0x00AA, "Western" },
  { 0x012C, "Foreign Film" },
  { 0x008C, "Musical & Perf. Arts" },
  { 0x006E, "Childrens" },
  { 0x0096, "Religious" },
  { 0x01F4, "Sports/Recreation" },
  { 0x02BC, "Education/Gen. Interest" },
  { 0x0384, "Adult Audience" },
  { 0x0389, "Adult Audience" },                 // Only one
  { 0x0005, "New Release" },
  { 0x0000, "Very New Release" },               // Only three
  { 0xffff, "Unknown" }                         // Not necessary
};


int read2( FILE* file )
{
  return (fgetc( file ) << 8) |	fgetc( file );
}

long read4( FILE* file )
{
  return (fgetc( file ) << 24) | (fgetc( file ) << 16) |
	  (fgetc( file ) << 8) |  fgetc( file );
}

int readw( FILE* file )
{
  return fgetc( file ) | (fgetc( file ) << 8);
}

long readl( FILE* file )
{
  return  fgetc( file )        | (fgetc( file ) << 8) |
	 (fgetc( file ) << 16) | (fgetc( file ) << 24);
}


char* lower( char* str )
{
  static char* nolo[] = { "ABC",  "BBC",  "CC",   "FA",   "FBI",  "II",
			  "III",  "IV",   "JFK",  "NBA",  "NFL",  "PGA",
			  "TNT",  "TV",   "UFO",  "WCW",  "WW",   "WWI",
			  "WWII", "ZZ",   "~" };
  char* tmp = str;
  int	cnt, j;

  for (;;)
  {
    while (*tmp && !isupper( *tmp )) ++tmp;
    if (!*tmp) break;
    if (tmp > str && isdigit( tmp[-1] ))
    {
      if (tmp[1] && !isalnum( tmp[2] ))
      {
	if ((tmp[0] == 'T' && tmp[1] == 'H') ||
	    (tmp[0] == 'S' && tmp[1] == 'T') ||
	    (tmp[0] == 'N' && tmp[1] == 'D') ||
	    (tmp[0] == 'R' && tmp[1] == 'D'))
	  --tmp;
      }
      else if (tmp[0] == 'S' && !isalnum( tmp[1] ))
	--tmp;
    }
    else if (*tmp == 'S' && tmp-1 > str && tmp[-1] == '\'' && isdigit(tmp[-2]))
      --tmp;
    else
    {
      for (cnt = 1; isupper( tmp[cnt] ) && cnt < 5; ++cnt) ;
      if (cnt == 2 && *tmp == 'V' && tmp[1] == 'S') --tmp;
      else if (cnt >= 2 || cnt <= 4)
      {
	for (j = 0; *nolo[j] < *tmp; ++j) ;
	while (*nolo[j] == *tmp)
	{
	  if (strlen( nolo[j] ) == cnt && !strncmp( nolo[j]+1, tmp+1, cnt-1 ))
	  {
	    tmp += cnt - 1;
	    break;
	  }
	  ++j;
	}
      }
    }
    ++tmp;
    while (*tmp && (isupper( *tmp ) || *tmp == '\''))
    {
      if (*tmp == '\'' && isupper( tmp[-1] ) && tmp[-1] != 'I' &&
	  isalnum( tmp[1] ) && isalnum( tmp[2] )) break;
      *tmp = tolower( *tmp );
      ++tmp;
    }
  }

  return str;
}


char* reads( FILE* file, int size )
{
  int	len;
  char* buf;

  len = (size == 1) ? fgetc( file ) : read2( file );
  if (len)
  {
    buf = malloc( len + 1 );
    fread( buf, len, 1, file );
    buf[len] = 0;
    lower( buf );
  }
  else buf = NULL;

  return buf;
}


char** reada( char* str, int* cnt )
{
  int	 len;
  char** buf;

  *cnt = 0;
  for (len = 0; str[len]; ++len)
  {
    if (str[len] == '\r') ++*cnt;
  }

  if (*cnt == 0) buf = NULL;
  else
  {
    buf = malloc( *cnt * sizeof(char*) );
    for (len = 0; len < *cnt; ++len)
    {
      buf[len] = str;
      while (*str != '\r') ++str;
      *str++ = 0;
    }
  }

  return buf;
}


void read_subcats( void )
{
  FILE* file = fopen( "subcat.lst", "rb" );
  char*	buf;
  int	len;

  fseek( file, 0, SEEK_END );
  len = ftell( file );
  rewind( file );
  buf = malloc( len );
  fread( buf, len, 1, file );
  fclose( file );
  subcat = reada( buf, &subcats );
}


void wrap( char* str, int width )
{
  int len = strlen( str );
  int j, k;

  while (len > width)
  {
    for (j = width; j > 0 && str[j] != ' '; --j) ;
    if (j == 0) j = width;
    k = (j == width);
    len -= j + 1;
    for (; j; ++str, --j) putchar( *str );
    ++str;
    if (!k) putchar( '\n' );
  }
  if (len == width)
    fputs( str, stdout );
  else
    puts( str );
}


void display_titles( int start, int cnt )
{
  char* title;

  for (; cnt; ++start, --cnt)
  {
    fseek( file, ((start < 0) ? movie[-start] : idx[start]) + TITLE, SEEK_SET );
    title = reads( file, 1 );
    puts( title );
    free( title );
  }
}


void display_film( int index )
{
  char*  title;
  char*  desc;
  char*  cast_s;
  char*  dir_s;
  char*  misc;
  char** cast;
  char** dir;
  int	 cast_c, dir_c, subc_c;
  int	 rate, length, cat, subc[7];
  int	 len;
  int	 j;

  if (index < 0)
  {
    index = -index;
    if (index >= movies)
    {
      printf( "Movie numbers only go up to %d.\n", movies - 1);
      return;
    }
    if (movie[index] == 0)
    {
      printf( "Movie number %d does not exist.\n", index );
      return;
    }
    index = movie[index];
  }
  else
  {
    if (index >= movies)
    {
      printf( "Movie numbers only go up to %d.\n", movies - 1);
      return;
    }
    index = idx[index];
  }
  fseek( file, index + RATING, SEEK_SET );

  rate = fgetc( file );
  length = read2( file );
  cat = read2( file );
  subc_c = fgetc( file );
  for (j = 0; j < subc_c; ++j)
    subc[j] = fgetc( file ) - 1;
  for (; j < 7; ++j) fgetc( file );
  title = reads( file, 1 );
  dir_s = reads( file, 1 );
  cast_s = reads( file, 2 );
  desc = reads( file, 2 );
  len = read2( file );			// Skip Director xref
  fseek( file, len, SEEK_CUR );
  len = read2( file );			// Skip Actor xref
  fseek( file, len, SEEK_CUR );
  misc = reads( file, 1 );		// Year~TV~B&W/Color~Type

  putchar( '\n' );
  wrap( title, 80 );
  putchar( '\n' );
  free( title );

  if (desc) wrap( desc, 80 );
  putchar( '\n' );
  free( desc );

  puts( misc );
  putchar( '\n' );
  free( misc );

  if (rate > RATINGS) rate = RATINGS;
  printf( "Rating: %s\n", rating[rate] );

  fputs( "Length: ", stdout );
  if (length) printf( "%d minutes\n", length );
  else puts( "Unknown" );

  fputs( "Category: ", stdout );
  for (j = 0; j < CATEGS && categ[j].id != cat; ++j) ;
  puts( categ[j].name );
  for (j = 0; j < subc_c; ++j)
    printf( "            %s\n", subcat[subc[j]] );

  if (cast_s)
  {
    cast = reada( cast_s, &cast_c );
    printf( "\nCast: %s\n", cast[0] );
    for (j = 1; j < cast_c; ++j)
    {
      printf( "      %s\n", cast[j] );
    }
    free( cast );
    free( cast_s );
  }

  if (dir_s)
  {
    dir = reada( dir_s, &dir_c );
    if (dir)				// Some are stuffed (?)
    {
      printf( "\nDirector: %s\n", dir[0] );
      for (j = 1; j < dir_c; ++j)
      {
	printf( "          %s\n", dir[j] );
      }
      free( dir );
    }
    free( dir_s );
  }
}


void search( char* wrd[], int wrds )
{
  FILE* idx = fopen( TITLEIDX, "rb" );
  FILE* ref = fopen( TITLEREF, "rb" );
  int	pos[28];
  int*	match = NULL;
  int*	title;
  int	matches = 0, titles = 0;
  int	exact;
  char* buf;
  char* num;
  int	i, j, k = 0, cnt;
  long	p;
  int	c, t = 0;

  fseek( idx, 0x18, SEEK_SET );
  for (j = 0; j < 28; ++j)
    pos[j] = readw( idx );

  exact = (*wrd[0] == '=');
  if (exact)
  {
    if (wrd[0][1]) ++wrd[0];
    else ++wrd, --wrds;
  }

  for (j = 0; j < wrds; ++j)
  {
    strupr( wrd[j] );
    i = (isupper( *wrd[j] )) ? *wrd[j] - 'A' + 1 : 0;
    fseek( idx, pos[i] * 4 + 0x50, SEEK_SET );
    p = readl( idx );
    fseek( idx, p, SEEK_SET );
    cnt = pos[i+1] - pos[i] + (i == 26);	// ??
    for (; cnt; --cnt)
    {
      titles = readw( idx );
      k = readw( idx );
      p = readl( idx );
      c = 0;
      while (wrd[j][c] && (t = fgetc( idx )) == wrd[j][c]) ++c;
      if (wrd[j][c] == 0 && fgetc( idx ) == 0)
	break;
      titles = 0;
      if (t > wrd[j][c]) break;
      if (t) while (fgetc( idx )) ;		// Skip to the NUL
      if (ftell( idx ) & 1) fgetc( idx );	// Skip second NUL
    }
    if (titles)
    {
      fseek( ref, p, SEEK_SET );
      buf = malloc( k+1 );
      fread( buf, k, 1, ref );
      buf[k] = 0;
      if (matches == 0)
      {
	match = malloc( titles * sizeof(int) );
	num = strtok( buf, "," );
	while (titles)
	{
	  match[matches++] = atoi( num );
	  num = strtok( NULL, "," );
	  --titles;
	}
      }
      else
      {
	title = malloc( matches * sizeof(int) );
	t = 0;
	num = strtok( buf, "," );
	while (titles)
	{
	  k = atoi( num );
	  for (i = 0; i < matches; ++i)
	  {
	    if (match[i] == k)
	    {
	      title[t++] = k;
	      break;
	    }
	  }
	  num = strtok( NULL, "," );
	  --titles;
	}
	for (i = 0; i < t; ++i) match[i] = title[i];
	matches = t;
	free( title );
	if (t == 0) j = wrds;
      }
      free( buf );
    }
  }

  if (matches)
  {
    if (exact && matches > 1)
    {
      titles = 0;
      for (j = 0; j < matches; ++j)
      {
	fseek( file, movie[match[j]] + TITLE, SEEK_SET );
	buf = strupr( reads( file, 1 ) );
	if (wrds == 1)
	{
	  for (num = buf; !isalnum( *num ); ++num) ;
	  k = !(strncmp( num, wrd[0], strlen( wrd[0] ) ));
	  if (k) k = (isupper( num[strlen( wrd[0] )] ) == 0);
	}
	else
	{
	  num = strstr( buf, wrd[0] ) + strlen( wrd[0] );
	  for (k = 1; k < wrds; ++k)
	  {
	    num = strstr( num, wrd[k] );
	    if (num == NULL) break;
	    num += strlen( wrd[k] );
	  }
	}
	if (k == wrds) match[titles++] = match[j];
	free( buf );
      }
      matches = titles;
    }
    if (matches == 1) display_film( -match[0] );
    else
    {
      for (j = 0; j < matches; ++j)
      {
	printf( "%5d: ", match[j] );
	fseek( file, movie[match[j]] + TITLE, SEEK_SET );
	buf = reads( file, 1 );
	puts( buf );
	free( buf );
      }
      printf( "\n%d titles found.\n", matches );
    }
  }
  else puts( "No titles found." );

  if (match) free( match );

  fclose( ref );
  fclose( idx );
}


int main( int argc, char* argv[] )
{
  long	index, mov;
  int	len;

  file = fopen( MOVCARD, "rb" );
  fseek( file, 8, SEEK_SET );
  idxs = read4( file );  		// Number of movies
  index = read4( file );		// Position of index
  mov = read4( file );			// Position of movie number index
  movies = read4( file );		// Number of movie numbers
  idx = malloc( (idxs + movies) * 4 );
  movie = idx + idxs;
  fseek( file, index, SEEK_SET );
  for (len = 0; len < idxs; ++len)
    idx[len] = read4( file );
  fseek( file, mov, SEEK_SET );
  for (len = 0; len < movies; ++len)
    movie[len] = read4( file );

  read_subcats();

  if (argc == 1)
  {
    display_titles( 0, idxs );
  }
  else
  {
    if (*argv[1] == '+' || *argv[1] == '-')
      for (len = 1; len < argc; ++len) display_film( atoi( argv[len] ) );
    else
      search( argv+1, argc-1 );
  }

  free( idx );
  free( *subcat );
  free( subcat );

  fclose( file );
  return 0;
}
