comment @
 
  Changes made by Scott McNay (1:395/11) July 26, 1992, to allow routine to be
  used with code compiled with BC's /Fs option.  (Most) changes marked with
  ;BCFS0726.  May have optimized some code also.  This is a plug-in replacement
  for the original code.

  BCFS0801: Standardized code format.  Made sure that DI, SI, BP, and DS are
  saved to meet requirements of BC 7.x.  Replace usage of BL with DL and SI
  with BX to keep from having to save SI (getting nitpicky, huh?)
 
 *  MOVECURSTR
 *----------------------------------------------------------------------------
 *
 *  Routine to generate an ANSI move cursor string
 *
 *  Author: Tom Collins
 *	    09-20-90
 *
 *  Calling Sequence:
 *
 *	A$ = SPACE$(8)
 *	CALL MoveCurStr(OldY, OldX, NewY, NewX, A$, ALen)
 *	A$ = LEFT$(A$, ALen)
 *	Call QuickTput(A$, 0)
 *
 *  Returns:
 *	ANSI string in A$
 *	Length of string in ALen
 *	OldX = NewX
 *	OldY = NewY
 *
 *  Assemble with: TASM movcstr.asm [/Zi]   or,
 *		   MASM movcstr.asm [/Zi]
 *  (Zi = Debug info for CV)
 *
	@

	extrn    StringAddress:far

	.MODEL   MEDIUM, BASIC

	.CODE

	PUBLIC   MOVECURSTR
	PUBLIC   ITOA

ITOA   proc

; Optimized (i.e., rewritten) by Scott McNay to shorten code and speed up.

	aam			; Divide by 10, AH=quotient, AL=remainder     ;BCFS0726
	add	ax,'00'		; Convert to ASCII			      ;BCFS0726
	cmp	ah,'0'		; If first digit is 0, don't send it	      ;BCFS0726
	je	IT01							      ;BCFS0726
	mov	es:[di],ah	; Send first digit			      ;BCFS0726
	inc	di							      ;BCFS0726
	inc	cx		; Increment count			      ;BCFS0726
IT01:	stosb								      ;BCFS0726
	inc	cx							      ;BCFS0726
	ret			; Done					      ;BCFS0726

ITOA	endp


MOVECURSTR	proc USES es di, OLDY:ptr, OLDX:ptr, NEWY:ptr, NEWX:ptr, A:ptr, ALEN:ptr ;BCFS0801

	push    A							      ;BCFS0726
	call    StringAddress						      ;BCFS0726
	mov	di,ax							      ;BCFS0726
	mov	es,dx							      ;BCFS0726

; Build the ANSI header = ESC [

	mov	al, 01Bh	; AL = ESC
	stosb			; Save it to A$
	mov	al, '['		; AL = '['
	stosb			; Save it to A$
	mov	cx, 3		; CX = New ALEN				      ;BCFS0726

; Get NEWX and NEWY in AL and AH

	mov	bx, NEWX	; DS:BX -> NEWX				      ;BCFS0801
	mov	al, [bx]	; AL = NEWX				      ;BCFS0801
	mov	bx, NEWY	; DS:BX -> NEWY				      ;BCFS0801
	mov	ah, [bx]	; AH = NEWY				      ;BCFS0801

; See if NEWX = NEWY = 0

	and	ax, ax		; Set the flags
	jz	MC15		; NEWX = NEWY = 0.  Return.

	cmp	ax, 0101h	; See if NEWX = NEWY = 1
	jnz	MC02		; No

; NEWX = NEWY = 1.  Set string to ESC [f

	mov	byte ptr es:[di], 'H' ; Set up the A$ string		      ;BCFS0726
	jmp	short MC16	; Return

; Get the differences between the OLD and NEW strings in AX

MC02:	mov	bx, OLDX	; DS:BX -> OLDX				      ;BCFS0801
	sub	al, [bx]	; AL = NEWX - OLDX			      ;BCFS0801
	mov	bx, OLDY	; DS:BX -> OLDY				      ;BCFS0801
	sub	ah, [bx]	; AH = NEWY - OLDY			      ;BCFS0801

; See whether the X or Y or both changed.

	and	ax, ax		; Set the flags
	jz	MC15		; Neither changed

	and	al, al		; Set the flags
	jz	MC03		; X didn't change.  Just Y.

	and	ah, ah		; X changed.  See if Y did.
	jz	MC05		; No

; Both X and Y changed.  Build a string containing ESC [ NEWY ; NEWX f

	mov	bx, NEWY	; DS:BX -> NEWY				      ;BCFS0801
	mov	ax, [bx]	; AX = NEWY				      ;BCFS0801
	call	ITOA		; Convert NEWY to a string
	mov	al, ';'		; Add the semicolon
	stosb
	inc	cx		; Correct the string length
	mov	bx, NEWX	; DS:BX -> NEWX				      ;BCFS0801
	mov	ax, [bx]	; AX = NEWX				      ;BCFS0801
	call	ITOA		; Convert NEWX to a string
	mov	byte ptr es:[di], 'H' ; Add the trailing character	      ;BCFS0726
	jmp	short MC16	; Done

; Just the Y coordinate changed.  Build ESC [ nn B (or A)

MC03:	mov	bx, OLDY	; DS:BX -> OLDY				      ;BCFS0801
	mov	ax, [bx]	; AX = OLDY				      ;BCFS0801
	mov	bx, NEWY	; DS:BX -> NEWY				      ;BCFS0801
	sub	ax, [bx]	; AX = OLDY - NEWY			      ;BCFS0801
	mov	dl, 'A'		; Trailing character is 'A' (move up)	      ;BCFS0801
	jmp	short MC06	; Do the string

; Just the X coordinate changed.  Build ESC [ nn C (or D)

MC05:	mov	bx, NEWX	; DS:BX -> NEWX				      ;BCFS0801
	mov	ax, [bx]	; AX = NEWX				      ;BCFS0801
	mov	bx, OLDX	; DS:BX -> OLDX				      ;BCFS0801
	sub	ax, [bx]	; AX = NEWX - OLDX			      ;BCFS0801
	mov	dl, 'C'		; Trailing character is 'C' (move right)      ;BCFS0801

MC06:	cmp	ax, 0		; See if AX is positive
	jg	MC07		; Yes
	neg	ax		; No.  Make it positive
	inc	dl		; Increment trailing character		      ;BCFS0801
MC07:	call	ITOA		; Convert AX to a string
	mov	es:[di], dl	; Add the trailing character		      ;BCFS0801
	jmp	short MC16	; Return

; One of the coordinates is zero (illegal), or no change is required.

MC15:	mov	bx, ALEN	; DS:BX -> ALEN				      ;BCFS0801
	mov	BYTE PTR[bx], 0 ; New ALEN is zero			      ;BCFS0801
	ret			; Return

; Normal return

MC16:	mov	bx, ALEN	; DS:BX -> ALEN				      ;BCFS0801
	mov	[bx], cx	; Save CX to ALEN			      ;BCFS0801

	mov	bx, NEWX	; DS:BX -> NEWX				      ;BCFS0801
	mov	al, [bx]	; AL = NEWX				      ;BCFS0801
	mov	bx, OLDX	; DS:BX -> OLDX				      ;BCFS0801
	mov	[bx], al	; OLDX = NEWX				      ;BCFS0801

	mov	bx, NEWY	; DS:BX -> NEWY				      ;BCFS0801
	mov	al, [bx]	; AL = NEWY				      ;BCFS0801
	mov	bx, OLDY	; DS:BX -> OLDY				      ;BCFS0801
	mov	[bx], al	; OLDY = NEWY				      ;BCFS0801

	ret			; Return

MOVECURSTR endp

	end
