' $linesize:132
' $title: 'RBBSSUB5.BAS 17.5, Copyright 1986 - 94 by D. Thomas Mack'
'  Copyright 1991 by D. Thomas Mack, all rights reserved.
'  Name ...............: RBBSSUB5.BAS
'  First Released .....: June 21, 1992
'  Subsequent Releases.:
'  Copyright ..........: 1986 - 1994
'  Purpose.............: The Remote Bulletin Board System for the IBM PC,
'     RBBS-PC.BAS utilizes a lot of common subroutines.  Those that do not
'     require error trapping are incorporated within RBBSSUB 2-7 as
'     separately callable subroutines in order to free up as much
'     code as possible within the 64K code segment used by RBBS-PC.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine       Line       Function of Subroutine
'   Name           Number
' ----------       ------     ----------------------
'  BreakFileName   63300      Break file name into component parts
'  DGSMark         21925      Compare DGSMarkedFiles$ TO ZMarkedFiles$
'  DoorReturn      63100      Process door requests
'  FileSystem      20117      File System for RBBS-PC
'  FileLister      65009      To handle list of files for uploading
'  FilSecChk       21930      Test for download security
'  HSAddFileSearch 65110      Search additional U/L files for duplication
'  HSFile          65099      Checks XFER%node%.DEF for extra HS uploaded files
'  RestoreCom      63310      Restore comm port after external program
'  ReadMacro       63330      Read and process macro
'  ReadXferInfo    22000      Read XferInfo$ for Filename & FailureParm
'  ShellExit       63320      Exit RBBS via shell
'  TStats          65004      Display file transfer stats
'  WildCard        63200      Matches string to a pattern
'  WildDown           50      Find matches to input for download
'  WildFile        65200      Matches file to a filespec
'  WildMark        90000      edit marked files after wildcard marking
'  WildShow        87000      Show the marked wildcard files to the user
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
50 ' $SUBTITLE: 'WildDown -- Find matches to input for download'
' $PAGE
'
' NAME    -- WildDown
'
' INPUTS  --       PARAMETER                 MEANING
'                  ZFileName$                USER INPUT
'                  ZMarkedFiles$             PREVIOUS MARKED FILES
'                  ZFastFileList$            NAME OF FFS FILE
'                  ZFidxCfg$                 WILDDOWN CONFIGURATION FILE
'
' OUTPUTS  --      WILD?.DEF                 FILE CONTAINING A LIST
'                                            OF WILDCARD SELECTED FILES
'
' * Originaly Written by: Richard Todd
'
' ***  WILDDOWN  -  Find matches to input for download  ***
'
100   SUB WILDDOWN (FilName$,MarkedFiles$,FastFileList$,Found)
      Found = ZFalse
      IF LEN(MID$(FilName$,1,INSTR(FilName$,".") - 1)) > 8 THEN _
         CALL QuickTPut1 (ZFG6$ + "File search string " + ZFG7$ + FilName$ + _
               ZFG6$ + " exceeds allowable characters!" + ZEmphasizeOff$) : _
               EXIT SUB
      CALL QuickTPut (ZFG4$ + "Looking for Matches to " + _
                  ZFGB$ + FilName$ + ZFG4$ + SPACE$(3) + ZEmphasizeOn$ + _
                  "(<CTRL-X> Aborts) " + ZEmphasizeOff$,0)
      NumDots = 0
      FilNum = 2
      CALL OpenWork (FilNum,ZFidxCfg$,ZFalse)
      CALL ReadDir (FilNum,1)
      MaxFiles = VAL(MID$(ZOutTxt$,1,INSTR(ZOutTxt$,",")-1))
      IF MaxFiles > 100 THEN _
         MaxFiles = 100
      Comma = INSTR(ZOutTxt$,",")
      IF Comma > 0 THEN _
         MaxLines = VAL(MID$(ZOutTxt$,Comma+1)) _
      ELSE MaxLines = 9999
'
' * check for previously marked files
'
      IF LEN(MarkedFiles$) > MaxFiles * 13 THEN
         CALL SkipLine (1)
         CALL QuickTPut1(ZFGF$ + ZBG4$ + _
                       "Too Many Files Already Marked!" + _
                       ZEmphasizeOff$)
         FilName$ = ""
         CLOSE FilNum
         EXIT SUB
      END IF
'
' * save the current list of marked files
'
   HoldMarkedFiles$ = MarkedFiles$
'
' * read in the directories from the FIDX.CFG and check Security Level
'
      Index = 1
      DO WHILE NOT EOF(FilNum)
         CALL ReadDir (FilNum,1)
         Level = INSTR(ZOutTxt$,",")
         IF ZUserSecLevel >= VAL(LEFT$(ZOutTxt$,Level-1)) THEN
            ZOutTxt$(Index) = RIGHT$(ZOutTxt$,LEN(ZOutTxt$)-Level)
            DirLength = LEN(ZOutTxt$(Index))
            IF INSTR(DirLength,ZOutTxt$(Index),"\") = 0 THEN _
               ZOutTxt$(Index) = ZOutTxt$(Index) + "\"
            Index = Index + 1
         END IF
      LOOP
      CLOSE FilNum
'
' * search in the Upload and Download Directories listed in the FIDX.CFG
'
200 TotalMatch = 0
      SearchDir = 1
      MarkedFiles$ = ""
      DO WHILE SearchDir < Index
         CALL Carrier                                                ' 175-1216
         IF ZSubParm = -1 THEN                                       ' 175-1216
            ZFileSysParm = 7                                         ' 175-1216
            RETURN                                                   ' 175-1216
         END IF                                                      ' 175-1216
         GOSUB 700
         IF KillSearch THEN _
            GOTO 400
         MatchFile$ = ""
         FILESPEC$ = ZOutTxt$(SearchDir) + FilName$
         IF SearchDir = 1 THEN
            CALL SkipLine (1)
            CALL QuickTPut (ZFG4$ + "Searching " + _
                          ZFG4$ + "for Files ",0)
         END IF
         CALL MarkTime (NumDots)
         MatchFile$ = DIR$(FILESPEC$)
         IF MatchFile$ <> "" THEN
            IF INSTR(MarkedFiles$,MatchFile$) > 0 OR _
               INSTR(HoldMarkedFile$,MatchFile$) > 0 THEN _
               GOTO 210
            CALL Trim(MatchFile$)
            MarkedFiles$ = MarkedFiles$ + MatchFile$ + _
                          SPACE$(12-LEN(MatchFile$)) + CHR$(13)
            TotalMatch = TotalMatch + 1
210         MatchFile$ = DIR$
            DO WHILE MatchFile$ <> ""
               IF INSTR(Markedfiles$,MatchFile$) > 0 OR _
                  INSTR(HoldMarkedFile$,MatchFile$) > 0 THEN _
                  GOTO 220
               CALL MarkTime (NumDots)
               CALL Trim(MatchFile$)
               MarkedFiles$ = MarkedFiles$ + MatchFile$ + _
                             SPACE$(12-LEN(MatchFile$)) + CHR$(13)
               TotalMatch = TotalMatch + 1
220            MatchFile$ = DIR$
               IF TotalMatch => MaxFiles THEN
                  CALL QuickTPut (ZBackSpace$,0)
                  CALL SkipLine (1)
                  CALL QuickTPut1(ZFGF$ + ZBG4$ + _
                                "Too Many Matching Files!" + _
                                ZEmphasizeOff$)
                  FilName$ = ""
                  GOTO 400
               END IF
            LOOP
         END IF
         SearchDir = SearchDir + 1
      LOOP
      CALL QuickTPut (ZBackSpace$,0)
300   IF NOT ZFastFileSearch THEN _
         GOTO 400
      TFastFileList$ = FastFileList$
      GOSUB 310                      ' setup FFS System and search for matches
      GOTO 400                       ' exit routine and display number of matches
310   FSize = 21
      FilNum = 2
      CALL OpenRSeq (TFastFileList$,HighRec&,WasX,21,FilNum)
      FIELD #FilNum, 12 AS SearchFile$, _
                      4 AS SearchPath$, _
                      3 AS SearchDate$, _
                      2 AS SearchCrLf$
      GET FilNum,1
      IF SearchCrLf$ <> ZCRLf$ THEN
         FSize = 18
         CALL OpenRSeq (TFastFileList$,HighRec&,WasX,18,FilNum)
         FIELD #FilNum, 12 AS SearchFile$, _
                         4 AS SearchPath$, _
                         2 AS SearchCrLf$
      END IF
      LowRec& = 1
      IF LEN(ZFastTabs$) < 160 THEN _
         GOTO 325
      FirstLetter$ = LEFT$(FilName$,1)
      Temp& = HighRec&
      FirstLet = INSTR("!#$0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_",FirstLetter$)
      IF FirstLet > 0 THEN _
         LowRec& = CVL(MID$(ZFastTabs$,1+4*(FirstLet-1),4)) - 1 : _
         IF FirstLet < 40 THEN _
            Temp& = CVL(MID$(ZFastTabs$,1+4*FirstLet,4))
      IF Temp& - 1 <> LowRec& THEN _
         HighRec& = Temp&
      IF LowRec& = 0 THEN _
         LowRec& = 1
      GOTO 350
325   IF LEFT$(FilName$,1) = "*" THEN _
         GOTO 350
      WCSearch = ZTrue
      CALL BinSearch (FilName$,1,12,FSize,HighRec&,RecFoundAt&,RecFound$,FilNum,WCSearch)
      WCSearch = ZFalse
      IF RecFoundAt& > 0 THEN _
         LowRec& = RecFoundAt& _
      ELSE LowRec& = 1
350   FOR Count& = LowRec& TO HighRec&
         CALL Carrier                                                ' 175-1216
         IF ZSubParm = -1 THEN                                       ' 175-1216
            ZFileSysParm = 7                                         ' 175-1216
            RETURN                                                   ' 175-1216
         END IF                                                      ' 175-1216
         GET FilNum, Count&
         GOSUB 700
         IF KillSearch THEN _
            EXIT FOR
         CALL MarkTime (NumDots)
         FileName$ = SearchFile$
         CALL Trim (FileName$)
         IF LEFT$(SearchFile$,1) > LEFT$(FilName$,1) THEN
            CALL QuickTPut (ZBackSpace$,0)
            EXIT FOR
         END IF
         CALL WildFile (FilName$,FileName$,DoesMatch)
         IF DoesMatch AND (VAL(SearchPath$) <= MaxLines) AND _
            INSTR(MarkedFiles$,FileName$) = 0 AND _
            INSTR(HoldMarkedFiles$,FileName$) = 0 THEN
            MarkedFiles$ = MarkedFiles$ + FileName$ + _
                   SPACE$(12-LEN(FileName$)) + CHR$(13)
            TotalMatch = TotalMatch + 1
         END IF
         IF TotalMatch => MaxFiles THEN
            CALL QuickTPut (ZBackSpace$,0)
            EXIT FOR
         END IF
      NEXT
      RETURN
400   CALL QuickTPut (ZBackSpace$,0)
'
' * display number of matches found and end sub
'
600   FilName$ = ""
      CLOSE FilNum
      FilNum = 2
      CALL KillWork (ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF")
      CALL OpenWork (FilNum,ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF",ZTrue)
      CALL PrintWork (FilNum,MarkedFiles$,ZFalse)
      CLOSE FilNum
      CALL SkipLine(1)
      ZOutTxt$ = ZFGE$ + STR$(TotalMatch) + ZFGA$ + " Matches Found"
      IF TotalMatch => MaxFiles THEN _
         ZOutTxt$ = ZOutTxt$ + ZFGF$ + " - " + ZFGC$ + _
                  "Maximum Allowed Matches Reached!"
      ZOutTxt$ = ZOutTxt$ + ZEmphasizeOff$
      Call QuickTPut1 (ZOutTxt$)
      IF MarkedFiles$ <> "" THEN _
         Found = ZTrue
      MarkedFiles$ = HoldMarkedFiles$
      EXIT SUB
'
' * routine to find user break
'
700   CALL FindFKey
      KillSearch = ZFalse
      IF ZKeyPressed$ = CHR$(24) THEN _
         KillSearch = ZTrue
      IF ZLocalUser THEN _
         RETURN
      IF ZCommPortStack$ <> "" THEN _
         IF LEFT$(ZCommPortStack$,LEN(ZCommPortStack$)-1) = CHR$(24) THEN _
            KillSearch = ZTrue
      CALL EofComm (Char)
      IF Char <> -1 THEN _
         CALL GetCom (WasX$) : _
         IF WasX$ = CHR$(24) THEN _
            KillSearch = ZTrue
      CALL FlushCom (ZCommPortStack$)
      RETURN
      END SUB
'
20117 ' $SUBTITLE: 'FileSystem -- subroutine for RBBS-PC's file system'
' $PAGE
'
' NAME    -- FileSystem
'
' INPUTS  --      PARAMETER                 MEANING
'                 ZFileSysParm = 1  LIST THE SYSOP'S COMMENTS FILE
'                                2  L)IST DIRECTORY COMMAND
'                                3  D)OWNLOAD COMMAND
'                                4  RETURN FROM EXTERNAL PROTOCOLS
'                                5  U)PLOAD COMMAND
'                                6  S)CAN DIRECTORY COMMAND
'                                7  P)ERSONAL FILES COMMAND
'                                8  N)EW FILES COMMAND
'                                9  RETURN FROM EXTENDED DESCRIPTION
'
' OUTPUTS --      ZFileSysParm = 1  COMMAND PROCESSED SUCCESSFULLY
'                                2  RECYCLE TO TOP OF RBBS-PC (202)
'                                3  PROCESS NEXT COMMAND (1200)
'                                4  DENY USER ACCESS (1380)
'                                5  HANDLE EXTENDED DESCRIP. (2008)
'                                6  USER'S TIME EXCEEDED (10553)
'                                7  Carrier DROPPED (10595)
'
' PURPOSE -- To handle the RBBS-PC file system commands
'
      SUB FileSystem STATIC
'
' *****  CHECK FOR WILDCARD DOWNLOAD SUPPORT ***
'
      ZFF = ZFileSysParm
      ZFileSysParm = 1
'      CALL SaveUserActivity("F", ZNodeRecIndex, ZFalse)
      ZActiveFMSDir$ = ""
      UploadFirst = ZFalse
      DownloadFirst = ZFalse
      DownloadMarking = ZFalse
      BatchOff = 0
      TextWrap$ = ""
      PartHold$ = ""
      ZFileNumberCount = 1
      IF ZExtFileSysProcessor THEN _
         ZWasBatchTransfer = ZFalse
      IF ZFF <> 3 THEN _
         ZMarkFileNumber$ = ""
      ON ZFF GOSUB 20119, _  ' HANDLER TO LIST COMMENTS TO SYSOP
                  20150, _  ' L)IST DIRECTORY COMMAND HANDLER
                  20180, _  ' D)OWNLOAD COMMAND HANDLER
                  20263, _  ' RETURN FROM EXTERNAL Protocol'S
                  20400, _  ' U)PLOAD COMMAND HANDLER
                  21800, _  ' S)CAN DIRECTORY COMMAND HANDLER
                  21850, _  ' P)ERSONAL FILES COMMAND HANDLER
                  21860, _  ' N)EW FILES COMMAND HANDLER
                  20705, _  ' RETURN FROM EXTENDED DESCRIPTIONS
                  20202     ' Download marked files exiting subboard
      GOTO 21920
20119 ZErrCode = 0
      GOTO 20122
'
' *****  SCAN DIRECTORIES (PRINT TEXT)  ****
'
'  (formerly lines 7000 to 7260 in RBBS-PC.BAS CPC16-1A
20120 ZOutTxt$ = "Scanning Directory " + _
           ZFileNameHold$
      IF WasRS$ <> "" THEN _
         ZOutTxt$ = ZOutTxt$ + " for " + WasRS$ : _
         PrevSearch$ = WasRS$
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL AskMore ("",ZTrue,ZTrue,ZAnsIndex,ZFalse)
      IF ZNo THEN _
         ZErrCode = 0 : _
         RETURN
      CLOSE 14
      Temp$ = ""
      WasPG = ZTrue
20122 CALL OpenWork (14,ZFileName$,ZFalse)
      IF ZErrCode = 53 THEN _
         ZOutTxt$ = "Missing File " + ZFileName$ : _
         CALL UpdtCalr (ZOutTxt$,2) : _
         ZOutTxt$ = ZOutTxt$ + _
              ". Please tell SysOp" : _
         GOSUB 21650 : _
         RETURN
      EndDesc = 33 + ZMaxDescLen
      ZJumpSupported = ZTrue
      ZJumpLast$ = ""
      LastOK = ZFalse
      ZJumpSearching = ZFalse
      MaxPrint = ZPageLength - 1
      CALL CmdStackPushPop (1)
      ZLastIndex = 0
20124 CALL Carrier
      IF EOF(14) OR _
         (ZSubParm = -1 AND NOT ZLocalUser) THEN _
         GOTO 20142
      IF PartHold$ <> "" THEN _
         ZOutTxt$ = PartHold$ : _
         PartHold$ = "" : _
         GOTO 20127
20126 CALL ReadDir (14,1)
      CALL TrimTrail (ZOutTxt$," ")
      IF LEFT$(ZOutTxt$,1) <> " " THEN
         IF TextWrap$ <> "" THEN
            PartHold$ = ZOutTxt$
            ZOutTxt$ = "  " + TextWrap$
            TextWrap$ = ""
            GOTO 20140
         END IF
      END IF
20127 IF ZErrCode <> 0 THEN _
         ZWasEL = 20126 : _
         GOTO 21900
      IF LEFT$(ZOutTxt$,1) = " " THEN _
         IF LastOK AND NOT ZExtendedOff THEN _
            GOTO 20140 _
         ELSE GOTO 20124
      IF WasCK = 0 THEN _
         GOTO 20140
      LastOK = ZFalse
20128 IF ZJumpSearching THEN _
         GOTO 20129
      IF WasCK < 2 THEN _
         GOTO 20130
      IF WildSearch THEN _
         ZWasA = INSTR(ZOutTxt$," ") : _
         IF ZWasA = 0 THEN _
            GOTO 20124 _
         ELSE ZWasZ$ = LEFT$(ZOutTxt$,ZWasA - 1) : _
              CALL WildFile (WasRS$,ZWasZ$,WasXXX) : _
              WasXXX = NOT WasXXX : _
              GOTO 20136
20129 ZWasZ$ = ZOutTxt$
      CALL AllCaps (ZWasZ$)
      WasXXX = (INSTR(ZWasZ$,WasRS$) = 0)
      GOTO 20136
20130 ZWasA = INSTR(9,MID$(ZOutTxt$,1,32),"/")
      IF ZWasA = 0 THEN _
         ZWasA = INSTR(9,MID$(ZOutTxt$,1,32),"-")
20132 IF ZWasA < 3 THEN _
         GOTO 20124
      IF INSTR("0123456789",MID$(ZOutTxt$,ZWasA - 1,1)) = 0 THEN _
         GOTO 20124
      ZWasA = ZWasA - 2
      WasWK$ = RIGHT$(MID$(ZOutTxt$,ZWasA,8),2) + _
            LEFT$(MID$(ZOutTxt$,ZWasA,8),2) + _
            MID$(MID$(ZOutTxt$,ZWasA,8),4,2)
      IF MID$(WasWK$,3,1) = " " THEN _
         MID$(WasWK$,3,1) = "0"
      IF MID$(WasWK$,5,1) = " " THEN _
         MID$(WasWK$,5,1) = "0"
20134 WasXXX = (WasWK$ < WasRS$)
20136 IF WasXXX THEN _
         GOTO 20124
      IF ZJumpSearching THEN _
         WasRS$ = PrevSearch$ : _
         WasCK = PrevCK : _
         ZJumpSearching = ZFalse : _
         GOTO 20140
      IF WasPG THEN _
         WasPG = ZFalse : _
         CALL OpenWork (14,ZFileName$,ZFalse) : _
         ZWasQ = 0 : _
         GOTO 20124
20138 IF WasPG THEN _
         GOTO 20124
20140 LastOK = ZTrue
      IF TextWrap$ <> "" AND PartHold$ = "" AND LEFT$(ZOutTxt$,1) = " " THEN
         ZOutTxt$ = "  " + LTRIM$(TextWrap$) + " " + LTRIM$(ZOutTxt$)
         TextWrap$ = ""
      ELSE
         IF TextWrap$ = "" AND LEFT$(ZOutTxt$,1) = " " THEN _
            ZOutTxt$ = "  " + LTRIM$(ZOutTxt$)
      END IF
      IF LEFT$(ZOutTxt$,1) = " " THEN _
         WrapPoint = 0 _
      ELSE WrapPoint = 6
      IF LEN(ZOutTxt$) < (EndDesc - 10) AND LEFT$(ZOutTxt$,1) = " " AND PartHold$ = "" THEN
         TextWrap$ = LTRIM$(ZOutTxt$) + " " + LTRIM$(TextWrap$)
         GOTO 20124         ' read the next record if display will be short
      END IF
      IF LEN(ZOutTxt$) > (EndDesc - WrapPoint) THEN _
         CALL FileNumberWrap (TextWrap$)
      IF LEFT$(ZOutTxt$,1) <> " " AND NOT ZNonStop THEN _
         CALL FileNumbers (ZOutTxt$,OutTxtTemp$)
      CALL ColorDir (ZOutTxt$,"Y")
      ZOutTxt$ = OutTxtTemp$ + ZOutTxt$
      OutTxtTemp$ = ""
      GOSUB 21650           ' Display .Dir information with TPUT
      IF ZFileSysParm > 1 THEN _
         RETURN
20141 IF ZLinesPrinted > MaxPrint THEN
         ZTurboKey = -ZTurboKeyUser
         ZStackC = ZTrue
         CALL AskMore (",D)nld,M)ark",ZTrue,ZTrue,ZAnsIndex,ZFalse)
         ZLastIndex = ZWasQ
         CALL AraAllCaps (ZUserIn$(),1)
         IF ZUserIn$(1) <> "M" AND ZUserIn$(1) <> "D" AND ZUserIn$(1) <> "V" _
              AND VAL(ZUserIn$(1)) = 0 THEN
            IF ZFileNumberCount > 99 THEN _
               ZMarkFileNumber$ = "" : _
               ZFileNumberCount = 1
         END IF
         IF ZNo THEN
            ZErrCode = 0
            RETURN
         ELSE
            Temp$ = ZUserIn$(1)
            ZAnsIndex = 1
            CALL AskItems ("DM",Temp$,ZTrue,"#'s or file",ZMarkedFiles$,ZPersonalDnld)
            ZUserIn$(1) = ""
         END IF
      END IF
      IF Temp$ = "M" THEN _
         ZLinesPrinted = MaxPrint + 1 : _
         GOTO 20141
      IF Temp$ = "D" THEN _
         Temp = ZTrue : _
         GOTO 20142
      IF ZWasDF$ = "Y" OR ZWasDF$ = "" THEN _
         WasRS$ = PrevSearch$ : _
         ZJumpSearching = ZFalse
      IF ZJumpSearching THEN _
         IF LEFT$(ZOutTxt$,1) <> " " THEN _
            PrevSearch$ = WasRS$ : _
            PrevCK = WasCK : _
            WasCK = 2 : _
            WasRS$ = ZJumpTo$
      IF NOT ZRet THEN _
         GOTO 20124
20142 ZWasQ = 0
      CALL CmdStackPushPop (2)
      ZJumpSupported = ZFalse
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7
      RETURN
'
' *  L - COMMAND FROM FILES MENU (LIST DIRECTORY)
'
20150 ZListDir = ZTrue
      ListNew = ZFalse
      SearchDate$ = ""
      SearchString$ = ""
      WasRS$ = ""
      ShowDirOfDir = (ZLastIndex <= ZAnsIndex) AND NOT ZExpertUser
      WasCK = 0
      ZSearchingAll = ZFalse
      ZExtendedOff = ZFalse
20155 IF ListNew OR ZAnsIndex > 255 THEN _
         RETURN
      IF ZFileSysParm = 4 THEN _
         RETURN
      CALL GetDirs (ShowDirOfDir)
      IF ZWasQ = 0 OR ZSubParm < -5 THEN _                           ' 175-1219
         RETURN                                                      ' 175-1219
      IF ZUserIn$(ZAnsIndex) = "P" THEN _
         GOTO 21850
      ShowDirOfDir = ZFalse
      CALL ConvertDir (ZAnsIndex)
      WasQX = ZLastIndex
20157 CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      GOTO 20161
20159 IF ZAnsIndex < ZLastIndex THEN _
            GOTO 20155
         ZSearchingAll = ZFalse
         CALL CmdStackPushPop (1)
         ZLastIndex = 0
         IF ZNo OR InFMS OR (ZFileNameHold$ = ZDirPrefix$) THEN _
            GOTO 20155
         GOSUB 20177
      IF Temp$ <> "D" THEN
         CALL QuickTPut (ZEmphasizeOff$,0)
         ZTurboKey = - ZTurboKeyUser
         ZOutTxt$ = "End list.  L)ist, M)ark, D)nld, [Q]uit"
         GOSUB 21667
         CALL AraAllCaps (ZUserIn$(),1)
         IF ZUserIn$(1) = "L" THEN _
            ZUserIn$(ZAnsIndex) = WasA1$ : _
            GOTO 20161
         Temp$ = ZUserIn$(1)
         Temp = (ZUserIn$(1) = "D")
      END IF
      CALL AskItems ("MD",Temp$,ZTrue,"#'s or file",ZMarkedFiles$,ZPersonalDnld)
      IF ZWasQ = 0 OR ZUserSecLevel < ZOptSec(19 - 20 * (ZMenuIndex = 6)) THEN _
         Temp$ = "" : _
         GOTO 20160
      IF Temp$ = "M" THEN _
         RETURN
      IF Temp THEN _
         Temp = ZFalse : _
         GOSUB 20202 _
      ELSE IF LEN(ZUserIn$(1)) > 1 THEN _
         ZAnsIndex = 1 : _
         GOSUB 20202
20160 CALL CmdStackPushPop (2)
      IF ZAutoEnd > 0 THEN _
         ZAutoEnd = 0
      RETURN
20161 IF INSTR(ZUserIn$(ZAnsIndex),".") THEN _
         GOTO 20172
      ZViolation$ = "List Dir. "
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      ZWasA = INSTR("E+E-E",ZWasZ$)
      IF ZWasA > 0 THEN _
         IF ZWasA = 5 THEN _
            ZExtendedOff = NOT ZExtendedOff : _
            GOTO 20155 _
         ELSE ZExtendedOff = (ZWasA > 2) : _
              GOTO 20155
      CALL AllCaps(ZWasZ$)
      ZFileNameHold$ = ZWasZ$
      WasA1$ = ZWasZ$
      IF ZWasZ$ = ZDirPrefix$ THEN _
         GOTO 20164
      InFMS = ZFalse
20162 CALL CmdStackPushPop (1)         ' save dir list list processing
      CALL FMS (ZWasZ$,SearchString$,SearchDate$,InFMS, _
                ZCategoryName$(),ZCategoryCode$(),ZCategoryDesc$(),_
                DnldFlag,CatFound,ZAnsIndex)
      IF ZFileSysParm = 4 THEN _
         RETURN
      WHILE DnldFlag > 0 AND ZSubParm > -1
         IF UCASE$(ZUserIn$(ZAnsIndex)) = "M" THEN _
            DownloadMarking = ZTrue
         GOSUB 20202
         IF ZAutoEnd = 2 THEN _
            ZAutoEnd = 0
         IF ZFileSysParm > 1 THEN _
            RETURN
         WasX$ = ZCategoryCode$(CatFound)
         TurboTemp = ZTurboKeyUser
         CALL SetExpert (ZTrue)
         CALL DispUpDir (WasX$,SearchString$,SearchDate$,DnldFlag,ZAnsIndex)
         CALL SetExpert (ZFalse)
         ZTurboKeyUser = TurboTemp
         IF ZFileSysParm = 4 THEN _
            RETURN
         CALL CheckTimeRemain (MinsRemaining)
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 6 : _
            RETURN
         CALL Carrier
      WEND
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF ZAnsIndex > 255 OR ZRet THEN _
         ZLastIndex = 0 : _
         RETURN
      CALL CmdStackPushPop (2)        ' restore dir list list processing
      ZActiveFMSDir$ = ""
      IF InFMS THEN _
         GOTO 20159
      IF ZUserSecLevel < ZMinSecToView THEN _
         IF ZFileNameHold$ = ZUpldDirCheck$ THEN _
            ZOutTxt$ = "Listing of Upload Directory Available to SysOp Only" : _
            GOSUB 21640 : _
            ZNo = ZTrue : _
            GOTO 20155
      ZFileNameHold$ = ZUserIn$(ZAnsIndex)
      IF ZLimitSearchToFMS THEN _
         GOTO 20166
      IF NOT ZSearchingAll THEN _
         IF ZFileNameHold$ = "ALL" OR ZFileNameHold$ = "A" THEN _
            ZSearchingAll = ZTrue : _
            GOSUB 21890 : _
            GOTO 20157
      CALL BadFile (ZFileNameHold$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20163,20172,20176
20163 ZFileName$ = ZFileNameHold$
      CALL BadName (BadFileNameIndex,ZTrue)
      ON BadFileNameIndex GOTO 20164,20176
20164 IF ZFileName$ = ZUpldDirCheck$ AND _
         ZUserSecLevel >= ZMinSecToView THEN _
            ZFileName$ = ZUpldPath$ _
      ELSE ZFileName$ = ZCurDirPath$
      ZFileName$ = ZFileName$ + _
                   ZFileNameHold$ + _
                   "." + _
                   ZDirExtension$
      CALL Graphic (ZFileName$,ZFalse)
20165 IF ZOK THEN _
         CALL ReadDir (2,1) : _
         IF ZErrCode = 0 THEN _
            IF LEFT$(ZOutTxt$,4) = "\FMS" THEN _
               InFMS = ZTrue : _
               ZActiveFMSDir$ = ZFileName$ : _
               GOTO 20162 _
            ELSE GOTO 20167
20166 ZFileName$ = ZCurDirPath$ + _
                   ZFileNameHold$ + ".MNU"
      CALL Graphic (ZFileName$,ZTrue)
      IF ZOK THEN _
         CALL BufFile (ZFileName$,ZAnsIndex,ZFalse) : _
         GOTO 20155
      IF ZAltdirExtension$ = "" THEN _
         GOTO 20172
      ZFileName$ = ZCurDirPath$ + _
                   ZFileNameHold$ + _
                   "." + _
                   ZAltdirExtension$
      CALL Graphic (ZFileName$,ZTrue)
      IF NOT ZOK THEN _
         GOTO 20172
20167 ZUserIn$(0) = ZUserIn$(ZAnsIndex)
      GOSUB 20120
      WHILE Temp$ = "D" AND NOT EOF(14) AND ZWasQ <> 0
         GOSUB 20159
         GOSUB 20124
      WEND
      IF ZFileSysParm > 1 THEN _
         RETURN
      GOTO 20170
20168 CALL BufFile(ZFileName$,ZAnsIndex,ZFalse)
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
20170 IF ZAnsIndex > 255 THEN _
         ZLastIndex = 0 : _
         RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(0)
      GOTO 20159
20172 IF NOT ZSearchingAll THEN _
         ZOutTxt$ = "Directory " + _
              ZFileNameHold$ + _
              " not found!" : _
         GOSUB 21640 : _
         ZNo = ZTrue : _
         IF ZFileSysParm > 1 THEN _
            RETURN
      GOTO 20155
20176 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20172
20177 ZListOnly = ZFalse
      ZExtraDnldTime = 0
      ZFreeDnld = ZFalse
      ZPersonalDnld = ZFalse
      RETURN
20178 Call WildShow (WildMarkedFiles$,WildParm) ' WildCard Support
      CALL KillWork (ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF")
      CALL Carrier
      IF ZSubParm = -1 THEN _
         EXIT SUB
      ZMarkedFiles$ = ZMarkedFiles$ + WildMarkedFiles$
      IF ZDGSMarkedFiles$ <> "" THEN _
         CALL DGSMark
      RETURN
20179 ZBatchTransfer = ZFalse
      ZCmdTransfer$ = ""
      IF NOT ZCDRom THEN _
         CALL KillWork (ZDownloadWorkFile$)
      CALL KillWork (ZDownloadWorkFile$ + ".DET")
      CALL KillWork (ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF")
      IF ZCDRom THEN
         CALL KillCDWork
         CALL FindFile ("CDWORK" + ZLibDrive$ + ".WRK",Found)
         IF Found THEN
            FilNum = 2
            CALL OpenWork (FilNum,"CDWORK" + ZLibDrive$ + ".WRK",ZFalse)
            CALL ReadDir (FilNum,1)
            CLOSE FilNum
            IF ZOutTxt$ = ZNodeID$ THEN _
               CALL KillWork ("CDWORK" + ZLibDrive$ + ".WRK")
         END IF
      END IF
      IF ZCDWorkDriveFull THEN _
         ZCDWorkDriveFull = ZFalse : _
         CALL UpdtCalr ("CD-ROM work drive insufficient space",2)
      ZErrCode = 0
      RETURN
'
' *  D - COMMAND FROM FILES MENU (SEARCH FOR FILE TO DOWNLOAD)
'
20180 Temp$ = "D"
      IF NOT ZGlobalSysOp THEN
         ZFileName$ = ZHelpPath$ + "DNMSG.HLP"
         CALL Graphic (ZFileName$,ZTrue)
         IF ZOK THEN _
            ZNonStop = ZTrue : _
            CALL BufFile (ZFileName$, ZWasX,ZTrue)
      END IF
      ZFileName$ = ""
      ZDGSMarkedFiles$ = ""
      AddMarkedFiles$ = ""
      IF ZAutoEnd > 0 THEN _
         ZAutoEnd = 0
      CALL AskItems ("D",Temp$,ZFalse,"#'s or file",ZMarkedFiles$,ZPersonalDnld)
      IF UCASE$(ZUserIn$(ZAnsIndex)) = "M" THEN _
         DownloadMarking = ZTrue
      GOSUB 20177
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ = 0 THEN
         IF ZHighSpeedTransfer AND UploadFirst THEN _
            ZOutTxt$ = "Continue with transfer ([Y],N)" : _
            ZTurboKey = -ZTurboKeyUser : _
            GOSUB 21668 : _
            IF NOT ZNo THEN _
               UploadFirst = ZFalse : _
               GOTO 20501
         GOSUB 20179
         RETURN
      ENDIF
20202 IF (ZTimeLock AND 2) AND (NOT TimeLockExempt) AND NOT ZHasPrivDoor THEN _
         CALL TimeLock : _
         IF NOT ZOK THEN _
            RETURN
      IF ZAutoEnd = 2 AND LastDnld = 0 THEN
         ZAutoEnd = 0
         GOTO 20204
      END IF
      FirstDnld = ZAnsIndex
      LastDnld = ZLastIndex
      ZCmdTransfer$ = ""
      ZAnsIndex = ZLastIndex
      GOSUB 20470
      LastDnld = LastDnld + (WasX > 0)
      ZLastIndex = LastDnld
      IF ZMarkedFiles$ <> "" AND ZAutoEnd < 4 AND _
         UCASE$(ZUserIn$(ZAnsIndex)) <> "M" AND _
         UCASE$(ZUserIn$(ZLastIndex)) <> "M" AND _
         ZWasZ$ <> "M" THEN
            Temp$ = ZUserIn$(ZAnsIndex)
            ZLastIndex = LastDnld
            CALL SkipLine (1)
            UserInTemp$ = ZUserIn$(ZAnsIndex)
            ZOutTxt$ = ZFG1$ + "ADD your Marked Files to this DOWNLOAD? [Y],N " + ZEmphasizeOff$
            ZSuspendAutoLogoff = ZTrue
            GOSUB 21660
            ZSuspendAutoLogoff = ZFalse
            ZUserIn$(ZAnsIndex) = UserInTemp$
            IF NOT ZNo THEN _
               ZWasZ$ = "M" : _
               ZLastIndex = ZLastIndex + 1 : _
               LastDnld = ZLastIndex : _
               ZDGSMarkedFiles$ = ZMarkedFiles$ : _
               CALL UnMarkItems (ZMarkedFiles$,LastDnld,ZLastIndex,FoundMarked,ZFalse) : _
               LastDnld = ZLastIndex
            ZUserIn$(ZAnsIndex) = Temp$
            ZAnsIndex = FirstDnld
      END IF
      BatchBytes# = 0
      BatchBlocks# = 0
      ZDownFiles = 0
      CALL KillWork (ZNodeWorkFile$)
      CALL KillWork (ZDownloadWorkFile$)
      CALL KillWork (ZDownloadWorkFile$ + ".DET")
      CALL KillWork (ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF")
      IF ZCDRom THEN _
         CALL KillCDWork
      NoTimeDnFlag = -1
      ZErrCode = 0
      RatioDnFlag = -1
      ZAnsIndex = FirstDnld
20203 IF ZAnsIndex > LastDnld THEN _
            GOTO 20204
      GOSUB 20470
      GOSUB 20205
      IF ReStart THEN _
         ReStart = ZFalse : _
         GOTO 20202
      CALL Line25
      IF ZFileSysParm > 1 OR ZInternalProt$ = "N" THEN _
         GOTO 20204
      ZAnsIndex = ZAnsIndex + 1
      GOTO 20203
20204 ZLastIndex = 0
      LastDnld = 0
      GOSUB 20179
      RETURN
20205 ZFileName$ = ZUserIn$(ZAnsIndex)
      CALL Remove (ZFileName$,", ")
      CALL AllCaps (ZFileName$)
      IF INSTR(ZFileName$,"*") = 0 AND INSTR(ZFileName$,"?") = 0 OR ZPersonalDnld THEN _
         GOTO 20215
      ZFileNameHold$ = ZFileName$
      CALL BadName (BadFileNameIndex,ZTrue)
      IF BadFileNameIndex = 2 THEN _
         GOTO 20245
      CALL BreakFileName (ZFileName$,DR$,ZWasY$,WasX$,ZTrue)
      IF (ZWasY$ = "" OR INSTR(2,WasX$,".") <> 0) THEN _             ' 175-1224
         GOTO 20245                                                  ' 175-1216
      CALL FindLast (WasX$,"*",AstLoc,AstFound)                      ' 175-1224
      IF AstFound > 1 THEN _                                         ' 175-1224
         GOTO 20231                                                  ' 175-1224
      IF INSTR(ZFileName$,"?") <> 0 THEN _
         CALL SkipLine(1) : _
         CALL QuickTPut1(ZFGF$ + "? " + ZFGC$ + _
                         "Character Not Allowed when Downloading" + _
                          ZEmphasizeOff$) : _
         GOTO 20231
      FileName$ = ZFileName$
      IF INSTR(FileName$, ".") = 0 THEN
         FileName$ = FileName$ + ".*"
      END IF
      IF ZWildDownOK THEN
         ZSuspendAutoLogoff = ZTrue
         CALL WildDown(FileName$,WildMarkedFiles$,ZFastFileList$,Found)
         IF ZFileSysParm > 1 THEN                                    ' 175-1216
            RETURN                                                   ' 175-1216
         END IF                                                      ' 175-1216
         IF Found THEN
            CALL CmdStackPushPop (1)
            GOSUB 20178
            CALL CmdStackPushPop (2)
            CALL KillWork (ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF")
            IF WildParm <> 0 THEN
               ZWasZ$ = "M"
               CALL UnMarkItems (WildMarkedFiles$,ZAnsIndex,LastDnld,FoundMarked,ZTrue)
               ZFileName$ = ZUserIn$(ZAnsIndex)
               ZLastIndex = LastDnld
            ELSE
               FirstDnld = FirstDnld + 1
               RETURN
            END IF
         END IF
         ZSuspendAutoLogoff = ZFalse
      END IF
20215 MarkingTime = (ZAnsIndex = FirstDnld OR NOT ZConcatFIles)
      ZViolation$ = "Download "
      IF ZListOnly THEN _
         CALL BreakFileName (ZFileName$,DR$,ZWasY$,WasX$,ZTrue) : _
         ZFileNameHold$ = ZWasY$ + _
                           WasX$ : _
         GOTO 20235
      IF LEN(ZFileName$) < 4 AND NOT DownloadMarking THEN _
         CALL NumberCheck(ZFileName$,FileHasLetter) _
      ELSE FileHasLetter = ZTrue
      IF ZMarkFileNumber$ <> "" AND NOT FileHasLetter _
                 AND NOT DownloadMarking THEN _
         CALL FindFileNumber (ZFileName$,NumFileName$,NumFound) : _
         IF NumFound THEN _
            ZFileName$ = NumFileName$
      ZFileNameHold$ = ZFileName$
      CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20220,20231,20233
20220 IF INSTR (ZFileName$,".") = 0 THEN _
         FileNameAlt$ = ZFileName$ : _
         ZFileName$ = ZFileName$ + "." + ZDefaultExtension$ : _
         ZFileNameHold$ = ZFileNameHold$ + "." + ZDefaultExtension$ _
      ELSE FileNameAlt$ = ""
20222 CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount + _
                      ((ZUserSecLevel < ZMinSecToView) OR _
                       NOT ZCanDnldFromUp),MarkingTime,"D")
20225 IF ZOK THEN _
         GOTO 20235
      IF ZAbort THEN
         ZAbort = ZFalse
         IF ZBatchTransfer AND ZAnsIndex >= LastDnld THEN
            GOTO 20262
         ELSE
            ZAutoLogoffReq = ZFalse
            RETURN
         END IF
      END IF
      IF ZDotFlag THEN _
         RETURN
      IF FileNameAlt$ <> "" THEN _
         ZFileName$ = FileNameAlt$ : _
         FileNameAlt$ = "" : _
         ZFileNameHold$ = ZFileName$ : _
         GOTO 20222
20231 ZOutTxt$ = ZFileNameHold$ + _
           " not found!"
      CALL UpdtCalr (ZOutTxt$,2)
      ZOutTxt$ = ZFGE$ + ZOutTxt$ + _
           ZFG1$ + " Enter Correct name"+ZPressEnterExpert$
      ZSuspendAutoLogoff = ZTrue
      GOSUB 21660
      ZSuspendAutoLogoff = ZFalse
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ=0 THEN _
         IF ZBatchTransfer AND ZAnsIndex >= LastDnld THEN _
            GOTO 20262 _
         ELSE ZAutoLogoffReq = ZFalse : _
              RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(1)
      GOTO 20205
20233 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20231
20235 CALL BadName (BadFileNameIndex,ZTrue)
      ON BadFileNameIndex GOTO  20236,20245
20236 ZLine25$ = "(D) " + _
                 ZWasZ$
'                                                                    ' 175-1220
' *  TEST FOR DOWNLOAD SECURITY                                      ' 175-1220
'                                                                    ' 175-1220
      ZViolation$ = "Download "                                      ' 175-1220
      CALL FilSecChk (ZViolation$, ZFileNameHold$, ZOK)              ' 175-1220
      IF NOT ZOK THEN _                                              ' 175-1220
         GOTO 20245                                                  ' 175-1220
      IF ZErrCode = 53 THEN _                                        ' 175-1220
         CALL UpdtCalr ("Missing file " + ZFileSecFile$,2) : _       ' 175-1220
         GOTO 20247                                                  ' 175-1220
      IF ZErrCode <> 0 THEN _                                        ' 175-1220
         ZWasEL = 20242 : _                                          ' 175-1220
         GOTO 21900                                                  ' 175-1220
      GOTO 20247
20245 ZViolation$ = "Download " + ZFileName$
20246 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4
      RETURN
20247 ZWasDF = 0
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZFalse)
      IF INSTR("...WRK.FW .ARC.EXE.COM.OBJ.WKS.LBR.ZIP.PAK.ZOO.LZH.ARJ.GIF.MAC.","."+Extension$+".") > 2 OR _
         MID$(Extension$,2,1) = "Q" OR _
         (ZRequireNonASCII AND Extension$ = "BAS") THEN _
            ZWasDF = ZTrue
20248 ZOutTxt$ = ""
      IF ZBatchTransfer THEN _
         IF ZAnsIndex < LastDnld THEN _
            GOTO 20260
      IF ZHighSpeedTransfer AND UploadFirst THEN _
         GOTO 20260
20250 CALL XferType (2,ZTrue)
      IF ZFF THEN _
         GOTO 20260
      CALL XferType (1,ZTrue)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
20260 IF ZHighSpeedTransfer AND NOT UploadFirst THEN _
         DownLoadFirst = ZTrue
      ZTransferFunction = 1
      GOSUB 21790
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZBatchTransfer = (ZBatchProto AND (LastDnld > FirstDnld))
      IF ZBatchTransfer AND ZCmdTransfer$ = "" THEN _
         ZCmdTransfer$ = ZWasFT$
      ON INSTR("AXCYN",ZInternalProt$) GOTO _
         20340, _              ' ASCII DOWNLOAD
         20290, _              ' Xmodem
         20290, _              ' Xmodem CRC
         20270, _              ' YMODEM
         21700                 ' NONE - CANCEL
'
' *  EXTERNAL Protocol Downloads/Uploads
'
20261 IF ZReq8Bit THEN _
         IF NOT ZEightBit THEN _
            GOSUB 20318 : _
            IF ZFileSysParm > 1 THEN _
               RETURN _
            ELSE GOSUB 20992 : _
                 IF ZFileSysParm > 1 THEN _
                    RETURN
      IF ZTransferFunction = 1 AND ZAnsIndex <= LastDnld THEN
         GOSUB 20750                 '  Calculate D/L Time Estimates
         CLOSE 2
         CALL Carrier
         IF ZSubParm = -1 THEN
            ZFileSysParm = 7
            RETURN
         END IF
         IF ZFileSysParm > 1 OR NOT ZOK THEN
            RETURN
         END IF
      END IF
      IF ZDGSMarkedFiles$ <> "" THEN _
         IF INSTR(ZDGSMarkedFiles$, ZFileNameHold$) = 0 THEN _
            AddMarkedFiles$ = AddMarkedFiles$ + ZFileNameHold$ + _
                               ZCarriageReturn$
20262 IF ZBatchTransfer THEN _
         IF ZAnsIndex < LastDnld THEN _
            RETURN _
         ELSE ZBlocksInFile# = BatchBlocks# : _
              ZBytesInFile# = BatchBytes# : _
              ZNumDnldBytes! = BatchBytes# : _
              IF ZBytesInFile# < 1 THEN _
                 RETURN _
              ELSE GOSUB 20780 : _
                   IF ZFileSysParm > 1 OR NOT ZOK THEN _
                      RETURN
      IF ZAutoEnd = 2 THEN
         ZAutoEnd = 0
         ZOK = ZFalse
         RETURN
      END IF
      IF Restart THEN
         Restart = ZFalse
         GOTO 20202
      END IF
      GOSUB 20337
      IF BatchOff <> ZFalse THEN _
         ZAutoLogoffReq = BatchOff
      IF ZHighSpeedTransfer AND DownloadFirst THEN _
         CALL SkipLine (1) : _
         ZSuspendAutoLogoff = ZTrue : _
         LastDnld = 0 : _
         GOTO 20400
      CALL Transfer
'
'  *  Return from external file transfer
'
20263 IF ZExtFileSysProcessor AND ZTransferFunction <> 1 THEN
         IF ZWasBatchTransfer THEN _
            ZWasBatchTransfer = ZFalse
         RETURN
      END IF
      IF ZPrivateDoor THEN _
         ZCmdTransfer$ = ZWasFT$ : _
         CALL XferType (2,ZTrue) : _
         ZCmdTransfer$ = ""
      ZErrCode = 0
      CALL OpenWork (2,"XFER" + ZNodeID$ + ".DEF",ZFalse)
      IF ZErrCode <> 0 THEN _
         GOTO 20267
      IF LOF(2) < 10 THEN _
         CLOSE 2 : _
         CALL KillWork ("XFER" + ZNodeID$ + ".DEF") : _
         GOTO 20267
      CALL ReadXfer (XError)
      IF XError THEN _
         CLOSE 2 : _
         CALL KillWork ("XFER" + ZNodeID$ + ".DEF") : _
         GOTO 20267
      CLOSE 2
      ZXferA = 1
      IF NOT ZFakeXRpt THEN _
         CALL TStats
      IF ZHighSpeedTransfer OR ZWasBatchTransfer THEN _
         CALL HSFile
20264 CALL KillWork ("XFER" + ZNodeID$ + ".DEF")
      CALL ReadXferInfo(XFileName$, XFailParm$)
      IF ZPrivateDoor THEN _
         ZFileName$ = XFileName$ : _
         CALL BreakFileName (ZFileName$,WasX$,ZFileNameHold$,ZWasY$,ZTrue) : _
         ZFileNameHold$ = ZFileNameHold$ + _
                           ZWasY$
      IF XFailParm$ = "L" OR XFailParm$ = "l" THEN _
         XFailParm$ = ZFailureString$
      IF ZTransferFunction = 1 AND XFailParm$ = "s" THEN _
         XFailParm$ = ZFailureString$
20265 IF ZTransferFunction = 2 THEN _
         IF INSTR(XFailParm$, ZFailureString$) <> 1 THEN _
            CALL QuickTPut1 (ZEmphasizeOn$ + "UPLOAD successful!" + ZEmphasizeOff$) : _
            GOTO 20700 _
         ELSE _
            AutoLogoffReq = ZFalse : _
            GOTO 20730
      IF ZTransferFunction = 1 THEN
         DnldCompleted = (XFailParm$ <> ZFailureString$)
         ZNumDnldBytes! = 0
         ZDownFiles = 0
      END IF
      GOSUB 21760              ' process download file transfer info
      ZXferInfo$ = ""
      ZXferC = 0
      GOSUB 20269              ' clean up temp files
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7
      RETURN
'
' *  XFER FILE NOT Found
'
20267 ZWasEL = 20263
      ZNumDnldBytes! = 0
      ZDownFiles = 0
      IF ZError <> 0 THEN _
         ZXferA = ZXferC + 1
      GOSUB 20269              ' clean up temp files
      GOTO 21900
'
'  Clean up temp files after a transfer to keep disk clean
'
20269 CALL KillWork (ZNodeWorkFile$)
      CALL KillWork (ZUploadWorkFile$)
      CALL KillWork (ZNodeWorkDrvPath$ + "NFUP" + ZNodeID$ + ".LST")
      CALL KillWork (ZNodeWorkDrvPath$ + "NODE" + ZNodeID$ + ".DIZ")
      CALL KillWork (ZDownloadWorkFile$)
      CALL KillWork (ZDownloadWorkFile$ + ".DET")
      CALL KillWork (ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF")
      ZPersonalDnld = ZFalse
      RETURN
'
' *  YMODEM DOWNLOAD DRIVER
'
20270 GOTO 20292
'
' *  Xmodem DOWNLOAD DRIVER
'
20290 '
20292 GOSUB 20750
      IF ZFileSysParm > 1 OR NOT ZOK THEN _
         RETURN
      WasA1$ = "SEND"
      GOSUB 20320
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZLocalUser THEN _
         CALL QuickTPut1 ("Protocol not available in local mode") : _
         RETURN
      GOSUB 21300
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZOutTxt$ = ""
      GOTO 20390
20294 RETURN
20318 ZOutTxt$ = "Please Switch to N,8,1 for binary transfer"
      GOSUB 21630
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL DelayTime (3)
      RETURN
20320 IF NOT ZEightBit THEN _
         GOSUB 20318 : _
         IF ZFileSysParm > 1 THEN _
            RETURN
20325 IF ZCheckSum THEN _
         ZNAK$ = CHR$(21) : _
         SOL = 132 _
      ELSE ZNAK$ = "C" : _
           SOL = 133
20330 GOSUB 20337
      ZOutTxt$ = ZFGE$ + ZProtoPrompt$ +ZFGF$ + _
            " " + WasA1$ + ZFGE$ + _
            " of " + ZFGF$ + _
            ZFileNameHold$ + ZFGE$ + _
            " ready.  <Ctrl X> aborts" + ZEmphasizeOff$
      GOSUB 21650
20335 IF ZTransferFunction = 1 THEN _
         CALL Talk (8,ZOutTxt$) _
      ELSE CALL Talk (9,ZOutTxt$)
      RETURN
20337 IF ZProtoMacro$ <> "" THEN _
         ZGSRAra$(1) = MID$("DU ",ZTransferFunction,1) : _
         CALL MacroExe (ZProtoMacro$)
      RETURN
'
' *  ASCII DOWNLOAD DRIVER
'
20340 IF ZWasDF THEN _
         ZOutTxt$ = "Switch to a non-ascii protocol" : _
         GOSUB 21650 : _
         GOTO 21700
      GOSUB 20750
      IF ZFileSysParm > 1 OR NOT ZOK THEN _
         RETURN
      CALL OpenWork (2,ZFileName$,ZFalse)
      IF (ZAnsIndex = FirstDnld OR NOT ZConcatFIles) THEN _
         GOSUB 20337 : _
         ZOutTxt$ = "^X aborts.  ^S suspends ^Q resumes" : _
         GOSUB 21640 : _
         IF ZFileSysParm > 1 THEN _
            RETURN _
         ELSE ZOutTxt$ = ZProtoPrompt$ + " SEND of " + _
              ZFileNameHold$ + _
              " ready. Press Any Key to start" : _
         ZTurboKey = 2 : _
         ZForceKeyboard = ZTrue : _
         ZSuspendAutologoff = ZTrue : _
         GOSUB 21660 : _
         ZSuspendAutologoff = ZFalse : _
         GOSUB 20335 : _
         IF ZFileSysParm > 1 THEN _
            RETURN
20380 ZStopInterrupts = ZFalse
      WasTU = 0
      SWAP WasTU,ZPageLength
      CALL BufFile (ZFileName$,WasX,ZFalse)
      SWAP WasTU,ZPageLength
      ZNonStop = (ZPageLength < 1)
      IF StopFile THEN _
         DnldCompleted = ZFalse : _
         GOTO 20390
20381 IF (ZAnsIndex = LastDnld OR NOT ZConcatFIles) THEN _
         CALL QuickTPut (CHR$(26),0) : _
         IF NOT ZLocalUser AND ZSubParm = 0 THEN _
            FOR WasX = 1 TO 5 : _
               CALL PutCom (CHR$(7)) : _
               CALL DelayTime (3) : _
            NEXT
20385 DnldCompleted = ZTrue
20390 GOTO 21760
'
' *  U - COMMAND FROM FILES MENU (UPLOAD)
'
20395 GOSUB 21640
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZOutTxt$ = "Correct name of file to upload" + _
           ZPressEnterExpert$
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ = 0 THEN _
         RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(1)
      GOTO 20435
20400 ZUpBatchTransfer = ZFalse
      ZWasBatchTransfer = ZFalse
      ZGetExtDesc = ZFalse
      ZWhoToSet = ZFalse
      IF ZHighSpeedTransfer AND DownloadFirst THEN _
         ZAnsIndex = ZLastIndex
      IF DownloadFirst THEN _
         BatchOff = ZAutoLogoffReq
      Temp$ = "U"
      IF NOT ZSysOp THEN
         ZFileName$ = ZHelpPath$ + "UPMSG.HLP"
         CALL Graphic (ZFileName$,ZTrue)
         IF ZOK THEN _
            ZNonStop = ZTrue : _
            CALL BufFile (ZFileName$, ZWasX,ZTrue)
         ZFileName$ = ""
      END IF
      SysOpByPass = ZFalse
      IF ZSysOp AND ZLocalUser THEN
         CALL SkipLine (1)
         ZOutTxt$ = ZFG5$ + "By-Pass Overwrite and Description Checks ([Y]" + _
                     ZFG5$ + ",N)" + ZEmphasizeOff$
         ZTurboKey = -ZTurboKeyUser
         GOSUB 21660
         IF NOT ZNo THEN _
            SysOpByPass = ZTrue
      END IF
      CALL AskItems ("U",Temp$,ZFalse,"file",ZMarkedFiles$,ZFalse)
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ = 0 THEN
         IF ZHighSpeedTransfer AND DownloadFirst THEN _
            ZOutTxt$ = "Continue with transfer ([Y],N)" : _
            ZTurboKey = -ZTurboKeyUser : _
            GOSUB 21668 : _
            IF NOT ZNo THEN _
               DownloadFirst = ZFalse : _
               GOTO 20263
         LastDnld = 0
         RETURN
      ENDIF
      FirstUpld = ZAnsIndex
      LastUpld = ZLastIndex
      GOSUB 20269
      ZErrCode = 0
      ZAlreadyGiven = ZFalse
      CALL TimeBack (1)
      GOTO 20430
20420 RETURN
'
' *  SEARCH FOR DUPLICATE FILENAME
'
20430 ZAnsIndex = ZLastIndex
      GOSUB 20470
      ZLastIndex = ZLastIndex + (WasX > 0)
      LastUpld = ZLastIndex
      IF FirstUpld <> LastUpld THEN _
         ZUpBatchTransfer = ZTrue
      IF NOT DownloadFirst THEN _
         BatchOff = ZAutoLogoffReq
      ZAutoLogoffReq = 0
20432 FOR ZAnsIndex = FirstUpld TO LastUpld
         IndexSave = ZAnsIndex
         GOSUB 20471
         GOSUB 20435
         FirstUpld = FirstUpld + 1
         IF ZFileSysParm > 1 THEN _
            IndexSave = LastUpld + 1
         ZAnsIndex = IndexSave
      NEXT
      ZWasBatchTransfer = ZFalse
      ZUpBatchTransfer = ZFalse
      ZWhoToSet = ZFalse
      GOSUB 20179
      RETURN
20435 ZFileNameHold$ = ZUserIn$(ZAnsIndex)
      ExtSrch = ZFalse
      IF INSTR(ZFileNameHold$,".") = 0 THEN _
         ZFileNameHold$ = ZFileNameHold$ + "." + ZDefaultExtension$
      CALL AllCaps(ZFileNameHold$)
      ZFileName$ = ZFileNameHold$
      ZViolation$ = "Upload "
      CALL NoPath (ZFileName$,BadFileNameIndex)
      IF BadFileNameIndex THEN _
         GOTO 20451
      CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20440,20451,20515
20440 HackName$ = ZDirPath$ + "HACK.COL"
      CALL FindIt (HackName$)
      CALL BreakFileName (ZFileName$,DR$,ZWasY$,WasX$,ZTrue)
      TempFileName$ = ZWasY$
      MatchFile = ZFalse
      IF ZOK THEN
         HackFil = 11
         CALL OpenWork (HackFil,HackName$,ZFalse)
         DO WHILE NOT EOF(HackFil)
            LINE INPUT #HackFil, HackFileName$
            IF (LEFT$(HackFileName$,1) <> ";" AND LEFT$(HackFileName$,1) <> " " AND HackFileName$ <> "") THEN
               CALL AllCaps (HackFileName$)
               CALL Trim (HackFileName$)
               IF HackFileName$ = TempFileName$ THEN
                  MatchFile = ZTrue
                  EXIT DO
               END IF
            END IF
         LOOP
         CLOSE HackFil
      END IF
      IF MatchFile THEN _
         SaveIt = ZStopInterrupts : _
         ZStopInterrupts = ZTrue : _
         CALL BufFile (ZHelpPath$ + "HACK.HLP",WasX,ZFalse) : _
         ZStopInterrupts = SaveIt : _
         ZFileName$ = TempFileName$ : _
         GOTO 20451
      CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount,ZTrue,"U")
      IF NOT ZOK AND (ZSysOp OR ZUserSecLevel >= ZMinSecPersUpld) THEN
         CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZTrue)
         Temp$ = ZPersonalDrvPath$ + WasX$ + Extension$
         CALL FindFile (Temp$,ZOK)
         IF ZOK THEN _
            ZFileName$ = Temp$
      END IF
      IF ZAbort THEN _
         GOTO 20476
20445 IF ZOK THEN _
         GOTO 20452
      IF INSTR(ZFileName$,".") = 0 THEN _
         GOTO 20475
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZFalse)
      WasI = 1
20447 WasJ = INSTR(MID$(ZCompressedExt$+". ",WasI),".")
      IF WasJ = 0 THEN _
         GOTO 20475
      Check$ = MID$(ZCompressedExt$,WasI,WasJ-1)
      WasI = WasI + WasJ
20450 IF Extension$ <> Check$ THEN _
         CALL RotorsDir (WasX$ + "." + Check$,ZSubDir$(),ZSubDirCount,ZTrue,"U") : _
         IF ZOK THEN _
            ExtSrch = ZTrue : _
            GOTO 20452
      IF ZAbort THEN _
         GOTO 20476
      GOTO 20447
20451 ZOutTxt$ = "Invalid file name <" + ZFileName$ + ">"
      GOTO 20395
20452 IF ZUserSecLevel < ZOverWriteSecLevel OR SysOpByPass THEN _
         GOTO 20453
      IF ExtSrch AND (WasX$ + "." + Check$) <> ZFileName$ THEN _
         ZOutTxt$ = WasX$ + "." + Check$ + " already here, " + _
                    "upload anyway (Y,[N])" _
      ELSE ZOutTxt$ = "Overwrite file (Y,[N])"
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT ZYes THEN _
         GOTO 20453
      ZWasZ$ = ZFileName$
      CALL KillWork (ZFileName$)
      IF ZErrCode <> 0 AND ZErrCode <> 53 THEN _
         ZOutTxt$ = "Unable to overwrite" : _
         GOSUB 21660 : _
         RETURN
      GOTO 20475
20453 CLOSE 2
      IF ZUserSecLevel >= ZAddDirSecurity THEN _
         GOTO 20455
20454 CALL QuickTPut1 (ZFG9$ + "Thanks, but we already have " + ZFGF$ + _
                       ZFileNameHold$ + ZEmphasizeOff$)
      CALL UpdtCalr ("Upload duplicate " + ZFileNameHold$,1)
      CALL SkipLine(1)
      CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
      RETURN
20455 IF SysOpByPass THEN _
         GOTO 20457
      ZOutTxt$ = "Add new directory entry (Y,[N])"
      ZTurboKey = - ZTurboKeyUser
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT ZYes THEN _
         RETURN
20457 ZAddingDescOnly = ZTrue
      ZUpBatchTransfer = ZFalse
      ZWasBatchTransfer = ZFalse
      ZWasFT$ = "l"
      IF ZGetDescAfterTransfer THEN _
         ZDesc$ = "" : _                                             ' 175-0205
         ZUCat$ = "" : _                                             ' 175-0205
         ZWhoTo$ = "" : _                                            ' 175-0205
         CALL FileLister (1) _
      ELSE _
         CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,1)
      IF ZAbort THEN _
         ZAddingDescOnly = ZFalse : _
         ZAbort = ZFalse : _
         RETURN
      IF ZWhoTo$ = "" AND NOT ZGetDescAfterTransfer THEN _
         IndexSave = LastUpld + 1 : _
         RETURN
      GOSUB 20702
      ZWhoToSet = ZFalse
      RETURN
20460 '
20470 ' *** CHECK FOR Protocol/Marked files IN FILE LIST ***
      WasX = 0
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL UnMarkItems (ZMarkedFiles$,ZAnsIndex,LastDnld,FoundMarked,ZFalse)
      IF FoundMarked THEN _
         RETURN
20471 ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps(ZWasZ$)
      WasX = 0
      IF LEN (ZWasZ$) = 1 THEN _
         WasX = INSTR(ZDefaultXfer$,ZWasZ$) : _
         IF WasX > 0 THEN _
            ZAnsIndex = ZAnsIndex + 1 : _
            IndexSave = IndexSave + 1 : _
            ZCmdTransfer$ = ZWasZ$ : _
            IF MID$(ZInternalEquiv$,WasX,1) = "N" THEN _
               ZCmdTransfer$ = ""
      RETURN
20475 ZWasZ$ = ZUpldDriveFile$
      CALL FindFree
      IF VAL(ZFreeSpace$) < 4096 THEN _
         GOSUB 21895 : _
         IndexSave = ZLastIndex + 1 : _
         RETURN
      IF (NOT ZUpBatchTransfer) OR (ZUpBatchTransfer AND ZAnsIndex >= LastUpld) THEN _
         ZOutTxt$ = "Upload disk has" + _
              ZFreeSpace$ : _
         GOSUB 21640 _
      ELSE CALL SkipLine (1)
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZGetDescAfterTransfer THEN _
         ZDesc$ = "" : _                                             ' 175-0205
         ZUCat$ = "" : _                                             ' 175-0205
         ZWhoTo$ = "" : _                                            ' 175-0205
         CALL FileLister (1) _
      ELSE CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,1)
20476 IF ZAbort THEN _
         IF NOT ZUpBatchTransfer OR (ZUpBatchTransfer AND ZAnsIndex = LastUpld) THEN _
            GOSUB 20179 : _
            ZAbort = ZFalse : _
            RETURN _
         ELSE _
            ZAbort = ZFalse : _
            RETURN
      IF NOT ZGetDescAfterTransfer THEN _
         IF ZWhoTo$ = "" THEN _
            IndexSave = LastUpld + 1 : _
            RETURN
      IF ZUpBatchTransfer AND ZAnsIndex < LastUpld THEN _
         RETURN
      ZLine25$ = "(U) " + _
                 ZFileNameHold$
      ZSubParm = 2
      CALL Line25
      ZOutTxt$ = ""
      ZOK = ZTrue
20477 IF ZHighSpeedTransfer and DownloadFirst THEN _
         GOTO 20500
      CALL XferType (2,ZTrue)
      IF ZFF THEN _
         GOTO 20500
      CALL XferType (1,ZTrue)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
20500 IF ZHighSpeedTransfer THEN
         IF NOT DownloadFirst THEN _
            UploadFirst = ZTrue : _
            CALL SkipLine (1) : _
            GOTO 20180
         ZAutoLogoffReq = BatchOff
         ZSuspendAutoLogoff = ZFalse
         GOTO 20263
      END IF
20501 ZTransferFunction = 2
      GOSUB 21790
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZInternalProt$ <> "N" THEN _
         IF NOT ZGetDescAfterTransfer THEN _
            IF ZWhoTo$ = "" THEN _
               GOTO 20735
      ON INSTR("AXCYN",ZInternalProt$) GOTO _
         20560, _         ' ASCII UPLOAD
         20542, _         ' Xmodem
         20542, _         ' Xmodem CRC
         20542, _         ' YMODEM
         20735            ' NONE - CANCEL
      GOTO 20261
20510 WasD$ = "<Esc> by SysOp aborts"
      GOSUB 21710
      RETURN
20515 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20420
'
' *  Xmodem/YMODEM UPLOAD DRIVER
'
20542 WasA1$ = "RECEIVE"
      GOSUB 20320
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZOK = ZTrue
      GOSUB 20860
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZOK THEN _
         GOTO 20700
      GOTO 20730
'
' *  ASCII UPLOAD
'
20560 LineACK = (ZDefaultLineACK$ <> "")
      IF LineACK THEN _
         ZOutTxt$ = "Acknowledge each line ([Y],N)" : _
         ZTurboKey = - ZTurboKeyUser : _
         LineACK = NOT ZNo : _
         GOSUB 21660 : _
         IF ZFileSysParm > 1 THEN _
            RETURN
      GOSUB 20337
      CALL QuickTPut1 ("Transfer MUST end with a <Ctrl-K>")
      CALL QuickTPut1 (ZFGE$ + ZProtoPrompt$ + ZFGF$ + " RECEIVE" + ZFGE$ + _
             " of " + ZFGF$ + ZFileNameHold$ + ZFGE$ + " ready" + ZEmphasizeOff$)
      ZOK = ZFalse
      XOff = ZFalse
      CALL OpenOutW(ZFileName$)
      IF ZErrCode <> 0 AND ZErrCode <> 53 THEN _
         ZWasEL = 20560 : _
         GOTO 21900
      GOSUB 20510
      IF ZFileSysParm > 1 THEN _
         RETURN
20600 CALL EofComm (Char)
      WHILE Char <> -1
         CALL Carrier
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 7 : _
            RETURN
         IF NOT ZFossil THEN _
            IF LOF(3) < 512 THEN _
               CALL PutCom(ZXOff$) : _
               XOff = ZTrue
20610    CALL FlushCom (WasX$)
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 7 : _
            RETURN
         IF INSTR(WasX$,CHR$(11)) THEN _
            GOTO 20650
         ZOK = ZTrue
20620    CALL PrintWork (2,WasX$,ZTrue)
         IF LineACK THEN _
            IF INSTR(WasX$,CHR$(10)) > 0 THEN _
               CALL PutCom (ZDefaultLineACK$)
         IF ZErrCode <> 0 THEN _
            ZWasEL = 20620 : _
            GOTO 21900
         WasD$ = WasX$
         NumReturns = 0
         GOSUB 21720
         IF ZFileSysParm > 1 THEN _
            RETURN
20621    CALL FindFKey
         IF ZSubParm < 0 THEN _
            ZFileSysParm = 2 : _
            RETURN
         IF ZKeyPressed$ = ZEscape$ THEN _
            GOTO 20745
         IF NOT ZOK THEN _
            GOTO 20670
      CALL EofComm (Char)
20630 WEND
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF XOff THEN _
         XOff = ZFalse : _
         CALL PutCom (ZXOn$) : _
         IF ZErrCode <> 0 THEN _
            ZWasEL = 20630 : _
            GOTO 21900
      GOTO 20600
20650 WasX = INSTR(WasX$,CHR$(11))
      IF WasX = 1 THEN _
         IF NOT ZOK THEN _
            GOTO 20730 _
         ELSE GOTO 20700
      CALL PrintWork (2,LEFT$(WasX$,WasX-1),ZFalse)
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20650 : _
         GOTO 21900
      GOTO 20700
20670 ZOutTxt$ = ZXOff$ + _
           "System error! Upload aborted <Ctrl-K> continues"
20675 GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL DelayTime (3)
      CALL PutCom(ZXOn$)
20680 CALL EofComm (Char)
      WHILE Char <> -1
         CALL FlushCom(WasX$)
         IF INSTR(WasX$,CHR$(11)) THEN _
            GOTO 20730
20685    CALL Carrier
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 7 : _
            RETURN
      CALL EofComm (Char)
      WEND
      GOTO 20680
'
' *  UPDATE UPLOAD DIRECTORY
'
20700 IF ZExtFileSysProcessor THEN _
         GOSUB 20269 : _               ' clean up temp files
         RETURN
      GOSUB 21780
      IF ZFileSysParm > 1 THEN _
         RETURN
20702 CALL FileLister (2)
      IF NOT ZAddingDescOnly THEN _
         ZUpldSubDir$ = ZUpldSubDirTemp$
20703 IF NOT ZGetExtDesc THEN _
         ZPrivateDoor = ZFalse : _
         GOTO 20710
      ZMsgHeader$ = "Extended Description for " + ZFileNameHold$
      ZSysopComment = ZTrue
      ZMaxMsgLines = ZMaxExtendedLines
      WasLL = ZRightMargin
      ZRightMargin = 30 + ZMaxDescLen
      IF ZRightMargin > 74 THEN _
         ZRightMargin = 74
      MParm = 12
      CALL MsgSys (MParm,ActionFlag,LogOff$,LogonMailNew,UtilMarginChange,MsgSec,UserCanReadMsg)
20705 ZMaxMsgLines = ZMaxMsgLinesDef
      ZRightMargin = WasLL
      CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,3)
20710 ZAddingDescOnly = ZFalse
      GOSUB 20269                        ' clean up temp files
      RETURN
20730 GOSUB 21780
      CALL QuickTPut1 (ZEmphasizeOn$ + "Upload aborted" + ZEmphasizeOff$)
      LastUpld = 0
      ZPrivateDoor = ZFalse
20735 CALL KillWork (ZFileName$)
      GOSUB 20269                        ' clean up temp files
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20736 : _
         GOTO 21900
      ZAnsIndex = ZLastIndex + 1
      IndexSave = ZAnsIndex
      ZLastIndex = 0
      RETURN
'
' *  Sysop ABORTED UPLOAD
'
20745 ZOutTxt$ = ZXOff$ + _
           "SysOp aborted upload. Stop transfer. <Ctrl-K> continues"
      GOTO 20675
'
' *  CALCULATE DOWNLOAD TIME ESTIMATE
'
20750 IF ZCDRom AND ZUseCDWorkDrive THEN
         CALL SkipLine (1)
         IF NOT ZCDWorkDriveFull THEN _
            CALL QuickTPut1 (ZFG6$ + "Please be patient..Copying " +  ZFG7$ + _
               ZFileNameHold$ + ZFG6$ + " from CD-ROM to Download Directory..." + ZEmphasizeOff$)
         CALL SkipLine (1)
         X = 1
         WasX = 0
         NoticeSent = ZFalse
20754    CALL Findfile ("CDWORK" + ZLibDrive$ + ".WRK",Found)
         IF Found THEN
            FilNum = 2
            CALL OpenWork (FilNum,"CDWORK" + ZLibDrive$ + ".WRK",ZFalse)
            CALL ReadDir (FilNum,1)
            CLOSE FilNum
            IF ZOutTxt$ = ZNodeID$ AND ZCDWorkDriveFull THEN _
               GOTO 20756
            CALL Carrier
            IF ZSubParm = -1 THEN _
               EXIT SUB
            IF NOT NoticeSent THEN _
               CALL QuickTPut (ZFG3$ + "CD ROM Drive is busy...please wait" + _
                                 ZEmphasizeOff$,0) : _
               NoticeSent = ZTrue
            CALL Delaytime (1)
            CALL MarkTime (WasX)
            X = X + 1
            IF X = 30 THEN _          ' Allow 30 seconds for clear
               CALL SkipLine (1) : _
               CALL QuickTPut1 (ZEmphasizeOn$ + "File " + ZFileNameHold$ + _
                                " currently unavailable..notify SysOp!" + _
                                 ZEmphasizeOff$) : _
               GOTO 20792 _
            ELSE _
               GOTO 20754
         END IF
         CALL CopyFile (ZFileName$,ZCDRomWorkDir$,1)
      END IF
20756 ZStartOfHeader$ = CHR$(1 - (ZInternalProt$ = "Y"))
      CALL OpenRSeq (ZFileName$,MaxBlock,ZWasDF,ZFLen,2)
20760 IF ZErrCode <> 0 THEN _
         CALL SkipLine(1) : _
         CALL QuickTPut1 (ZFG4$ + "Unable to access " + ZFGB$ + _
                          ZFileNameHold$ + ZFGC$ + _
                          " - File Omitted") : _
         CALL UpdtCalr ("Unable to access "+ ZFileName$ + _
                         " - File Omitted",2) : _
         ZOK = ZFalse : _
         ZErrCode = 0 : _
         ZBytesInFile# = 0 : _
         RETURN
      ZBytesInFile# = LOF(2)
      ZNumDnldBytes! = LOF(2)
      ZOK = ZTrue
      IF SizeOnly THEN _
         SizeOnly = ZFalse : _
         RETURN
      ZBlocksInFile# = MaxBlock
      CALL OpenWork (2,ZDownloadWorkFile$,ZTrue)
      CALL PrintWork (2,ZFileName$,ZFalse)
      CLOSE 2
      CALL OpenRSeq (ZFileName$,MaxBlock,ZWasDF,ZFLen,2)
      IF ZErrCode <> 0 THEN _
         RETURN
      Blocks# = ZBlocksInFile# / _
           VAL(MID$("00000300045012002400480072009601200144016801920216024002640288038405760", -4 * ZCBPS, 4))
      Blocks# = Blocks# * ZFLen / ZSpeedFactor!
      Estimate$ = RIGHT$(SPACE$(5) + STR$(INT(Blocks#/60)),5) + ":" + _
                  RIGHT$(STRING$(2,48) + _
                  LTRIM$(STR$(INT(Blocks#-(INT(Blocks# / 60) * 60)))),2)
      CALL OpenWork (2,ZDownloadWorkFile$ + ".DET",ZTrue)
      CALL PrintWork (2,ZFilenameHold$ + SPACE$(14-LEN(ZFilenameHold$)) + _
                      STR$(ZBytesInFile#) + _
                      SPACE$(12-LEN(STR$(ZBytesInFile#))) + _
                      Estimate$,ZFalse)
      CLOSE 2
20770 IF ZBatchTransfer THEN _
         BatchBlocks# =  BatchBlocks# + ZBlocksInFile# : _
         BatchBytes# = BatchBytes# + ZBytesInFile# : _
         CALL OpenWork (2,ZNodeWorkFile$,ZTrue) : _
         CALL PrintWork (2,ZFileName$,ZFalse) : _
         ZDownFiles = ZDownFiles + 1 : _
         CLOSE 2 : _
         RETURN
      ZDownFiles = 1
20780 ZOutTxt$ = "File Size    :"
      ZOK = ZTrue
      IF ZBlockSize > 0 THEN _
         ZOutTxt$ = ZFGE$ + ZOutTxt$ + ZFGF$ + _
              STR$(FIX(ZBlocksInFile#)) + ZFGE$ + _
              " blocks "
20785 ZBlocksInFile# = ZBlocksInFile# / _
         VAL(MID$("00000300045012002400480072009601200144016801920216024002640288038405760", -4 * ZCBPS, 4))
      ZBlocksInFile# = ZBlocksInFile# * ZFLen / ZSpeedFactor!
      IF (ZAnsIndex > 1 AND ZConcatFIles) THEN _
         RETURN
      ZOutTxt$ = ZOutTxt$ + ZFGF$ + _
           STR$(ZBytesInFile#) + ZFGE$ + _
           " bytes" + ZEmphasizeOff$
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZBytesInFile# < 1 THEN _
         RETURN
20790 ZSubParm = 2
      CALL Line25
      ZOutTxt$ = ZFGE$ + "Transfer Time:" + ZFGF$ + _
         STR$(INT(ZBlocksInFile# / 60)) + ZFGE$ + _
         " min," + ZFGF$ + _
         STR$(INT(ZBlocksInFile# - (INT(ZBlocksInFile# / 60) * 60))) + _
         ZFGE$ + " sec (approx)" + ZEmphasizeOff$
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
20791 CALL CheckTimeRemain (MinsRemaining)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 6 : _
         RETURN
      ZOK = ZTrue
      Temp = ZExtraDnldTime
      CALL ChkAddedTime (Temp)
      Temp = MinsRemaining + Temp
      ZWasA = INT(ZBlocksInFile# / 60) + 1
      IF ZWasA <= Temp THEN _
         GOTO 20795                              ' enough time to download
      IF NOT ZTimeBankInActive THEN
        IF ZGlobalBankTime + Temp > ZWasA THEN   ' check banktime to perform download
           BankTemp = ZGlobalBankTime
           IF BankTemp > 0 THEN
              CALL SkipLine (1)
              CALL UpdtCalr ("Not enough time to D/L - Access Time Bank",2)
              ZOutTxt$ = ZFGA$ + "Not enough time to Download Files" + _
                          ZCrLf$ + ZFG1$ + "Access Time Bank ([Y]" + _
                          ZFG1$ + ",N) " + ZEmphasizeOff$
              ZTurboKey = -ZTurboKeyUser
              WasAA = ZWasA      ' ZWasA is set to 0 from TGET in POPCMDSTACK
              GOSUB 21668        ' popcmdstack
              ZWasA = WasAA      ' set it back to orginal value
              IF ZSubParm = -1 THEN
                 ZFileSysParm = 7
                 RETURN
              ELSE
                 IF NOT (ZNo) THEN
                    CALL BankTime
                    CALL SkipLine (1)
                    IF ZGlobalBankTime < BankTemp THEN _
                       GOTO 20791                 ' time has been withdrawn
                 END IF
              END IF
           END IF
        END IF
      END IF
      FileTime = -1
      GOSUB 20855                   ' Not enough time to download
      IF NoTimeDnFlag = 99 THEN _
         NoTimeDnFlag = 0
20792 ZNumMarked = 0              ' reset counts for d/l number
      ZMarkBlocksInFile# = 0      ' and download time estimates
      ZNumDnldBytes! = 0          ' when marking files
      IF ZDownFiles < 2 THEN _
         GOTO 20794
      DGSEdit = 0
      ZLastIndex = 0
      ZOutTxt$ = "Edit files to download ([Y],N)"
      ZTurboKey = -ZTurboKeyUser
      GOSUB 21668
      IF ZNo THEN
         IF ZAutoEnd = 4 THEN           ' edit files
            RETURN
         END IF
         ZMarkedFiles$ = ""
         ZDGSMarkedFiles$ = ""
         LastDnld = 0
         GOTO 20794
      END IF
      Temp = 0
      ZNumMarked = 0
      CALL OpenWork (2,ZDownloadWorkFile$ + ".DET",ZFalse)
      IF ZErrCode = 0 THEN
         CALL SkipLine (2)
         CALL QuickTPut1 (ZFG9$ + "Files marked for DL are ..." + ZCrLF$)
         CALL QuickTPut1 (ZFG1$ + "FileName       Bytes        DL Time" + ZCrLf$ + _
              ZFGE$ + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + ZEmphasizeOff$)
         WHILE NOT EOF(2)
               LINE INPUT #2, FilesMarked$
               CALL QuickTPut1 (ZFG4$ + FilesMarked$ + ZEmphasizeOff$)
         WEND
      END IF
      CLOSE 2
      CALL SkipLine (2)
      CALL OpenWork (2,ZNodeWorkFile$,ZFalse)
      IF ZMarkedFiles$ <> "" THEN _
         ZMarkedFiles$ = "" : _
         ZDGSMarkedFiles$ = ""
      WHILE NOT EOF(2)
         CALL ReadDir (2,1)
         CALL BreakFileName (ZOutTxt$,DR$,ZWasY$,WasX$,ZTrue)
         ZFileName$ = ZWasY$ + WasX$
         ZOutTxt$ = "Download " + ZFileName$ + " (Y,[N])"
         ZTurboKey = - ZTurboKeyUser
         GOSUB 21668
         IF ZYes THEN
            DGSEdit = 1
            Temp = Temp + 1
            ZNumMarked = ZNumMarked + 1
            ZOutTxt$(Temp) = ZFileName$
            IF ZAutoEnd = 4 THEN _
               ZMarkedFiles$ = ZMarkedFiles$ + ZFileName$ + _
                                       ZCarriageReturn$
         END IF
      WEND
      CLOSE 2
      ZCmdTransfer$ = ZWasFT$
      ZAnsIndex = 1
      FirstDnld = 1
      ReStart = (Temp > 0)
      LastDnld = Temp
      ZLastIndex = Temp
      FOR WasX = 1 TO  Temp
         ZUserIn$(WasX) = ZOutTxt$(WasX)
      NEXT
20794 ZOutTxt$ = ""
      ZOK = ZFalse
      ZAutoLogoffReq = ZFalse
      RETURN
20795 IF ZRatioRestrict# > 0 THEN _
         CALL CheckRatio (ZTrue)
      IF ZOK = ZFalse THEN _
         RatioFile = -1 : _
         GOSUB 20855
      IF ZXferA = -1 THEN
         ZAutoEnd = 4
         ZXferA = 0
         GOSUB 20792
         GOTO 20808
      END IF
      IF ZFileSysParm > 1 OR NOT ZOK THEN
         GOSUB 20792
         GOTO 20808
      END IF
20798 CALL AutoLogoff
      IF ZAutoEnd = 2 THEN                     ' Abort
         LastDnld = 0
         GOSUB 21700
      END IF

      IF ZAutoEnd = 3 THEN _
       IF ZTransferFunction = 1 THEN _
          LastDnld = 0 _
       ELSE _
          IF ZTransferFunction = 2 THEN _
             LastUpld = 0

      IF ZDGSMarkedFiles$ <> "" AND ZMarkedFiles$ = "" THEN
         ZMarkedFiles$ = ZDGSMarkedFiles$ + AddMarkedFiles$
         ZDGSMarkedFiles$ = ""
      END IF

      IF ZAutoEnd = 4 THEN                     ' Edit
         GOSUB 20792
         GOTO 20808
      END IF

      IF ZAutoEnd = 5 THEN                                ' Mark
         IF ZDownFiles = 1 AND ZMarkedFiles$ = "" THEN
            CALL BreakFileName (ZFileName$,DR$,ZWasY$,WasX$,ZTrue)
            ZXferInfo$ = ZWasY$ + WasX$
            ZMarkedFiles$ = ZMarkedFiles$ + ZXferInfo$ + _
                            ZCarriageReturn$
         END IF
         TempMarked$ = ZMarkedFiles$
         ZMarkedFiles$ = ""
         ZDGSMarkedFiles$ = ""
         CALL AskItems ("M","M",ZTrue,"file",ZMarkedFiles$,ZPersonalDnld)
         IF ZWasQ = 0 THEN _
            ZMarkedFiles$ = TempMarked$ : _
            GOTO 20798
         IF TempMarked$ <> ZMarkedFiles$ THEN _
            ZMarkedFiles$ = ZMarkedFiles$ + TempMarked$
         StartFile = 1
         EndFile = LEN(ZMarkedFiles$)
         Count = 1
         WHILE StartFile < EndFile
           Temp = INSTR(StartFile,ZMarkedFiles$,ZCarriageReturn$)
           Temp$ = MID$(ZMarkedFiles$,StartFile,Temp-StartFile)
           ZUserIn$(Count) = Temp$
           Count = Count + 1
           StartFile = Temp + 1
         WEND
         ZAnsIndex = 1
         ZLastIndex = Count - 1
         GOSUB 20807
         ReStart = ZTrue
         RETURN
      END IF
      RETURN
20807 CALL KillWork (ZNodeWorkFile$)
      CALL KillWork (ZDownloadWorkFile$)
      CALL KillWork (ZDownloadWorkFile$ + ".DET")
      BatchBlocks# = 0
      BatchBytes# = 0
      ZDownFiles = 0
      RETURN
20808 IF DGSEdit THEN
         DGSEdit = 0
         ReStart = ZTrue
         GOSUB 20807
         RETURN
      END IF
      IF ZMarkedFiles$ = "" THEN
         GOSUB 21700
         LastDnld = 0
      END IF
      RETURN
20810 ZDelay! = TIMER + 6
20840 CALL EofComm (Char)
      IF Char = -1 THEN _
         GOTO 20850
      CALL FlushCom(ZWasY$)
      RETURN
20850 CALL CheckTime (ZDelay!, TempElapsed!, 1)
      IF TempElapsed! > 0 THEN _
         CALL GoIdle : _
         GOTO 20840
20851 ZWasY$ = ""
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      RETURN
20855 IF ZDownFiles < 2 THEN
         CALL AllCaps (ZFileNameHold$)
         IF FileTime THEN _
            ZOutTxt$ = ZFileNameHold$ + " Not enough time left!  Need" + _
                       STR$(ZWasA) + "  have" + STR$(Temp) + " mins." : _
            CALL QuickTPut1 (ZFGC$ + ZOutTxt$ + ZEmphasizeOff$)
         IF RatioFile THEN _
            ZOutTxt$ = ZFileNameHold$ + " Exceeds Users Ratio"
         IF NoTimeDnFlag OR RatioDnFlag THEN _
            CALL UpdtCalr (ZOutTxt$,2)
         IF ZMarkedFiles$ <> "" THEN _
            ZMarkedFiles$ = "" : _
            ZDGSMarkedFiles$ = ""
         FileTime = 0
         NoTimeDnFlag = 99
         IF RatioFile THEN _
            GOTO 20857
         GOTO 20856
      END IF
      CALL OpenWork (2,ZNodeWorkFile$,ZFalse)
      WHILE NOT EOF(2) AND (NoTimeDnFlag OR RatioDnFlag)
            CALL ReadDir (2,1)
            CALL BreakFileName (ZOutTxt$,DR$,ZWasY$,WasX$,ZTrue)
            ZFileName$ = ZWasY$ + WasX$
            IF FileTime THEN _
               ZOutTxt$ = ZFileName$ + " Not enough time!  Need" _
                          + STR$(ZWasA) + "  have" + STR$(Temp)
            IF RatioFile THEN _
               ZOutTxt$ = ZFileName$ + " Exceeds Users Ratio"
            CALL UpdtCalr (ZOutTxt$,2)
      WEND
      CLOSE 2
      IF FileTime THEN _
         ZOutTxt$ = ZFGF$ + "Not enough time left!  Need" + ZFGC$ + STR$(ZWasA) + _
                    ZFGF$ + " mins. & have" + ZFG7$ + STR$(Temp) + _
                    ZEmphasizeOff$ : _
         CALL QuickTPut1 (ZOutTxt$) : _
         FileTime = 0 : _
         NoTimeDnFlag = 99
      IF RatioFile THEN _
         GOTO 20857
20856 RETURN
20857 RatioFile = 0
      RatioDnFlag = 0
      RETURN
'
' *  Xmodem/YMODEM UPLOAD
'
20860 GOSUB 20992
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT ZEightBit THEN _
         GOSUB 21280 : _
         IF ZFileSysParm > 1 THEN _
            RETURN
20900 WasX$ = ""
      Sec = 1
      IF ZFLen > ZWriteBufDef THEN _
         WriteBuf = ZFLen _
      ELSE WriteBuf = ZWriteBufDef
      CALL OpenRSeq (ZFileName$,WasY,ZWasDF,WriteBuf,2)
      IF ZErrCode <> 0 AND ZErrCode <> 53 THEN _
         ZWasEL = 20900 : _
         GOTO 21900
      FIELD #2, WriteBuf AS ZUpldRec$
      RecsWrit = 0
      NumInBuff = 0
      TransferAbort! = TIMER + ZWaitBeforeDisconnect
      Year$ = " " + _
            CHR$(1) + _
            CHR$(2) + _
            ZEndTransmission$ + _
            ZCancel$
20903 CALL PutCom (ZNAK$)
20920 WasX = 1
20922 CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      CALL FindFKey
      IF ZKeyPressed$ = ZEscape$ THEN _
         GOSUB 20510 :_
         IF ZFileSysParm > 1 THEN _
            RETURN _
         ELSE GOTO 21240
      GOSUB 20810
      IF ZFileSysParm > 1 THEN _
         RETURN
20930 WasJ = INSTR(Year$,LEFT$(ZWasY$,1))
      ON WasJ GOTO 20960,20999,20999,21220,21230
20960 IF ZWasY$ <> "" THEN _
         GOSUB 21280 : _
         IF ZFileSysParm > 1 THEN _
            RETURN _
         ELSE CALL CheckTime (TransferAbort!,TempElapsed!,1) : _
              ON ZSubParm GOTO 20920,21230
20970 WasX = WasX + 1
      CALL DelayTime (1)
      CALL PutCom (ZNAK$)
      IF WasX < 6 THEN _
         GOTO 20922
      WasD$ = "Upload Timeout"
      GOSUB 21710
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL CheckTime (TransferAbort!,TempElapsed!,1)
      ON ZSubParm GOTO 20990,21230
20990 GOTO 20920
'
' *  CHANGE TO 8 BIT FOR Xmodem
'
20992 GOSUB 20510
      IF ZFileSysParm > 1 THEN _
         ZFileSysParm = 2 : _
         RETURN
      IF NOT ZEightBit THEN _
         PrevLineCntl = INP (ZLineCntlReg) : _
         CALL DelayTime (3) : _
         SwitchToEight = ZTrue : _
         OUT ZLineCntlReg,3
20996 WasSO = 0
      RETURN
'
' *  EXPECTED BLOCK LENGTH. 132 FOR CheckSum, 133 FOR CRC, 1029 FOR YMODEM
'
20999 SOL = 896 * WasJ - 1659 + ZCheckSum
      DataSol = 128 - (SOL > 1024)*896
      GOTO 21020
'
' *  Xmodem/YMODEM UPLOAD
'
21000 GOSUB 20810
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasY$ = "" THEN _
         WasD$ = "Upload Timeout" : _
         GOSUB 21710 : _
         IF ZFileSysParm > 1 THEN _
            RETURN _
         ELSE GOTO 21040
21020 WasX$ = WasX$ + _
           ZWasY$
      IF LEN(WasX$) < SOL THEN _
         GOTO 21000
21040 IF LEN(WasX$) = SOL THEN _
         GOTO 21090
21050 IF LEN(WasX$) > SOL THEN _
         GOTO 21180
21060 IF WasX$ = ZEndTransmission$ THEN _
         GOTO 21220
21070 IF WasX$ = ZCancel$ THEN _
         GOTO 21230
21080 GOTO 21170
21090 WasJX = ASC(MID$(WasX$,2,1))
      IF Sec = WasJX THEN _
         GOTO 21100
      GOTO 21200
21100 IF (Sec XOR 255) <> ASC(MID$(WasX$,3,1)) THEN _
         GOTO 21210
21110 IF ZCheckSum THEN _
         WasWK$ = MID$(WasX$,4,128) : _
         GOSUB 21750 : _
         IF ZFileSysParm > 1 THEN _
            RETURN _
         ELSE IF XmodemChecksum <> ASC(MID$(WasX$,132,1)) THEN _
            GOTO 21190 _
         ELSE GOTO 21120
      WasWK$ = MID$(WasX$,4)
      GOSUB 21750
      IF ZFileSysParm > 1 THEN _
         RETURN
21113 IF CRCValue <> 0 THEN _
         GOTO 21191
21120 WasSO = WasSO + 1
      CALL PutCom (ZAcknowledge$)
21131 IF NumInBuff >= WriteBuf THEN _
         NumInBuff = 0 : _
         CALL PutWork (ZUpldRec$,RecsWrit,WriteBuf) : _
         IF ZErrCode <> 0 THEN _
            ZWasEL = 21131 : _
            GOTO 21900
      MID$(ZUpldRec$,NumInBuff+1,DataSol) = WasWK$
      NumInBuff = NumInBuff + DataSol
21145 Sec = 255 AND (Sec + 1)
      CALL QuickLPrnt ("OK Rec Blk #",WasSO)
21150 WasX$ = ""
      XmodemChecksum = 0
      TransferAbort! = TIMER + 45
      GOTO 20920
21170 ZOutTxt$ = "Short Blk #"
      GOTO 21212
21180 ZOutTxt$ = "Long Blk #"
      GOTO 21212
21190 ZOutTxt$ = "Chksum Error #"
      GOTO 21212
21191 ZOutTxt$ = "CRC Error"
      GOTO 21212
21200 IF Sec < WasJX THEN _
         ZOutTxt$ = "Blk # Error in #" : _
         GOTO 21212
      CALL PutCom (RIGHT$(ZAckChar$,1 - (WasJX = 0)))
      GOTO 21150
21210 ZOutTxt$ = "Complement Error in #"
21212 CALL PutCom (ZNAK$)
      CALL LPrnt(ZLineFeed$ + ZOutTxt$ + STR$(WasSO + 1),0)
      GOTO 21150
21220 IF NumInBuff < 1 THEN _
         GOTO 21225
      WasWK$ = LEFT$(ZUpldRec$,NumInBuff)
      CALL OpenRSeq (ZFileName$,MaxBlock,ZWasDF,128,2)
      IF ZErrCode > 0 THEN _
         ZWasEL = 21220 : _
         GOTO 21900
      LastBlock = MaxBlock
      FIELD #2, 128 AS ZUpldRec$
      MaxBlock = CDBL(RecsWrit) * WriteBuf / 128
      FOR WasI = 1 TO NumInBuff/128
         CALL PutWork (MID$(WasWK$,128*WasI-127,128),MaxBlock,128)
         IF ZErrCode > 0 THEN _
            ZWasEL = 21220 : _
            GOTO 21900
      NEXT
      CLOSE 2
21225 CALL PutCom (ZAcknowledge$)
      GOTO 21250
21230 WasD$ = ZLineFeed$ + _
           "Transfer Aborted"
      GOSUB 21710
      IF ZFileSysParm > 1 THEN _
         RETURN
21240 CALL EofComm (Char)
      IF Char <> -1 THEN _
         GOSUB 21280 : _
         IF ZFileSysParm > 1 THEN _
            RETURN _
         ELSE CALL DelayTime (1) : _
         GOTO 21240
      CALL PutCom (ZCancel$ + ZCancel$)
      CALL DelayTime (1)
      CALL EofComm (Char)
      IF Char <> -1 THEN _
         GOTO 21240
      ZOK = ZFalse
21250 ZEightBit = ZTrue
      RETURN
'
' *  CLEAR GARBAGE OUT OF COMMUNICATIONS BUFFER
'
21280 CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      CALL EofComm (Char)
      IF Char = -1 THEN _
         RETURN
21281 CALL FlushCom(ZWasDF$)
      GOTO 21280
'
' *  Xmodem/YMODEM DOWNLOAD
'
21300 GOSUB 20992
      IF ZFileSysParm > 1 THEN _
         RETURN
      Sec = 0
      GOSUB 21280
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZNAK$ = CHR$(21)
      TransferAbort! = TIMER + ZWaitBeforeDisconnect
      CALL OpenRSeq (ZFileName$,MaxBlock,ZWasDF,ZFLen,2)
21303 FIELD 2,ZFLen AS ZDnldRecord$
'
' *  ROUTINE TO START AN "Xmodem" OR "YMODEM" DOWNLOAD.  CHECK'S INITIAL
' *  "HANDSHAKE" TO SEE IF CHARACTER IS SENT IS A:
' *           "X" = Xmodem WITH CheckSum AND 128 CHARACTER RECORDS
' *           "C" = Xmodem WITH CRC CHECK AND 128 CHARACTER RECORDS
' *           "Y" = YMODEM WITH CRC CHECK AND 1024 CHARACTER RECORDS
'
21350 CALL EofComm (Char)
      WHILE Char <> -1
21360    CALL GetCom(ZWasY$)
         IF ZWasY$ = ZCancel$ THEN _
            GOTO 21561
21380    ZCheckSum = (ZWasY$ = ZNAK$)
         IF ZCheckSum THEN _
            ZFF = INSTR(ZInternalEquiv$,"X") : _
            IF ZFF > 0 THEN _
               ZWasFT$ = MID$(ZDefaultXfer$,ZFF,1) : _
               GOTO 21480 _
            ELSE ZWasFT$ = "X" : _
                 GOTO 21480 _
         ELSE IF ZWasY$ = "C" THEN _
                 GOTO 21480
         CALL EofComm (Char)
21390 WEND
      GOSUB 21460
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZKeyPressed$ = ZEscape$ THEN _
         RETURN
      CALL CheckTime (TransferAbort!, TempElapsed!, 1)
      ON ZSubParm GOTO 21350,21455
21410 TransferAbort! = TIMER + ZWaitBeforeDisconnect
'
' *  ROUTINE TO WAIT FOR AN ACKNOWLEDGEMENT ON AN "Xmodem" OR "YMODEM"
' *  DOWNLOAD
'
21415 CALL EofComm (Char)
      IF Char <> -1 THEN _
         GOTO 21420
      GOSUB 21460
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZKeyPressed$ = ZEscape$ THEN _
         RETURN
      CALL GoIdle
      CALL CheckTime (TransferAbort!, TempElapsed!, 1)
      ON ZSubParm GOTO 21415,21455
21420 CALL GetCom(ZWasY$)
      IF ZWasY$ = ZAcknowledge$ THEN _
         GOTO 21470
21440 IF ZWasY$ <> ZNAK$ THEN _
         GOTO 21450
21443 WasD$ = ZLineFeed$ + _
         "Error -> retrans #" + _
         STR$(WasSO)
      GOSUB 21710
      IF ZFileSysParm > 1 THEN _
         RETURN
21445 WasSO = WasSO - 1
      GOTO 21490
21450 IF ZWasY$ = ZCancel$ THEN _
         IF HaveACancel THEN _
            GOTO 21560 _
         ELSE HaveACancel = ZTrue
      CALL CheckTime (TransferAbort!, TempElapsed!, 1)
      ON ZSubParm GOTO 21415,21455
21455 WasD$ = "Download timeout"
      GOSUB 21710
      IF ZFileSysParm > 1 THEN _
         RETURN
      GOTO 21560
21460 CALL CheckCarrier
      CALL FindFKey
      IF ZSubParm < 0 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF ZKeyPressed$ = ZEscape$ THEN _
         GOTO 21540
      RETURN
'
' *  DISPLAY BLOCK SENT OK AND THEN READ IN NEXT RECORD FROM DISK TO DOWNLOAD
'
21470 CALL QuickLPrnt ("OK Sent Blk #",WasSO)
      CALL GoIdle
21480 IF LOC(2) => MaxBlock THEN _
         GOTO 21530
      CALL GetWork (ZFLen)
      IF ZErrCode <> 0 THEN _
         ZWasEL = 21480 : _
         GOTO 21900
      Sec = 255 AND (Sec + 1)
      GOTO 21490
'
' *  ROUTINE TO WRITE OUT AN "Xmodem" OR "YMODEM" RECORD TO THE COMM. PORT
'
21490 WasSO = WasSO + 1
      CALL PutCom (ZStartOfHeader$ + CHR$(Sec) + CHR$(Sec XOR 255))
      CALL PutCom (ZDnldRecord$)
      HaveACancel = ZFalse
21503 WasWK$ = ZDnldRecord$
21504 GOSUB 21750
      IF ZFileSysParm > 1 THEN _
         RETURN
21510 IF ZCheckSum THEN _
         CALL PutCom(CHR$(XmodemChecksum)) _
      ELSE CALL PutCom(CHR$(CRCHigh) + CHR$(CRCLow))
      GOSUB 21280
      IF ZFileSysParm > 1 THEN _
         RETURN
      GOTO 21410
'
' *  END-OF-FILE FOR Xmodem Dnlds -- SEND THE "EOT" CHARACTER AND WAIT UP
' *  TO 2 SECONDS FOR A POSITIVE RESPONSE (I.E. AN "ACK").  IF NONE IS
' *  RE-TRY UP TO 10 TIMES.  IF No POSITIVE RESPONSE IS RECEIVED AFTER TEN
' *  ATTEMPTS, ASSUME THE DOWNLOAD WAS UNSUCCESSFULL.
'
21530 CALL PutCom (ZEndTransmission$)
      WasX = 1
21531 GOSUB 20810
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF INSTR(ZWasY$,ZAcknowledge$) THEN _
         GOTO 21550
      CALL FindFKey
      IF ZSubParm < 0 THEN _
         ZFileSysParm = 2 : _
         RETURN
      IF ZKeyPressed$ = ZEscape$ THEN _
         GOSUB 21540 : _
         GOTO 21545
      IF WasX < 10 THEN _
         WasX = WasX + 1 : _
         GOTO 21531
      DnldCompleted = ZFalse
      GOTO 21230
21540 GOSUB 20510
      IF ZFileSysParm > 1 THEN _
         RETURN
      RETURN
21545 ZWasY$ = ZCancel$
      CALL PutCom (ZCancel$ + ZCancel$ + ZCancel$)
      DnldCompleted = ZFalse
      GOTO 21250
21550 DnldCompleted = ZTrue
      GOTO 21250
21560 IF WasSO >= LastBlock THEN _
         GOTO 21550
21561 DnldCompleted = ZFalse
      WasD$ = ZLineFeed$ + _
           "Caller aborted trans"
      GOSUB 21710
      IF ZFileSysParm > 1 THEN _
         RETURN
      GOTO 21545
'
' STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL OUTPUT ROUTINE
'
' Modeled on lines 12975 to 12983 in RBBS-PC.BAS
21630 ZSubParm = 1
      GOTO 21655
21640 ZSubParm = 3
      GOTO 21655
21650 ZSubParm = 5
21655 CALL TPut
      IF ZSubParm < 0 THEN _
         ZFileSysParm = 2 : _
         RETURN
      IF ZSubParm = 8 THEN _
         GOSUB 21660
      RETURN
'
' STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL INPUT ROUTINE
'
' Modeled on lines 12995 to 12997 in RBBS-PC.BAS
21660 ZSubParm = 1
      CALL TGet
21665 IF ZSubParm < 0 THEN _
         ZFileSysParm = 2
      RETURN
21667 ZStackC = ZTrue
21668 CALL PopCmdStack
      GOTO 21665
21700 ZErrCode = 0
      ZLastIndex = 0
      ZFileName$ = ""
      ZOK = ZFalse
      IF INSTR("AXCYN",ZInternalProt$) = 5 THEN _
         IF ZDGSMarkedFiles$ <> "" THEN _
            CALL DGSMark
      GOSUB 20179
      RETURN
'
' **** COMMON LOCAL DISPLAY PRINT ***
'
'  (formerly lines 1315 to 1320 in RBBS-PC.BAS
21710 NumReturns = 1
21720 CALL LPrnt (WasD$,NumReturns)
      RETURN
'
' *  Xmodem / CRC INTERFACE
'
'  (formerly line 46000 in RBBS-PC.BAS
21750 XmodemChecksum = 0
      CRCValue = 0
      CALL Xmodem(WasWK$,XmodemChecksum,CRCValue,CRCHigh,CRCLow)
      RETURN
'
' * UPDATE DOWNLOAD STATISTICS
'
21760 GOSUB 21780                      ' call to setecho and set to 8 bit
      IF ZDGSMarkedFiles$ <> "" THEN _ ' update marked files for unsuccessful transfers
         CALL DGSMark
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT DnldCompleted THEN _
         ZAutoLogoffReq = ZFalse : _
         ZWasDF$ = " Aborted" : _
         GOTO 21768
      ZFreeDnld = ZPersonalDnld
      CALL LogPDown (ZPersonalDnld,1+ZAnsIndex-FirstDnld)
      CALL Muzak (6)
      ZWasDF$ = " Downloaded"
      IF (ZAnsIndex = LastDnld OR NOT ZConcatFiles) THEN
         CALL SkipLine (1)
         CALL QuickTPut1 (ZFG8$ + "Download successful!" + ZEmphasizeOff$)
         WasX = ((ZRatioRestrict# > 0) AND ZEnforceRatios AND ZFreeDnld)
         IF WasX THEN _
            CALL QuickTPut1 (ZFG4$ + "...But not counted against ratios" + ZEmphasizeOff$)
      END IF
21768 ZOutTxt$ = ""
21770 CALL AMorPM
      IF NOT ZBatchTransfer AND NOT ZPrivateDoor THEN
         XFileName$ = ZFileName$
      END IF
21772 IF XFileName$ = "" THEN
         ZBatchTransfer = ZFalse
         GOTO 21774
      END IF
      IF INSTR(XFileName$, "\") = 0 THEN
         ZFileName$ = XFileName$
         CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount,ZFalse,"")
         IF ZOK THEN
            XFileName$ = ZFileName$
         ELSE
            CALL UpdtCalr (XFileName$ + " Not Found!",2)
            CALL ReadXferInfo(XFileName$, XFailParm$)
            GOTO 21772
         END IF
      END IF
      IF XFailParm$ = ZFailureString$ OR XFailParm$ = "L" OR XFailParm$ = "s" THEN
         ZWasDF$ = " Aborted"
      ELSE
         ZWasDF$ = " Downloaded"
      END IF
      CALL OpenWork (2,XFileName$,ZFalse)
      IF ZErrCode > 0 THEN
         ZErrCode = 0
         IF ZBatchTransfer AND ZTransferFunction = 1 THEN
            GOSUB 21778
            IF NOT NodeFileFound THEN _
               ZErrorCode = 99
            IF ZErrCode > 0 THEN
               ZErrCode = 0
               CALL ReadXferInfo(XFileName$, XFailParm$)
               GOTO 21772
            END IF
         ELSE
            CLOSE 2
            GOTO 21774
         END IF
      END IF
      ZBytesInFile# = LOF(2)
      IF ZWasDF$ <> " Aborted" AND XFileName$ <> TempName$ THEN
         ZNumDnldBytes! = ZNumDnldBytes! + ZBytesInFile#
         ZMenuDownloads = ZMenuDownloads + ZDownFiles
         ZDownFiles = ZDownFiles + 1
         TempName$ = XFileName$
      END IF
      ZFileName$ = XFileName$
21773 CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZTrue)
      ZWasZ$ = WasX$ + _
           Extension$ + _
           ZWasDF$ + _
           " at " + _
           ZTime$ + _
           " using " + _
           ZWasFT$ + _
           STR$(ZBytesInFile#)
      CALL UpdtCalr (ZWasZ$,2)
      IF ZBatchTransfer THEN _
         CALL ReadXferInfo(XFileName$, XFailParm$) : _
         GOTO 21772
21774 WasX=((ZRatioRestrict# > 0) AND ZEnforceRatios AND ZFreeDnld)
      IF NOT WasX THEN _
         ZDnlds = ZDnlds + ZDownFiles : _
         ZGlobalDLToday! = ZGlobalDLToday! + ZDownFiles : _
         ZGlobalDnlds = ZGlobalDnlds + ZDownFiles : _
         ZDLBytes! = ZDLBytes! + ZNumDnldBytes! : _
         ZGlobalDLBytes! = ZGlobalDLBytes! + ZNumDnldBytes! : _
         ZDLToday! = ZDLToday! + ZDownFiles : _
         ZBytesToday! = ZBytesToday! + ZNumDnldBytes! : _
         ZGlobalBytesToday! = ZGlobalBytesToday! + ZNumDnldBytes!
      ZNumDnldBytes! = 0
21775 IF ZHighSpeedTransfer THEN _
         GOTO 20700
      CALL TimeRemain (MinsRemaining)
      IF DnldCompleted AND NOT ZExpertUser AND MinsRemaining > 0 THEN _
         CALL SkipLine(1) : _
         CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue) : _
      RETURN
21778 CALL OpenWork (2,ZNodeWorkFile$,ZFalse)
           IF ZErrCode > 0 THEN _
              RETURN
           NodeFileFound = ZFalse
           WHILE NOT EOF (2)
              CALL ReadAny
              IF INSTR(XFileName$, ZOutTxt$) > 0 THEN
                 XFileName$ = ZOutTxt$
                 NodeFileFound = ZTrue
              END IF
           WEND
      RETURN
'
' *****   TURN ON INTERMEDIATE ECHO   ****
'
'  (formerly line 50620 in RBBS-PC.BAS
21780 IF ZEchoer$ = "I" THEN _
         CALL SetEcho ("I")
'
' *  RESTORE COMMUNICATIONS AFTER Switch TO 8 BIT
'
'  (formerly between lines 50620 and 50630 in RBBS-PC.BAS
      IF SwitchToEight THEN _
         IF ZSwitchBack THEN _
            OUT ZLineCntlReg, PrevLineCntl : _
            CALL DelayTime (3) : _
            ZEightBit = ZFalse : _
            SwitchToEight = ZFalse
      RETURN
'
' *****  TURN OFF INTERMEDIATE ECHO  ****
'
'  (formerly line 50630 in RBBS-PC.BAS
21790 IF ZEchoer$ = "I" THEN _
         CALL SetEcho ("R")
      RETURN
'
' *****   DIRECTORY SEARCH   ****
'
'  (formerly lines 52900 to 52920 in RBBS-PC.BAS
21800 WasCK = 2
21810 ZOutTxt$ = ZFGB$ + "Search string or filename (wildcards OK), [ENTER]" + _
         ZFGB$ + " quits)" + ZEmphasizeOff$
      ZMacroMin = 99
      GOSUB 21668
      IF ZWasQ = 0 THEN _
         RETURN
21820 WasRS$ = ZUserIn$(ZAnsIndex)
      IF LEN(WasRS$) > 30 THEN _
         CALL SkipLine (1) : _
         CALL QuickTPut1 (ZFGC$ + "Search String Too Long! (Max. " + _
               ZFGF$ + "30" + ZFGC$ + " chrs)" + ZEmphasizeOff$) : _
         ZAnsIndex = ZLastIndex : _
         RETURN
      WildSearch = (INSTR(WasRS$,"*") > 0 OR INSTR(WasRS$,"?") > 0)
      CALL AllCaps (WasRS$)
      IF RIGHT$(WasRS$,1) = "*" THEN _
         IF RIGHT$(WasRS$,2) <> ".*" THEN _
            WasRS$ = WasRS$ + ".*"
      SearchString$ = WasRS$
      SearchDate$ = ""
      ZJumpSearching = ZFalse
      WasA1$ = WasRS$
      ZExtendedOff = ZFalse
      GOTO 21867
'
' *****  P - personal download  ****
'
'  (formerly lines 52950 to 52952 in RBBS-PC.BAS
21850 IF ZPersonalBegin < 1 OR ZPersonalLen < 1 THEN _
         RETURN
      DnldFlag = 0
      ZPersonalDnld = ZTrue
      ZFileWaiting = ZFalse
      ZFreeDnld = ZPersonalDnld
      ZListOnly = ZPersonalDnld
      ZExtraDnldTime = -60 * ZPersonalDnld
      PersName$ = ZMnuPath$ + "PERS." + ZMnuExt$
      IF NOT ZExpertUser THEN
         CALL Graphic (PersName$,ZTrue)
         IF ZOK THEN _
            ZNonStop = ZTrue : _
            CALL BufFile (PersName$, ZWasX,ZTrue) : _
            ZNonStop = ZFalse
      END IF
21852 ZActiveFMSDir$ = ZPersonalDir$
      TurboTemp = ZTurboKeyUser
      CALL SetExpert (ZTrue)
      CALL DispUpDir (WasX$,SearchString$,SearchDate$,DnldFlag,ZAnsIndex)
      CALL SetExpert (ZFalse)
      ZTurboKeyUser = TurboTemp
      IF ZFileSysParm = 4 THEN _
         RETURN
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7: _
         RETURN
      IF ZAnsIndex > ZLastIndex OR ZRet THEN _
         GOTO 21854
      ZConcatFIles = ZPersonalConcat
      ZStopInterrupts = ZTrue
      TimeLockExempt = ZTrue
      GOSUB 20202
      IF ZFileSysParm > 1 THEN _
         GOTO 21854
      IF ZAutoEnd = 2 THEN _
         ZAutoEnd = 0
      TimeLockExempt = ZFalse
      ZConcatFIles = ZFalse
      GOTO 21852
21854 GOSUB 20177
      RETURN
'
' *  N - COMMAND FROM FILES MENU (DISPLAY NEW FILES SINCE LAST DIR DISPLAY)
'
'  (formerly lines 53000 to 53070 in RBBS-PC.BAS
21860 WasCK = 1
21862 WasA1$ = RIGHT$(ZWasLM$,4) +_
            LEFT$(ZWasLM$,2)
      ZOutTxt$ = ZFG1$ + "Files on/after MMDDYY, [S]" + ZFG1$ + "ince = " + _
           ZFGA$ + WasA1$ + ZEmphasizeOff$
      GOSUB 21668
      CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
      IF ZWasQ = 0 OR ZUserIn$(ZAnsIndex) = "S" THEN _
         WasRS$ = ZWasLM$ : _
         GOTO 21866
21865 IF LEN(ZUserIn$(ZAnsIndex)) <> 6 THEN _
         GOTO 21862
      WasA1$ = ZUserIn$(ZAnsIndex)
      WasRS$ = RIGHT$(WasA1$,2) + _
            LEFT$(WasA1$,4)
      ListNew = ZTrue
21866 SearchDate$ = WasRS$
      SearchString$ = ""
      ZJumpSearching = ZFalse
      ZExtendedOff = ZFalse
21867 DirPromptSave$ = ZDirPrompt$
      ZDirPrompt$ = MID$(ZDirPrompt$,1,(INSTR(ZDirPrompt$,"P") - 1)) + _
        MID$(ZDirPrompt$,INSTR(ZDirPrompt$,"P") + 6,LEN(ZDirPrompt$) - (INSTR(ZDirPrompt$,"P") + 5))
21869 CALL GetDirs (NOT ZExpertUser)
      IF ZWasQ = 0 THEN _
         ZDirPrompt$ = DirPromptSave$ : _
         RETURN
      IF ZUserIn$(ZAnsIndex) = "P" THEN _
         GOTO 21869
21871 CALL ConvertDir (ZAnsIndex)
      ZListDir = ZTrue
      ListNew = ZTrue
      ZSearchingAll = ZFalse
21875 ZWasZ$ = ZUserIn$(ZAnsIndex)
      IF NOT ZSearchingAll THEN _
         IF ZWasZ$ = "ALL" THEN _
            IF NOT ZLimitSearchToFMS THEN _
               GOSUB 21890
21880 WasQX = ZAnsIndex
      GOSUB 20157
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZAnsIndex = ZAnsIndex + 1
      IF ZAnsIndex <= ZLastIndex THEN _
         GOTO 21875
      ZDirPrompt$ = DirPromptSave$
      ListNew = ZFalse
      SearchString$ = ""
      SearchDate$ = ""
      RETURN
21890 WasG = ZAnsIndex
      CALL GetAll (ZUserIn$(),WasG)
      ZSearchingAll = ZTrue
      ZLastIndex = WasG
      ZAnsIndex = ZAnsIndex + 1
      RETURN
21895 CALL QuickTPut1 (ZEmphasizeOn$ + "No room for uploads. Try tomorrow" + ZEmphasizeOff$)
      RETURN
'
' *  MAIN FILE SYSTEM ERROR TRAP - ALL ERRORS PASS THROUGH THIS ROUTINE
'
'  (formerly lines 13000 to 13500 in RBBS-PC.BAS
21900 IF ZDebug THEN _
         ZOutTxt$ = "RBBSSUB5 DEBUG Error Trap Entry ERL=" + _
              STR$(ZWasEL) + _
              " ERR=" + _
              STR$(ZErrCode) : _
         IF ZPrinter THEN _
            CALL Printit(ZOutTxt$) _
         ELSE CALL LPrnt(ZOutTxt$,1)
      IF ZWasEL = 20126 AND ZErrCode = 53 THEN _
         GOTO 20142
      IF ZWasEL = 20242 AND ZErrCode = 62 THEN _
         CALL UpdtCalr (ZFileSecFile$ + " bad format!",2) : _
         GOTO 20247
      IF ZWasEL = 20263 THEN _
         ZOutTxt$ = "<Download aborted>" : _
         DnldCompleted = ZFalse : _
         GOTO 20390
      IF ZWasEL = 20560 AND ZErrCode = 67 THEN _
         GOTO 20451
      IF ZWasEL = 20560 AND ZErrCode = 70 THEN _
         IF VAL(ZFreeSpace$) > 1999 THEN _
            GOTO 20610 _
         ELSE GOSUB 21895 : _
              GOTO 21700
      IF ZWasEL = 20620 THEN _
         GOTO 20670
      IF ZWasEL = 20650 THEN _
         GOTO 20670
      IF ZWasEL = 20736 AND ZErrCode = 53 THEN _
         GOTO 21700
      IF ZWasEL = 20900 AND ZErrCode = 75 THEN _
         GOTO 21230
      IF ZWasEL = 20900 AND ZErrCode = 70 THEN _
         GOSUB 21895 : _
         GOTO 21230
      IF ZWasEL = 21131 OR ZWasEL = 21220 THEN _
         ZErrCode = 0 : _
         GOTO 21230
      IF ZWasEL = 21480 THEN _
         CALL LogError : _
         IF ZErrCode = 57 THEN _
            CALL QuickTPut1 ("Error reading file.  Aborting download") : _
            DnldCompleted = ZFalse : _
            GOTO 21230
21910 CALL LogError
      CALL QuickTPut1 (ZCallersRecord$)
      ZFileSysParm = 3
      RETURN
21920 ' EXIT RBBS-PC FILE SUBSYSTEM
      END SUB
21925 '$SUBTITLE: ' DGSMARK - COMPARE DGSMarkedFiles$ TO ZMarkedFiles$'
' $PAGE
'
'  NAME    -- DGSMark
'
'  INPUTS  -- PARAMETER                      MEANING
'             ZDGSMarkedFiles$
'             ZMarkedFiles$
'
'  OUTPUTS --
'
'
'  PURPOSE -- Check a marked file hold list (ZDGSMarkedFiles$)
'             against the normal marked file list (ZMarkedFiles$)
'
'  Temp$  = FILENAME FROM ZDGSMarkedFiles$
'  Temp2$ = FILENAME FROM ZMarkedFiles$
'
      SUB DGSMark
      StartFile = 1
      EndFile = LEN(ZDGSMarkedFiles$)
      EndFile2 = LEN(ZMarkedFiles$)
      WHILE StartFile < EndFile
        Temp = INSTR(StartFile,ZDGSMarkedFiles$,ZCarriageReturn$)
        Temp$ = MID$(ZDGSMarkedFiles$,StartFile,Temp-StartFile)
        StartFile2 = 1
        MatchFile = 0
        Found = ZFalse
        WHILE StartFile2 < EndFile2
           Temp2 = INSTR(StartFile2,ZMarkedFiles$,ZCarriageReturn$)
           Temp2$ = MID$(ZMarkedFiles$,StartFile2,Temp2-StartFile2)
           IF Temp2$ = Temp$ THEN _
              StartFile2 = EndFile2 : _
              Found = ZTrue
           StartFile2 = Temp2 + 1
        WEND
        IF NOT Found THEN _
           ZMarkedFiles$ = ZMarkedFiles$ + Temp$ + ZCarriageReturn$
        StartFile = Temp + 1
      WEND
      ZDGSMarkedFiles$ = ""
      END SUB
'
21930 '$SUBTITLE: ' FILSECCHK - New FILESEC SubRoutine for VIEW and DOWNLOADED'
' $PAGE
'
'  NAME    -- FilSecChk
'
'  INPUTS  -- PARAMETER                      MEANING
'             ZViolation$                STRING FOR TYPE OF ACTION
'                                        "DOWNLOAD" or "VIEW"
'             ZWasZ$                     PATH/FILENAME OF FILE BEING CHECKED
'
'  OUTPUTS -- NoViolation                PASSED OR FAILED FILESEC CHECK
'                                        (True)    (False)
'
'  PURPOSE -- To enable FILESEC to be checked for downloads and
'             for file viewing
'
'
      SUB FilSecChk (ZViolation$, ZWasZ$, NoViolation)
      NoViolation = ZTrue
      FilNum = 2
      CALL OpenWork (FilNum,ZFileSecFile$,ZFalse)
      IF ZErrCode = 53 THEN _
         EXIT SUB
21940 IF EOF(FilNum) THEN _
         CLOSE FilNum : _
         EXIT SUB
      CALL ReadParmsX (FilNum,ZWorkAra$(),3,1)
      IF ZErrCode <> 0 THEN _
         CLOSE FilNum : _
         EXIT SUB
21950 CALL WildFile (ZWorkAra$(1),ZWasZ$,ZOK)
      IF NOT ZOK THEN _
         NoViolation = ZTrue : _
         GOTO 21940
21960 IF ZUserSecLevel < VAL(ZWorkAra$(2)) THEN _
         GOTO 21970
      FilePswd$ = ZWorkAra$(3)
      IF FilePswd$ = "" THEN _
         CLOSE FilNum : _
         EXIT SUB
      CALL AllCaps (FilePswd$)
      IF FilePswd$ = ZPswd$ THEN _
         CLOSE FilNum : _
         EXIT SUB
      ZOutTxt$ = "Enter a Password for " + ZFileName$
      ZHidden = ZTrue                                                ' 175-1221
      ZSubParm = 1
      CALL TGet
      ZHidden = ZFalse                                               ' 175-1221
      IF ZFileSysParm > 1 THEN _
         CLOSE FilNum : _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         CLOSE FilNum : _
         EXIT SUB
      CALL AraAllCaps (ZUserIn$(),1)
      IF ZUserIn$(1) = FilePswd$ THEN _
         CLOSE FilNum : _
         EXIT SUB
21970 NoViolation = ZFalse
21980 IF ZViolation$ = "View ARC" OR ZViolation$ = "TYPE file" THEN
         ZViolation$ = ZViolation$ + " " + ZFileName$
         Call QuickTPut1 (ZFGC$ + ZBG4$ + " Protected File! " + _
                          ZEmphasizeOff$)
      END IF
      CLOSE FilNum
      EXIT SUB
      END SUB
'
22000 '$SUBTITLE: ' ReadXferInfo - Read XferInfo$ for Filename & FailureParm'
' $PAGE
'
'  NAME    -- ReadXferInfo
'
'  INPUTS  -- PARAMETER                      MEANING
'
'  OUTPUTS -- XFileName$               FILENAME FROM XferInfo$
'             XFailParm$               FAILURE PARM FROM XferInfo$
'
'  PURPOSE -- To parse the Xferinfo$ file to obtain the filename
'             and failure parm when processing downloads.  The
'             XferInfo$ file has the format of:
'
'             Filename<cr>Failure Parm<cr>
'
'             for each file processed from reading the XFER-?.DEF
'             file which is done in SUB6 in ReadXfer
'
      SUB ReadXferInfo(XFileName$, XFailParm$) STATIC
      IF ZXferA > ZXferC THEN
         XFileName$ = ""
         XFailParm$ = ""
         EXIT SUB
      END IF
      Temp2 = INSTR(ZXferA,ZXferInfo$,ZCarriageReturn$)
      Temp2$ = MID$(ZXferInfo$,ZXferA,Temp2-ZXferA)
      Temp3 = INSTR(Temp2+1,ZXferInfo$,ZCarriageReturn$)
      Temp3$ = MID$(ZXferInfo$,Temp2+1,Temp3-(Temp2+1))
      ZXferA = Temp3 + 1
      XFailParm$ = Temp2$
      XFileName$ = Temp3$
      EXIT SUB
      END SUB
'
63100 ' $SUBTITLE: 'DoorReturn - Subroutine to process requests from a door'
' $PAGE
'
'  NAME    -- DoorReturn
'
'  INPUTS  -- PARAMETER                      MEANING
'             DOUTx.DEF               FILE OF REQUESTS
'
'  OUTPUTS -- ZUserSecLevel           REVISED SECURITY LEVEL
'
'  PURPOSE -- To give Doors a stable way to make requests
'             to the host.
'
      SUB DoorReturn STATIC
      IF NOT ZExitToDoors THEN _
         EXIT SUB
      CALL OpenUser (ZHighestUserRecord)
      FIELD 5, 128 AS ZUserRecord$
      FIELD 5,31 AS ZUserName$, _
              15 AS ZPswd$, _
               2 AS ZSecLevel$, _
              14 AS ZUserOption$,  _
              24 AS ZCityState$, _
               1 AS MachineType$, _
               1 AS ZDropTimes$, _
               1 AS ZBankTime$,_
               4 AS ZTodayDl$, _
               4 AS ZTodayBytes$, _
               4 AS ZDlBytes$, _
               4 AS ZULBytes$, _
              14 AS ZLastDateTimeOn$, _
               3 AS ZListNewDate$, _
               2 AS ZUserDnlds$, _
               2 AS ZUserUplds$, _
               2 AS ZElapsedTime$
      ZSubParm = 6
      CALL FileLock
      GET 5,ZUserFileIndex
      ZTimesLoggedOn = CVI(MID$(ZUserOption$,1,2))
      IF ZDoorDropFile$ = "R" THEN _
         CALL ReadDoorSys
      CALL SetSysOp
      CALL SetUserPref
      CALL SetUserUpDn
      ZGlobalsSet = ZFalse
      CALL SetGlobalUpDn
      ZElapsedTime = CVI(MID$(ZUserRecord$,127,2))
      IF ZDoorDropFile$ = "R" THEN _
         ZErrCode = 0 : _
         PUT 5,ZUserFileIndex
      ZFileName$ = "DOUT" + ZNodeID$ + ".DEF"
      CALL FindIt (ZFileName$)
      IF NOT ZOK THEN _
         GOTO 63197
63105 IF EOF(2) THEN _
         GOTO 63195
      CALL ReadParms (ZOutTxt$(),2,1)
      IF ZErrCode > 0 THEN _
         GOTO 63115
      IF LEN(ZOutTxt$(1)) < 2 THEN _
         GOTO 63105
      ZUserIn$ = LEFT$(ZOutTxt$(1),2) + ","
      WasX = INSTR("SL,UR,",ZUserIn$)
      IF WasX = 0 THEN _
         GOTO 63105
      WasX = WasX\3 + 1
      ON WasX GOTO 63110,63115
      GOTO 63105
63110 WasX$ = LEFT$(ZOutTxt$(2),1)         ' ZWasSL = Security Level
      CALL CheckInt (ZOutTxt$(2))
      IF ZErrCode > 0 THEN _
         GOTO 63105
      IF WasX$ = "+" OR WasX$ = "-" THEN _
         ZWasA = ZUserSecLevel + ZTestedIntValue _
      ELSE ZWasA = ZTestedIntValue
      IF ZWasA < ZSysopSecLevel THEN
         ZAdjustedSecurity = (ZWasA <> ZUserSecLevel)
         IF ZAdjustedSecurity THEN
            IF ZRegDateChg <> 0 THEN
               IF ZWasA > ZUserSecLevel AND ZWasA >= ZRegDateChg THEN _
                  CALL ResetRegDate(DATE$)
            END IF
            ZUserSecLevel = ZWasA
            MID$(ZUserRecord$,47,2) = MKI$(ZWasA)
            CALL QuickTPut1 ("Security changed to" + STR$(ZWasA))
            CALL UpdtCalr ("Door reset security to "+STR$(ZWasA),2)
            CALL SetPrivileges
            CALL SetPrompt
         END IF
      END IF
      GOTO 63105
63115 IF LEN(ZOutTxt$(1)) < 7 THEN _
         GOTO 63105
      IF MID$(ZOutTxt$(1),3,1) <> "(" THEN _
         GOTO 63105
      WasX = INSTR(4,ZOutTxt$(1),":")
      IF WasX < 1 THEN _
         GOTO 63105
      CALL CheckInt (MID$(ZOutTxt$(1),4,WasX-4))
      IF ZErrCode > 0 THEN _
         GOTO 63105
      IF ZTestedIntValue > 128 OR ZTestedIntValue < 1 THEN _
         GOTO 63105
      ZWasA = ZTestedIntValue
      CALL CheckInt (MID$(ZOutTxt$(1),WasX+1))
      IF ZErrCode > 0 OR ZTestedIntValue < 1 OR ZTestedIntValue > 128 THEN _
         GOTO 63105
      MID$(ZUserRecord$,ZWasA,ZTestedIntValue) = LEFT$(ZOutTxt$(2) + _
         SPACE$(ZTestedIntValue),ZTestedIntValue)
      CALL UpdtCalr ("Door set UR"+STR$(ZWasA)+":"+STR$(ZTestedIntValue)+" to <"+ZOutTxt$(2)+">",2)
      GOTO 63105
63195 CALL KillWork (ZFileName$)
      ZErrCode = 0
      PUT 5,ZUserFileIndex
63197 ZSubParm = 8
      CALL FileLock
      CALL BufFile (ZDoorDisplay$,WasX,ZFalse)                       ' 175-1221
      END SUB
'
63200 ' $SUBTITLE: 'WildCard -- Matches string to a pattern'
' $PAGE
'  NAME    -- WildCard
'
'  INPUTS  -- PARAMETER             MEANING
'             Pattern$              PATTERN TO CHECK
'             Strng$                STRING TO FIND
'
'  OUTPUTS -- ZOK                   TRUE IF MATCH FOUND
'                                   FALSE IF NO MATCH WAS FOUND
'
'  PURPOSE  Determine whether a string is an instance in a pattern
'           supported patterns are only "?" which requires a
'           character but can be any, and "*" which matches any-
'           thing, including a null string.  Anything else in a
'           sting must be an exact match.  Supports reverse
'           wildcards.
'
'
      SUB WildCard (Pattern$,Strng$) STATIC
63285 ZOK = ZTrue
      PatPos = 0
      StrPos = 0
      Inc = 1
      WasKT = 0
      WasP = LEN(Pattern$)
      WasL = LEN(Strng$)
63286 PatPos = PatPos + Inc
      StrPos = StrPos + Inc
      WasKT = WasKT + 1
      IF WasKT > WasL THEN _
         GOTO 63288
      ZUserIn$ = MID$(Pattern$,PatPos,1)
      IF ZUserIn$ = "*" THEN _
         GOTO 63289
63287 IF ZUserIn$ <> "?" AND MID$(Strng$,StrPos,1) <> ZUserIn$ THEN _
         ZOK = ZFalse : _
         EXIT SUB
      GOTO 63286
63288 IF PatPos >= LEN(Pattern$) OR PatPos < 1 THEN _
         EXIT SUB
      IF MID$(Pattern$,PatPos,1) <> "*" THEN _
         ZOK = ZFalse : _
         EXIT SUB
63289 IF PatPos <> WasP THEN _   ' Reverse search
         Inc = -1 : _
         WasP = PatPos : _
         PatPos = LEN(Pattern$) + 1 : _
         StrPos = LEN(Strng$) + 1 : _
         WasKT = 0 : _
         GOTO 63286
      END SUB
'
63300 ' $SUBTITLE: 'BreakFileName - sub to split file name into components'
' $PAGE
'
'  NAME    -- BreakFileName
'
'  INPUTS  -- PARAMETER                    MEANING
'             FileSpec$        FULL NAME OF FILE
'             ForJoining       True IF WANT PARTS FORMATTED FOR
'                                           FORMING FILE NAMES
'  OUTPUTS -- DrvPath$         DRIVE AND PATH
'             Prefix$          PREFIX OF FILE NAME
'             Extension$       EXTENSION OF FILE NAME
'
' (E.G. "C:\RBBS\ARCE.COM" HAS "C:\RBBS" AS DRIVE AND PATH,
'                              "ARCE"    AS PREFIX OF THE FILE NAME, AND
'                              "COM"     AS THE EXTENSION OF THE FILE NAME.
'
' JOINED FORMAT IS C:\RBBS\,ARCE,.COM
'
'  PURPOSE -- To break a file name into its component parts
'             of drive/path, prefix, and extension
'
'
      SUB BreakFileName (PassedFileSpec$,DrvPath$,Prefix$,Extension$,ForJoining) STATIC
      FileSpec$ = PassedFileSpec$
      CALL AllCaps (FileSpec$)
      DrvPath$ = ""
      Prefix$ = ""
      Extension$ = ""
      WasL = LEN(FileSpec$)
      IF WasL < 1 THEN _
         EXIT SUB
      CALL FindLast (FileSpec$,"\",WasX,WasY)
      IF WasX < 1 THEN _
         IF MID$(FileSpec$,2,1) = ":" THEN _
            DrvPath$ = LEFT$(FileSpec$,2) : _
            ZWasS = 3 _
         ELSE ZWasS = 1 _
      ELSE DrvPath$ = LEFT$(FileSpec$,WasX) : _
           ZWasS = WasX + 1
      WasX = INSTR(ZWasS,FileSpec$ + ".",".")
      IF WasX < WasL THEN _
         Extension$ = MID$(FileSpec$,WasX)
      IF ZWasS <= WasL THEN _
         IF WasX >= ZWasS THEN _
            Prefix$ = MID$(FileSpec$,ZWasS,WasX - ZWasS)
      IF ForJoining THEN _
         EXIT SUB
      IF WasY > 1 THEN _
         DrvPath$ = LEFT$(DrvPath$, LEN(DrvPath$) - 1)
      IF LEN(Extension$) > 0 THEN _
         Extension$ = MID$(Extension$, 2)
      END SUB
'
63310 ' $SUBTITLE: 'RestoreCom - sub to restore comm port'
' $PAGE
'
'  NAME    -- RestoreCom
'
'  INPUTS  -- none
'
'  OUTPUTS -- none
'
'  PURPOSE -- To restore communications port after an external
'             program may have left it in altered state
'
      SUB RestoreCom
      Parity$ = MID$(",N,8,1,E,7,1",7 + 6 * ZEightBit,6)
      IF ZLocalUser THEN _
         EXIT SUB
      CALL SetBaud
      IF NOT ZFossil THEN _
         CALL OpenCom(ZTalkToModemAt$,Parity$)
      END SUB
'
63320 ' $SUBTITLE: 'ShellExit - sub to shell out from RBBS'
' $PAGE
'
'  NAME    -- ShellExit
'
'  INPUTS  -- ShellTem$     STRING TO INVOKE SHELL WITH
'
'  OUTPUTS -- none
'
'  PURPOSE -- Delay so that strings can finish printing.  Restore comm
'             port on return
'
      SUB ShellExit (ShellTem$)
      CALL DelayTime (8 + ZBPS)
      IF NOT ZLocalUser THEN _
         IF ZFossil THEN _
            CALL FOSExit(ZComPort) _
         ELSE CLOSE 3 : _
              OUT ZModemCntlReg,INP(ZModemCntlReg) OR 1
      CLOSE 2
      CALL MetaGSR (ShellTem$,ZFalse)
      CurrentDrivePath$ = CURDIR$
      SHELL ShellTem$
      IF CurrentDrivePath$ <> CURDIR$ THEN
         IF LEFT$(CURDIR$,2) <> LEFT$(CurrentDrivePath$,2) THEN
            CHDRIVE LEFT$(CurrentDrivePath$,2)
         END IF
         CHDIR CurrentDrivePath$
      END IF
      IF ZFossil THEN _
         IF NOT ZLocalUser THEN _
            CALL FOSinit(ZComPort,Result) : _
            IF Result = -1 THEN _
               CALL PScrn("ERROR INIT FOSSIL AFT EXTERNAL") : _
               SYSTEM
      CALL DelayTime (2)
      CALL RestoreCom
      END SUB
'
63330 ' $SUBTITLE: 'ReadMacro - sub to read macro'
' $PAGE
'
'  NAME    -- ReadMacro
'
'  INPUTS  -- PARAMETER             MEANING
'
'  OUTPUTS -- ZOutTxt$               LINE TO PROCESS IN MACRO
'             ZMacroActive           FLAG WHETHER IN A MACRO
'
'  PURPOSE -- Reads in a line from macro file (#6) and processes
'             macro commands, which are:
'             *0 - display what follows, no carriage return
'             *1 - display what follows with carriage return
'             *B - display block that follows
'             *F - display File
'             WT - wait specified # of seconds
'             >> - append following block to specified file
'             ST - stack following (with carriage return)
'             ON - define case
'             == - case value that applies to following block
'             M! - execute following macro
'             M@ - abort macro processing
'             EY - Echo on (yes)
'             EN - Echo off (no)
'             /* - comment line skipped in processing
'             TK - Turbo key on (if user preference)
'             << - Read from file into a form
'             := - Assign value to work variable
'             LO - Set the location of a file
'             AT - Abort a file transfer
'
      SUB ReadMacro STATIC
      IF ZMacroTemplate$ <> "" THEN _
         GOTO 63392
      IF ZDistantTGet = 2 THEN _
         GOTO 63349
63336 GOSUB 63395
      IF NOT ZMacroActive THEN _
         ZMacroEcho = ZTrue : _
         EXIT SUB
      IF CompareVar > 0 THEN _
         IF NOT CaseExecute THEN _
            IF LEFT$(ZOutTxt$,3) = ZSmartTextCode$+"==" THEN _
               WasX$ = RIGHT$(ZOutTxt$,LEN(ZOutTxt$)-3) : _
               GOTO 63370 _
            ELSE IF LEFT$(ZOutTxt$,7) = ZSmartTextCode$ + "END ON" THEN _
                    CompareVar = 0 : _
                    GOTO 63336 _
                  ELSE GOTO 63336
      IF LEN(ZOutTxt$) < 3 THEN _
         GOTO 63398
      WasX$ = RIGHT$(ZOutTxt$,LEN(ZOutTxt$)-3)
      IF LEFT$(ZOutTxt$,1) <> ZSmartTextCode$ THEN _
         GOTO 63398
      CALL CheckInt (MID$(ZOutTxt$,2))
      IF ZErrCode > 0 THEN _
         GOTO 63398
      IF ZTestedIntValue > 0 AND ZTestedIntValue <= ZMaxWorkVar THEN _
         ZOutTxt$ = WasX$ : _  ' Macro command ask
         ZForceKeyboard = ZTrue : _
         ZMacroSave = ZTestedIntValue : _
         ZLinesPrinted = 1 : _
         ZNonStop = (ZPageLength < 1) : _
         EXIT SUB
      ON (1+INSTR("*0*1*B*FWT>>STON==M!M@EYEN/*TK<<:=LVNVCVLOAT",MID$(ZOutTxt$,2,2)))\2 GOTO _
         63345, _  ' Display with no Carriage Return
         63347, _  ' Display with Carriage Return
         63340, _  ' Display Block
         63348, _  ' Display File
         63343, _  ' Wait # of seconds
         63350, _  ' Append to file
         63355, _  ' Stack
         63360, _  ' Case
         63370, _  ' Case Comparison
         63375, _  ' Macro execute
         63380, _  ' Macro Abort
         63383, _  ' Macro Echo on
         63385, _  ' Macro Echo off
         63336, _  ' Macro Comment
         63387, _  ' Turbo Key allowed
         63390, _  ' Form read
         63362, _  ' Assign value to work var
         63363, _  ' LV list verify
         63364, _  ' NV number verify
         63364, _  ' CV character verify
         63367, _  ' LO assign file location
         63368     ' AT abort a file transfer
      GOTO 63398
63338 ZOutTxt$ = WasX$
63339 ZSubParm = 4
      CALL TPut
      RETURN
63340 WasX$ = ZSmartTextCode$ + "END"  ' Print Block
      GOSUB 63395
      WHILE ZMacroActive AND LEFT$(ZOutTxt$,4) <> WasX$
         GOSUB 63339
         CALL SkipLine (1)
         GOSUB 63395
      WEND
      GOTO 63336
63343 CALL CheckInt (WasX$)      ' Delay
      IF ZErrCode = 0 THEN _
         CALL DelayTime (ZTestedIntValue)
      GOTO 63336
63345 GOSUB 63338               ' Print Line
      GOTO 63336
63347 CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
      GOSUB 63338
      CALL SkipLine (1)
      GOTO 63336
63348 CALL Trim (WasX$)            ' Print File
      CALL FindItX (WasX$,2)
      IF NOT ZOK THEN _
         GOTO 63336
      ZLinesPrinted = 1
      ZNo = ZFalse
      ZNonStop = (ZNonStop OR ZPageLength < 1)
63349 WHILE (NOT EOF(2) AND (NOT ZNo) AND (ZNonStop OR (ZLinesPrinted < ZPageLength)) AND (ZSubParm > -1))
         CALL ReadDir (2,1)
         GOSUB 63396
         ZSubParm = 5
         CALL TPut
      WEND
      ZDistantTGet = 0
      IF ZSubParm < 0 THEN _
         EXIT SUB
      IF EOF(2) OR ZNo THEN _
         CLOSE 2 : _
         ZNo = ZFalse : _
         GOTO 63336
      ZDistantTGet = 2
      CALL PauseExit
      EXIT SUB
63350 ZWasEN$ = WasX$            ' Append to file
      WasX = INSTR(ZWasEN$," /FL")
      OverStrike = (WasX > 0)
      IF OverStrike THEN _
         ZWasEN$ = LEFT$(ZWasEN$,WasX-1) + RIGHT$(ZWasEN$,LEN(ZWasEN$)-WasX-3)
      CALL Trim (ZWasEN$)
      CALL LockAppend
      IF ZErrCode > 0 THEN _
         GOTO 63352
      GOSUB 63395
      WasX$ = ZSmartTextCode$ + "END"
      WHILE ZMacroActive AND LEFT$(ZOutTxt$,4) <> WasX$
         CALL PrintWork (2,ZOutTxt$,ZFalse)
         GOSUB 63395
      WEND
63352 CALL UnLockAppend
      OverStrike = ZFalse
      GOTO 63336
63355 CALL GlobalSrchRepl (WasX$,"|",ZCarriageReturn$,ZTrue)
      ZCommPortStack$ = ZCommPortStack$ + WasX$ + ZCarriageReturn$
      GOTO 63336
63360 CompareVar = VAL(WasX$)
      CALL AllCaps (WasX$)
      IF CompareVar < 1 OR CompareVar > ZMaxWorkVar THEN _
         CompareVar = 0
      GOTO 63336
63362 CALL Trim (WasX$)
      CALL CheckInt (WasX$)
      WasX = INSTR(WasX$," ")
      IF WasX > 0 AND ZTestedIntValue > 0 AND ZTestedIntValue <= ZMaxWorkVar THEN _
         ZGSRAra$(ZTestedIntValue) = RIGHT$(WasX$,LEN(WasX$)-WasX)
      GOTO 63336
63363 ZVerifyList$ = WasX$
      CALL Trim (ZVerifyList$)
      GOTO 63365
63364 CALL Trim (WasX$)
      WasX = INSTR(WasX$," ")
      IF WasX = 0 THEN _
         GOTO 63336
      ZVerifyLow$ = LEFT$(WasX$,WasX-1)
      ZVerifyHigh$ = RIGHT$(WasX$,LEN(WasX$)-WasX)
      CALL Trim (ZVerifyLow$)
      CALL Trim (ZVerifyHigh$)
      ZVerifyNumeric = (MID$(ZOutTxt$,2,1) = "N")
63365 ZVerifying = ZTrue
      GOTO 63336
63367 CALL TRIM (WasX$)
      ZFileLocation$ = WasX$
      GOTO 63336
63368 IF ZFileSysParm > 0 THEN _
         ZAbort = ZTrue
      GOTO 63336
63370 IF CompareVar = 0 THEN _     ' Compare Case
         GOTO 63336
      ZWasDF$ = ZGSRAra$(CompareVar)
      CALL AllCaps (ZWasDF$)
      CaseExecute = (WasX$ = ZWasDF$)
      GOTO 63336
63375 CALL Trim (WasX$)           ' Execute Macro
      CALL Macro (WasX$,WasX)
      GOTO 63336
63380 ZMacroActive = ZFalse     ' Abort Macro
      GOTO 63398
63383 ZMacroEcho = ZTrue
      GOTO 63336
63385 ZMacroEcho = ZFalse
      GOTO 63336
63387 ZTurboKey = -ZTurboKeyUser   'TK Turbo Key
      GOTO 63336
63390 ZUserIn$ = ZOutTxt$
      ZUserIn$(5) = ""
      ZUserIn$(6) = ""
      ZWasQ = 1
      ZStoreParseAt = 1
      CALL ParseIt
      IF ZWasQ < 4 THEN _
         GOTO 63336
      WasX$ = ZSmartTextCode$ + "END"
      GOSUB 63397
      ZMacroTemplate$ = ""
      WHILE ZMacroActive AND LEFT$(ZOutTxt$,4) <> WasX$
         ZMacroTemplate$ = ZMacroTemplate$ + ZOutTxt$ + ZCrLf$
         GOSUB 63397
      WEND
      WasX = VAL(ZUserIn$(4))
      VarLen = (ZUserIn$(3) <> "/F")
      CALL FindIt (ZUserIn$(2))
      IF (WasX < 1) OR (NOT ZOK) OR (VarLen AND WasX > ZMaxWorkVar) THEN _
         ZMacroTemplate$ = "" : _
         GOTO 63336
      PauseEachRec = (ZUserIn$(6) = "/1")
63392 CALL FormRead (ZMacroTemplate$,ZUserIn$(2),NOT VarLen,WasX,(ZUserIn$(5) = "/FL"),PauseEachRec)
      IF ZMacroTemplate$ <> "" THEN _
         EXIT SUB _
      ELSE GOTO 63336
63395 GOSUB 63397
      GOSUB 63396
      RETURN
63396 CALL SmartText (ZOutTxt$,ZFalse, OverStrike)
      CALL MetaGSR (ZOutTxt$,OverStrike)
      RETURN
63397 IF EOF(6) THEN _         ' Read next line in macro
         ZMacroActive = ZFalse _
      ELSE CALL ReadDir (6,1) : _
           ZMacroActive = (ZErrCode = 0)
      RETURN
63398 END SUB    ' Not Macro command - pass to normal processing
'
' $SUBTITLE: 'TStats --- Display Transfer Stats from XFER? file'
' $PAGE
'
65004 SUB TStats
      CALL OpenWork (2,"XFER" + ZNodeID$ + ".DEF",ZFalse)
      IF ZErrCode <> 0 THEN _
         EXIT SUB
      CALL SkipLine (2)
      CALL QuickTPut1 (ZFG9$ + " Stats on this Transfer ..."+ZCrLF$)
      CALL QuickTPut1 (ZFG1$ + "FileName          Bytes   Dtr Rate  CPS        Errors " + ZCrLf$ + _
           ZFGE$ + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + ZEmphasizeOff$)
      WHILE NOT EOF(2)
         LINE INPUT #2,Stat$
         WasS = INSTR(Stat$,"rs ")
         IF WasS > 0 THEN
            WasX$ = MID$(Stat$, 2)
            WasX$ = LTRIM$(WasX$)
            Hold = INSTR(WasX$, " ")
            WasXa$ = MID$(WasX$,1,hold-1)
            WasX$ = LTRIM$(MID$(WasX$,Hold+1,WasS-Hold))
         ELSE
            GOTO 65006
         END IF
         Match = INSTR(Stat$, ".")
         IF Match > 0 THEN _
            WasZyX$ = MID$(Stat$, Match - 8, 12)
         Match = 0
         Start = 1
         DO
            Match = INSTR(Start, WasZyX$, "\")
            IF Match = 0 THEN _
               Match = INSTR(Start, WasZyX$, "/")
            IF Match = 0 THEN _
               Match = INSTR(Start, WasZyX$, " ")
            IF INSTR(WasZyX$, " ") > INSTR(WasZyX$, ".") THEN
               WasZyX$ = LEFT$(WasZyX$, INSTR(WasZyX$, " "))
               WasZyX$ = RTRIM$(WasZyX$)
            ELSE
               WasZyX$ = RIGHT$(WasZyX$, LEN(WasZyX$) - Match)
            END IF
         LOOP WHILE Match
            WasXy = LEN(WasZyX$)
            WasAy = LEN(WasXa$)
            CALL QuickTPut1 (ZFG1$ + WasZyX$ + SPACE$(23-(WasXy+WasAy)) + _
                             WasXa$ + "   " + WasX$ + ZEmphasizeOff$)
65006 WEND
      CALL SkipLine (1)
      CLOSE 2
      END SUB
'
65009 ' $SUBTITLE: 'FileLister - subroutine to handle list of upload files'
' $PAGE
'
'  NAME    -- FileLister
'
'                 PARAMETER                    MEANING
'
'  INPUTS  --  ZFileName$            FILE NAME AND PATH
'              ZFileNameHold$        FILE NAME
'              ZDesc$                FILE DESCRIPTION
'              ZUCat$                FILE CATEGORY
'              ZWhoTo$               WHO FILW IS TO
'              WasFF                 1 = STORE FILE INFO
'                                    2 = READ FILE INFO
'
'  OUTPUTS --
'
'  PURPOSE --  To list files, description and category for uploading
'
65010 SUB FileLister (WasFF)
      ON WasFF GOTO 65012,65014
65012 CALL OpenWork (2,ZNodeWorkDrvPath$ + "NFUP" + ZNodeID$ + ".LST",ZTrue)
      CALL PrintWork (2,ZFileName$,ZFalse)
      CALL PrintWork (2,ZFileNameHold$,ZFalse)
      CALL PrintWork (2,ZDesc$,ZFalse)
      CALL PrintWork (2,ZUCat$,ZFalse)
      CALL PrintWork (2,ZWhoTo$,ZFalse)
      CLOSE 2
      CALL OpenWork (2,ZUploadWorkFile$,ZTrue)
      CALL PrintWork (2,ZFileName$,ZFalse)
      CLOSE 2
      IF ZAnsIndex = ZLastIndex AND ZUpBatchTransfer THEN _
         ZUpBatchTransfer = ZFalse : _
         ZWasBatchTransfer = ZTrue
      EXIT SUB
65014 CALL KillWork (ZUploadWorkFile$)
      ZErrCode = 0
      Temp$ = ZNodeWorkDrvPath$ + "NFUP" + ZNodeID$ + ".LST"
      CALL OpenWork (8,Temp$,ZFalse)
      IF ZErrCode = 0 THEN
         WHILE NOT EOF(8)
            LINE INPUT #8,ZFileName$
            LINE INPUT #8,ZFileNameHold$
            LINE INPUT #8,ZDesc$
            LINE INPUT #8,ZUCat$
            LINE INPUT #8,ZWhoTo$
            Found = ZFalse
            CALL FindFile (ZFileName$,Found)
            IF Found THEN _
               CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,2) _
            ELSE _
               IF ZWasBatchTransfer THEN _
                  CALL UpdtCalr (ZFileNameHold$ + " Aborted during Batch Upload",2) _
               ELSE _
                  ZGetExtDesc = ZFalse : _
                  CALL UpdtCalr (ZFileNameHold$ + " Aborted during Upload",2)
         WEND
         CLOSE 8
         IF ZWasBatchTransfer THEN _
            CALL UpdtCalr ("Batch Upload Completed at " + ZTime$,2)
         CALL KillWork (Temp$)
      ENDIF
      ZErrCode = 0
      END SUB
'
65099 ' $SUBTITLE: 'HSFile - subroutine to check XFER-%.DEF file for extra files'
' $PAGE
'
'  NAME    -- HSFile
'
'                 PARAMETER                    MEANING
'
'  INPUTS  __     Node XFER file               FILE TRANSFER STATISTICS
'
'  OUTPUTS --     NONE
'
'  PURPOSE --  To check XFER-%.DEF file for extra uploads that the
'              user did not tell the system he was sending.
'
65100 SUB HSFile
      CALL OpenWork (2,"XFER" + ZNodeID$ + ".DEF",ZFalse)
      IF ZErrCode <> 0 THEN _
         ZErrCode = 0 : _
         EXIT SUB
      ZFoundExtra = ZFalse
      ZSuspendAutoLogoff = ZTrue
      BatchOff = ZAutoLogoffReq
65101 WHILE NOT EOF(2)
         LINE INPUT #2,Line$
         Match = INSTR(Line$, ".")
         IF Match > 0 THEN _
            ZFileNameHold$ = MID$(Line$, Match - 8, 12)
         Match = 0
         Start = 1
         DO
            Match = INSTR(Start, ZFileNameHold$, "\")
            IF Match = 0 THEN _
               Match = INSTR(Start, ZFileNameHold$, "/")
            IF Match = 0 THEN _
               Match = INSTR(Start, ZFileNameHold$, " ")
            ZFileNameHold$ = RIGHT$(ZFileNameHold$, LEN(ZFileNameHold$) - Match)
         LOOP WHILE Match
         CALL AllCaps (ZFileNameHold$)
         CALL OpenWork (11,ZUploadWorkFile$,ZFalse)
         IF ZErrCode = 0 THEN
            WHILE NOT EOF(11)
               LINE INPUT #11,Line$
               Match = INSTR(Line$,ZFileNameHold$)
               IF Match > 0 THEN _
                  ZFileNameHold$ = "" : _
                  CLOSE 11 : _
                  GOTO 65107
            WEND
            CLOSE 11
         ENDIF
         ZErrCode = 0
         CALL OpenWork (11,ZDownloadWorkFile$,ZFalse)
         IF ZErrCode <> 0 THEN _
            ZErrCode = 0 : _
            GOTO 65102
         WHILE NOT EOF(11)
            LINE INPUT #11,Line$
            Match = INSTR(Line$,ZFileNameHold$)
            IF Match > 0 THEN _
               ZFileNameHold$ = "" : _
               CLOSE 11 : _
               GOTO 65107
         WEND
         CLOSE 11
65102    ZFileName$ = ZUpldSubDir$ + "\" + ZFileNameHold$
         CALL FindFile (ZFileName$,Found)
         IF NOT Found THEN _
            GOTO 65107
65103    GOSUB 65109
         BatchOff = ZFalse
         CALL SkipLine (1)
         CALL HSAddFileSearch (Found)
         IF Found THEN _
            CALL QuickTPut1 (ZEmphasizeOn$ + "Additional File " + _
              ZFileNameHold$ + " already exists here!" + ZEmphasizeOff$) : _
            CALL QuickTPut1 (ZEmphasizeOn$ + "Deleting file & removing credits!" + _
                          ZEmphasizeOff$) : _
            CALL SkipLine (1) : _
            GOTO 65107
         CALL Carrier
         IF ZSubParm = -1 THEN _
            ZDesc$ = " >>> Description Unavailable <<< " : _
            ZUCat$ = "***" : _
            ZWhoTo$ = "SYSOP" : _
            CALL OpenWork (2,ZNodeWorkDrvPath$ + "NFUP" + ZNodeID$ + ".LST",ZTrue) : _
            CALL PrintWork (2,ZFileName$,ZFalse) : _
            CALL PrintWork (2,ZFileNameHold$,ZFalse) : _
            CALL PrintWork (2,ZDesc$,ZFalse) : _
            CALL PrintWork (2,ZUCat$,ZFalse) : _
            CALL PrintWork (2,ZWhoTo$,ZFalse) : _
            CLOSE 2 : _
            GOTO 65107
65105    IF ZWasBatchTransfer THEN _
            ZWasBatchTransfer = ZFalse : _
            ZUpBatchTransfer = ZTrue: _
            ZAnsIndex = 1 : _
            ZLastIndex = 1
         IF ZGetDescAfterTransfer THEN _
            ZDesc$ = "" : _                                          ' 175-0205
            ZUCat$ = "" : _                                          ' 175-0205
            ZWhoTo$ = "" : _                                         ' 175-0205
            CALL FileLister(1) _
         ELSE _
            CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,1)
         IF ZAbort THEN _
            ZAbort = ZFalse : _
            GOTO 65103
         ZFileName$ = ""
         ZFileNameHold$ = ""
65107 ZFoundExtra = ZFalse
      WEND
      CLOSE 2
      IF ZUpBatchTransfer THEN _
         ZUpBatchTransfer = ZFalse : _
         ZWasBatchTransfer = ZTrue
      ZSuspendAutoLogoff = ZFalse
      ZAutoLogoffReq = BatchOff
      EXIT SUB
65109 CALL SkipLine (1)
      CALL QuickTPut1 (ZEmphasizeOn$ + "Additional File " + ZFileNameHold$ + _
                       " Detected!" + ZEmphasizeOff$)
      ZFoundExtra = ZTrue
      ZGetExtDesc = ZFalse
      RETURN
      END SUB
'
65110 ' $SUBTITLE: 'HSAddFileSearch - search for duplicate files'
' $PAGE
'
'  NAME    --  HSAddFileSearch
'
'              PARAMETER                   MEANING
'
'  INPUTS  __  ZFileNameHold$              FOUND UPLOADED FILE
'              ZFileName$                  FILE WITH PATH
'
'  OUTPUTS --  Found                       TRUE IF FILE IS DUPLICATE
'
'  PURPOSE --  To check additional files uploaded during a batch
'              upload to see if they already exist on the system.
'              If found to be duplicate(s), will delete the file(s).
'
      SUB HSAddFileSearch (Found)
      Found = ZFalse
      FileSearch$ = ZFileName$
      FileSearchHold$ = ZFileNameHold$
      AddTemp$ = ZUpldSubDir$ + "\NODE" + ZNodeID$ + "TMP.FIL"
      NAME ZFileName$ AS AddTemp$
      CALL RotorsDir (FileSearchHold$,ZSubDir$(),ZSubDirCount,ZFalse,"")
      IF ZOK THEN _
         GOTO 65120
      IF INSTR(FileSearchHold$,".") = 0 THEN _
         NAME AddTemp$ AS ZFileName$ : _
         GOTO 65125
      CALL BreakFileName (FileSearch$,DR$,WasX$,Extension$,ZFalse)
      WasI = 1
65115 WasJ = INSTR(MID$(ZCompressedExt$+". ",WasI),".")
      IF WasJ = 0 THEN _
         NAME AddTemp$ AS ZFileName$ : _
         GOTO 65125
      Check$ = MID$(ZCompressedExt$,WasI,WasJ-1)
      WasI = WasI + WasJ
      IF Extension$ <> Check$ THEN _
         CALL RotorsDir (WasX$ + "." + Check$,ZSubDir$(),ZSubDirCount,ZFalse,"") : _
         IF ZOK THEN _
            GOTO 65120
      GOTO 65115
65120 CALL KillWork (AddTemp$)
      Found = ZTrue
      CALL UpdtCalr ("Duplicate additional file " + ZFileNameHold$ + " deleted!",2)
65125 EXIT SUB
      END SUB
'
65200 ' $SUBTITLE: 'WildFile -- Matches file to a filespec'
' $PAGE
'  NAME    -- WildFile
'
'  INPUTS  -- PARAMETER             MEANING
'             Pattern$              PATTERN TO CHECK AGAINST
'             ItemToMatch$          FILE NAME TO MATCH
'
'  OUTPUTS -- DoesMatch             WHETHER MATCHES
'
'  PURPOSE  Determine whether a file name is an instance of
'    a file specification.  Exactly like DOS except that ? must have a
'    character.
'
      SUB WildFile (Pattern$,ItemToMatch$,DoesMatch) STATIC
      IF Pattern$ <> PrevPattern$ THEN _
         CALL BreakFileName (Pattern$,PDrive$,PPrefix$,PExt$,ZFalse) : _
         PrevPattern$ = Pattern$
      CALL BreakFileName (ItemToMatch$,IDrive$,IPrefix$,IExt$,ZFalse)
      DoesMatch = ZFalse
      IF PDrive$ <> "" AND PDrive$ <> IDrive$ THEN _
         EXIT SUB
      CALL WildCard (PPrefix$,IPrefix$)
      IF NOT ZOK THEN _
         EXIT SUB
      CALL WildCard (PExt$,IExt$)
      DoesMatch = ZOK
      END SUB
'
87000 ' $SUBTITLE: 'WildShow - Show the marked wildcard files to the user'
' $PAGE
'
'  NAME    -- WildShow
'                                  MEANING
'  INPUTS  -- WILDx.DEF            LIST OF FILES THAT MATCHED
'                                  THE WILDCARD DOWNLOAD REQUEST
'                                  THAT IS DISPLAYED TO THE USER
'
'  OUTPUTS -- WildParm             0 = NO FILES MARKED
'                                  1 = FILE(s) MARKED
'
'             FileList$            Files the user marked
'                                  for downloading
'
'  PURPOSE -- To show the files that matched the WildCard Download
'             search and give the user an opportunity to select
'             which files to add to their marked file list.
'             The user can also edit the marked file list
'             which only contains the files from WildCard marking
'             as the "other" marked file list is kept in a temp
'             variable to be combined after the user quits the
'             wildshow function.
'
      SUB WildShow (FileList$,WildParm)
      WildParm = 0
      WildMenu$ = ZMnuPath$ + "WILD." + ZMnuExt$
87100 WildLineCount = 0
      CALL SkipLine(1)
      CALL QuickTPut1 (ZFG9$ + "Files matching your request" + ZEmphasizeOff$)
      CALL QuickTPut1 (ZFGE$ + "~~~~~~~~~~~~~~~~~~~~~~~~~~~" + _
                 ZEmphasizeOff$)
      InList = ZFalse
      LowRec& = 1
      CountRec& = 0
      TempRec& = 1
      WildPrint = ZPageLength - 1
      WildLineCount = WildLineCount + 5
      ZNonStop = ZFalse
      IF ZRightMargin > 50 THEN _
         WildCol = 3
      IF ZRightMargin > 30 AND ZRightMargin < 51 THEN _
         WildCol = 2
      IF ZRightMargin < 31 THEN _
         WildCol = 1
      ZJumpSupported = ZFalse
87110 WildName$ = ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF"
      FilNum = 2
      CALL OpenRSeq (WildName$,HighRec&,DGSWasX,13,FilNum)
      FIELD FilNum, 12 AS WildFileName$, _
                     1 AS WildCr$
      LowRec& = TempRec&
      FOR Count& = LowRec& TO HighRec&-1
          IF InList THEN _
             InList = ZFalse : _
             GOTO 87120
          GET FilNum, Count&
          IF (Count& MOD WildCol) = 0 OR Count& = HighRec&-1 THEN _
             ZSubParm = 5 : _
             WildLineCount = WildLineCount + 1 _
          ELSE ZSubParm = 4
          ZOutTxt$ = ZFGF$ + STR$(Count&) + "."
          ZOutTxt$ = ZOutTxt$ + SPACE$(5-LEN(STR$(Count&))) + ZFGB$ + _
                     WildFileName$ + SPACE$(5) + ZEmphasizeOff$
          CALL TPut
          IF WildLineCount > WildPrint AND ZNonStop = ZFalse THEN
87120        CALL AskMore (",M)ark",ZTrue,ZFalse,WasX,ZFalse)
                  IF ZNo OR WasX = 32000 THEN _
                     EXIT FOR _
                  ELSE WildLineCount = 0
                       WasX$ = LEFT$(ZUserIn$(1),1)
                       CALL AllCaps (WasX$)
                       IF WasX$ = "M" THEN _
                          InList = ZTrue : _
                          GOSUB 87150 : _
                          GOTO 87110
          END IF
      NEXT
      CLOSE FilNum
      InList = ZFalse
      GOTO 87200
'
87150 IF NOT NumberOnCmdLine THEN
         CALL SkipLine(1)
         CALL QuickTPut1 (ZFGE$ + "Enter" + ZFGF$ + " File NUMBER(s)" + _
                    ZFGE$+ " to Mark," + ZEmphasizeOff$)
         ZOutTxt$ = ZFG4$ + "Ex: " + ZFGB$ + "1 2 5-9 14 " + _
                             ZFG4$ + "etc." + ZFGE$ + " (" + _
                             ZBG4$ + ZFGF$ + "[ENTER]" + _
                             ZFG0$ + ZFGE$ + " Quits)" + ZEmphasizeOff$
         ZStackC = ZTrue
         CALL PopCmdStack
      END IF
      UseMultiCheck = ZFalse
      FileNumberCount = 0
      FOR Temp = ZAnsIndex to ZLastIndex
        Test = VAL(ZUserIn$(Temp))
        IF Test = 0 THEN
           IF TempName$ <> ZUserIn$(Temp) THEN
              CALL SkipLine(1)
              CALL QuickTPut1 (ZFGF$ + "*** " + ZFGE$ + "Please use " + ZFGF$ + _
                         "FILE NUMBERS" + ZFGE$ + " when marking WildCard files" + _
                          ZEmphasizeOff$ + ZBellRinger$)
              CALL QuickTPut1 (ZFGF$ + "       File: " + ZFG4$ + _
                              "{ " + ZFGC$ + ZUserIn$(Temp) + ZFG4$ + " }" + _
                               ZFGE$ + " Omitted" + ZEmphasizeOff$)
              TempName$ = ZUserIn$(Temp)
              CALL SkipLine(1)
              CALL DelayTime(1)
           END IF
        ELSE
           FileNumberCount = FileNumberCount + 1
        END IF
        IF INSTR(ZUserIn$(Temp),"-") > 1 THEN _
           UseMultiCheck = ZTrue
        IF Test > 0 THEN _
           ZOutTxt$(FileNumberCount) = ZUserIn$(Temp)
      NEXT
      ZAnsIndex = 1
      ZLastIndex = FileNumberCount
      FOR WasX = 1 TO  FileNumberCount
         ZUserIn$(WasX) = ZOutTxt$(WasX)
      NEXT
      IF ZSubParm < 0 THEN _
         EXIT SUB
      TempRec& = Count&
      IF ZWasQ = 0 THEN _
         IF InList THEN _
            RETURN _
          ELSE GOTO 87200
      TempMarked$ = FileList$
      IF UseMultiCheck THEN _
         CALL MultiFile
      CALL AskItems ("W","W",ZFalse,"wild",FileList$,ZPersonalDnld)
      IF TempMarked$ <> FileList$ THEN _
         WildLineCount = 0 : _
         WildParm = 1
      IF InList THEN _
         RETURN
'
87200 CALL SkipLine(1)
      NumberOnCmdLine = ZFalse
      IF ZExpertUser THEN _
         GOTO 87220
87210 CALL Graphic (WildMenu$,ZTrue)
      IF ZOK THEN _
         CALL BufFile (WildMenu$,X,ZTrue)
87220 ZOutTxt$ = "WildCommand: (?," + _
        LEFT$("E)dit Files",-10 * (NOT ZExpertUser) + 1) + _
        LEFT$(",H)elp",-4 * (NOT ZExpertUser) + 2) + _
        LEFT$(",M)ark",-4 * (NOT ZExpertUser) + 2) + _
        LEFT$(",[Q]uit",-3 * (NOT ZExpertUser) + 4) + _
        LEFT$(",R)elist Files",-12 * (NOT ZExpertUser) + 2) +")"
      ZStackC = ZTrue
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      WildLineCount = 7
      IF VAL(ZUserIn$(ZAnsIndex)) <> 0 THEN _
         NumberOnCmdLine = ZTrue : _
         GOTO 87150
      CALL AllCaps(ZUserIn$(ZAnsIndex))
      IF ZWasQ = 0 THEN _
         GOTO 87400
      ON INSTR("QMREH?D",ZUserIn$(ZAnsIndex)) GOTO 87400,87150,87100,87300,87210,87210,87400
      GOTO 87220
87300 CALL WildMark (FileList$)
      GOTO 87200
87400 IF FileList$ = "" THEN _
         WildParm = 0
      CLOSE FilNum
      EXIT SUB
      END SUB
'
90000 ' $SUBTITLE: 'WildMark - edit marked files after wildcard marking'
' $PAGE
'
'  NAME    -- WildMark
'                                  MEANING
'
'  INPUTS  -- FileList$            LIST OF FILES THAT WERE MARKED
'                                  FROM THE WILDCARD FILE DISPLAY
'
'  OUTPUTS -- FileList$            MODIFIED LIST OF MARKED FILES
'                                  WHICH ONLY CONTAINS THE FILES
'                                  THE USER ANSWERED YES TO KEEP
'                                  IN THE MARKED FILES LIST
'
'  PURPOSE -- To read the FileList$ variable and give the user
'             an opportunity to edit the files in it.
'
      SUB WildMark (FileList$)
      IF FileList$ = "" THEN _
         CALL SkipLine(1) : _
         CALL QuickTPut (ZFGB$ + "No marked files to edit" + ZEmphasizeOff$,2) : _
         CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue) : _
         EXIT SUB
      ZWasZ$ = "M"
      ZAnsIndex = 1
      LastDnld = 1
      CALL UnMarkItems (FileList$,ZAnsIndex,LastDnld,FoundMarked,ZTrue)
90100 FOR Temp = ZAnsIndex TO LastDnld
          TempName$ = ZUserIn$(Temp)
          ZOutTxt$ = ZFG1$ + "Keep " + ZFGF$ + TempName$ + _
                     ZFG1$ + " in marked file list?" + ZEmphasizeOff$ + _
                     " (Y,[N])"
          ZTurboKey = - ZTurboKeyUser
          CALL PopCmdStack
          IF ZSubParm < 0 THEN _
             EXIT SUB
          IF ZYes THEN
             FileList$ = FileList$ + TempName$ + ZCarriageReturn$
          END IF
      NEXT
      END SUB
