#include <stdlib.h>;
#include <stdio.h>;
#include <stdarg.h>
#include <alloc.h>;
#include <dos.h>;

#include "mcgalib.h";
#include "animlib.h";
#include "mcgaplus.h";

/*
   INVADERS - D.G. Sureau - Example for Artist Of Virtuality
   Demo of how a simple loop can make the core of a game!
   Exemple montrant comment une simple boucle constitue la base d'un jeu!
   Requires:
    VGA256LIB.OBJ
    ANIMLIB.C
    VGA256PLUS.OBJ
*/

#define ENGLISH
#define _FRANCAIS
#define VGA256 19
#define TEXT 3
#define REALSEG 0xA000
#define FP_SEG(fp)  ((unsigned)((unsigned long)(fp) >> 16))

unsigned char *PALETTE;     /* Palette buffer */

/* Max size for monster path */
/* Taille maximale du chemin du monstre */

#define MAXPATH  1024

#define SHIP_SERIES 1
#define MONSTER_SERIES 2
#define SCENERY_SERIES 3

int *MONSTER_PATH;
int XPATH;
int YPATH;

/* Error message */
/* Message d'erreur */

int no_found(char *name)
{
#ifdef ENGLISH
 printf("File no found %s\n",name);
#endif
#ifdef FRANCAIS
 printf("Fichier non trouv %s\n",name);
#endif
 exit(0);
}


/* Function for loading any binary file */
/* Fonction qui charge tout fichier binaire */

int bload(char *fname, char *adr, int siz)
{
 FILE *FP;

 if((FP = fopen(fname,"rb")) == 0L) no_found(fname);
 fread((char *) adr, siz, 1, FP);
 fclose(FP);
 return(1);
}


int GetPathSize(int *path)
{
 return(path[0]);
}

void GetPath(int *path, int level)
{
 int number;

 number = level * 2 + 1;
 XPATH = path[number];
 YPATH = path[number + 1];
}


void main()
{
 int x, y;
 int SPRMAX;
 int ch;
 int i;
 char *ALTSCREEN;             /* address of the virtual screen */
 unsigned int VIRTUALSEG;       /* segment of the virtual screen */

 int MONSTER_PATH_POS;        /* Position in the path array */
 int monster_first;           /* Alien first sprite of animation */
 int ship_first;              /* First sprite of ship animation */
 int monster_animation_size;  /* Number of frames of monster animation*/
 int ship_animation_size;     /* Number of frames of player's ship animation */
 int ship_frame;              /* Frame number, for player's ship */
 int monster_frame;           /* Frame number, for alien */
 int ship_cycling;            /* Cycle counter to slow animation */
 int monster_cycling;
 int xscenery;                /* To scroll scenery / Dfilement dcor */
 int yscenery;
 int scenery_cycling;

/* First, allocation of memory buffer */
/* D'abord, allocation des tampons en mmoire */

  sprite_alloc();

 MONSTER_PATH = (int *) malloc(MAXPATH * 4 + 2);

/* Allocating palette */
/* Allocation pour une palette */

 PALETTE = malloc(1024);

/*
   Allocating an alternate screen. This is allocated in far heap
   A 0 offset is required as for the real screen and the segment
   is calculated by setvirtual() for that

   On alloue un tampon pour un ecran virtuel qui sera dans la
   "far heap". Un offset de 0 est requis comme pour l'ecran reel
   aussi setvirtual() calcule le segment en consequence
*/

 ALTSCREEN = (char *) farmalloc(64000L);
 VIRTUALSEG = setvirtual((unsigned long) ALTSCREEN);

/*
   Statements to verify allocating
   Vrification de l'allocation
*/

printf("Buffer (%x:%x) Virtual screen:%x\n",FP_SEG(ALTSCREEN),
					    FP_OFF(ALTSCREEN),
					    VIRTUALSEG);

 if(!FP_SEG(SPVECTOR) ||
    !FP_SEG(MONSTER_PATH) ||
    !FP_SEG(ALTSCREEN)
    )
    {
       puts("Alloc error...");
       exit(0);
    }

/* Loading sprites  */
/* Chargement des sprites */

#ifdef ENGLISH
 printf("Loading sprites...");
#endif
#ifdef FRANCAIS
 printf("Chargement des sprites...");
#endif

 SPRMAX = sprites_load("invaders.dat", 65512U);
 if(!SPRMAX) no_found("invaders.dat");

 puts("ok");
 printf("%d sprites\n", SPRMAX);
 printf("%d frames max./animation\n", FRAMESIZE);

/* Loading monster's paths */
/* On charge les chemins des monstres */

#ifdef ENGLISH
 printf("Loading monster's path...");
#endif
#ifdef FRANCAIS
 printf("Chargement du chemin de l'envahisseur...");
#endif

 bload("invaders.pth", (char *) MONSTER_PATH, MAXPATH * 4 + 2);
 puts("ok");

/* Loading and setting palette  */
/* Only first 768 bytes are loaded here */

#ifdef ENGLISH
 printf("Loading palette...\n");
#endif
#ifdef FRANCAIS
 printf("Chargement de la palette...\n");
#endif
 bload("invaders.pal", PALETTE, 768);

#ifdef ENGLISH
puts("\n< Press a key to continue >");
#endif
#ifdef FRANCAIS
puts("\n< Appuyer une touche pour continuer >");
#endif
if(getch() == 27) exit(0);

/*
   Setting VGA 256 colors screen and setting the
   loaded palette to the system, in this order.
   Ecran en mode VGA 256 couleurs et changement de palette,
   dans cet ordre.
*/

 selectscreen(VGA256);
 writeRGB(PALETTE);

/* Setting a full screen window */
/* On utilise une fentre plein cran */

 VGASCREEN = REALSEG;
 window19(0, 0, 319, 199);

 xscenery        = 200;
 yscenery        = 100;
 scenery_cycling = 0;

 i = get_first(SCENERY_SERIES) + 1;

/* Get start or animation and size - series 2 for player sprites */
/* Dbut d'animation et taille - la srie 2 est celle du vaisseau */

 ship_first          = get_first(SHIP_SERIES);
 ship_animation_size = get_frame_number(SHIP_SERIES);
 ship_frame          = 0;
 ship_cycling        = 0;
 x                   = 140;        /* Starting location of the ship */
 y                   = 25;

/* Series 1 for ship sprites */
/* La srie 1 est celle des sprites des monstres */

 MONSTER_PATH_POS       = 1;
 monster_first          = get_first(MONSTER_SERIES);
 monster_animation_size = get_frame_number(MONSTER_SERIES);
 monster_frame          = 0;
 monster_cycling        = 0;

 VGASCREEN = VIRTUALSEG;

 do
 {

/* New screen with scrolling background */
/* Nouvel cran avec dfilement de l'horizon */

  cls19(0);
  csprite256c(xscenery, yscenery, GETSPADR(i));

  GetPath(MONSTER_PATH, MONSTER_PATH_POS);
  if(++MONSTER_PATH_POS > MONSTER_PATH[0]) MONSTER_PATH_POS = 0;

/* Player's ship / Vaisseau du joueur */

  sprite256(x , y, GETSPADR(ship_first + ship_frame));

/* Alien's sprite / Sprite de l'envahisseur */

  sprite256c(XPATH, YPATH, GETSPADR(monster_first + monster_frame));

/* Copying virtual screen over real one */
/* Copie de l'cran virtuel sur l'cran rel */

  synchro();
  copyscreen(VIRTUALSEG, REALSEG);


  if(scenery_cycling++ == 4)
   {
    yscenery--;
    scenery_cycling = 0;
   }

/* Next image of the alien animation */
/* Image suivante dans l'animation de l'envahisseur */

  if(++monster_cycling == 4)
  {
   if(++monster_frame >= monster_animation_size) monster_frame = 0;
   monster_cycling = 0;
  }

/* Next image of the ship animation */
/* Image suivante dans l'animation du vaisseau */

  if(ship_cycling++ == 1)
  {
   if(++ship_frame >= ship_animation_size) ship_frame = 0;
   ship_cycling = 0;
  }

/* Keyboard input / Entre clavier */

  if(kbhit())
   {
    ch = getch();
    if(!ch) ch = 1000 + getch();
    switch(ch)
    {
     case 1075: x--; break;
     case 1077: x++; break;
     default: break;
    }

    if(x < 20) x = 20;
    if(x > 300) x = 300;
   }
  delay(5);

} while(ch != 27 && yscenery);

finish:

/* Restores DOS text screen and exit program */
/* Retour  l'cran texte du DOS et sortie du programme */

 selectscreen(TEXT);
 exit(0);
}
