{
    VGAXDEMO -- VGA ModeX graphics demo.  Mode setup, pixel plotting.
}

{$G+}
program vgaxdemo;
uses crt;

{--------------------------------------------------------------------}

procedure setmode(mode:integer); assembler;
asm
    mov ax,mode;
    xor ah,ah;
    int 10h;
end;

{--------------------------------------------------------------------}

procedure cls; assembler;
asm
    mov ax,0A000h;      { ES = video memory }
    mov es,ax;

    mov dx,03C4h;       { Select all planes }
    mov ax,0F02h;
    out dx,ax;

    xor di,di;          { Set up for clear }
    xor ax,ax;
    mov cx,9600

    rep stosw;          { Clear the screen }
end;

{--------------------------------------------------------------------}

procedure setmodex;
const
    xdata : array[1..10] of Word = (
        $0011, $0B06, $3E07, $EA10, $8C11,
        $DF12, $0014, $E715, $0416, $E317);
var
    i:integer;
begin
    setmode($13);               { Set mode 13h 320x200x256 }

    port[$03C2] := port[$03CC] or $C0;
    portw[$03C4] := $0604;      { Set ModeX 320x240x256 }
    for i := 1 to 10 do begin
        portw[$03D4] := xdata[I];
    end;

    cls;
end;

{--------------------------------------------------------------------}

procedure putpixel(x, y, color:integer); assembler;
asm
    mov ax,0A000h;          { ES = video memory }
    mov es,ax;
    mov cx,x;               { CX = X }

    mov dx,03C4h;           { Set the memory plane }
    mov ax,1102h;
    rol ah,cl;
    out dx,ax;

    imul di,y,80;           { DI = offset in video memory }
    shr cx,2;
    add di,cx;
    mov ax,color;           { Set the pixel }
    stosb;
end;

{--------------------------------------------------------------------}

function getpixel(x, y:integer):integer; assembler;
asm
    mov ax,0A000h;          { ES = video memory }
    mov es,ax;
    mov cx,x;               { CX = X }

    mov dx,03CEh;           { Set the memory plane }
    mov al,4;
    mov ah,cl;
    and ah,3;
    out dx,ax;

    imul di,y,80;           { DI = offset in video memory }
    shr cx,2;
    add di,cx;
    mov al,es:[di];         { Read the pixel }
    or al,es:[di];          { Buggy video card fix }
    xor ah,ah;
end;

{--------------------------------------------------------------------}

var
    i:integer;
begin
    setmodex;

    while not keypressed do begin
        for i := 1 to 200 do
            putpixel(random(320), random(240), random(256));
    end;

    while keypressed do readkey;
    cls;

    setmode($03);
end.

