; GRAVITY.ASM
;     Optimized by Andy Kurnia <akur@iname.com>
; To make .COM, use TASM >= 3.2 and TLINK >= 5.1:
;     tasm /m9 gravity
;     tlink /t/x gravity
; PS. I'd like to know Paul Hsieh's and Tylisha C. A.'s e-mail addresses...
;
; The data is stored at (SS = CS = DS):
;
;       SS:A000 Random Number Generator
;       SS:9FFE X Position[5]   9FFE -> Offset OR 3Ah
;       SS:9FFC X Speed[5]      9FFE    = 9FFEh for X
;       SS:9FFA Y Position[5]   9FFA    = 9FFAh for Y
;       SS:9FF8 Y Speed[5]      9FFA
;       SS:9FF6 X Position[4]   9FFE
;       SS:9FF4 X Speed[4]      9FFE
;       SS:9FF2 Y Position[4]   9FFA
;       SS:9FF0 Y Speed[4]      9FFA
;       SS:9FEE X Position[3]   9FFE
;       SS:9FEC X Speed[3]      9FFE
;       SS:9FEA Y Position[3]   9FFA
;       SS:9FE8 Y Speed[3]      9FFA
;       SS:9FE6 X Position[2]   9FFE
;       SS:9FE4 X Speed[2]      9FFE
;       SS:9FE2 Y Position[2]   9FFA
;       SS:9FE0 Y Speed[2]      9FFA
;       SS:9FDE X Position[1]   9FFE
;       SS:9FDC X Speed[1]      9FFE
;       SS:9FDA Y Position[1]   9FFA
;       SS:9FD8 Y Speed[1]      9FFA
;       SS:9FD6 X Position[0]   9FFE
;       SS:9FD4 X Speed[0]      9FFE
;       SS:9FD2 Y Position[0]   9FFA
;       SS:9FD0 Y Speed[0]      9FFA
;
; These familiar instructions:
;
;       PUSH    AX                      POP     AX
;
; are actually doing these instructions (if addressing [SP] were allowed):
;
;       MOV     TEMP, AX                MOV     TEMP, SS:[SP]
;       DEC     SP                      INC     SP
;       DEC     SP                      INC     SP
;       MOV     SS:[SP], TEMP           MOV     AX, TEMP
;
; The TEMP imaginary register explains how PUSH SP and POP SP works.

JUMPS
MULTERRS
WARN

.MODEL TINY
.386
.CODE

        ORG     100H
PROG:   MOV     AX, 13H
        INT     10H
        CLI
        MOV     DI, 0A000H
        MOV     SP, DI
        MOV     ES, DI
        MOV     CX, 24
RAND:   IMUL    AX, [DI], -6BH
        INC     AX
        MOV     [DI], AX
        AAM     33
        SUB     AL, 16
        CBW
        PUSH    AX
        LOOP    RAND
        MOV     BP, SP
MAIN:   MOV     AX, 0E06H
        MOV     SI, 318
DRAW:   POP     DI DI BX BX
        IMUL    DI, 320
        LEA     DI, [BX + DI + 32160]
        STOSB
        ADD     DI, SI
        STOSW
        STOSB
        ADD     DI, SI
        STOSB
        DEC     AH
        DEC     AL
        JNZ     DRAW
        MOV     SP, BP
        MOV     AH, 86H
        CWD
        INT     15H
ERAS:   STOSB
        LOOP    ERAS
        MOV     CL, 12
MOVE:   POP     AX DI
        SAR     AX, 1
        ADD     DI, AX
        PUSH    DI
        POP     DI
        LOOP    MOVE
        MOV     SP, BP
        MOV     CL, 12
CALC:   MOV     SI, SP
        OR      SI, 3AH
        SUB     DI, DI
        POP     AX BX
CA_B:   CMP     BX, DI
        JL      CA_C
        JZ      CA_D
        DEC     AX
        DEC     AX
CA_C:   INC     AX
CA_D:   MOV     DI, [SI]
        SUB     SI, 8
        CMP     SI, 9FC8H
        JNB     CA_B
CA_E:   DEC     AX
        CMP     AL, 29
        JG      CA_E
CA_F:   INC     AX
        CMP     AL, -30
        JL      CA_F
        PUSH    BX AX
        POP     AX BX
        LOOP    CALC
        MOV     SP, BP
        MOV     AH, 1
        INT     16H
        JZ      MAIN
        MOV     AX, 3
        INT     10H
        INT     16H
        INT     20H

        END     PROG
