; PLASMA.ASM - Andy Kurnia <akur@indo.net.id>
;
; Use TASM 3.2 or above to assemble this program:
;     tasm/m9 plasma
;
; Use TLINK 5.1 or above to link it:
;     tlink/t/x plasma

; EDITOR'S NOTE:  Modified to fit rules & for stability:
;   No startup assumptions (added XOR AX,AX; MOV BL,0C0h --> MOV BX,0C0h)
;   Can't trust INT after CLI (moved the CLI to after the INT 10h).

JUMPS
MULTERRS
WARN

.MODEL TINY
.386
.CODE

        ORG     100H
PROG:   MOV     BP, 3                   ; BD 03 00
        MOV     SI, OFFSET PAL          ; BE(40 F4)
        MOV     DI, SI                  ; 8B FE
        MOV     CX, 576                 ; B9 40 02
        PUSH    CX                      ; 51
        SUB     AX, AX                  ; 2B C0
        REP     STOSW                   ; F3 AB
        MOV     AL, 13H                 ; B0 13
        INT     10H                     ; CD 10
        CLI                             ; FA
        MOV     AX, 3F00H               ; B8 00 3F
        MOV     BX, 0C0H                ; BB C0 00
PALOOP: MOV     [BX + SI - 3], AH       ; 88 60 FD
        MOV     [BX + SI - 1], AL       ; 88 40 FF
        MOV     [BX + SI + 189], AX     ; 89 80 BD 00
        MOV     [BX + SI + 382], AX     ; 89 80 7E 01
        SUB     AX, 0FFH                ; 2D FF 00
        SUB     BX, BP                  ; 2B DD
        JNZ     PALOOP                  ; 75(EB)
        POP     CX                      ; 59
        SUB     DI, CX                  ; 2B F9
        REP     MOVSB                   ; F3 A4
        CALL    SETPAL                  ; E8(36 00)
        PUSH    0A000H                  ; 68 00 A0
        POP     DS                      ; 1F
        MOV     AL, 96                  ; B0 60
        MOV     [BX], AL                ; 88 07
        MOV     DS:[319], AL            ; A2 3F 01
        MOV     [DI], AL                ; 88 05
        MOV     DS:[63999], AL          ; A2 FF F9
        PUSH    199 319 CX CX           ; 68 C7 00 68 3F 01 51 51
        CALL    PLASMA                  ; E8(2D 00)
ROTATE: MOV     DL, 0DAH                ; B2 DA
VRTLP:  IN      AL, DX                  ; EC
        AND     AL, 8                   ; 24 08
        JZ      VRTLP                   ; 74(FB)
        CALL    SETPAL                  ; E8(11 00)
        SUB     BX, BP                  ; 2B DD
        JNS     ROTAT1                  ; 79(03)
        MOV     BX, 576                 ; BB 40 02
ROTAT1: MOV     AH, 1                   ; B4 01
        INT     16H                     ; CD 16
        JZ      ROTATE                  ; 74(E9)
        XCHG    BP, AX                  ; 95
        INT     10H                     ; CD 10
        RET                             ; C3

SETPAL: MOV     DX, 3C8H                ; BA C8 03
        MOV     AL, 1                   ; B0 01
        OUT     DX, AL                  ; EE
        INC     DX                      ; 42
        LEA     SI, PAL[BX]             ; 8D B7 40 F4
        MOV     CX, 576                 ; B9 40 02
        REP     SEGCS OUTSB             ; F3 2E 6E
        RET                             ; C3

PLASMA: PUSHA                           ; 60
        ENTER   -20, 0                  ; C8 EC FF 00
        POP     AX BX CX DX             ; 58 5B 59 5A
        LEAVE                           ; C9
        MOV     SI, CX                  ; 8B F1
        SUB     SI, AX                  ; 2B F0
        DEC     SI                      ; 4E
        JLE     PDONE                   ; 7E(50)
        MOV     SI, AX                  ; 8B F0
        ADD     SI, CX                  ; 03 F1
        SAR     SI, 1                   ; D1 FE
        MOV     DI, BX                  ; 8B FB
        ADD     DI, DX                  ; 03 FA
        SAR     DI, 1                   ; D1 FF
        CALL    ADJTB                   ; E8(6D 00)
        CALL    ADJLR                   ; E8(5E 00)
        PUSH    DX SI DI AX DX CX DI SI ; 52 56 57 50 52 51 57 56
        PUSH    DI CX BX SI DI SI BX AX ; 57 51 53 56 57 56 53 50
        MOV     BP, SP                  ; 8B EC
        PUSH    BX AX BX CX DX AX DX CX ; 53 50 53 51 52 50 52 51
        PUSH    DI SI                   ; 57 56
        CALL    GETPIX                  ; E8(23 00)
        JNZ     PRCRSE                  ; 75(13)
        CWD                             ; 99
        MOV     CX, 4                   ; B9 04 00
PLASM1: CALL    GETPIX                  ; E8(1A 00)
        LOOP    PLASM1                  ; E2(FB)
        XCHG    DX, AX                  ; 92
        SHR     AX, 2                   ; C1 E8 02
        PUSH    DI SI                   ; 57 56
        STC                             ; F9
        CALL    PIXEL                   ; E8(0F 00)
PRCRSE: MOV     SP, BP                  ; 8B E5
        MOV     CX, 4                   ; B9 04 00
PRCRS1: CALL    PLASMA                  ; E8(A1 FF)
        LOOP    PRCRS1                  ; E2(FB)
PDONE:  POPA                            ; 61
        RET     8                       ; C2 08 00

GETPIX: CLC                             ; F8
PIXEL:  PUSH    BP                      ; 55
        MOV     BP, SP                  ; 8B EC
        PUSHF                           ; 9C
        IMUL    BX, [BP + 6], 320       ; 69 5E 06 40 01
        ADD     BX, [BP + 4]            ; 03 5E 04
        POPF                            ; 9D
        JC      PIXEL1                  ; 72(06)
        MOV     AL, [BX]                ; 8A 07
        ADD     DX, AX                  ; 03 D0
;*      AAD     0                       ; D5 00
        DB      0D5h, 000h
PIXEL1: MOV     [BX], AL                ; 88 07
        POP     BP                      ; 5D
        RET     4                       ; C2 04 00

ADJLR:  CALL    ADJLR1                  ; E8(00 00)
ADJLR1: PUSH    DI AX DX AX BX AX       ; 57 50 52 50 53 50
        XCHG    CX, AX                  ; 91
        JMP     ADJUST                  ; EB(0B)

ADJTB:  CALL    ADJTB1                  ; E8(00 00)
ADJTB1: PUSH    BX SI BX CX BX AX       ; 53 56 53 51 53 50
        XCHG    BX, DX                  ; 87 DA
ADJUST: PUSHA                           ; 60
        MOV     BP, SP                  ; 8B EC
        PUSH    4 PTR [BP + 24]         ; 66 FF 76 18
        CALL    GETPIX                  ; E8(C3 FF)
        JNZ     ADONE                   ; 75(4A)
        CWD                             ; 99
        MOV     BX, [BP + 22]           ; 8B 5E 16
        ADD     BX, [BP + 20]           ; 03 5E 14
        SUB     BX, [BP + 18]           ; 2B 5E 12
        SUB     BX, [BP + 16]           ; 2B 5E 10
        SHL     BX, 1                   ; D1 E3
        INC     BX                      ; 43
        IMUL    AX, CS:RNDNUM, 7FH      ; 2E 6B 06(73 02)7F
        INC     AX                      ; 40
        MOV     CS:RNDNUM, AX           ; 2E A3(73 02)
        DIV     BX                      ; F7 F3
        SAR     BX, 1                   ; D1 FB
        SUB     DX, BX                  ; 2B D3
        PUSH    DX                      ; 52
        MOV     AH, 0                   ; B4 00
        CWD                             ; 99
        PUSH    4 PTR [BP + 16]         ; 66 FF 76 10
        CALL    GETPIX                  ; E8(95 FF)
        PUSH    4 PTR [BP + 20]         ; 66 FF 76 14
        CALL    GETPIX                  ; E8(8E FF)
        XCHG    DX, AX                  ; 92
        SAR     AX, 1                   ; D1 F8
        POP     DX                      ; 5A
        ADD     AX, DX                  ; 03 C2
        INC     AX                      ; 40
        JLE     $ - 1                   ; 7E FD
        DEC     AX                      ; 48
        CMP     AX, 192                 ; 3D C0 00
        JGE     $ - 4                   ; 7D FA
        INC     AX                      ; 40
        PUSH    4 PTR [BP + 24]         ; 66 FF 76 18
        CALL    PIXEL                   ; E8(78 FF)
ADONE:  POPA                            ; 61
        ADD     SP, 12                  ; 83 C4 0C
        RET                             ; C3

RNDNUM  DW      ?

        ORG     63680 - 1152
PAL     DB      1152 DUP (?)

        END     PROG
