//***********************************************************************
//
//  DrawDoc.cpp
//
//***********************************************************************

#include <afxwin.h>
#include <afxcoll.h>
#include "Resource.h"
#include "Circle.h"
#include "DrawDoc.h"

IMPLEMENT_DYNCREATE (CDrawDoc, CDocument)

BEGIN_MESSAGE_MAP (CDrawDoc, CDocument)
    ON_COMMAND_RANGE (ID_COLOR_BLACK, ID_COLOR_WHITE, OnColor)
    ON_UPDATE_COMMAND_UI_RANGE (ID_COLOR_BLACK, ID_COLOR_WHITE,
        OnUpdateColor)
END_MESSAGE_MAP ()

void CDrawDoc::DeleteContents ()
{
    POSITION pos = m_list.GetHeadPosition ();

    while (pos != NULL)
        delete m_list.GetNext (pos);

    m_list.RemoveAll ();
}

void CDrawDoc::Serialize (CArchive& ar)
{
    m_list.Serialize (ar);
}

BOOL CDrawDoc::OnNewDocument ()
{
    if (!CDocument::OnNewDocument ())
        return FALSE;
    m_nColor = 4;
    return TRUE;
}

BOOL CDrawDoc::OnOpenDocument (LPCTSTR lpszPathName)
{
    if (!CDocument::OnOpenDocument (lpszPathName))
        return FALSE;
    m_nColor = 4;
    return TRUE;
}

void CDrawDoc::OnColor (UINT nID)
{
    m_nColor = nID - ID_COLOR_BLACK;
}

void CDrawDoc::OnUpdateColor (CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck ((pCmdUI->m_nID - ID_COLOR_BLACK) == m_nColor);
}

CCircle* CDrawDoc::AddCircle (CPoint point1, CPoint point2)
{
    static COLORREF crColors[8] = {
        RGB (  0,   0,   0),    // Black
        RGB (  0,   0, 255),    // Blue
        RGB (  0, 255,   0),    // Green
        RGB (  0, 255, 255),    // Cyan
        RGB (255,   0,   0),    // Red
        RGB (255,   0, 255),    // Magenta
        RGB (255, 255,   0),    // Yellow
        RGB (255, 255, 255)     // White
    };

    CCircle* pCircle;
    try {
        CRect rect (point1.x, point1.y, point2.x, point2.y);
        pCircle = new CCircle (rect, crColors[m_nColor]);
        m_list.AddTail (pCircle);
        SetModifiedFlag ();
    }
    catch (CMemoryException* e) {
        if (pCircle != NULL) {
            delete pCircle;
            pCircle = NULL;
        }
        AfxMessageBox ("Out of memory", MB_ICONSTOP | MB_OK);
        e->Delete ();
    }
    return pCircle;
}

POSITION CDrawDoc::GetFirstCirclePosition ()
{
    return m_list.GetHeadPosition ();
}

CCircle* CDrawDoc::GetNextCircle (POSITION& pos)
{
    return (CCircle*) m_list.GetNext (pos);
}
